from paraview.simple import *
from paraview.servermanager import vtkProcessModule

print("Executing data reduction pipeline")

from paraview import catalyst, print_error

options = catalyst.Options()

# registrationName must match the channel name used in the
# 'CatalystAdaptor'.
producer = TrivialProducer(registrationName="grid")

# Create an extractor taking the output of the slice. This way,
# the slice will be sent back as a Catalyst result node to AdiosCatalyst.
steering = CreateExtractor("steering", producer, registrationName="steerchannel")

def catalyst_execute(info):
    producer.UpdatePipeline()
    producerInformation = producer.GetDataInformation()
    bounds = producer.GetDataInformation().GetBounds()[:2]

    pm = vtkProcessModule.GetProcessModule()
    controller = pm.GetGlobalController()
    rank = controller.GetLocalProcessId()

    # Data is a 120x59x43 grid
    # 4 MPI ranks simulation

    expected_bounds = [
        (0.0, 30.0),
        (30.0, 60.0),
        (60.0, 90.0),
        (90.0, 120.0),
    ]

    assert bounds == expected_bounds[rank], f"Producer does not have the right bounds ({bounds})"

    assert (
        producerInformation.GetNumberOfCells() == 76110
    ), f"Producer does not have the right number of cells ({producerInformation.GetNumberOfCells()})"
    assert (
        producerInformation.GetNumberOfPoints() == 81840
    ), f"Producer does not have the right number of points ({producerInformation.GetNumberOfPoints()})"
