from paraview.simple import *

print("Executing data reduction pipeline")

from paraview import catalyst
options = catalyst.Options()

# registrationName must match the channel name used in the
# 'CatalystAdaptor'.
producer = TrivialProducer(registrationName="grid")
mergeBlocks = MergeBlocks(Input=producer, MergePartitionsOnly=1)

# Create a slice of the producer
sliced = Slice(Input=mergeBlocks, SliceType="Plane")
sliced.SliceType.Offset = 0.0
sliced.SliceType.Origin = [60.0, 35.4, 62.35]
sliced.SliceType.Normal = [0.0, 1.0, 0.0]

sliced2 = Slice(Input=mergeBlocks, SliceType="Plane")
sliced2.SliceType.Offset = 0.0
sliced2.SliceType.Origin = [60.0, 35.4, 62.35]
sliced2.SliceType.Normal = [1.0, 1.0, 0.0]

# Create a composite structure out of the slices,
# So the steered extract is processed as multimesh.
grouped = GroupDatasets(Input=[sliced, sliced2])
steering = CreateExtractor("steering", grouped, registrationName="steerchannel")


def catalyst_execute(info):
    grouped.UpdatePipeline()

    producerInformation = producer.GetDataInformation()
    bounds = producer.GetDataInformation().GetBounds()

    # Detect MPI rank based on bounds
    is_mpi = not (bounds[0] == 0.0 and bounds[1] == 120.0)


    if not is_mpi:
        assert (
            producerInformation.GetNumberOfCells() == 304440
        ), "Producer does not have the right number of cells"
        assert (
            producerInformation.GetNumberOfPoints() == 319440
        ), "Producer does not have the right number of points"
    else:
        assert (
            producerInformation.GetNumberOfCells() == 152220
        ), "Producer does not have the right number of cells"
        assert (
            producerInformation.GetNumberOfPoints() == 161040
        ), "Producer does not have the right number of points"

    
    sliceInformation = grouped.GetDataInformation()
    if not is_mpi:
        assert (
            sliceInformation.GetNumberOfCells() == 21500
        ), "Sliced data does not have the right number of cells"
        assert (
            sliceInformation.GetNumberOfPoints() == 11088
        ), "Sliced data does not have the right number of points"
    else:
        assert (
            sliceInformation.GetNumberOfCells() == 10750
        ), "Sliced data does not have the right number of cells"
        assert (
            sliceInformation.GetNumberOfPoints() == 5588
        ), "Sliced data does not have the right number of points"
