from paraview.simple import *
from paraview.servermanager import vtkProcessModule

print("Executing visualization pipeline on reduced data")

from paraview import catalyst

options = catalyst.Options()
options.GlobalTrigger = "TimeStep"
options.CatalystLiveTrigger = "TimeStep"
options.EnableCatalystLive = 1

# producer data should have ghost cells
producer = TrivialProducer(registrationName="steerchannel")

def catalyst_execute(info):
    extracted_ghost_cells = ExtractGhostCells(Input=producer)
    extracted_ghost_cells.UpdatePipeline()

    producerInformation = producer.GetDataInformation()
    bounds = producer.GetDataInformation().GetBounds()[:2]
    nb_ghostcells = extracted_ghost_cells.GetDataInformation().GetNumberOfCells()
    nb_ghostpoints = extracted_ghost_cells.GetDataInformation().GetNumberOfPoints()

    pm = vtkProcessModule.GetProcessModule()
    controller = pm.GetGlobalController()
    rank = controller.GetLocalProcessId()

    # Data is a 120x59x43 cell grid
    # 4 MPI ranks simulation
    # data is distributed along the x axis

    expected_bounds = [
        (0.0, 31.0),
        (29.0, 61.0),
        (59.0, 91.0),
        (89.0, 120.0),
    ]
    expected_ghostcells = [2537, 5074, 5074, 2537]
    expected_ghostpoints = [5280, 10560, 10560, 5280]
    expected_cells = 76110 + expected_ghostcells[rank]
    expected_points = 81840 + expected_ghostpoints[rank]*0.5

    assert bounds == expected_bounds[rank], f"Producer does not have the right bounds ({bounds})"

    assert (
        nb_ghostcells == expected_ghostcells[rank]
    ), f"Producer does not have the right number of ghost cells ({nb_ghostcells} in rank {rank})"

    assert (
        nb_ghostpoints == expected_ghostpoints[rank]
    ), f"Producer does not have the right number of ghost points ({nb_ghostpoints} in rank {rank})"

    assert (
        producerInformation.GetNumberOfCells() == expected_cells
    ), f"Producer does not have the right number of cells ({producerInformation.GetNumberOfCells()} in rank {rank})"

    assert (
        producerInformation.GetNumberOfPoints() == expected_points
    ), f"Producer does not have the right number of points ({producerInformation.GetNumberOfPoints()} in rank {rank})"
