from paraview.simple import *
from paraview.servermanager import vtkProcessModule

print("Executing data reduction pipeline")

from paraview import catalyst

options = catalyst.Options()

# registrationName must match the channel name used in the
# 'CatalystAdaptor'.
producer = TrivialProducer(registrationName="grid")

ghostcells = GhostCells(Input=producer, GenerateGlobalIds=True)

# Create an extractor taking the output of ghostcells to send it back as a Catalyst result node to AdiosCatalyst.
steering = CreateExtractor("steering", ghostcells, registrationName="steerchannel")

def catalyst_execute(info):
    producer.UpdatePipeline()

    extracted_ghost_cells = ExtractGhostCells(Input=ghostcells)
    extracted_ghost_cells.UpdatePipeline()

    producerInformation = producer.GetDataInformation()
    bounds = producer.GetDataInformation().GetBounds()[:2]
    nb_ghostcells = extracted_ghost_cells.GetDataInformation().GetNumberOfCells()
    nb_ghostpoints = extracted_ghost_cells.GetDataInformation().GetNumberOfPoints()

    pm = vtkProcessModule.GetProcessModule()
    controller = pm.GetGlobalController()
    rank = controller.GetLocalProcessId()

    # Data is a 120x59x43 cell grid
    # 4 MPI ranks simulation
    # data is distributed along the x axis

    expected_bounds = [
        (0.0, 30.0),
        (30.0, 60.0),
        (60.0, 90.0),
        (90.0, 120.0),
    ]
    expected_ghostcells = [2537, 5074, 5074, 2537]
    expected_ghostpoints = [5280, 10560, 10560, 5280]
    expected_cells = 76110
    expected_points = 81840

    assert bounds == expected_bounds[rank], f"Producer does not have the right bounds ({bounds})"

    assert (
        nb_ghostcells == expected_ghostcells[rank]
    ), f"Producer does not have the right number of ghost cells ({nb_ghostcells} in rank {rank})"

    assert (
        nb_ghostpoints == expected_ghostpoints[rank]
    ), f"Producer does not have the right number of ghost points ({nb_ghostpoints} in rank {rank})"

    assert (
        producerInformation.GetNumberOfCells() == expected_cells
    ), f"Producer does not have the right number of cells ({producerInformation.GetNumberOfCells()})"

    assert (
        producerInformation.GetNumberOfPoints() == expected_points
    ), f"Producer does not have the right number of points ({producerInformation.GetNumberOfPoints()})"
