#!/bin/sh

set -e

readonly cmake_root="/opt/"

mkdir -p "$cmake_root"
cd "$cmake_root"

readonly version="4.0.3"
readonly shatool="sha256sum"
readonly sha256sum="585ae9e013107bc8e7c7c9ce872cbdcbdff569e675b07ef57aacfb88c886faac"
readonly platform="linux-x86_64"

readonly filename="cmake-$version-$platform"
readonly tarball="$filename.tar.gz"

echo "$sha256sum  $tarball" > cmake.sha256sum
curl -OL "https://github.com/Kitware/CMake/releases/download/v$version/$tarball"
$shatool --check cmake.sha256sum
tar xf "$tarball"
mv "$filename" cmake

rm -rf "$tarball" cmake.sha256sum
