# AdiosCatalyst

## Requirements

need to build and install:
- adios2 : https://adios2.readthedocs.io/en/latest/
- catalyst2 : https://catalyst-in-situ.readthedocs.io/en/latest/

## Getting started


The current code implements the Catalyst API to write ADIOS2 output from the simulation Conduit nodes. The ADIOS2 reading, alongside to processing and visualization pipeline creation should come later, inspired by the catalyst-replay mechanism.

- first, you will need to specify several environment variables:

```
export PYTHONPATH=/opt/adios2/2.8.0/lib/python3/dist-packages:$PYTHONPATH \
export PYTHONPATH=<paraview-build-location>/lib/python3.8/site-packages:$PYTHONPATH \
export CATALYST_IMPLEMENTATION_PATHS="<adioscatalyst-build-location>/catalyst" \
export CATALYST_IMPLEMENTATION_NAME=adios
```

- then, start the simulation :

```
build/<simulation-name> <adios-xml-config-file> Testing/Commons/catalyst_pipeline.py
```

As we used catalyst like a wrapper, you should be able to start the visualization node, in another terminal, with matplolib :

- export adios for python :

```
export PYTHONPATH=/opt/adios2/2.8.0/lib/python3/dist-packages:$PYTHONPATH
```

- In `Testing/Visu/` run (*gs.bp* should be generated in your build folder):
```
python3 visu.py -i <gs.bp>
```

## Limitations

- The main difference between catalyst2 and adios2 is the `Initialize` method. For adios2, to define a variable we need to know its dimensions but we cannot access them in Catalyst `Initialize`. So we define these variables during the first `Execute` called.
- Adios engine support only [scalar variables](https://adios2.readthedocs.io/en/latest/components/components.html#data-types), so for vector fields we need to split it by components.
