# AdiosCatalyst example: unstructured grid

This example was mainly inspired by the `CxxFullExample` provided on ParaView [here](https://gitlab.kitware.com/paraview/paraview/-/tree/master/Examples/Catalyst2/CxxFullExample).

## Build and dependency

All dependencies are described in the main [README](../../README.md) of this repository.

To build this project please enable `BUILD_EXAMPLES`:

```bash
git clone https://gitlab.kitware.com/paraview/adioscatalyst
cd adioscatalyst
mkdir -p build
cmake -GNinja -DBUILD_EXAMPLES=ON ..
ninja
```

## How run the example

As described in the main README, this implementation required to be launch with two separate command lines in the terminal, one for the simulation and another one for the visualization.

To start the simulation with this example set catalyst environment variable and launch the executable:

```bash
export CATALYST_IMPLEMENTATION_PATHS="/lib/catalyst"
bin/Example_UnstructuredGrid ../Examples/UnstructuredGrid/adios2.xml ../Examples/UnstructuredGrid/paraview_pipeline.py
```

On another terminal to start the visualization part:

```bash
export CATALYST_IMPLEMENTATION_PATHS="<paraview-build-location>/lib/catalyst"
export CATALYST_IMPLEMENTATION_NAME=paraview
bin/AdiosReplay ../Examples/UnstructuredGrid/adios2.xml
```

On the visualization side, when the simulation running, the script `catalyst_pipeline.py` will output bound of each field for specific step, e.g. for timestep 0:

```
executing paraview_pipeline
-----------------------------------
executing (cycle=0, time=0.0)
bounds: (0.0, 76.0, 0.0, 70.8, 0.0, 124.7)
velocity-magnitude-range: (0.0, 107.48023074035522)
pressure-range: (1.0, 1.0)
```

Note that if you want to specify a number of rank on the simulation part, you will need to update the `RendezvousReaderCount` and specify on it the number of rank in the [adios2.xml](adios2.xml).