# AdiosCatalyst example: multimesh

This example was mainly inspired by the `CxxFullExample` provided on ParaView [here](https://gitlab.kitware.com/paraview/paraview/-/tree/master/Examples/Catalyst2/CxxFullExample).

This simulation will follow the 'multimesh' protocol defined in [ParaView](https://kitware.github.io/paraview-docs/latest/cxx/ParaViewCatalystBlueprint.html). It's used to describe how a simulation of a multi block should be pass through catalyst api.

## Build and dependency

All dependencies are described in the main [README](../../README.md) of this repository.

To build this project please enable `BUILD_EXAMPLES`:

```bash
git clone https://gitlab.kitware.com/paraview/adioscatalyst
cd adioscatalyst
mkdir -p build
cmake -GNinja -DBUILD_EXAMPLES=ON ..
ninja
```

## How run the example

As described in the main README, this implementation required to be launch with two separate command lines in the terminal, one for the simulation and another one for the visualization.

To start the simulation with this example, set catalyst environment variable and launch the executable:

```bash
export CATALYST_IMPLEMENTATION_PATHS="/lib/catalyst"
bin/Example_Multimesh ../Examples/Multimesh/adios2.xml ../Examples/Multimesh/paraview_pipeline.py
```

On another terminal to start the visualization part:

```bash
export CATALYST_IMPLEMENTATION_PATHS="<paraview-build-location>/lib/catalyst"
export CATALYST_IMPLEMENTATION_NAME=paraview
bin/AdiosReplay ../Examples/Multimesh/adios2.xml
```

When you running this simulation, the `paraview_pipeline.py` script will output the bound of each grid inside of the multiblock.

Note that if you want to specify a number of rank on the simulation part, you will need to update the `RendezvousReaderCount` and specify on it the number of rank in the [adios2.xml](adios2.xml).
