# Style Guide

From the GitHub Manual of Style, which this style guide inherits from:

> Words are an important part of how software works. Just as we have a style guide for our code, we have a style guide for our tone and our voice. Even though there may be dozens of people creating a product, it should still sound like we speak in one consistent voice.
>
> In other words, the way we write is just as important as the way we design. Consider these things when writing copy.

Where possible, [automated tests](../test/prose) enforce style rules.

## Content Principles
All written content should follow these principles:

* **Approachability:** Don't assume reader has prior knowledge
* **Brevity:** Keep it simple, link to outside content for deeper dives
* **Curation:** Amplify community best practices vs. any individual's point of view

Content should maintain a light-hearted, but wise (think classy, not overly excited) tone. Open source is fun! Readers should feel inspired, not discouraged, by the tone of your writing, and they should trust you to help them get started.

## Mentions

When referring to people that use GitHub, use @mentions of their username instead of their full name.

- :smile: As @jessfraz put it...
- :cry: As [Jess Frazelle](https://github.com/jessfraz) put it...

When referring to a project on GitHub, link to the repository so others can dive deeper, if they choose.

- :smile: @maxogden took a similar approach to [Dat](https://github.com/datproject/dat)...
- :cry: @maxogden took a similar approach to Dat...

## Capitalization

"Guides" is capitalized when referring to the "Open Source Guides", but not when saying "the guide" or "this guide".

- :smile: Welcome to Open Source Guides!
- :smile: The guide is meant to..
- :cry: The goal of this Guide is to...
