# Content Model
Open Source Guides help individuals, communities, and companies embrace open source software. It explains not only how to accomplish a task, but why you'd want to, and how that task fits into the larger story of consuming, contributing to, and producing open source software.

This content was originally created and curated by GitHub, and covers topics that are very relevant to GitHub users, but it is not specific to GitHub products.

For content that is specific to GitHub products, see:

- help.github.com - gets existing users unstuck and back to work.
- guides.github.com -  tutorials about a larger idea or product feature for new users.

Everything written in the guides should fall into one of the following categories.

## Concept Guides

Concept guides dive deep into a specific topic (for example, "Building a community" or "Measuring success"). They may contain visuals and anecdotes to illustrate their point. While meant to be read from beginning to end, they have a table of contents to help the reader quickly skim the content and find a relevant subsection.

## FAQ

An FAQ tackles a complex topic where a reader is likely coming in with specific questions (for example, "The legal side of open source" or "Leadership & governance"). Whereas concept guides aim to teach the entire concept, an FAQ respects a reader's desire to jump around, get the information they need, and leave. The table of contents is especially important in an FAQ, because the page isn't meant to be read from beginning to end. FAQs might also be longer than a concept guide, because of the jump-around navigation.

## Design Elements

If you're writing a concept guide, here are some smaller design elements that enrich the content experience. We use them to draw the reader's attention and break up walls of text; therefore, they should all get some sort of visual treatment.

## Pull quote

We use quotes in the guide to illustrate a point through an anecdote. Pull quotes should highlight real people and their experiences.

## Image

Images help visually illustrate a point. Some images are instructive, such as a graph. Other images are visual, such as a webpage screenshot. We should have lots of these.

## Data vignette

Whereas pull quotes and images help ground ideas in something specific and concrete, data vignettes help connect ideas to bigger systems.

Data vignettes are limited so as not to overwhelm, but contain just enough information to help readers understand why they should pay attention to a certain idea.

## Historical vignette

Historical vignettes are fun anecdotes that keep a reader's attention. They make community members the heroes of the story, and help pass down cultural knowledge.
