---
lang: zh-tw
title: 如何為開源做貢獻？
description: 想為開源貢獻心力？一個菜鳥老手都值得一看的指南。
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## **為何要為開源貢獻心力？**

<aside markdown="1" class="pquote">
  <img src="https://avatars2.githubusercontent.com/u/134585?v=3&s=400" class="pquote-avatar" alt="avatar">
  在開源專案[freenode]的工作讓我學習到許多技能，這些技能在我往後大學研究及實際工作上有許多幫助，我在開源專案的貢獻跟收穫一樣多！
  <p markdown="1" class="pquote-credit">
— @errietta, ["為什麼我熱愛貢獻心力在開源軟體上"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

透過為開源貢獻力量，能從中學習、幫助他人並且從中累積相關技能的經驗 - 任何你能想像得到的技能。

為什麼會有人為開源做出貢獻？有數不清的原因！

### **鞏固現有技能**

無論是撰寫程式碼、設計使用者介面、平面設計，撰寫文章或是組織活動，只要你有意願實踐，你總能在開源專案中找到自己的位置。

### **認識那些與你有相似興趣的人**

一個友善、溫暖的開源社群會讓人們持續的參與。許多人透過參與開源建立了深厚的友誼，可能是在一次的技術研討中，也可能是在線上聊天室的閒聊中發生。

### **尋找導師，並且嘗試幫助他人**

與他人在共享的專案中工作，你會需要向他人解釋自己是如何做的，同時也需要向他人求助。每個參與開源的人都教學相長。

### **在公眾建立你的名聲（以及職業名聲）**

根據開源的定義，你在開源裡的所有工作都是公開的，這也意味開源專案是一個能好好展現你實力的地方。

### **學習人際交往的能力**

開源為練習領導及管理的能力提供了很好的機會。例如如何解決衝突、組織團隊以及如何為工作的優先順序排列。

### **鼓勵作出改變，哪怕只是很微小的改變**

你不一定要持續不斷的貢獻開源才能享受參與的樂趣。你是否曾在某個網站上發現拼寫錯誤，並希望有人能夠修改它？在開源專案中你可以親自修正這樣的錯誤即可。開源讓人們自在的做事，而這正是這個世界應有的體驗。

## 具體而言什麼是貢獻

如果你是一名開源世界的新手，可能會對貢獻的流程心生畏懼。如何找到適合彼此的專案？不會寫程式又想參與怎麼辦？萬一中間出了差錯怎麼辦？

不用擔心！條條大路通羅馬，有很多能參與開源專案的方式。以下是一些實用的技巧，幫你快速的獲得經驗。

### **你不一定要會寫程式才能貢獻**

對開源做出貢獻常見的誤解之一就是：要寫程式纔算貢獻。其實專案裡不需編碼的工作也是[經常被忽視](https://github.com/blog/2195-the-shape-of-open-source)的部分。你對專案所做的非程式類貢獻，其實是對專案來說莫大的幫助！

<aside markdown="1" class="pquote">
  <img src="https://avatars1.githubusercontent.com/u/49038?v=3&s=460" class="pquote-avatar" alt="avatar">
  我被大家所熟知是因為為 CocoaPods 做了一些事, 但大多數人並不知道我實際並沒有為 CocoaPods 本身做了什麼，我多數的工作是撰寫說明文件與品牌宣傳的事情。
  <p markdown="1" class="pquote-credit">
— @orta, ["將自己預設為開源軟體"](https://realm.io/news/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

即便你樂於寫程式，撰寫程式以外的貢獻對於專案來說也是舉足輕重的，維繫這樣的關係也能讓你獲得與專案的其他成員共事的機會。

<aside markdown="1" class="pquote">
  <img src="https://avatars3.githubusercontent.com/u/54418?v=3&s=460" class="pquote-avatar" alt="avatar">
  我第一次接觸 Python 開發團隊（簡稱 python-dev）是在 2002年6月17日，當時我向郵件列表寄了一份請求接受補丁的信，接著我決定為工作小組蒐集整理郵件摘要，後來他們甚至給了我一個機會去諮詢某個主題，這當中的關鍵是，我能注意到有人指出哪些東西必須要處裡。
  <p markdown="1" class="pquote-credit">
— @brettcannon, ["系統維護者的故事"](https://github.com/open-source/stories/brettcannon)
  </p>
</aside>

### **你是否熱衷於規劃活動？**

* 為專案舉辦一個工作坊或線下聚會，[例如 @fzamperin 為 NodeSchool 所做的](https://github.com/nodeschool/organizers/issues/406)
* 為專案舉辦一個大型會議﹝如果它有需求的話﹞
* 幫助社群成員找到合適的會議，或是協助成員找到窗口提交演講的提案。

### 你是否喜愛設計？

* 重新佈置佈局以提高專案的可用性
* 做一份使用者調查去整頓與完善專案導覽或菜單，像 [Drupal 所提出的建議](https://www.drupal.org/community-initiatives/drupal-core/usability)
* 整理一個風格指南，以幫助專案有一致的視覺設計方針。
* 透過藝術創作設計T恤或畫一個新標誌，就像 [hapi.js 的貢獻者所做的](https://github.com/hapijs/contrib/issues/68)

### **你是否熱愛寫作？**

* 撰寫和改善專案的說明文件
* 策劃一個資料夾來蒐集專案的實際應用案例
* 辦一個專案的電子報，或者蒐整郵件列表的摘要
* 寫一個專案教學，就像 [PyPA 的貢獻者做的](https://github.com/pypa/python-packaging-user-guide/issues/194)
* 翻譯專案的說明文件

<aside markdown="1" class="pquote">
  <img src="https://avatars3.githubusercontent.com/u/853712?v=3&s=400" class="pquote-avatar" alt="avatar">
  講真的， [說明文件] 是至關重要的。目前 Babel 的說明文件已經很棒了，這也是它傑出的特色之一。有些段落還需要加強或者補上一個句子，有些段落是很值得讚賞的。
  <p markdown="1" class="pquote-credit">
— @kittens, ["貢獻者召集令"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### **你喜歡組織活動嗎？**

* 指認出過去討論過或重複的議題、推薦一個新的議題類別，讓事物井井有序
* 瀏覽在開放狀態（open）的議題，並建議將已經處於開放狀態很久的議題設為已結束（closed）[就像 @nzakas 在專案 eslint 做的](https://github.com/eslint/eslint/issues/6765)
* 鼓勵最近才剛提問的人將疑問闡釋清楚，加速討論的進展

### **你喜歡寫程式？**

* 嘗試解決一個開放狀態（open）的議題（issue） [就像 @dianjin 在 Leaflet 做的](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* 想想自己是否能協助開發一個新功能？
* 將專案建置變得自動化
* 改善工具及測試方法

### **你喜歡幫助他人？**

* 回答有關於專案的問題，例如在 Stack Overflow( [Postgres 的展示範例](http://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-to-ge) )或者 reddit 上
* 回答處於開放狀態的議題
* 鼓勵、協助創造友善的討論區禮儀

### **你喜歡協助他人改善它的程式嗎？**

* 為他人貢獻的程式碼做程式碼審查
* 寫一個教學向大家介紹如何使用該專案
* 當其他貢獻者的導師， [像在 Rust 專案中 @ereichert 為 @bronzdoc 做的](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### **其實不一定要是開源軟體的專案！**

雖然很多人提到「開源」兩字是指「開源軟體」，其實不盡是如此，許多事物你都可以你可以開源協作，你可以開源一本書、開源食譜、開源一張你整理的清單，都可以像開源軟體一樣發展你想製作的東西。

舉例來說：

* @sindresorhus 蒐集了 [「驚奇」（awesome） 列表](https://github.com/sindresorhus/awesome)
* @h5bp 維護了針對前端開發者的[面試題](https://github.com/h5bp/Front-end-Developer-Interview-Questions)
* @stuartlynn 和 @nicole-a-tesla 蒐集了[關於海鸚的小知識](https://github.com/stuartlynn/puffin_facts)

即使你是一個軟體開法者，撰寫說明文件也能幫助剛加入開源的你去更加的認識它。這通常也能讓你以一個不用接觸程式碼的方式自在的參與專案，當中協作的過程亦能建立你的信心與經驗。

## **根據專案定位自我**

<aside markdown="1" class="pquote">
  <img src="https://avatars2.githubusercontent.com/u/1179362?v=3&s=460" class="pquote-avatar" alt="avatar">
  如果你嘗試使用 Issue tracker 去了解一件 Issue，看完後還是滿腹疑惑，其他的人一定也會。要能會活用這些工具有許多小訣竅，總會有人教你怎麼使用，你也可以直接向他們提出問題。
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["如何為開源做貢獻"](http://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

除了錯誤檢查錯字的簡單工作之外，為開源做貢獻有時就像是走進陌生人群嘗試融入一樣。如果這群人已經討論西討論得的非常深入了，你突然加入劈頭就開始講東，肯定會讓人覺得你有點奇怪。

與其盲目地在社群中拋出你自己的看法，不如先觀察一下社群的氛圍後再提出，這樣你的想法被注意到的機會才會增加。

### **剖析一個開源社群**

每一個開源社群都不盡相同。

在某個開源專案中耕耘多年，意味著你只是對這一個開源專案很熟悉。若是轉換到不同的專案，你可能會發現社群的規範、用字遣詞與溝通方式都變得不一樣了。

很多開源專案還是都遵循著組織架構的。嘗試認識不同社群角色和整體流程，能幫助你在加入一個新的專案時快速的找到你的定位。

一個典型的開源專案都會有下列的這些人：

* **作者:** 專案的發起者或發起的社群
* **擁有者:** 有權限直接修改程式碼或修改文件的管理員（不一定和作者是同一人）
* **維護者:** 貢獻者，負責專案的方向和組織的管理（他們通常也是專案的作者或擁有者。）
* **貢獻者:** 只要是爲專案做出了貢獻的人。
* **社群成員:** 專案的使用者，他們有時會積極的參與討論或是表達他們對專案走向的看法。

一個較大的專案，可能底下還會細分子社群，或是針對不同任務組成的工作小組，比如負責打造工具的小組、引導社群力量的人、負責社群管理以及組織活動的小組等。試著找找看專案網站上「團隊介紹」的頁面，或著也能從說明成員編組的文件中找到更多這類的訊息。

專案會有一系列的說明文件，這些文件通常會在根目錄上找得到清單。

* **許可協議（LICENSE）:** 根據定義，每個開源專案都必須有個[開源許可協議](https://choosealicense.com)。如果專案沒有的話，那它不能算是個開源社群。
* **README:**  README 是一個引導手冊，對剛加入社群的人們表示歡迎，它通常會解釋專案有何用處，為何發起，以及如何快速入門等。
* **貢獻（CONTRIBUTING）:**  READMES 幫助人認識與使用專案，「貢獻」這個文件則是針對想對專案貢獻的人寫的指南。它會說明目前專案需要怎樣類型的貢獻者，並介紹貢獻時的流程是如何進行。並非所有的專案都會有這個文件，但如果有的話某種程度上也是向有意貢獻的人表達友善的意思。
* **行爲準則（CODE_OF_CONDUCT）:** 這份文件裡頭設立了基本規範來約束參與者的行為以及提醒應有的禮儀，並非所有的專案都會有這個文件，但如果有的話某種程度上也是向有意貢獻的人表達友善的意思。
* **其它文件:** 有些專案也許還有其它文件，例如教學、專案導覽，或者是管理政策，這在大型專案中常見。

此外，開源專案還會利用如下列的一些工具來進行組織討論，閱讀這些檔案對於理解社群的想法、是如何工作的有非常大的作用。

* **問題追蹤（Issue tracker）:** 這裡是人們討論專案相關問題的地方。
* **請求提取（Pull requests）:** 這裡給人們檢查程式碼、以及相關問題的討論。
* **論壇或郵件列表:** 一些專案會利用對話式的方式討論主題（例如 _"How do I..."_ 或 _"What do you think about..."_ 來替代回報 Bug 或特別的請求）。然而有一些專案討論過程都全程使用問題追蹤。
* **即時在線聊天:** 有一些專案會使用聊天頻道（諸如 Slack 或 IRC），能夠隨意的談話、協作和快速的交換意見。

## **找尋專案開始貢獻**

讀到這裏，已經對開源專案如何運作有了進一步的了解，是該找一個合適的專案做貢獻的時候了！

如果你從來都沒有爲開源做過貢獻的話，那麼請謹記來自美國總統約翰 F.肯尼迪的這段話：「**不問國家能爲你做什麼，要問你能爲國家做什麼。**」

開源專案的每個面向與跨專案間都需要貢獻者，先不用太專牛角尖的去想你一定要先在那做貢獻，或是做得好不好。

不如從你使用過的或將來會使用到的專案開始貢獻，你特別關注的專案才會是你會自願積極參與的專案。

參與的過程中，如果有任何點子，覺得可以讓專案更好或更不一樣的，就依你的直覺行事。

開源並不是會員專屬的俱樂部；它就是由你這樣的人所打造。「開源」只是針對這個世界的需要修復的問題的一個夢幻術語罷了。

你或許在查看 README 的時候，發現了失效的超連結、或發現了錯字。又或者你在使用的過程中發現了問題、某件你真的覺得該寫進說明文件的議題，與其視而不見或請別人處理，試著自己投入看看是否有你能幫上忙的地方，這就是開源的精神！

> 平均一個專案有[28% 的貢獻是隨意且偶然的](http://www.igor.pro.br/publica/papers/saner2016.pdf) ，像是寫說明文件、修正錯字、調整格式或翻譯。

你也可以利用如下列的資源來找到合適的新專案：

* [GitHub 探索](https://github.com/explore/)
* [First Timers Only](http://www.firsttimersonly.com/)
* [你的第一個 PR](https://yourfirstpr.github.io/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](http://up-for-grabs.net/)
* [貢獻忍者](https://contributor.ninja)

### **提交貢獻前應做的檢查清單**

當你找到了你打算貢獻的專案時，在有任何行動之前，先整體做個瀏覽，確保專案是願意接受貢獻的。否則，你辛勤的工作可能沒有任何的回報。

以下是一個簡易的檢查表，用來評估一個專案是否適合新的貢獻者。

**符合開源的定義**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  有許可協議嗎？通常會在根目錄有一個叫做 LICENSE 的文件。
  </label>
</div>

**專案是否積極地接受各方的貢獻**

在 master branch 上看看提交的活躍度。在 GitHub 上託管的開源專案，你可以在專案主頁上看到這些訊息。

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  最近的一次提交是在什麼時候？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  專案目前有多少貢獻者？
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  提交的次數頻繁嗎？ （在 GitHub，你可以點擊 "commits" 來查看。）
  </label>
</div>

接下來，就是看專案 issue 的數量。

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    目前有多少個還處於開放狀態的 issue？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    專案的維護者對於開放狀態的 issue 回覆是否迅速？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    是否有討論很頻繁的 issue？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    issue 都是最近提的嗎？
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    issue 是否都會一個個地被標為結束？ （在 GitHub, 點擊 "closed" 標籤就可以看到所有已經結束的 issue。）
  </label>
</div>

同樣再來看看 PR 的情形。

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    現在有多少處於開放狀態的PR？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    當提交了 PR 後，維護者的回覆是否迅速？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    是否有討論很熱烈的 PR？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    都是最近發的的 RP 嗎？
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    最近有多少 PR 合併？ （在 GitHub, 點擊 RP頁面的 "closed" 的標籤頁來查看已經關閉的標籤頁。）
  </label>
</div>

**專案是友善的**

一個專案的友好程度意味着更能接納新的貢獻者。

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    在 issue 的問題中，維護者的回答是否有幫助？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    人們在 issue 的討論中、聊天室、論壇是否親切？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    PR 是否被審查過？
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    維護者是否對付出貢獻的人們表達謝意？
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars1.githubusercontent.com/u/401111?v=3&s=400" class="pquote-avatar" alt="avatar">
  當你看到一個很長的對話時，來自核心開發者的零星的回覆排在列表的後面。你就得想想，他們是否在作建設性的總結？是否保持風度的情況下做出最後的決定？如果你看到的是更多的口水仗，這通常代表社群的能量都在拿來爭論，已經不在開發上了。
  <p markdown="1" class="pquote-credit">
— @kfogel, [_開源軟體生產力_](http://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## **如何提交成果**

你已經找到了你喜愛的專案，也已準備好貢獻了，接下來就剩思考如何以一個適當的方式去貢獻。

### **有效溝通**

無論你只是一次性的貢獻，或是決定長期參與社群，在開源的世界裡，學會如何與他人共事是很重要的技能之一。

<aside markdown="1" class="pquote">
  <img src="https://avatars2.githubusercontent.com/u/7693422?v=3&s=460" class="pquote-avatar" alt="avatar">
  \[作爲一名新手,\] 我很快的就注意到，若嘗試要解決一條 issue 時，我不得不向社群提問題。我瀏覽了程式碼，一旦對議題有一定程度的了解後，我就會去社群徵詢一些指南，然後嘩啦！ 在我得到所有的所需要的訊息後，我就有能力親自解決這個問題！
  <p markdown="1" class="pquote-credit">
— @shubheksha, [一名菜鳥進入開源世界的顛頗之旅](https://medium.freecodecamp.com/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39#.pcswr2e78)
  </p>
</aside>

在你提出一個 issue 或 PR 之前，或者是在聊天室提問之前，請謹記下面所列出的幾點建議，會讓你的工作更有效率。

**交代來龍去脈。** 以便於讓其他人能夠快速的理解。比方說執行程式時遇到一個錯誤，你要解釋你是當時是想做甚麼，並描述如何做才能重現錯誤。又比方說你是提交一個新的想法，你要解釋爲什麼這麼想，為什麼你認為這點子對專案會有幫助（而不是只對你有幫助！）

> 😇 _"當我做 Y 的時候 X 功能沒有正常運作"_
>
> 😢 _"X 出問題! 請修好它。"_

**在進一步行動前，做好準備工作。** 不知道沒關係，但至少你要先嘗試過、努力過。在尋求幫助之前，請確認閱讀了專案的 README、文件、issue（open 的和 closed 的）、郵件列表，並在網絡上查查看。當你表現出很強烈的求知慾時，人們會很樂意的幫助你的。

> 😇 _"我不確定 X 是如何做到的，我查閱了說明文件，但沒有找到相關的介紹。"_
>
> 😢 _"我該怎麼做 X 這件事?"_

**溝通時力求精簡明瞭。** 就像發送一份郵件、每一次的貢獻，無論是多麼的簡單，都是需要他人去檢閱的。很多專案都是請求的人多，提供幫助的人少。保持簡潔，能讓你得到他人幫助的機會大大增加。

> 😇 _"我很樂意寫 API 的教學。"_
>
> 😢 _" 有一天開車在高速公路上，停在某個加油站加油的時候，我突發奇想，覺得我們應該這麼做，在進一步解釋之前，我先和大家展示一下… "_

**盡量讓溝通都是在公開場合下進行。** 盡量不要發私訊給維護者，雖然很多人會想這樣做，除非是你要分享一些機敏資訊（諸如安全問題或有人嚴重的違反行為準則）。你若能夠保持談話是公開的，很多人可以從彼此交換的意見中學習和受益。

> 😇 _（評論） "@維護者 你好！我們該如何處理這個 PR ？"_
>
> 😢 _（郵件） "你好，非常抱歉發信給你，但是我實在很希望你能看一下我提交的 PR 。"_

**大膽的提問（但是要有耐心！）。** 每個人參與社群，開始的時候都是新手，哪怕是經驗老到的貢獻者也一樣，在剛進入一個新專案的時候，也是新手。出於同樣的原因，長期維護的人也並不一定都熟悉專案的每一個部分。協作時表現出你的耐心，你也會得到同樣的回報。

> 😇 _"感謝你檢查了這個錯誤，我按照您的建議做了，這是輸出結果。"_
>
> 😢 _"你爲什麼不處理我的問題？這不是你的專案嗎？"_

**尊重社群的決定。** 你的想法可能會和社群的優先順序、願景有所差異，他們可能回覆了你的想法或最後決定不採納你的建言，這時你應該去積極討論並尋求折衷的辦法，維護者必須慎重的考慮你的想法。但是如果你實在是不能同意社群的做法，你還是可以堅持己見將專案分支（fork）出去另起爐灶。

> 😇 _"雖然我很遺憾你不能支援我的需求，但是你解釋這只是對一小部分使用者起作用，我理解你的理由。感謝你的耐心傾聽。"_
>
> 😢 _"你爲什麼不支援我的需求？這真是難以接受！"_

**以上幾點，要銘記在心。** 開源是由來自世界各地的人們共同協作實現的。需要面對跨語言、跨文化、不同的地理位置、不同的時區的問題，另外，單純文字上的溝通無法傳達語氣和情緒。就先假設這些對話都充滿善意吧。不用害怕拒絕人家，詢問事情的狀況，進一步澄清你的立場。試著讓網路世界成為一個更好的地方。

### **多了解來龍去脈**

在正式開始之前，做一些快速檢查，也許有人已經討論過你的疑惑了。瀏覽專案的 README、issue（ open 和 closed 都算）、郵件列表、Stack Overflow。毋需去花好幾個小時去全部折騰一遍，但是用幾個關鍵字搜尋一下是必要的。

如果你沒有找到和你想法一樣的內容，你就可以開工了。如果專案是在 GitHub 上的話，你可以開啓一個 issue 或 PR：

* **Issues** 開啓一次對話或討論
* **Pull requests** 請求接受自己的解決方法
* **簡單的溝通** ，例如澄清或 how-to 的問題，嘗試到 Stack Overflow 、IRC、Slack 或其它聊天頻道問問看。

在你創建 issue 和 PR 之前，請檢查專案的貢獻者文件（文件名通常叫做 CONTRIBUTING，或者就直接寫在 README 中），找到你需要、較具體的東西，例如他們會要求你遵循某個樣板，或者是要求你使用某個測試。

如果你想做一個重大的貢獻，在正式開始之前先創建一個 issue。監控專案是很有幫助的（在GitHub，[點擊 "Watch"](https://help.github.com/articles/watching-repositories/) ，所有當中的對話都會通知你），通知社群的成員們，讓大家知道你要做的工作，免得你做了之後，他們事後才知道。

<aside markdown="1" class="pquote">
  <img src="https://avatars2.githubusercontent.com/u/810438?v=3&s=400" class="pquote-avatar" alt="avatar">
  只要你踊躍的使用 watching ，在 GitHub 上密切觀察專案，並閱讀每一個 issue 和 PR，你會從你積極參與的專案中學到 <em>很多</em> 。
<p markdown="1" class="pquote-credit">
— @gaearon [參與專案](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### 提出問題

你應該在遇到下列情況時，去創建一個 issue：

* 報告一個你自己無法解決的錯誤
* 討論一個重要的主題或想法（例如：社群、遠景、政策等）
* 提議做一個新的功能，或者其它專案的想法

在 issue 的溝通中幾點實用的技巧：

* **假如你看到一個 open 的 issue，也是你打算解決的**，寫下留言，告訴其他人你要開工了。這樣的話，可以避免與其他人做了重複的事情。
* **假如某個 issue 已經處於 open 的狀態很久了**，可能是有人正在處理中，又或者是已經解決了，也請你留言確認一下事情的狀態再決定下一步。
* **假如你創建了 issue ，但是沒多久自己解決了**，也要留言，讓其他人知道，然後結束該 issue 。記錄本身就是爲社群的貢獻。

### **創建 pull request**

在下面的情形時，請你務必使用 PR：

* 提交簡易的補丁 (例如拼寫錯誤、失效的超連結、或者是其它較明顯的錯誤)
* 開始一項別人請求的任務，或者是過去在 issue 中早就討論過的事情

一個 PR 並不代表工作已經完成了。它通常是儘早開啓一個 PR ，這樣其他人可以了解或者給你一些回饋。只需要標記爲 "WIP"（Working in Progress）。你可以隨時添加任何留言。

如果說專案是託管在 GitHub 上，以下是我們對於提交 RP 的建議：

* **[Fork 程式碼](https://guides.github.com/activities/forking/)** 並下載到自己的電腦，在本地端設定「上游」爲遠端倉庫。這樣你可以在提交你的 PR 時保持和「上游」同步，合併時會減少解決衝突的時間。（更多關於同步的說明，請參考[這裡](https://help.github.com/articles/syncing-a-fork/)。）
* **[創建一個分支](https://guides.github.com/introduction/flow/)** 方便自己編輯。
* **參考任何相關的 issue**或在你的 RP 中註記相關的文件（例如："Closes #37."）
* **留下更動前後的螢幕截圖**，如果你修改了 HTML/CSS。在你的 PR 中放上截圖。
* **測試你的工作！**用原本寫好的測試來跑你寫好的新功能，若沒有的話，則需要寫一個測試。無論是否有測試，一定要確保你的改動不會弄壞現有的專案的功能。
* **和專案現有的風格保持一致**，盡你最大的努力，在使用縮排、分號或註釋很可能和你自己的風格大相徑庭，但這是為了節省維護者的精力，為了以後要了解、維護時的方便。

如果這是你第一次提交 PR。可以瀏覽[提交 PR](http://makeapullrequest.com/)的文件，這是 @kentcdodds 專門爲初次創建 PR 的人寫的手把手教學。

## **提交後需要善後的事宜**

你做到了！恭賀你成爲貢獻開源的一員。希望這是一個好的開始。

在你提交了貢獻之後，下面幾種情形中的某種是可能發生的：

### 😭 **沒有人理你。**

希望你在工作開始之前[檢查過了專案的活躍度](./#提出問題)，不過有時即使檢查過了，在一個活躍的專案中沒有人理會你的貢獻也是很正常的。

如果過了一週，依舊沒有人回應，請心平氣和的在同個條目下留言，請人幫你審核。如果你知道可以找誰審核，你可以使用 @名字，提醒他一下。

**千萬不要**私下去聯絡他人；要記住開源專案裡，所有的溝通都應該是公開的。

如果還是沒有人回覆，那就是真的沒有人對你的貢獻做出回應。這可能感覺很差，但千萬不要灰心。每個人都會遇到這樣的情況。有很多原因會導致沒人回應你，這些原因通常也不是你能控制的。再接再厲，換一種方法去提交，或者換一個專案。這也是一個好時機讓你決定不要投資太多時間在成員活動不活躍的專案。

### 🚧 **有人希望你修改你的貢獻。**

被人要求修改你的貢獻是很常見的事情，可能是改變你的提議，或是修改程式碼。

當有人提出變更時，請及時回覆。畢竟他們花時間看了你的工作。開了一則 PR ，然後一走了之是一個壞習慣。如果你不知道如何改，花點時間研究，如果還是沒有想到好辦法，那麼是該向他人求助的時候了。

如果你沒時間處裡一則 issue （舉例來說，如果對話已經持續了一個月了，而你還有其他的事情要處裡），那麼請通知維護的人，你無法及時的回覆了，肯定有人非常樂意接替你的工作的。

### 👎 **你的貢獻沒有被採納。**

你的工作最後可能沒有被接受。希望你沒有為此花太多力氣。如果你不確定爲什麼沒有被接收，這正是一個很好的機會，去詢問維護者的看法、給他們一個澄清的機會。無論如何，你都要對他們的決定表示尊重。別花時間在爭論或樹立敵人上。如果你堅持自己，你還是可以隨意 fork 專案，按照自己的思路發展出分支來。

### 🎉 **你的貢獻被接受。**

太棒了！你完成了一次開源貢獻！

## 你辦到了!

不論你是第一次貢獻，還是正在嘗試其他的貢獻方式， 希望本文有提供你一些靈感去實踐。即便你的貢獻沒有被採納，別忘了對幫助過你的維護者表示感謝。開源就是由你這樣的人所打造：一則 issue、一則 PR或透過留言討論。
