---
lang: zh-cn
title: 通过为开源工作获得报酬
description: 为了让你能够持续的为开源项目，理应得到相应的经济上的报酬。
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Why some people seek financial support

很多开源的工作都是来自志愿者的辛勤付出。例如，有些人在使用项目的过程中遇到了问题，然后快速的修复了；也有些人是利用他们的业余时间在开源项目中需求挑战。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
我尝试着寻找让人爱不释手的编程项目，从而使我的周末或圣诞节也能保持状态。(...)我拥有一台家用电脑，手头也并不十分宽裕。在思考了一阵子之后，我决定写一新的交互式的编程语言，（...)后来我将这门语言叫做Python。
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Python 编程"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

人们从事开源相关的工作，却没有得到报酬，这事一点都不奇怪，让我们来看看缘由：

* **他们本来就有一份自己热爱的全职工作,** 这可以让他们在没有后顾之忧的情况下利用业余空闲时间来为开源做贡献。
* **他们热衷于沉浸在开源的思考中**  又或者是创造逃避环境，只是不想在他们的项目中获得金钱上的回报。
* **他们能够从开源的贡献中获得其它好处，** 比如收获名誉、投资，又或者是学习到新的技能，又或者是能够感觉到和社区很接近。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  对于一些情况，金钱上的赞助会增加责任的感觉，（...）这点对于我们来说很重要，尤其是一个全球性的社区，我们生活在一个快节奏的世界，只是想说明"不是现在，我觉得去做一些完全不同的事"。
  <p markdown="1" class="pquote-credit">
— @alloy, ["为什么我们不接受捐赠"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

但是，很多时候，尤其是正在进行的或者是需要花费大量时间的付出时，能够取得报酬是人们积极参与开源的唯一理由，无论是项目需求还是个人原因。

维护颇流行的项目是一项很重要的责任，需要在每周花10～20小时，而不是每个月的几个小时。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  询问任何一位开源项目维护者，他们会告诉您管理项目的工作量的实际情况。你拥有客户，你要为他们解决问题，你要创建新功能，这些都需要花时间去做。
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["无偿劳动的伦理和开源软件社区"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

有偿工作也使人们从不同的各行各业做出有意义的贡献。有些人无法承受为开源项目做没有金钱回报的工作，他们自身的情况，如当前的财务收入、债务、或者来自家庭等其它的照顾义务。这也就意外着这个世界再也无法看到那些拥有天分但是有心无力的人们的贡献了。这是一个伦理上的问题，正如 @ashedryden 在 [无偿劳动的伦理和开源软件社区](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community) 一文中所描述的，因此开源的很多工作是由那些已经在生活上取得成就的人们所贡献的，通过志愿的贡献进一步让他们获得了更加丰富的回报，而那些无法承受时间的人们错失了这样的机会，这就导致了开源社区越发的缺乏多样性。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   开源软件为技术领域贡献了巨大的好处，其实，更准确的说是所有的行业。(...) 然而，如果仅仅是靠人们自身的痴迷和兴趣所致，那么很可能就没有开源的今天。
  <p markdown="1" class="pquote-credit">
— @isaacs, ["金钱与开源"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

如果你在寻找金钱上的支持，可以考虑两条路径。你可以作为贡献者来将你的时间作为资金，或者是找一家能够为项目提供资金的组织。

## Funding your own time

在今天，有很多人在开源中获得了报酬，无论是兼职或全职。最为常见的做法就是，有些老板愿意为你付出的时间和工作成果掏腰包。

如果你的老板使用到了相应的项目，那么人们找到对应的开源工作就顺理成章，当然这需要你有足够的能力来担当。也有的情况是老板没有使用到相应的开源项目，但是用到了诸如Python之类的开源编程语言，那么能够维护流行的开源编程语言项目可以帮助老板吸引到相应的开发者。又或者都不是，那老板也可以获得对开发者友好的口碑。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/hzoo?s=180" class="pquote-avatar" alt="avatar">
  就像很多开源项目的故事一样，我花了大量的时间来维护项目。当我第一次开始为开源做事情的时候，我在公司待到很晚才回家。（...)然后我就和老板谈，就开源的任务当作本来的工作来做。
  <p markdown="1" class="pquote-credit">
— @hzoo, ["一名维护者的故事"](https://github.com/open-source/stories/hzoo)
  </p>
</aside>

如果你现在还没有为开源项目做工作，但是你希望你现在所做得成绩开源出来，那么你可以和你的老板讲，奉劝他将内部的软件开源。

很多公司都在开发开源项目，从而能够打造自己的品牌，以及希望雇佣到高质量的人才。

@hueniverse ，举例来说，有充足的证据证明 [沃尔玛对开源的投资](https://hueniverse.com/2014/08/15/open-source-aint-charity/)是合理的。 @jamesgpearce 同样，脸谱网的开源项目让它的招聘显得[与众不同](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) :

> 开源能够与我们Hacker文化密切配合，也能够和我们的组织融洽。我们询问员工："在Facebook真的那么的在意开源软件？" 超过2/3的人的回答是"yes"。一半的人表示，该计划对他们为我们工作的决定作出了积极的贡献。这可不是一个戏谑的数字，我们希望继续保持这样。

如果你所在的公司不赞同这么做，没关系，重要的是保持社区和企业活动之间的界限清晰。你要告诉老板，开源的维持是由全球各地的人所贡献，要比任何一个公司或某一地域都大的多。老板会自己作出权衡的。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  获得开源的工作是一个难得的机会，而你不应该放弃对这个过程的热情。公司应该为你的激情付相应的报酬。
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

如果你实在无法在当前的雇主下开展相关开源的工作，那么是该考虑换老板的时候，应到找个支持想开源作贡献的老板！寻找那些致力于开源工作的公司。比如：

* [Ghost](https://ghost.org/)  就是一家围绕很多[开源项目](https://github.com/tryghost/ghost)的好公司
* [Rackspace](https://www.rackspace.com/en-us) 甚至为其员工提供了[贡献开源守则](https://blog.rackspace.com/rackspaces-policy-on-contributing-to-open-source/)

那些大公司发起的项目，如 [Go](https://github.com/golang) 或 [React](https://github.com/facebook/react)，均希望雇佣到优秀的工程师来为他们工作。

当然最终还是要看你自身的条件而定，你甚至可以利用你的开源项目来独立的进行融资。这边就有几个案例：

* @gaearon 通过 [Patreon crowdfunding campaign](https://redux.js.org/)为他的项目 [Redux](https://github.com/reactjs/redux)成功的融到了资金。
* @andrewgodwin [通过 Kickstarter campaign](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django) 为Django schema 迁移拿到了资金

## Finding funding for your project

除了针对个人贡献者的建议之外，还有一些项目可以从公司、独立投资方、以及其它的资金处来获得进一步的工作。

机构资金可能用于支付当前的贡献者，涵盖运行项目的成本（如托管费用）或投资于新功能或想法。

一些获得组织资助的项目案例：

* **[webpack](https://github.com/webpack),**  [通过 OpenCollective](https://opencollective.com/webpack) 从公司和个人来筹集资金
* **[Vue](https://github.com/vuejs/vue),** 由 @yyx990803 创建，[通过 Patreon](https://github.com/open-source/stories/yyx990803)获得资助
* **[Ruby Together](https://rubytogether.org/),** 由 @indirect 创建的非盈利组织 ，为诸如 [bundler](https://github.com/bundler/bundler)、[RubyGems](https://github.com/rubygems/rubygems)、以及其它的一些 Ruby 的基础设施项目提供资金支持

尽管开源日渐的流行，但是为项目寻找资金仍然是处于试验中。目前所收集到的包括：

* **通过大力宣传活动或募捐，为您的工作筹集资金** 这策略在你拥有足够的粉丝，或者是已经社区声誉良好的情况下，又或者是项目非常的受欢迎，等情况下有效。
* **接受基金巨头的资助** 一些软件基金会和公司为开源的相关工作提供很好的机会，如[Python 软件基金会](https://www.python.org/psf/grants/), [Mozilla 基金会](https://www.mozilla.org/en-US/grants/)、以及[Stripe](https://stripe.com/blog/open-source-retreat-2016).
* **获得公司或独立投资商的赞助** 通过软件基金会，或者是干脆 **创业** 来支撑项目。

更多的案例和细节， @nayafia [专门写过一个指南](https://github.com/nayafia/lemonade-stand) ，专门针对的就是如何为开源工作获得报酬。不同类型的资助需要不同的技能，所以仔细的掂量下资格，然后找个最适合自己的方式。

## Building a case for financial support

无论你的项目是新的创意，还是已经运行多年，你都需要为你的资助者满意，并提出有效而合理的案例。

不管是你自己寻找相应的工作，还是为项目融资，你都应该尝试回答下面的问题。

### 影响

为什么说这个项目有实际用处？你的用户或潜在的用户会喜欢它？5年之后它会是什么样子？

### 牵引

尝试着去收集一些和你项目休戚相关的证据，比如指标、有趣的事情、还是其他人的推荐。是否有其它公司或者是业内意见领袖正在使用你的项目？如果没有的话，是不是应该去找相应的人去推荐下？

### 充分利用资助者的价值

资助者，无论他是雇佣你的老板，还是一家获得授权的基金会，你都有机会和他们频繁的进行接触。 他们为什么会放弃其它机会而去支持你的项目？他们个人有何好处？

### 利用风投

您将如何用拟议的资金完成什么？专注于项目里程碑或成果，而不是支付工资。

### 你将以何种方式接受资助

资助者是否有关于宣传的额外需求？例如，你可能需要您可能需要成为非盈利组织或拥有非营利性财政赞助商。又或者是资助者必须给到个人而不是一个组织。这些不同的需求会因为不同的资助者而异，所以请事先做好准备。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  多年以来，我们一直都是网站友好图标资源的领先者，社区超过2千万人，并为7千万网站提供资源，其中包括 Whitehouse.gov。 (...) 3年前我们发布了Font Awesome 的第4个版本。Web技术从那时起改变了更多事情，而且坦率的说Font Awesome 都有点过时。 (...) 这也是我们刚刚发布 FontAwesome 5的原因之一，我们模块化和重写了 CSS，并从上到下重新设计了每一个图标。我们积极的探讨更好的设计、更好的一致性、以及更好的可读性。
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter 众筹视频](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Experiment and don't give up

赚更多的钱不是件容易的事情，无论你是在开源项目，亦或是在非盈利组织，又或者是软件的创业公司，但是无论在哪里，挣更多钱的秘密就是更多的创造力。当确定了你想如何获得报酬的时候，请继续你的研究，将自己放在投资人的角度来看问题，可以帮助你更好的构建一个更加令人信服的赚钱之道。
