---
lang: zh-cn
title: 为项目寻找合适的用户
description: 通过找到称心如意的用户，帮助开源项目成长。
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Spreading the word

并没有什么规范说当你创建一个开源项目时，要怎么去推广它。但没有任何理由说必须默默无闻的在开源项目上工作。相反，如果你想要有更多的人发现和使用你的开源项目，你就应该让所有人知道你所努力的成果！

## Figure out your message

在开始推广你的项目之前，你应该能够解释你的项目是做什么的，为什么大家需要它?

是什么让你的项目变得不同或者有趣，在自己心中问这些问题会让你更容易说服别人。

牢记一件事情，别人之所以使用你的项目，甚至是为你的项目做贡献，是因为你的项目解决了他们的问题。所以你要找出他们需要什么，然后把它当成你项目的卖点或者说价值所在。

举个例子，[@robb](https://github.com/robb)用代码实例来清晰的阐述为什么他的项目[Cartography](https://github.com/robb/Cartography)是有用的。

![cartography readme](/assets/images/finding-users/cartography.jpg)

如果你想深入了解如何挖掘项目的"卖点"，看一下Mozilla的["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/)，练习如何建立用户的形象。

## Help people find and follow your project

<aside markdown="1" class="pquote">
  你最好有一个唯一的"主页"链接用来推广，引导人们关注你的项目。你不需要找一个炫酷的模板或者域名，但是你的项目确实需要一个入口。
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

通过引导他们到一个唯一的地址来帮助人们发现和记住你的项目。

**要有一个推广的主阵地。**一个Twitter账号，Github链接，或者IRC频道是引导人们查看你的项目的一个简单方式。这些方式也给你日益增长的社区一个讨论的好地方。

如果你目前还不想给你的项目搞这么多乱七八糟的东西，只要在有机会的时候推广你的Twitter账户和Github账户即可。举个例子，如果你在某一个讨论会或者活动上发言要保证在你的简历或者幻灯片上包含这些信息。只有这样人们才会知道怎么找到你或者关注你的工作。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  我之前犯过的一个错误就是没有给项目开一个Twitter账户。Twitter是一个让人们知晓项目进展的好渠道，也可以让人们持续的接触到你的项目。
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**考虑给你的项目做一个网站**一个网站可以让你的项目更加友好，而且更加容易浏览，更重要的是附上清晰的文档和教程。这也是象征着你的项目还是活跃的，这会让你的用户在使用项目时感觉更放心。可以用一些例子告诉人们如何使用你的项目。

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), Django的作者说，我们给Django做的网站可以说是"在早期开发Django的时候做的最好的一件事情了"。

如果你的项目是托管在GitHub上的，你可以用[GitHub Pages](https://pages.github.com/)简单地创建一个网站。[Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), and [Middleman](https://middlemanapp.com/) 是一些优秀的内容详尽的网站[例子](https://github.com/showcases/github-pages-examples)

![vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

现在你的项目有了"卖点"，和让人们很容易发现你项目的渠道，接下来我们谈谈如何和你的用户交流吧！

## Go where your project's audience is (online)

网上拓展是分享和快速宣传项目的一个好方法。借助一些网上的渠道，你有可能找到一大批受众。

利用好已有的线上社区和平台去找你的受众。如果你的开源项目是一个软件项目，你可能会在[Stack Overflow](https://stackoverflow.com/), [reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/), 或者[Quora](https://www.quora.com/)，找到你认为最有可能从你的项目中受益或者对你项目感兴趣的渠道。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  每个程序都会有那么一些方法只有一部分人才会用到，所以不要想着去打扰每一个人，把你的力气用在可能会从你项目受益的社区就好。
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

来看看下面的一些方法吧，也许推广你的项目的时候用得着。

* **快找找有没有相关的开源项目和社区。**有时候，你不需要直接推广你的项目。如果你的项目对使用Python的数据科学家来说是无可挑剔的，那么就去找Python数据科学的社区。等他们知道你的项目之后，很自然的就会谈论然后分享你的工作成果。
* **如果你的项目尝试解决某些问题，那么找到会遇到这些问题的人。**想一下你的项目受众会在哪些论坛，然后搜索这些论坛，回答他们的问题，然后找一个合适的时机，向他们建议使用你的项目来作为一种解决方案。
* **寻求反馈。**向一个可能会用到你项目的人介绍你自己和你做的工作。对哪些人会从你的项目受益要很明确。尝试完善一下下面这句话："我觉得我的项目能够帮助到A，那些尝试做B事情的人"。听取和回复别人的反馈，而不是简单的推广。

一般来说，在你索取什么回报之前先把精力放在帮助别人上。因为在网上推广一个项目对任何人都是一个不难的事情，肯定会有一些不同的声音。告诉人们你是谁，而不是你想要什么，这样才能从众多推广者中脱颖而出。

如果没有人对你的推广感兴趣，不要灰心！大部分的项目的开展都是一个要花费数月和数年的反复过程。如果你第一次没收到反应，尝试换一种策略，或者找办法给别人的项目做做贡献。这都是些需要时间和奉献精神的事情。

## Go where your project's audience is (offline)

![public speaking](/assets/images/finding-users/public_speaking.jpg)

线下活动是向观众推广新项目的常见方式之一。这是一个接触某个忠实听众和建立深层次联系的好方式，特别是如果你对到场的开发者感兴趣的话。

如果你还是个[公众演讲的新手](https://speaking.io/)，从寻找一个和你项目使用的语言或者生态系统相关的当地的聚会开始吧。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  我去PyCon的时候非常紧张。我要发表一个演讲，在那儿我就认识几个人，还在那儿呆了整整一周。但是其实我不应该焦虑的。PyCon真是太棒了！每个人都是超级友好外向，以至于我很少有时间不和别人讲话。
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

如果你从来没在公共场合讲过话，感觉紧张那就太正常啦！记住你的听众就在那儿，因为他们都是真正的想听你介绍你的项目。

当你在写你的演讲稿的时候，把重点放在你的听众会感兴趣而且能获取价值的事情上。保证你的语言要友好和亲切。笑一笑，深呼吸，幽默一点儿。

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  当你开始写你的演讲稿的时候，不管你的主题是什么，如果你能把你的演讲当成是给别人讲故事的话，效果会更更好。
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

等你准备好了，考虑一下在某个会议上发言的时候推广你的项目研讨会可以帮助你接触更多人，有时候是来自全世界各地的人。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  我非常认真的给JSConf的人写了一封信，然后求他们给我一点时间在JSConf上展示我的项目。同时我又非常担心，这个项目我做了六个月，要是大家不认可怎么办。那时候我就一直在想，我的天，我在这里都干些什么事啊？
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Build a reputation

除了上面提到的策略之外，邀请人们分享和支持你的项目的最好办法就是分享和支持他们的项目。

帮助新手，分享资源，给别人的项目认真的做贡献会帮助你建立起良好的声誉。然后他们就很有可能知道你的项目而且更有可能关注和分享你在做的事情。

有时候，这些关系还会进一步发展成更广阔的生态系统中的官方合作伙伴（意思是你有可能成为那些知名社区的成员）

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  urllib3现在成为最流行的Python第三方库的唯一原因就是大家都需要它。
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

种一棵树的最好时间是十年前，其次是现在。所以任何时候开始建立你的声望都不晚。即使是你早就已经建立了自己的项目，也还是要继续找办法帮助别人。

建立用户群没有一蹴而就的方法。获取别人的信任和尊重需要时间，同样，建立声望的过程也永远不会停止。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ariya?s=180" class="pquote-avatar" alt="avatar">
  PhantomJS公开第一个版本的时候是在2011年初。我也就是用了一些常规的方法来推广：发Twitter，写博客告诉别人可以用它来做什么，在各种各样的聚会上我都提到过它。到2014年它已经广为人知的时候，我才开始做关于它的演讲。
  <p markdown="1" class="pquote-credit">
— @ariya, ["Maintainer Stories"](https://github.com/open-source/stories/ariya)
  </p>
</aside>

## Keep at it!

有时候，让人们注意你的开源项目会花费很多时间。但是没关系！一些今天很流行的项目都是花了很多年才有如今的高活跃度。把重点放在建立声望上而不是企图一夜成名。耐心一点，一如既往的和那些可能会从中受益的人分享你的项目。
