---
lang: ta
title: திறந்த மூல அளவீடுகள்
description: உங்கள் திறந்த மூல திட்டத்தை வெற்றிகரமாக அளவிட்டு, அதன் வெற்றியை கண்காணிப்பதன் மூலம் அறிவுறுத்தப்பட்ட முடிவுகளை எடுங்கள்.
class: metrics
order: 9
image: /assets/images/cards/metrics.png
related:
  - finding
  - best-practices
---

## ஏன் எதையும் அளவிட வேண்டுமா?

திறந்த மூல பராமரிப்பாளராக சிறந்த தீர்மானங்களை எடுக்க உதவுவதற்கு, தரவு உங்களுக்கு பயனுள்ளதாக இருக்கும்.

கூடுதலான தகவலுடன், நீங்கள்:

* புதிய அம்சத்திற்கு பயனர்கள் எவ்வாறு பதிலளிக்கிறார்கள் என்பதைப் புரிந்து கொள்ளுங்கள்
* புதிய பயனர்கள் எங்கிருந்து வருகிறார்கள் என்பதைக் கண்டறியவும்
* அடையாளம் கண்டறிந்து, ஆதரவளிப்பீர்களா, வெளிப்படையான பயன்பாடு வழக்கு அல்லது செயல்பாடு என்பதை முடிவு செய்யுங்கள்
* உங்கள் திட்டத்தின் புகழை அளவிடுங்கள்
* உங்கள் திட்டம் எவ்வாறு பயன்படுத்தப்படுகிறது என்பதை புரிந்து கொள்ளுங்கள்
* நிதியுதவி மற்றும் மானியங்கள் மூலம் பணம் திரட்டவும்

உதாரணத்திற்கு, [ஹோம்புருவ்](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Analytics.md) கூகுள் பகுப்பாய்வியல் வேலைக்கு முன்னுரிமை கொடுக்க உதவுகிறது:

> ஹோம்புருவ் இலவசமாக வழங்கப்படுகிறது மற்றும் முழுமையாக தன்னார்வலர்களால் தங்கள் ஓய்வு நேரத்தில் இயக்கப்படுகிறது. இதன் விளைவாக எதிர்கால அம்சங்களை எவ்வாறு வடிவமைப்பது மற்றும் தற்போதைய பணியை முன்னுரிமைப்படுத்துவது ஆகியவற்றை எவ்வாறு தீர்மானிப்பது என்பதைத் தீர்மானிக்க வீட்டு ஹோம்புருவ் பயனர்களின் விரிவான பயனர் ஆய்வுகள் செய்ய எங்களிடம் ஆதாரங்கள் இல்லை. பெயர் அறியப்படாத ஒருங்கிணைந்த பயனர் பகுப்பாய்வு, எங்கு, எங்கு, எப்போது மக்கள் ஹோம்புருவ்-ஐ பயன்படுத்துவது என்ற அடிப்படையில் திருத்தங்கள் மற்றும் அம்சங்களை முன்னுரிமை செய்ய அனுமதிக்கிறது.

புகழ் மட்டுமே எல்லாம் இல்லை. எல்லோரும் வெவ்வேறு காரணங்களுக்காக திறந்த மூலத்தை அடைவார்கள். திறந்த மூல பராமரிப்பாளராக உங்கள் குறிக்கோள் உங்கள் வேலையை காட்ட வேண்டும் என்றால், உங்கள் குறியீட்டு பற்றி வெளிப்படையானதாக இருக்க வேண்டும், அல்லது கேளிக்கையாக இருந்தால், அளவீடு உங்களுக்கு முக்கியமானதாக இருக்காது.

நீங்கள் உங்கள் திட்டத்தை ஒரு ஆழமான மட்டத்தில் புரிந்து கொள்ள ஆர்வமாக இருந்தால், உங்கள் திட்டத்தின் செயல்பாட்டை ஆராய்வதற்கான வழிகளைப் படிக்கவும்.

## கண்டுபிடித்தல்

யாராவது உங்கள் திட்டத்திற்கு மீண்டும் பயன்படுத்த அல்லது பங்களிக்க முன்பு, அவர்கள் அது இருப்பதை தெரிந்து கொள்ள வேண்டும். உங்களை நீங்களே கேட்டுக்கொள்ளுங்கள்: _மக்கள் இந்த திட்டத்தை கண்டுபிடிக்கிறார்களா?_

![போக்குவரத்து வரைபடம்](/assets/images/metrics/repo_traffic_graphs_tooltip.png)

உங்கள் திட்டம் கிட்ஹப் இல் வழங்கப்பட்டிருந்தால், உங்கள் திட்டத்திற்கு எத்தனை பேர் வருகிறார்கள் மற்றும் எங்கிருந்து வருகிறார்கள் என்பதை [நீங்கள் காணலாம்](https://help.github.com/articles/about-repository-graphs/#traffic). உங்கள் திட்டத்தின் பக்கத்திலிருந்து, "நுண்ணறிவு" என்பதைக் கிளிக் செய்து, பின்னர் "போக்குவரத்து" என்பதைக் கிளிக் செய்யவும். இந்த பக்கத்தில், நீங்கள் பார்க்க கூடியது:

* **மொத்த பக்கம் நோக்குகள்:** எத்தனை முறை உங்கள் திட்டம் பார்க்கப்பட்டது என்று உங்களுக்கு சொல்கிறது

* **மொத்த தனித்துவமான பார்வையாளர்கள்:** உங்கள் திட்டத்தை எத்தனை பேர் பார்த்தார்கள் என்று உங்களுக்கு சொல்கிறது

* **குறிப்பிடு தளங்கள்:** பார்வையாளர்கள் எங்கிருந்து வந்தார்கள் என்று உங்களுக்கு சொல்கிறது. உங்கள் பார்வையாளர்களை எங்கு சென்று அடைவது, உங்கள் ஊக்குவிப்பு முயற்சிகள் உழைக்கிறதா என்பதையும் இந்த அளவீடு உங்களுக்கு உதவும்.

* **பிரபலமான உள்ளடக்கம்:** பார்வையாளர்கள் உங்கள் திட்டத்தில் எங்கு செல்கிறார்கள், பக்கம் நோக்குகள் மற்றும் தனித்துவமான பார்வையாளர்களால் பிரிக்கப்பட்டு உங்களுக்குத் தெரிவிக்கும்.

[கிட்ஹப் நட்சத்திரங்கள்](https://help.github.com/articles/about-stars/) பிரபலத்தின் அடிப்படை அளவை வழங்க உதவுகிறது. கிட்ஹப் நட்சத்திரங்கள் பதிவிறக்கங்கள் மற்றும் பயன்பாட்டுடன் அவசியம் தொடர்பில்லை என்றாலும், உங்கள் வேலையை எத்தனை பேர் கவனிக்கிறார்களென அவை உங்களுக்கு சொல்ல முடியும்.

நீங்கள் [குறிப்பிட்ட இடங்களில் கண்டுபிடிப்பதை கண்டறியலாம்](https://opensource.com/business/16/6/pirate-metrics):  எடுத்துக்காட்டாக, கூகுள் பக்க தரவரிசை, உங்கள் திட்டத்தின் வலைத்தளத்திலிருந்து பரிந்துரைத்த போக்குவரத்து, அல்லது பிற திறந்த மூல திட்டங்கள் அல்லது வலைத்தளங்களில் இருந்து பரிந்துரைகளை வழங்குகிறது.

## பயன்பாடு

இந்த கட்டுப்பாடற்ற இடத்திலும் மக்கள் இந்த திட்டத்தை கண்டுபிடிப்பதை இணையம் என நாங்கள் அழைக்கிறோம். வெறுமனே, அவர்கள் உங்கள் திட்டம் பார்க்கும் போது, அவர்கள் ஏதாவது செய்ய கட்டாயம் உணர வேண்டும். நீங்கள் கேட்க விரும்பும் இரண்டாவது கேள்வி என்னவென்றால்: _இந்த திட்டத்தை மக்கள் பயன்படுத்துகிறார்களா?_

உங்கள் திட்டத்தை விநியோகிக்க, நீங்கள் npm அல்லது RubyGems.org போன்ற ஒரு தொகுப்பு நிர்வாகியைப் பயன்படுத்தினால், நீங்கள் உங்கள் திட்டத்தின் பதிவிறக்கங்களைக் கண்காணிக்க முடியும்.

ஒவ்வொரு தொகுப்பு மேலாளரும் "பதிவிறக்க" என்ற சற்று வித்தியாசமான வரையறையைப் பயன்படுத்தலாம், மற்றும் பதிவிறக்கங்கள் அவசியம் நிறுவ அல்லது பயன்படுத்தத் தேவை இல்லை, ஆனால் அது ஒப்பீட்டளவில் சில அடிப்படைகளை வழங்குகிறது. பல பிரபலமான தொகுப்பு மேலாளர்களுக்கிடையே பயன்பாட்டு புள்ளிவிவரங்களைக் கண்காணிக்க [Libraries.io](https://libraries.io/) ஐப் பயன்படுத்தி முயற்சிக்கவும்.

உங்கள் திட்டம் கிட்ஹப் இல் இருந்தால், "போக்குவரத்து" பக்கம் மீண்டும் செல்லவும். உங்கள் திட்டத்தை ஒரு குறிப்பிட்ட நாளில் எத்தனை முறை நகலி எடுக்கப்படுகிறது, மொத்த நகலிகள் மற்றும் தனிப்பட்ட நகலி எடுத்தவர்கள் என பிரித்து பார்க்க [நகலி வரைபடம்](https://github.com/blog/1873-clone-graphs) பயன்படுத்த முடியும்.

![நகலி வரைபடம்](/assets/images/metrics/clone_graph.png)

உங்கள் திட்டத்தை கண்டுபிடிப்பவர்களின் எண்ணிக்கை ஒப்பிடும்போது பயன்பாடு குறைவாக இருந்தால், கருத்தில் கொள்ள இரண்டு சிக்கல்கள் உள்ளன. இரண்டில் ஒன்று:

* உங்கள் திட்டம் வெற்றிகரமாக உங்கள் பார்வையாளர்களை மாற்றவில்லை, அல்லது
* நீங்கள் தவறான பார்வையாளர்களை ஈர்க்கிறீர்கள்

உதாரணமாக, ஹேக்கர் நியூஸ் முன் பக்கத்தில் உங்கள் திட்டம் தரையிறங்கி இருந்தால், நீங்கள் ஹேக்கர் நியூஸ் அனைவரையும் அடைந்து கொண்டிருப்பதால், ஒருவேளை திட்டத்தை கண்டுபிடிப்பதில் (போக்குவரத்தில்) ஒரு உச்சமடைதலை காணலாம், ஆனால் குறைந்த மாற்று விகிதமே இருக்கும். உங்கள் ரூபி திட்டம் ஒரு ரூபி மாநாட்டில் இடம்பெற்றிருந்தால், நீங்கள் உங்கள் இலக்கு பார்வையாளர்களிடமிருந்து அதிக மாற்று விகிதத்தைக் காணலாம்.

உங்களுடைய பார்வையாளர்கள் எங்கிருந்து வருகிறார்கள் என்பதைக் கண்டுபிடிக்க முயற்சிக்கவும் மற்றும் நீங்கள் எதிர்கொள்ளும் இந்த இரண்டு சிக்கல்களில் எது கண்டுபிடிக்கப்பட வேண்டும் என்பதை உங்கள் திட்டப்பக்கத்தில் கருத்துத் கேட்கவும்.

உங்கள் திட்டத்தை மக்கள் பயன்படுத்தி வருகின்றனர் என்பதை நீங்கள் அறிந்தவுடன், அவர்கள் என்ன செய்கிறார்கள் என்பதை நீங்கள் கண்டுபிடிக்க முயற்சி செய்யலாம். உங்கள் குறியீட்டின் கவையை கொண்டு, அம்சங்களைச் சேர்ப்பதன் மூலம் அவர்கள் அதை உருவாக்கிக் கொண்டிருக்கிறார்களா? அவர்கள் அதை அறிவியல் அல்லது வணிகத்திற்கு பயன்படுத்துகிறார்களா?

## தக்கவைத்தல்

மக்கள் உங்கள் திட்டத்தை கண்டுபிடித்து அதை பயன்படுத்துகின்றனர். உங்களை நீங்களே கேட்க வேண்டிய அடுத்த கேள்வி: _இந்த திட்டத்திற்கு மக்கள் பங்களிப்பு செய்கிறார்களா?_

பங்களிப்பாளர்களைப் பற்றி சிந்திக்கத் தொடங்குவதற்கு இது மிகவும் முற்போக்கானது அல்ல. மற்றவர்கள் தூக்கி எறியவில்லையென்றாலும், உங்கள் திட்டம் _புகழ்பெற்றது_ (பலர் இதைப் பயன்படுத்துகிறார்கள்) ஆனால் _ஆதரிக்கவில்லை_ (தேவைப்பாட்டை சந்திக்க போதுமான பராமரிப்பாளர் நேரம் இல்லை) என்றால் ஆரோக்கியமற்ற சூழ்நிலையில் உங்களை ஈடுபடுத்திக் கொள்கிறீர்கள்.

தக்கவைத்தலுக்கு [புதிய பங்களிப்பாளர்களிடம் செல்வதற்கு](http://blog.abigailcabunoc.com/increasing-developer-engagement-at-mozilla-science-learning-advocacy#contributor-pathways_2) தேவைப்படுகிறது, இதற்கு முன்பு செயலில் பங்களிப்பவர்கள் இறுதியில் மற்ற விஷயங்களுக்கு நகர்வார்கள்.

நீங்கள் தொடர்ந்து கண்காணிக்க விரும்பும் சமூக அளவீடுகளின் எடுத்துக்காட்டுகளில் பின்வருவன அடங்கும்:

* **பங்களிப்பாளர்களின் மொத்த எண்ணிக்கை மற்றும் பங்களிப்பு தொகைகளின் எண்ணிக்கை:** உங்களுக்கு எத்தனை பங்களிப்பாளர்கள் உள்ளனர் என கூறுகிறது, மேலும் அவர்களில் அதிக அல்லது குறைவான செயலில் உள்ளவர் யார். கிட்ஹப் மீது, நீங்கள் இதை "நுண்ணறிவு" -> "பங்களிப்பாளர்கள்" என்பதில் காணலாம். இப்போது, இந்த வரைபடம் களஞ்சியத்தின் இயல்புநிலை கிளைக்கு பங்களித்த பங்களிப்பாளர்களை மட்டுமே கணக்கிடுகிறது.

![பங்களிப்பாளர் வரைபடம்](/assets/images/metrics/repo_contributors_specific_graph.png)

* **முதல் முறை, சாதாரண, மற்றும் திரும்ப வரும் பங்களிப்பாளர்கள்:** புதிய பங்களிப்பாளர்கள் வருகிறார்களா, அவர்கள் திரும்பி வருகிறார்களா என்பதை நீங்கள் கண்காணிக்க உதவுகிறது. (குறைந்த பங்களிப்புடன் சாதாரண பங்களிப்பாளர்கள் பங்களிப்பவர்கள். அது ஒன்றே ஒன்று தான், ஐந்து ஒப்புவிப்புகளுக்கு குறைவாகவோ அல்லது வேறு ஏதாவது என்பது உங்களை பொறுத்தது.) புதிய பங்களிப்பாளர்கள் இல்லாமல், உங்கள் திட்டத்தின் சமூகம் தேக்கமுற்றதாகிவிடும்.

* **திறந்த சிக்கல்கள் மற்றும் திறந்த இழு கோரிக்கைகளின் எண்ணிக்கை:** இந்த எண்கள் மிக அதிகமானதாக இருந்தால், உங்களுக்கு சிக்கல் மற்றும் குறியீட்டு மதிப்பீடுகளுடன் உதவி தேவைப்படலாம்.

* **_திறந்துள்ள_ சிக்கல்கள் மற்றும் _திறந்துள்ள_ இழு கோரிக்கைகளின் எண்ணிக்கை:** Oதிறந்த சிக்கல்கள் என்பது ஒரு சிக்கலைத் திறக்க உங்கள் திட்டம் பற்றி யாராவது அக்கறை காட்டுகிறார்கள். காலப்போக்கில் அந்த எண்ணிக்கை அதிகரிக்கிறது என்றால், உங்கள் திட்டத்தில் மக்கள் அக்கறை காட்டுகிறார்கள்.

* **பங்களிப்பு வகைகள்:** உதாரணமாக, எழுத்துப்பிழைகள் அல்லது பிழைகளை சரிசெய்து, அல்லது சிக்கலில் கருத்து தெரிவித்தல்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/arfon?s=180" class="pquote-avatar" alt="avatar">
  திறந்த மூலம் குறியீட்டை விட கூடுதலாகும். வெற்றிகரமான திறந்த மூல திட்டங்கள் இந்த மாற்றங்கள் பற்றி உரையாடல்களுடன் குறியீடு மற்றும் ஆவண பங்களிப்பு ஆகியவை அடங்கும்.
  <p markdown="1" class="pquote-credit">
— @arfon, ["திறந்த மூல வடிவம்"](https://github.com/blog/2195-the-shape-of-open-source)
  </p>
</aside>

## பராமரிப்பாளர் செயல்பாடு

இறுதியாக, உங்கள் திட்டத்தின் பராமரிப்பாளர்கள் பெறப்பட்ட பங்களிப்புகளின் அளவைக் கையாள முடியும் என்பதை உறுதிப்படுத்துவதன் மூலம் வட்டத்தை மூடுவதை நீங்கள் விரும்புவீர்கள். உங்களை நீங்களே கேட்க வேண்டிய கடைசி கேள்வி: _நான் (அல்லது நாம்) நமது சமூகத்திற்கு மறுமொழி கூறுகிறோமா?_

செயற்படாத பராமரிப்பாளர்கள் திறந்த மூல திட்டங்களுக்கான ஒரு சிக்கல். யாராவது ஒரு பங்களிப்பைச் சமர்ப்பித்திருந்து, ஒரு பராமரிப்பாளரிடமிருந்து ஒருபோதும் மறுமொழி வரவில்லையென்றால், அவர்கள் சோர்வடைந்து விடுவார்கள்.

[மோசில்லாவிலிருந்து ஆராய்ச்சி](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) பராமரிப்பாளர் எதிர்க் குறிப்பு உணர்த்துதல் மீண்டும் பங்களிப்புகளை ஊக்குவிப்பதில் ஒரு முக்கிய காரணி என்று கூறுகிறது.

ஒரு சிக்கல் அல்லது இழு கோரிக்கை நீங்கள் எவ்வளவு நேரம் எடுத்துக்கொள்கிறீர்கள் (அல்லது இன்னுமொரு பராமரிப்பாளர்) எடுத்துக்கொள்வதைக் கவனியுங்கள். மறுமொழி கூற நடவடிக்கை தேவையில்லை. எளியதாக கூறுவதென்றால்: _"உங்கள் சமர்ப்பிப்பிற்கு நன்றி! நான் அடுத்த வாரத்திற்குள் இதை மதிப்பாய்வு செய்வேன்."_

நீங்கள் பங்களிப்பு செயல்முறை நிலைகளில் இடையே நகர்த்த எடுக்கும் நேரத்தை அளவிட முடியும், அதாவது:

* ஒரு சிக்கல் திறந்த நிலையில் உள்ள சராசரி நேரம்
* சிக்கல்கள் PRக்கள் மூலம் மூடப்பட்டனவா
* பழைய பிரச்சினைகள் மூடப்பட்டனவா
* இழு கோரிக்கையை ஒன்றாக்க சராசரி நேரம்

## மக்களைப் பற்றி அறிய 📊 பயன்படுத்தவும்

அளவீடுகளை புரிந்துகொள்ளுவது செயலில் உள்ள, வளர்ந்து வரும் திறந்த மூல திட்டத்தை உருவாக்க உதவும். நீங்கள் முகப்புப்பெட்டி ஒவ்வொரு அளவீடு பகுதியையும் கண்காணிக்கவில்லை என்றால், உங்கள் திட்டத்தை வளர்த்துக் கொள்ள உதவும் நடத்தை வகையின் மீது உங்கள் கவனத்தை ஒருமுகப்படுத்த மேலே உள்ள கட்டமைப்பைப் பயன்படுத்தவும்.
