---
lang: ta
title: உங்கள் திட்டத்திற்கான பயனர்களைக் கண்டறிதல்
description: மகிழ்ச்சியான பயனர்களின் கைகளில் தருவதன் மூலம் உங்கள் திறந்த மூல திட்டத்தை வளர உதவுங்கள்.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## வார்த்தை பரப்புதல்

நீங்கள் ஒரு திறந்த மூல திட்டத்தை தொடங்கும் பொழுதே ஊக்குவிக்க வேண்டும் என்று எந்த விதியும் இல்லை. திறந்த மூலத்தில் பணியாற்றுவதற்கு பல முழுமையடைக்கூடுய காரணங்கள் உள்ளன, அவை பிரபலத்துவத்திற்காக இல்லை. உங்கள் திறந்த மூல திட்டத்தை கண்டுபிடித்துப் பயன்படுத்துவதற்கு மற்றவர்களை நம்புவதற்குப் பதிலாக, உங்களின் கடின உழைப்பைப் பற்றி வார்த்தைகளைப் பரப்ப வேண்டும்!

## உங்கள் செய்தியைக் கண்டறியவும்

உங்கள் திட்டத்தை ஊக்குவிப்பதற்கான உண்மையான பணியைத் தொடங்குவதற்கு முன், நீங்கள் என்ன செய்ய வேண்டும் என்பதை விளக்கவும், ஏன் முக்கியம் என்பதை விளக்கவும் முடியும்.

உங்கள் திட்டம் வித்தியாசமானதா அல்லது சுவாரஸ்யமானதா? நீங்கள் ஏன் அதை உருவாக்கினீர்கள்? இந்த கேள்விகளுக்கு பதில் அளிப்பது, உங்கள் திட்டத்தின் முக்கியத்துவத்தை நீங்கள் பரப்புவதற்கு உதவும்.

பயனர்கள் பயனர்களாக ஈடுபடுவதை நினைவில் கொள்ளுங்கள், இறுதியில் பங்களிப்பாளர்களாகி விடுகிறார்கள், ஏனென்றால் உங்கள் திட்டம் அவர்களுக்கு ஒரு சிக்கலை தீர்க்கிறது. உங்கள் திட்டத்தின் செய்தி மற்றும் மதிப்பைப் பற்றி நீங்கள் சிந்திக்கும்போது, _பயனர்கள் மற்றும் பங்களிப்பாளர்கள்_ விரும்பும் கண்ணாடி வில்லை மூலம் அவற்றைப் பார்க்க முயற்சி செய்யுங்கள்.

எடுத்துக்காட்டாக, @robb [வரைபடவியல்](https://github.com/robb/Cartography), ஏன் பயனுள்ளதாக இருக்கும் என்பதைப் பற்றிய தெளிவான குறியீடுகளைப் பயன்படுத்துகிறார்:

![வரைபடவியல் README](/assets/images/finding-users/cartography.jpg)

ஒரு ஆழமான செய்திக்கு, மொஸில்லாவின்["ஆளுமை மற்றும் பாதைகள்"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) பயனர் நபர்களை உருவாக்குவதற்கான பயிற்சியைப் பார்க்கவும்.

## மக்கள் உங்கள் திட்டத்தை கண்டுபிடித்து பின்பற்ற உதவுங்கள்

<aside markdown="1" class="pquote">
  உங்கள் திட்டம் தொடர்பாக மக்களை ஊக்குவிப்பதற்கும் மக்களை சுட்டிக்காட்டவும் ஒரு தனித்துவமான "முகப்பு" URL உங்களுக்கு தேவை. உங்களுக்கு ஒரு ஆடம்பரமான வார்ப்புரு வெளியே தெறித்தலோ அல்லது ஒரு திரளம் பெயர் கூட தேவையில்லை, ஆனால் உங்கள் திட்டம் ஒரு மைய புள்ளியாக வேண்டும்.
  <p markdown="1" class="pquote-credit">
— பீட்டர் கூப்பர் & ராபர்ட் நெய்மான், ["உங்கள் குறியீடு பற்றி வார்த்தை எவ்வாறு பரப்புவது"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

ஒரு பெயரைக் குறிப்பிடுவதன் மூலம் மக்கள் உங்கள் திட்டத்தை கண்டுபிடித்து, நினைவில் வைக்க உதவுங்கள்.

**உங்கள் வேலையை ஊக்குவிக்க ஒரு தெளிவான கைப்பிடி வேண்டும்.** ஒரு கீச்சர் கைப்பிடி, கிட்ஹப் URL, அல்லது IRC சேனல் உங்கள் திட்டத்தை மக்கள் சுட்டிக்காட்ட ஒரு சுலபமான வழி. Tஇந்த நிலையங்கள் உங்கள் திட்டத்தின் வளர்ந்து வரும் சமூகத்தை கூட்டுவதற்கு ஒரு இடத்தையும் கொடுக்கின்றன.

இன்னும் உங்கள் திட்டத்திற்கான நிலையங்கள் அமைக்க விரும்பவில்லை என்றால், நீங்கள் செய்யும் அனைத்தையும் உங்கள் சொந்த கீச்சர் அல்லது கிட்ஹப் கைப்பிடிகளை விளம்பரப்படுத்தவும். உங்கள் கீச்சர் அல்லது கிட்ஹப் கைப்பிடிகளை மேம்படுத்துவது, உங்களை தொடர்புகொள்வது அல்லது உங்கள் வேலையை எவ்வாறு பின்பற்றுவது என்பதை மக்கள் அறிவர். ஒரு சந்திப்பு அல்லது நிகழ்வில் நீங்கள் பேசினால், உங்கள் தொடர்பு தகவல்கள் உங்கள் ஆளுமைக் குறிப்பு அல்லது விளக்கக்காட்சிகளில் சேர்க்கப்பட்டுள்ளதா என்பதை உறுதிப்படுத்திக் கொள்ளுங்கள்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  அந்த ஆரம்ப நாட்களில் நான் செய்த ஒரு தவறு (...) திட்டம் ஒரு கீச்சர் கணக்கு தொடங்கவில்லை. ஒரு திட்டம் பற்றி மக்கள் நிகழ்நிலைப்படுத்த உதவுவதுடன் தொடர்ந்து மக்களை திட்டத்திற்கு அம்பலப்படுத்த கீச்சர் ஒரு சிறந்த வழி.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**உங்கள் திட்டத்திற்கான வலைத்தளத்தை உருவாக்குங்கள்.** தெளிவான ஆவணங்கள் மற்றும் பயிற்சிகளுடன் இணைந்திருக்கும் போது, ஒரு வலைத்தளம் உங்கள் திட்டத்தை நட்பு ரீதியாகவும் எளிதாகவும் செல்லவும் செய்கிறது. ஒரு வலைத்தளம் இருப்பதால், உங்கள் திட்டம் செயலில் இருப்பதைக் குறிக்கிறது, இது உங்கள் பார்வையாளர்களை மிகவும் வசதியாக உணர வைக்கும். உங்கள் திட்டத்தை எவ்வாறு பயன்படுத்துவது என்பது குறித்த யோசனைகளை வழங்குவதற்கு உதாரணங்கள் வழங்கவும்.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), டிஜாங்கோவின் இணை-படைப்பாளி, ஒரு வலைத்தளம் _"நாங்கள் ஆரம்ப நாட்களில் டிஜாங்கோவில் செய்த சிறந்த விஷயம்"_ என்று கூறினார்.

கிட்ஹப் இல் உங்கள் திட்டம் host செய்யப்பட்டிருந்தால், எளிதாக ஒரு வலைத்தளத்தை உருவாக்க [கிட்ஹப் பக்கங்கள்](https://pages.github.com/) பயன்படுத்தலாம். [யோமன்](http://yeoman.io/), [வேக்ரன்ட்](https://www.vagrantup.com/), மற்றும் [மிடில்மேன்](https://middlemanapp.com/) சிறப்பான, விரிவான வலைத்தளங்களின் [சில உதாரணங்கள்](https://github.com/showcases/github-pages-examples) ஆகும்.

![வேக்ரன்ட் முகப்புப்பக்கம்](/assets/images/finding-users/vagrant_homepage.png)

இப்போது உங்கள் திட்டத்திற்கான செய்தியைக் கொண்டிருக்கிறோம், உங்கள் திட்டத்தை மக்கள் கண்டுபிடிக்க எளிய வழி, அங்கு சென்று, உங்கள் பார்வையாளர்களுடன் பேசவும்!

## உங்கள் திட்டத்தின் பார்வையாளர்களிடம் (இயங்கலை) செல்லுங்கள்

இயங்கலை விஞ்சியிறுப்பு விரைவில் வார்த்தையை பகிர மற்றும் பரவ ஒரு சிறந்த வழி. இயங்கலை தடங்களைப் பயன்படுத்தி, மிக அதிகமான பார்வையாளர்களை அடைய உங்களுக்கு வாய்ப்பு உள்ளது.

உங்கள் பார்வையாளர்களை அடைய, ஏற்கனவே இருக்கும் இயங்கலை சமூகங்களையும் தளங்களையும் பயன்படுத்தி கொள்ளுங்கள். உங்கள் திறந்த மூல திட்டம் ஒரு மென்பொருள் திட்டமாக இருந்தால், உங்கள் பார்வையாளர்களை ஒருவேளை [ஸ்டாக் ஓவர்ஃப்ளோ](https://stackoverflow.com/), [ரெட்டிட்](https://www.reddit.com), [ஹாக்கர் நியூஸ்](https://news.ycombinator.com/), or [கோரா](https://www.quora.com/) ஆகியவற்றில் நீங்கள் காணலாம். உங்கள் வேலையினால் மக்கள் மிகவும் பயன் அடையும் அல்லது உற்சாகமாக இருக்க வேண்டும் என நினைக்கும் தடங்களை கண்டறியுங்கள்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  ஒவ்வொரு நிரலிலும் மிகவும் குறிப்பிட்ட செயல்களால் பயனர்களின் ஒரு பகுதியினர் மட்டுமே பயன் பெறுவார்கள். முடிந்தவரை பல நபர்களுக்கு மின் அஞ்சல் குப்பைகள் அனுப்பாதீர்கள். அதற்கு பதிலாக, உங்கள் திட்டத்தை பற்றி தெரிந்து கொள்ளும் சமூகங்களுக்கு உங்கள் முயற்சிகளை இலக்காகக் கொள்ளுங்கள்.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["திறந்த மூல திட்டங்களுக்கான சந்தைப்படுத்தல்"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

உங்கள் திட்டத்தை பொருத்தமான வழிகளில் பகிர்ந்து கொள்ள வழிகளைக் காண முடியுமா என்பதைக் காணவும்:

* **பொருத்தமான திறந்த மூல திட்டங்கள் மற்றும் சமூகங்களை அறிந்து கொள்ளுங்கள்.** சில நேரங்களில், நீங்கள் நேரடியாக உங்கள் திட்டத்தை ஊக்குவிக்க வேண்டியதில்லை. உங்கள் திட்டமானது பைத்தானைப் பயன்படுத்தும் தரவு விஞ்ஞானிகளுக்கு சரியானது என்றால், பைத்தான் தரவு அறிவியலாளரை அறிந்து கொள்ளுங்கள். மக்கள் உங்களுக்குத் தெரிந்தால், உங்கள் வேலையைப் பற்றி பேசுவதற்கும், பகிர்ந்து கொள்வதற்கும் வாய்ப்புகள் இயற்கையாக எழும்.
* **உங்கள் திட்டத்தை சரிசெய்யும் சிக்கலை எதிர்கொள்ளும் நபர்களைக் கண்டறியவும்.** உங்கள் திட்டத்தின் இலக்கு பார்வையாளர்களில் விழும் நபர்களை தொடர்புடைய கருத்துக்களம் மூலம் தேடலாம். அவர்களின் கேள்விக்கு பதில் மற்றும் உத்தமமான வழியை கண்டுபிடிக்கவும், தக்க சமயத்தில் ஒரு தீர்வாக உங்கள் திட்டத்தை பரிந்துரைக்கவும்.
* **கருத்துக்களைக் கேட்கவும்.** உங்களையும் உங்கள் வேலையும் ஒரு பார்வையாளருக்கு, அதனுடன் தொடர்புடையதாகவும் சுவாரசியமாகவும் இருக்கும்படி அறிமுகப்படுத்தவும். உங்கள் திட்டத்தில் இருந்து யார் பயனடையலாம் என நீங்கள் நினைப்பதைப் பற்றி குறிப்பிடவும். Tவாக்கியத்தை முடிக்க முயற்சிக்கும் போது: _"என் திட்டம் உண்மையில் Y- ஐ செய்ய முயற்சிக்கும் X-க்கு உதவும் என்று நினைக்கிறேன்_". வெறுமனே உங்கள் வேலையை ஊக்குவிப்பதை விட, மற்றவர்களின் கருத்துக்களைக் கேட்டு மறுமொழி கூறுங்கள்.

பொதுவாக, மற்றவர்களிடம் எதிர் உதவி கேட்கும் முன்பு, உதவுவதில் கவனம் செலுத்துங்கள். யாரும் எளிதாக ஒரு திட்டத்தை இயங்கலையில் ஊக்குவிக்க முடியும் என்பதால், கூச்சல் நிறைய இருக்கும். கூட்டத்தில் இருந்து தனித்து நிற்க, மக்களிடம் நீங்கள் எதை விரும்புகிறீர்கள் என்று மட்டுமல்லாமல், நீங்கள் யார் என்பதையும் கூறவும்.

யாரும் கவனத்தை ஈர்க்காவிட்டால் அல்லது உங்கள் ஆரம்ப முயற்சிகளுக்கு பதிலளிக்காவிட்டால், மனந்தளர வேண்டாம்! பெரும்பாலான திட்டங்களை அறிமுகப்படுத்த மாதங்கள் அல்லது ஆண்டுகள் ஆகலாம். நீங்கள் முதல் முறையாக பதிலைப் பெறவில்லையெனில், வேறு தந்திரோபாயத்தை முயற்சிக்கவும் அல்லது மற்றவர்களின் வேலைக்கு மதிப்பு சேர்க்க வழிகளைத் தேடுங்கள். உங்கள் திட்டத்தை மேம்படுத்த மற்றும் துவக்க நேரம் மற்றும் அர்ப்பணிப்பு ஆகியவற்றை எடுக்கும்.

## உங்கள் திட்டத்தின் பார்வையாளர்களிடம் (முடக்கலை) செல்லுங்கள்

![பொது பேச்சு](/assets/images/finding-users/public_speaking.jpg)

முடக்கலை நிகழ்வுகள் பார்வையாளர்களுக்கு புதிய திட்டங்களை மேம்படுத்துவதற்கான ஒரு பிரபலமான வழியாகும். ஈடுபட்டுள்ள பார்வையாளர்களை அடைய மற்றும் ஆழமான மனித இணைப்புகளை உருவாக்க அது ஒரு சிறந்த வழி, குறிப்பாக நீங்கள் நிரலாளர்களை அடைவதில் ஆர்வமாக இருந்தால்.

நீங்கள் [பொது பேச்சிற்கு புதிது](https://speaking.io/) என்றால், உங்கள் திட்டத்தின் மொழி அல்லது சுற்றுச்சூழல் தொடர்பான உள்ளூர் சந்திப்பைக் கண்டுபிடிப்பதன் மூலம் தொடங்கவும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  நான் PyCon செல்வது பற்றி சிறிது பதற்றமாக இருந்தது. நான் ஒரு பேச்சு கொடுக்கவிருந்தேன், நான் அங்கு ஒரு சிலரை மட்டுமே தெரிந்து கொள்ள போகிறேன், நான் ஒரு முழு வாரத்திற்கு போகிறேன். (...) நான் கவலைப்பட தேவையில்லை. PyCon அற்புதமாக இருந்தது! (...) எல்லோரும் நம்பமுடியாத நட்புடனும் மற்றும் வெளிப்படையாகவும் இருந்தனால், நான் மற்றவர்களிடம் பேசாமல் இருந்த நேரம் என்பது மிகவும் அரிதாக இருந்தது!
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["நான் கவலைப்படுவதை நிறுத்தி PyCon மீது நேசம் கொண்டேன்"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

நீங்கள் முன்பு ஒரு நிகழ்வில் பேசிய அனுபவம் இல்லையென்றால், பதற்ற உணர்வு முற்றிலும் சாதாரணமானது! உங்கள் வேலையைப் பற்றி உண்மையிலேயே கேட்க விரும்புவதால் உங்கள் பார்வையாளர்கள் அங்கு இருப்பதை நினைவில் வையுங்கள்.

உங்கள் பேச்சை எழுதும்போது, உங்கள் பார்வையாளர்களுக்கு சுவாரசியமானவற்றையும், மதிப்பை கொடுப்பதையும் கவனத்தில் கொள்ளவும். உங்கள் மொழி நட்பு மற்றும் அணுகக்கூடியதாக வையுங்கள். புன்னகையுங்கள், சுவாசியுங்கள், கேளிக்கை கொள்ளுங்கள்.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  உங்கள் உரையைத் தொடங்கும்போது, உங்கள் தலைப்பு என்னவாக இருந்தாலும் சரி, உங்கள் உரையை ஒரு கதையாக நீங்கள் பார்த்தால், அதை மக்களுக்குக் கூறும்பொழுது உதவும்.
  <p markdown="1" class="pquote-credit">
— லேனா ரெய்ன்ஹார்ட், ["ஒரு தொழில்நுட்ப மாநாடு பேச்சு தயாரித்தல் மற்றும் எழுதவது எப்படி"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

நீங்கள் தயாராக இருந்தால், உங்கள் திட்டத்தை மேம்படுத்த மாநாட்டில் பேசுங்கள். மாநாடுகள் பலரைச் சென்றடைய உதவும், சில நேரங்களில் உலகம் முழுவதும்.

உங்கள் மொழி அல்லது சுற்றுச்சூழல் தொடர்பான குறிப்பிட்ட மாநாடுகளைப் பாருங்கள். உங்கள் பேச்சுக்கு முன், மாநாட்டில் கலந்துரையாடலைப் பேசுவதற்கு உங்கள் உரையைச் சுருக்கமாக ஆராயுங்கள், மாநாட்டில் பேசுவதற்கான வாய்ப்புகள் அதிகரிக்கும். மாநாட்டின் பேச்சாளர்களைப் பார்த்து நீங்கள் உங்கள் பார்வையாளர்களை உணர்வீர்கள்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  நான் JSConf மக்களுக்கு மிக நேர்த்தியாக எழுதினேன் மற்றும் அவற்றை JSConf ஐரோப்பிய ஒன்றியத்தில் வழங்குவதற்கு எனக்கு ஒரு நேரம் கொடுக்க அவர்களை கெஞ்சினேன். (...) நான் மிகவும் பயந்தேன், ஆறு மாதங்களுக்கு நான் வேலை செய்து வந்த இந்த விஷயத்தை விளக்கினேன். (...) முழு நேரமும் நான் யோசித்துக் கொண்டிருந்தேன், அட கடவுளே.நான் இங்கே என்ன செய்கிறேன்?
  <p markdown="1" class="pquote-credit">
— @ry, ["Node.js இன் வரலாறு" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## நற்பெயர் உருவாக்கவும்

மேலே கோடிட்டுள்ள உத்திகளைத் தவிர்த்து, உங்கள் திட்டத்தில் பங்கெடுக்க மற்றும் பங்களிக்க மக்களை அழைப்பதற்கான சிறந்த வழி அவர்களின் திட்டங்களை பகிர்ந்து மற்றும் பங்களிக்க வேண்டும்.

புதியவர்களுக்கு உதவி, வளங்களை பகிர்தல், மற்றவர்களின் திட்டங்களுக்கு சிந்தனைக்குரிய பங்களிப்புகளை செய்வது ஆகியவை நேர்மறையான நற்பெயரை உருவாக்க உதவும். திறந்த மூல சமுதாயத்தில் செயலில் உள்ள உறுப்பினராக இருப்பதால், உங்கள் வேலைக்கு மக்கள் சூழலைக் கொண்டிருப்பார்கள், மேலும் உங்கள் திட்டத்தை கவனத்தில் எடுத்து, பகிர்ந்து கொள்ளலாம். மற்ற திறந்த மூல திட்டங்களுடனான உறவை வளர்ப்பதன் மூலம் உத்தியோகபூர்வ கூட்டுக்களுக்கு வழிவகுக்கலாம்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  ஒரே காரணம் urlib3 என்பது மிகவும் பிரபலமான மூன்றாம்-தரப்பு பைத்தான் நூலகம், ஏனெனில் இது கோரிக்கைகளின் பகுதியாக உள்ளது.
  <p markdown="1" class="pquote-credit">
— @shazow, ["உங்கள் திறந்த மூல திட்டத்தை எவ்வாறு வளர்த்துக் கொள்வது"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

உங்கள் நற்பெயரைத் தொடங்குவதற்கு என்றும் முன்னதாகவோ அல்லது மிகவும் தாமதமாக இல்லை. நீங்கள் ஏற்கனவே உங்கள் சொந்த திட்டத்தை ஆரம்பித்திருந்தாலும், மற்றவர்களுக்கு உதவ வழிகளைத் தேடுங்கள்.

பார்வையாளர்களை உருவாக்குவதற்கு ஒரே இரவில் தீர்வு இல்லை. நம்பிக்கையையும் மற்றவர்களுடைய மரியாதையையும் பெற்றுக்கொள்வது நேரம் எடுக்கும், உங்கள் நற்பெயரைக் கட்டி முடிக்காது.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ariya?s=180" class="pquote-avatar" alt="avatar">
  2011ன் தொடக்கத்தில் முதல்முறையாக PhantomJS வெளியிடப்பட்டது. (...) நான் வழக்கமான வழிகளில் வார்த்தையை பரப்பினேன்: நான் அதை பற்றி கீச்சினேன், நான் அதை வைத்து செய்ய முடியும் விஷயங்களை இடுகைகள் எழுதினார், நான் சந்திப்புகள் பல்வேறு விவாதங்களின் போது அதை குறிப்பிட்டுள்ளேன். அது 2014 ல் நன்கு அறியப்பட்டபோது, அதைப் பற்றி விளக்கங்களைத் தரத் தொடங்கினேன்.
  <p markdown="1" class="pquote-credit">
— @ariya, ["பராமரிப்பாளர் கதைகள்"](https://github.com/open-source/stories/ariya)
  </p>
</aside>

## பொறுமை காக்கவும்

உங்கள் திறந்த மூல திட்டத்தை மக்கள் கவனிக்க முன் நீண்ட நேரம் எடுக்கலாம். பரவாயில்லை! மிக பிரபலமான சில திட்டங்கள் இன்று அதிக அளவில் நடவடிக்கைகளை எட்டுவதற்கு பல ஆண்டுகள் எடுத்தன. உங்கள் திட்டம் தன்னிச்சையாக புகழ் பெறும் என்று நம்புவதற்குப் பதிலாக உறவுகளை மேம்படுத்தவதில் கவனம் செலுத்துங்கள். பொறுமையாக இருங்கள், உங்கள் வேலையைப் பாராட்டுபவர்களுடன் பகிர்ந்து கொள்ளுங்கள்.
