---
lang: ta
title: வரவேற்பு சமூகங்களை உருவாக்குதல்
description: உங்கள் திட்டத்தை மக்களுக்கு பயன்படுத்தவும், பங்களிக்கவும், ஊக்கப்படுத்தவும் ஒரு சமூகத்தை உருவாக்குங்கள்.
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## வெற்றிக்கு உங்கள் திட்டத்தை அமைத்தல்

நீங்கள் உங்கள் திட்டத்தைத் தொடங்கினீர்கள், நீங்கள் வார்த்தை பரப்பி வருகிறீர்கள், அதை பார்க்கிறார்கள். அற்புதம்! இப்போது, அவர்களை எப்படிக் அருகாமையில் வைத்திருப்பது?

ஒரு வரவேற்பு சமூகம் உங்கள் திட்டத்தின் வருங்கால மற்றும் புகழ் முதலீடு ஆகும். உங்கள் திட்டம் அதன் முதல் பங்களிப்பைப் பார்க்க ஆரம்பித்தால், ஆரம்ப பங்களிப்பாளர்களுக்கு ஒரு நேர்மறையான அனுபவத்தை வழங்குவதன் மூலம் தொடங்கவும், மேலும் அவர்கள் மீண்டும் வருவதை எளிதாக்கவும் செய்யுங்கள்.

### மக்கள் வரவேற்பை உணர வேண்டும்

உங்கள் திட்டத்தின் சமூகத்தைப் பற்றி சிந்திக்க ஒரு வழி @MikeMcQuaid [பங்களிப்பாளர் வடிகுழலி](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/) என அழைக்கிறார்.:

![பங்களிப்பாளர் வடிகுழலி](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

நீங்கள் உங்கள் சமூகத்தை உருவாக்கும்போது, வடிகுழலியின் (ஒரு சாத்தியமான பயனர்) ஒருவரை கோட்பாட்டளவில் கீழ்தளத்திற்கு (செயலூக்கமுள்ள பராமரிப்பாளராக) எப்படிக் கொண்டு வரலாம் என்று கருதுங்கள். பங்களிப்பவர் அனுபவத்தின் ஒவ்வொரு கட்டத்திலும் உராய்வுகளை குறைப்பதே உங்கள் குறிக்கோள். மக்கள் எளிதாக வெற்றி காணும்போது, அவர்கள் இன்னும் செய்ய ஊக்கமளிக்கும்.

உங்கள் ஆவணங்களுடன் தொடங்கவும்:

* **உங்கள் திட்டத்தை யாரேனும் பயன்படுத்த எளிதாக செய்தல்.** [ஒரு தோழமையான README](../starting-a-project/#readme-எழுதுவது) மற்றும் தெளிவான குறியீடு எடுத்துக்காட்டுகள் உங்கள் திட்டத்தில் தொடங்குவதற்கு எவருக்கும் எளிதாக இருக்கும்.
* [உங்களின் CONTRIBUTING கோப்பு](../starting-a-project/#உங்கள்-பங்களிப்பு-வழிமுறைகளை-எழுதுதல்) உங்கள் சிக்கல்களை புதுப்பித்த நிலையில் வைத்திருப்பதன் மூலம், **எப்படி பங்களிக்க வேண்டும் என்பதை தெளிவுபடுத்துங்கள்**.

[கிட்ஹப் இன் 2017 திறந்த மூல கருத்தாய்வு](http://opensourcesurvey.org/2017/) மிகப்பெரிய பிரச்சனையாக முழுமையடையாத அல்லது குழப்பமான ஆவணமாக்கலைக் திறந்த மூல பயனர்களுக்கு உள்ளது என காட்டியது. நல்ல ஆவணங்கள் உங்கள் திட்டத்துடன் தொடர்புகொள்வதற்கு மக்களை வரவேற்கின்றது. இறுதியில், யாராவது ஒரு சிக்கலைத் அல்லது இழு கோரிக்கையை திறக்கலாம். இந்த பரஸ்பரங்களைப் பயன்படுத்தி அவற்றை வடிகுழலின் கீழ் வரை நகர்த்துவதற்கான வாய்ப்பாக பயன்படுத்தவும்.

* **உங்கள் திட்டத்தில் யாரேனும் புதியதாக தொடங்கினால், அவர்களுடைய ஆர்வத்திற்கு நன்றி சொல்லுங்கள்!** ஒரே ஒரு எதிர்மறை அனுபவமானது ஒருவரை மறுபடியும் திரும்பி வர விரும்பாமல் செய்துவிடும்.
* **மறுமொழி கூறுங்கள்.** ஒரு மாதம் தங்கள் பிரச்சனைக்கு நீங்கள் பதிலளிக்கவில்லை என்றால் அவர்கள் ஏற்கனவே உங்கள் திட்டத்தை மறந்துவிட வாய்ப்புகள் உள்ளன.
* **நீங்கள் ஏற்றுக் கொள்ள வேண்டிய பங்களிப்புகளை பற்றி திறந்த மனதுடன் இருங்கள்.**பல பங்களிப்பாளர்கள் ஒரு பிழை அறிக்கை அல்லது சிறு பிழைத்திருத்தத்துடன் தொடங்குகின்றனர். ஒரு திட்டத்திற்கு [பங்களிக்க பல வழிகள் உள்ளன](../how-to-contribute/#பங்களிப்பதின்-அர்த்தம்-என்ன). மக்கள் எவ்வாறு உதவ விரும்புகிறார்களோ அவ்வாறே உதவட்டும்.
* **நீங்கள் உடன்படாத ஒரு பங்களிப்பு இருந்தால்,** அவர்கள் கருத்திற்கு நன்றி தெரிவிக்கவும் [ஏன்](../best-practices/#இல்லை-என-சொல்ல-கற்றல்) இது திட்டத்தின் நோக்கத்திற்கு ஏன் பொருந்தவில்லை என, ஆவணத்துடன் (இருந்தால்) சுட்டிக்காட்டவும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  திறந்த மூலத்திற்கான பங்களிப்பு சிலருக்கு மற்றவர்களைவிட எளிதானது. ஏதேனும் தவறு செய்துவிடுமோ அல்லது பொருத்தமற்றதாக இல்லை என்ற எவரேனும் கூச்சலிடுவார்களோ என்ற அச்சம் நிறைய இருக்கிறது. (...) பங்களிப்பாளர்கள் மிகவும் குறைந்த தொழில்நுட்ப திறமை (ஆவணங்கள், வலை உள்ளடக்கம் குறைத்து மதிப்பிடல் முதலியன) பங்களிக்க ஒரு இடத்தை வழங்குவதன் மூலம் நீங்கள் பெரிதும் அந்த கவலைகள் குறைக்க முடியும்.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["நவீன திறந்த மூலத்தில் ஒரு பங்களிப்பு தளத்தை வளர்ப்பது"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

பெரும்பாலான திறந்த மூல பங்களிப்பாளர்கள் "தற்காலிக பங்களிப்பாளர்கள்": ஒரு திட்டத்தில் பங்களித்தவர்கள் எப்போதாவது மட்டுமே. ஒரு சாதாரண பங்களிப்பாளருக்கு உங்கள் திட்டத்தின்போது வேகத்தை அதிகரிக்க நேரம் கிடைக்காமல் போகலாம், எனவே உங்கள் வேலையை எளிதில் பங்களிக்க உதவும்.

பிற பங்களிப்பாளர்களை உற்சாகப்படுத்துவது உங்களுக்கு ஒரு முதலீடு ஆகும். நீங்கள் உற்சாகமாக பணிபுரியும் உங்கள் பெரிய ரசிகர்களை அதிகப்படுத்தும்போது, எல்லாவற்றையும் நீங்களே செய்வதற்கான அழுத்தம் குறைகிறது.

### அனைத்தையும் ஆவணப்படுத்துங்கள்

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  நீங்கள் யாரையும் தெரியாத இடத்தில் (தொழில்நுட்ப-) நிகழ்வில் எப்போதாவது இருந்திருக்கிறீர்களா, ஆனால் எல்லோரும் குழுக்களில் நின்றுக்கொண்டு பழைய நண்பர்களைப் போல் அரட்டை அடிக்கிறார்களா? (...) Nஇப்போது நீங்கள் ஒரு திறந்த மூல திட்டத்தில் பங்களிப்பு செய்ய விரும்புகிறீர்கள் என்று கற்பனை செய்யுங்கள், ஆனால் இது ஏன் அல்லது எப்படி நடக்கிறது என்பதை நீங்கள் பார்க்கவில்லை.
  <p markdown="1" class="pquote-credit">
— @janl, ["நிலையான திறந்த மூலம்"](https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

நீங்கள் ஒரு புதிய திட்டத்தை தொடங்கும்போது, உங்கள் வேலையைத் தனிப்பட்ட முறையில் வைத்திருக்க இயலும். உங்கள் செயல்முறையை பொதுவில் ஆவணப்படுத்தும்போது, திறந்த மூல திட்டங்கள் செழித்தோங்கும்.

விடயங்களை எழுதும்போது, ஒவ்வொரு அடியிலும் அதிகமானவர்கள் பங்கேற்பார்கள். நீங்கள் உங்களுக்குத் தெரியாத ஒன்றில் உங்களுக்கு உதவி கிடைக்கலாம்.

விடயங்களை எழுதுவது வெறும் தொழில்நுட்ப ஆவணங்களை விட அதிகமானது. எந்த நேரத்திலும் உங்கள் திட்டத்தை விவாதித்து அல்லது தனிப்பட்ட முறையில் கலந்துரையாடுவது எப்போது வேண்டுமானாலும் நீங்கள் உணரலாம், அதை பொதுவெளியில் வைக்கலாமா என்று உங்களை நீங்களே கேளுங்கள்.

உங்கள் திட்டத்தின் திட்ட வரைபடம், நீங்கள் தேடுகிற பங்களிப்புகள், பங்களிப்புகளை மதிப்பாய்வு செய்தல் அல்லது நீங்கள் ஏன் சில முடிவுகளை எடுத்தீர்கள் என்பதை பற்றி வெளிப்படையாக இருங்கள்.

பல பயனர்கள் அதே சிக்கலில் இயங்குவதை நீங்கள் கண்டால், README இல் பதில்களை ஆவணப்படுத்தவும்.

சந்திப்புகளுக்கு, உங்கள் குறிப்புகள் அல்லது எடுத்துக்காட்டுகளை ஒரு பொருத்தமான விவகாரத்தில் வெளியிடுங்கள். வெளிப்படையான இந்த மட்டத்திலிருந்து நீங்கள் பெறும் பின்னூட்டம் உங்களுக்கு ஆச்சரியமாக இருக்கலாம்.

எல்லாவற்றையும் ஆவணப்படுத்துவது என்பது நீங்கள் செய்யும் வேலைக்கும் பொருந்தும். உங்கள் திட்டத்திற்கு ஒரு கணிசமான புதுப்பிப்பை நீங்கள் செய்திருந்தால், அதை ஒரு மிகுதிக் கோரிக்கையுடன் போட்டு, அதை பணி முன்னேற்றத்தில் (WIP) என்று குறிக்கவும். அந்த வழியில், பிற மக்கள் ஆரம்பத்தில் இருந்தே செயல்முறையில் ஈடுபட்டு உணர முடியும்.

### பதிலளிக்க வேண்டும்

நீங்கள் [உங்கள் திட்டத்தை ஊக்குவிக்க](../finding-users), மக்கள் உங்களுக்கு கருத்து தெரிவிக்க வேண்டும். விஷயங்கள் எவ்வாறு வேலை செய்கின்றன என்பதைப் பற்றிய கேள்விகள் இருக்கலாம் அல்லது தொடங்குவதற்கு உதவி தேவைப்படலாம்.

யாராவது ஒரு சிக்கலைப் பதிவுசெய்தால், இழு கோரிக்கையை சமர்ப்பித்தால் அல்லது உங்கள் திட்டத்தைப் பற்றிய கேள்வியை கேட்டால், பதிலளிக்கும் முயற்சியை மேற்கொள்ளுங்கள். நீங்கள் விரைவாக பதிலளிக்கும்போது, அவர்கள் ஒரு உரையாடலின் பகுதியாக இருப்பதாக மக்கள் உணருவார்கள், மேலும் அவர்கள் பங்கு பெறுவதில் ஆர்வம் காட்டுவார்கள்.

நீங்கள் கோரிக்கையை உடனடியாக மதிப்பாய்வு செய்யாவிட்டாலும், ஆரம்பத்தில் அதை ஒப்புக் கொள்ளுதல் என்பது பங்களிப்பை அதிகரிக்க உதவுகிறது. [மிடில்மேன்](https://github.com/middleman/middleman/pull/1466) இழு கோரிக்கைக்கு @tdreyno இவ்வாறு பதிலளித்தார்:

![மிடில்மேன் இழு கோரிக்கை](/assets/images/building-community/middleman_pr.png)

[ஒரு மோசில்லா ஆய்வு](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) 48 மணி நேரத்திற்குள் குறியீட்டு மதிப்பீடுகளைப் பெற்ற பங்களிப்பாளர்கள் மிக அதிகமான எண்ணிக்கையில் திரும்பினர் மற்றும் மீண்டும் பங்களிப்பு செய்தனர் என்று கண்டறிந்தது.

உங்கள் திட்டத்தைப் பற்றிய உரையாடல்கள், இணையம் முழுவதும் பிற இடங்களில் ஸ்டேக் ஓவர்ஃப்ளோ, ட்விட்டர் அல்லது ரெடிட் போன்றவைகளில் நடக்கலாம். இந்த இடங்களில் சில அறிவிப்புகளை நீங்கள் அமைக்கலாம், எனவே யாராவது உங்கள் திட்டத்தை குறிப்பிடுகையில் விழிப்பூட்டப்படுவீர்கள்.

### உங்கள் சமுதாயத்தைக் ஒன்று திரட்ட ஒரு இடம் கொடுங்கள்

உங்கள் சமுதாயத்தை ஒன்று சேர்ப்பதற்கான இடம் கொடுப்பதற்கு இரண்டு காரணங்களாகும்.

முதல் காரணம் அவர்களுக்காக. ஒருவருக்கொருவர் தெரிந்துகொள்ள உதவுங்கள். பொதுவான நலன்களைக் கொண்ட மக்கள் தவிர்க்கவியலாமல் அதைப் பற்றி பேச ஒரு இடம் வேண்டும். தொடர்பு பொதுவிலும் மற்றும் அணுகத்தக்க வகையிலும் இருக்கும் போது, எவராலும் முந்தைய காப்பகங்களை படித்து வேகமாக பங்கு பெற முடியும்.

இரண்டாவது காரணம் உங்களுக்காக. உங்கள் திட்டத்தைப் பற்றி பேசுவதற்கு பொது மக்களுக்கு பொதுவெளியில் இடம் கொடுக்கவில்லை என்றால், அவர்கள் உங்களை நேரடியாக தொடர்புகொள்வார்கள். தொடக்கத்தில், இது தனிப்பட்ட செய்திகளுக்கு பதிலளிக்கும் போது "இது ஒரு முறை" மட்டுமே என எளிதானதாக தோன்றலாம். ஆனால் காலப்போக்கில், குறிப்பாக உங்கள் திட்டம் பிரபலமாகி விட்டால், நீங்கள் சோர்வாக உணருவீர்கள். தனிப்பட்ட முறையில் உங்கள் திட்டத்தைப் பற்றி மக்களுடன் தொடர்பு கொள்வதற்கான தூண்டுதலை எதிர்க்கவும். அதற்கு பதிலாக, ஒரு நியமிக்கப்பட்ட பொது அலைத்தடத்திற்கு அவர்களை வழிநடத்துங்கள்.

உங்கள் வலைப்பதிவில் நேரடியாகவோ அல்லது கருத்து தெரிவிப்பதற்கோ பதிலளிப்பதற்குப் பதிலாக, மக்களை திறந்த சிக்கலுக்கு வழிகாட்டுவதைப்போல பொது தகவல்தொடர்பு மிகவும் எளிது. நீங்கள் ஒரு அஞ்சல் பட்டியலை அமைக்கலாம் அல்லது ஒரு ட்விட்டர் கணக்கை உருவாக்கலாம், ஸ்லாக் அல்லது ஐ.ஆர்.சி சேனல் உங்கள் திட்டத்தை பற்றி பேசுவதற்கு. அல்லது மேலே கூறிய அனைத்தையும் முயற்சி செய்யலாம்!

[குபெர்னீஸ் காப்ஸ்](https://github.com/kubernetes/kops#getting-involved) சமுதாய உறுப்பினர்களுக்கு உதவ ஒவ்வொரு வாரமும் அலுவலக நேரங்களை ஒதுக்கி வைக்கிறது:

> சமூகத்திற்கு உதவி மற்றும் வழிநடத்துதலை வழங்குவதற்காக ஒவ்வொரு வாரமும் காப்ஸ் நேரத்தை ஒதுக்கியுள்ளது. காப்ஸ் பராமரிப்பாளர்கள் குறிப்பாக புதிதாக பணிபுரியும் பணியாளர்களுடன் பணிபுரிவதற்கு அர்ப்பணிக்கப்பட்ட நேரத்தை ஒதுக்கி, PR களுக்கு உதவுவது, புதிய அம்சங்களைப் பற்றி கலந்துரையாட ஒப்புக் கொண்டனர்.

பொது தொடர்புக்கு குறிப்பிடத்தக்க விதிவிலக்குகள்: 1) பாதுகாப்பு பிரச்சினைகள் மற்றும் 2) உணர்ச்சிமிக்க நடத்தை நெறிமுறைகளின் கட்டு மீருகைகள். இந்த சிக்கல்களைத் தனிப்பட்ட முறையில் தெரிவிக்க மக்களுக்கு எப்போதும் ஒரு வழி இருக்க வேண்டும். நீங்கள் உங்கள் தனிப்பட்ட மின்னஞ்சல் பயன்படுத்த விரும்பவில்லை என்றால், ஒரு பிரத்யேக மின்னஞ்சல் முகவரியை அமைக்கலாம்.

## உங்கள் சமூகத்தை வளர்த்தல்

சமூகங்கள் மிகவும் சக்திவாய்ந்தவை. அந்த சக்தி உங்களுக்கு ஆசீர்வாதமாகவோ சாபமாகவோ இருக்கலாம், அதை எவ்வாறு செயலாட்சி செய்கிறோம் என்பதைப் பொறுத்து. உங்கள் திட்டத்தின் சமூகம் வளரும் போது, கட்டுமானத்திற்கு ஒரு சக்தியாக உதவுவதற்கான வழிகளாக இருக்கும், அழிக்கும் வழியாக அல்ல.

### தீங்கு விளைவிப்பவர்களை பொறுத்துக் கொள்ளாதீர்கள்

எந்தவொரு பிரபலமான திட்டமும் தவிர்க்க முடியாமல் தீங்கு விளைவிக்கும் நபர்களை ஈர்க்கும். அவர்கள் தேவையற்ற விவாதங்களைத் தொடங்கலாம், அற்பமான அம்சங்கள் மீது விவாதிக்கலாம் அல்லது மற்றவர்களுக்கு தொல்லை தரலாம்.

இந்த வகையான மக்களிடம் சகிப்பின்மையை கடைப்பிடிப்பது சிறந்தது. இதை தடுக்காமல் விட்டுவிட்டால், எதிர்மறையான மக்கள் உங்கள் சமூகத்தில் பிறருக்கு சங்கடத்தை ஏற்படுத்தலாம். அவர்கள் விலக கூட நேரிடலாம்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/karissa?s=180" class="pquote-avatar" alt="avatar">
  உண்மை என்னவென்றால் ஒரு ஆதரவான சமூகம் இருப்பது முக்கியமானது. என் சக பணியாளர்கள், நட்பு இணைய அந்நியர்கள் மற்றும் வம்பளக்கிற ஐ.ஆர்.சி. சேனல்கள் ஆகியோரின் உதவியின்றி இந்த வேலையை நான் செய்ய முடியாது. (...) குறைவாக குடியேறாதீர்கள். அறிவில்லாதவர்களை பொறுத்துக்கொள்ள தேவையில்லை.
  <p markdown="1" class="pquote-credit">
— @karissa, ["ஒரு FOSS திட்டத்தை எவ்வாறு இயக்க வேண்டும்"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

உங்கள் திட்டத்தின் அற்பமான அம்சங்களைப் பற்றிய வழக்கமான விவாதங்கள் முக்கியமான விஷயங்களில் கவனம் செலுத்துவதில் இருந்து நீங்கள் உட்பட, மற்றவர்களை திசை திருப்ப கூடியவை. உங்கள் திட்டத்திற்கு வரும் புதிய நபர்கள் இந்த உரையாடல்களைக் காணலாம் மற்றும் பங்கேற்க விரும்பாமல் போகலாம்.

உங்கள் திட்டத்தில் எதிர்மறையான நடத்தை நடக்கும்போது, அதை வெளிப்படையாக அழைக்கவும். ஒரு வகையான ஆனால் உறுதியான தொனியில், அவர்களின் நடத்தை ஏற்றுக்கொள்ளத்தக்கது அல்ல என விளக்கவும். பிரச்சனை தொடர்ந்தால், நீங்கள் [அவர்களை விலகி விடுமாறு கேளுங்கள்](../code-of-conduct/#உங்கள்-நடத்தை-விதித்-தொகுப்பை-செயல்படுத்ததுதல்). உங்கள் [நடத்தை குறியீடு](../code-of-conduct/) இந்த உரையாடல்களுக்கு ஒரு ஆக்கபூர்வமான வழிகாட்டியாக இருக்கலாம்.

### பங்களிப்பவர்கள் எங்கிருந்தாலும் அவர்களை சந்திக்கவும்

உங்கள் சமூகம் வளரும் போது நல்ல ஆவணங்கள் மிக முக்கியமானதாக மாறும். உங்கள் திட்டத்தினை நன்கு அறிந்திருக்காத சாதாரண பங்களிப்பாளர்கள், அவர்களுக்கு தேவையான சூழலை விரைவாக பெற உங்கள் ஆவணங்களைப் படிக்கவும்.

உங்கள் பங்களிப்புக் (CONTRIBUTING) கோப்பில், புதிய பங்களிப்பாளர்களை எவ்வாறு தொடங்குவது என்பதைத் தெளிவாக வெளிப்படுத்துங்கள். இந்த நோக்கத்திற்காக நீங்கள் ஒரு பிரத்யேக பிரிவை உருவாக்க விரும்பலாம்.[Django](https://github.com/django/django), உதாரணமாக, புதிய பங்களிப்பாளர்களை வரவேற்க ஒரு சிறப்பு இறங்கும் பக்கம் வைத்துள்ளார்.

![ஜாங்கோ புதிய பங்களிப்பாளர்கள் பக்கம்](/assets/images/building-community/django_new_contributors.png)

உங்கள் பிரச்சினை வரிசையில், பல்வேறு வகை பங்களிப்பாளர்களுக்கு பொருத்தமான பிழைகளுக்கு விவரத்துணுக்கு கொடுக்கவும்: உதாரணத்திற்கு, [_"முதல் முறை பங்களிப்பாளர்களுக்கு மட்டும்"_](https://kentcdodds.com/blog/first-timers-only), _"நல்ல முதல் பிழை"_, அல்லது _"ஆவணங்கள்"_. [இந்த விவரத்துணுக்குகள்](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) யாராவது உங்கள் திட்டத்திற்கு புதியவர்கள் விரைவாக உங்கள் பிரச்சினைகளை பார்பதற்கும், தொடங்குவதற்கும் எளிதாக்குகின்றன.

கடைசியாக, ஒவ்வொரு அடியிலும் மக்கள் வரவேற்பைப் பெற உங்கள் ஆவணங்களைப் பயன்படுத்தவும்.

உங்கள் திட்டத்தில் உள்ள பெரும்பாலான மக்களுடன் நீங்கள் தொடர்பு கொள்ள மாட்டீர்கள். நீங்கள் பெறாத பங்களிப்புகள் இருக்கலாம், ஏனெனில் யாரோ ஒருவர் பயமுறுத்தப்பட்டார் அல்லது எங்கு தொடங்குவது என தெரியாமல் இருக்கலாம். உங்கள் திட்டத்தை இருந்து யாரேனும் விலகுவதை உங்களின் ஒரு சில கனிவான வார்த்தைகளால் தடுக்கலாம்.

உதாரணமாக, [ரூபினிஸ்](https://github.com/rubinius/rubinius/) இங்கே எப்படி [அதன் பங்களிப்பு வழிகாட்டியை](https://github.com/rubinius/rubinius/blob/master/.github/contributing.md) தொடங்குகியது:

> ரூபினியஸைப் பயன்படுத்துவதற்கு நன்றி தெரிவிப்பதன் மூலம் நாம் துவங்க வேண்டும். இந்த திட்டம் காதலால் உருவானது, மற்றும் பிழைகள் பிடிக்க, செயல்திறன் மேம்பாடுகள், மற்றும் ஆவணங்களை உதவி என்று அனைத்து பயனர்களையும் பாராட்டுகிறோம். ஒவ்வொரு பங்களிப்பும் அர்த்தமுள்ளது, எனவே பங்கு பெறுவதற்கு நன்றி. இதனால் கூறப்படுவதன் என்னவெனில், உங்களுடைய பிரச்சினையை வெற்றிகரமாக தீர்க்க நாங்கள் பின்பற்றும் சில வழிகாட்டு நெறிகள் நீங்கள் பின்பற்ற வேண்டும் .

### Share ownership of your project

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sarahsharp?s=180" class="pquote-avatar" alt="avatar">
  உங்கள் தலைவர்கள் வித்தியாசமான கருத்துக்களைக் கொண்டிருக்கலாம், அனைத்து ஆரோக்கியமான சமூகங்களைப் போல! எனினும், உரத்த குரல் எப்போதும் மக்கள் சோர்வாகி வெளியேறவும் மூலம் வெற்றி பெறவில்லை என உறுதி செய்ய நடவடிக்கை எடுக்க வேண்டும், மற்றும் குறைந்த முக்கிய மற்றும் சிறுபான்மை குரல்கள் கேட்கப்பட வேண்டும்.
  <p markdown="1" class="pquote-credit">
— @sarahsharp, ["என்ன ஒரு நல்ல சமூகத்தை உருவாக்குகிறது?"](https://sarah.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

உரிமையாளர்களாக உணர்கையில் மக்கள் திட்டங்களுக்கு பங்களிப்பதில் உற்சாகமாக உள்ளனர். நீங்கள் உங்கள் திட்டத்தின் பார்வையிலிருந்து விலக வேண்டும் அல்லது நீங்கள் விரும்பாத பங்களிப்பை ஏற்க வேண்டும் என்று அர்த்தமில்லை. ஆனால் நீங்கள் மற்றவர்களை கௌரவப்படுத்தும் பொழுது, அவர்கள் இன்னும் அதிகமாகக் பங்களிப்பார்கள்.

உங்கள் சமூகத்துடன் உரிமையை எவ்வளவு பகிர முடியுமோ அந்தளவு வழிகளை நீங்கள் கண்டுபிடிக்க முடியுமா என்பதைப் பார்க்கவும். சில யோசனைகள்:

* **எளிதாக (அல்லாத முக்கிய) பிழைகளை சரிசெய்வதை எதிர்க்கவும்.** அதற்கு மாறாக, புதிய பங்களிப்பாளர்களைப் பணியமர்த்துவதற்கான வாய்ப்பாக அவற்றைப் பயன்படுத்துங்கள் அல்லது பங்களிக்க விரும்பும் ஒரு வழிகாட்டியாக இருக்க வேண்டும். இது முதலில் இயற்கைக்கு மாறானதாக தோன்றலாம், ஆனால் உங்கள் முதலீடு காலப்போக்கில் திரும்பிவிடும். உதாரணமாக,  @michaeljoseph சிக்கலைக் குறைக்க, தானே சரிசெய்யாமல், ஒரு பங்களிப்பாளரிடம் [Cookiecutter](https://github.com/audreyr/cookiecutter) இழு கோரிக்கை எழுப்புமாறு கேட்டார்.

![Cookiecutter சிக்கல்](/assets/images/building-community/cookiecutter_submit_pr.png)

* [சினாட்ரா](https://github.com/sinatra/sinatra/blob/master/AUTHORS.md) போன்று உங்கள் திட்டத்தில் பங்களித்த அனைவருக்கும் **உங்கள் திட்டத்தில் ஒரு பங்களிப்பாளர்கள்(CONTRIBUTORS) அல்லது நூலாசிரியர்கள்(AUTHORS) கோப்பைத் தொடங்கவும்.**

* உங்கள் சமூகம் பெரியதாயிருந்தால், **ஒரு செய்திமடலை முடிக்க அல்லது வலைப்பதிவு இடுகையை எழுதுவதன் முலம்** பங்களிப்பாளர்களுக்கு நன்றி சொல்லுங்கள். ரஸ்ட்-ன் [இந்த வாரம் ரஸ்ட்](https://this-week-in-rust.org/) மற்றும் ஹூடி-ன் [கூச்சலிடுங்கள்](http://hood.ie/blog/shoutouts-week-24.html) இரண்டு நல்ல உதாரணங்களாகும்.

* **ஒவ்வொரு பங்களிப்பாளரும் ஒப்பவிக்கும் அனுமதி தரவும்.** இது மக்களை [அவர்களின் இணைப்புகளை மெருகூட்டுவதற்கு மிகவும் உற்சாகமாக இருக்கிறது](https://felixge.de/2013/03/11/the-pull-request-hack.html)என்று @felixge கண்டறிந்தார், மேலும் அவர் சமீபத்தில் வேலை செய்யாத திட்டங்களில் கூட புதிய பராமரிப்பாளர்களைக் கண்டார்.

* உங்கள் திட்டம் கிட்ஹப் இல் இருந்தால், **உங்கள் திட்டத்தை உங்கள் தனிப்பட்ட கணக்கிலிருந்து ஒரு [அமைப்பாக](https://help.github.com/articles/creating-a-new-organization-account/)** மாற்றவும் மற்றும் குறைந்தது ஒரு காப்பு நிர்வாகியை சேர்க்கவும். வெளிப்புற ஒத்துழைப்பாளர்களுடன் திட்டங்களில் வேலை செய்வதை நிறுவனங்கள் எளிதாக்குகின்றன.

உண்மை என்னவென்றால், [பெரும்பாலான திட்டங்களுக்கு](https://peerj.com/preprints/1233.pdf) பெரும்பாலான வேலைகள் செய்யக்கூடிய ஒன்று அல்லது இரண்டு பராமரிப்பாளர்கள் இருப்பர். பெரிய திட்டம், மற்றும் உங்கள் சமூகம் பெரியதாக இருப்பின், எளிதாக உதவியை கண்டுபிடிக்க முடியும்.

அழைப்பிற்கு பதில் தெரிவிக்க யாரும் இல்லை என்றாலும், ஒரு சமிக்ஞையைத் தட்டினால், மற்றவர்கள் அதில் கலந்துகொள்ளும் வாய்ப்புகளை அதிகரிக்கிறது. எவ்வளவு முந்தி நீங்கள் ஆரம்பிக்கிறீர்களோ, விரைவில் மக்களால் உதவ முடியும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  பணியை அனுபவிக்கும் பங்களிப்பாளர்களைப் பணியமர்த்துதல் மற்றும் நீங்கள் இல்லாத காரியங்களைச் செய்யக்கூடியவர்கள் யார் என்பதில் \[இது உங்கள் சிறந்த ஆர்வத்தில் உள்ளது\]. நீங்கள் குறியீடு எழுதுவதை அனுபவிக்கிறீர்களா, ஆனால் சிக்கல்களுக்கு பதிலளிப்பதில்லையா? பின்னர் உங்கள் சமூகத்தில் அந்த நபர்களை அடையாளம் காணுங்கள், அவர்கள் அதைச் செய்யட்டும்.
  <p markdown="1" class="pquote-credit">
— @gr2m, ["வரவேற்பு சமூகங்கள்"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## முரண்பாடுகளை தீர்த்தல்

உங்கள் திட்டத்தின் ஆரம்ப கட்டங்களில், பெரிய முடிவுகளை எடுப்பது எளிதானது. நீங்கள் ஏதாவது செய்ய விரும்பினால், நீங்கள் அதை செய்யலாம்.

உங்கள் திட்டம் மிகவும் பிரபலமாகும்போது, நீங்கள் செய்யும் தீர்மானங்களில் ஆர்வம் அதிகரிக்கும். உங்களுக்கு ஒரு பெரிய பங்களிப்பாளர் சமூகம் இல்லையெனிலும், உங்கள் திட்டத்தில் நிறைய பயனர்கள் இருந்தால், முடிவுகளை எடுப்பதில் அல்லது தங்கள் சொந்த பிரச்சினைகளை எழுப்புவதில் உங்களை எடை போடலாம்.

பெரும்பாலும், நீங்கள் ஒரு நட்பு, மரியாதைக்குரிய சமூகம் பயிரிட்டால் மற்றும் உங்கள் செயல்முறைகளை வெளிப்படையாக ஆவணப்படுத்தியிருந்தால், உங்கள் சமூகம் தீர்மானத்தைக் கண்டறிய முடியும். ஆனால் சில நேரங்களில் ஒரு சில சிக்கல்களில் நீங்கள் உரையாட சிறிது கடினமான இருக்கலாம்.

### இரக்கத்திற்கு கோல் வைக்கவும்

உங்கள் சமூகம் கடினமான சிக்கலைக் கொண்டுவருகையில், கோபம் அதிகரிக்கும். மக்கள் கோபமாக அல்லது விரக்தியடைந்து, ஒருவருக்கொருவர் அல்லது உங்களிடத்தில் கோபம் கொள்ளலாம்.

ஒரு பராமரிப்பாளராக உங்கள் வேலை இந்த சூழ்நிலைகளை அதிகரிக்காமல் பார்க்க வேண்டும். உங்களுக்கு ஒரு தலைப்பில் ஒரு வலுவான கருத்து இருந்தால் கூட, போராட்டத்தில் குதித்து விடாமல் அல்லது உங்கள் கருத்துக்களை தள்ளி விடாமல், ஒரு நடுவராக நிலையை எடுக்க முயற்சிக்கவும். யாரோ ஒருவர் கலகலப்பாகவோ அல்லது உரையாடலை ஏகபோகமாகவோ செய்தால், [உடனடியாக செயல்பட்டு](../building-community/#தீங்கு-விளைவிப்பவர்களை-பொறுத்துக்-கொள்ளாதீர்கள்) விவாதங்களை பொறுப்புள்ளதாக மற்றும் ஆக்கமிக்கதாக செய்யுங்கள்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  ஒரு திட்டம் பராமரிப்பாளராக, உங்களுக்கு பங்களிப்பவர்களுக்கு மரியாதை கொடுத்தல் மிகவும் முக்கியம். அவர்கள் அடிக்கடி நீங்கள் தனிப்பட்ட முறையில் என்ன சொல்கிறீர்கள் என்பதை எடுத்துக்கொள்கிறார்கள்.
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["உள்ளன்புள்ள அல்லது தனிவழியாக இருத்தல்"](https://www.kennethreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

மற்றவர்கள் வழிநடத்துதலுக்காக உங்களைத் தேடுகிறார்கள். ஒரு நல்ல உதாரணம் அமையுங்கள். நீங்கள் இன்னமும் ஏமாற்றம், துயரத்தை அல்லது கவலையை வெளிப்படுத்தலாம், ஆனால் அமைதியாக செய்யலாம்.

உங்களை சாந்தமாக வைத்துக்கொள்வது எளிதானது அல்ல, ஆனால் உங்கள் சமூகத்தின் ஆரோக்கியத்தை மேம்படுத்துவது என்பது தலைமைத்துவத்தை நிரூபிக்கிறது. இணையம் நன்றி சொல்லும்.

### உங்கள் README ஐ ஒரு அரசியலமைப்பாக நடத்துங்கள்

உங்கள் README [வழிமுறைகளின் தொகுப்பை விடவும் மேலானது](../starting-a-project/#readme-எழுதுவது). இது உங்கள் இலக்குகள், தயாரிப்பு பார்வை, மற்றும் திட்ட வரைபடங்களைப் பற்றி பேசுவதற்கான இடமாகும். ஒரு குறிப்பிட்ட அம்சத்தின் தகுதியைப் பற்றி விவாதிக்க மக்கள் கவனம் செலுத்தினால், அது உங்கள் README ஐ மறுபரிசீலனை செய்ய மற்றும் உங்கள் திட்டத்தின் உயர்ந்த பார்வை பற்றி பேச உதவும். உங்கள் README இல் கவனம் செலுத்துவது உரையாடலைப் பயன்படுத்துகிறது, எனவே நீங்கள் ஒரு ஆக்கபூர்வமான விவாதம் செய்யலாம்.

### பயணத்தின் மீது கவனம் செலுத்துங்கள், இலக்கு அல்ல

சில திட்டங்கள் பெரிய முடிவுகளை எடுக்க வாக்களிக்கும் செயல்முறையைப் பயன்படுத்துகின்றன. முதல் பார்வையில் புத்திசாலித்தனமாக, வாக்களிப்பது ஒருவரது கவலையைப் பேசுவதற்கும், பேசுவதற்கும் பதிலாக "பதில்" பெறுவதை வலியுறுத்துகிறது.

வாக்களிப்பு அரசியல் ரீதியாக மாறலாம், அங்கு சமூக உறுப்பினர்கள் ஒருவருக்கொருவர் உத்வேகம் கொடுப்பதாக அல்லது ஒரு குறிப்பிட்ட வழியில் வாக்களிக்க அழுத்தம் கொடுக்கின்றனர். உங்கள் சமூகத்தில்  எல்லோரும் வாக்குகளிப்பது இல்லை, அது [அமைதி பெரும்பான்மை](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) உள்ளவர்கள் அல்லது ஒரு வாக்களிக்க தெரியாத தற்போதைய பயனர்கள் யாராயினும்.

சில நேரங்களில், வாக்களிப்பது அவசியமான ஒரு தேவையான சமநிலை முறிகை ஆகும். இருப்பினும், உங்களால் முடிந்த அளவுக்கு, ஒருமித்த கருத்தை விட ["சமரசம் தேடுவதை"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making) வலியுறுத்துகின்றன.

ஒரு கருத்தொன்றைத் தேடும் செயல்முறையின் கீழ், சமுதாய உறுப்பினர்கள் தாங்கள் போதுமான அளவு கேட்டிருப்பதை உணரும் வரை முக்கிய கவலைகளை விவாதிக்கின்றனர். சிறிய கவலை மட்டுமே இருக்கும் போது, சமூகம் முன்னோக்கி நகர்கிறது. ஒரு சமூகம் ஒரு சரியான பதிலை அடைய முடியாது என்பதை ஒப்புக்கொள்கிறது. அதற்கு பதிலாக, அதை கேட்பதற்கும் மற்றும் விவாதிப்பதற்கு முன்னுரிமை கொடுக்கவும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  ஆட்டம்(Atom) குழு அனைத்து சந்தர்ப்பங்களிலும் வாக்களிப்பு முறையை பின்பற்றுவதற்குப் போவதில்லை என்பதால் Atom சிக்கல்களுக்கு ஒரு வாக்கெடுப்பு முறை இல்லை. சில நேரங்களில் நாம் எது சரியானது என்று நினைக்கிறோமோ அதை தேர்வு செய்வது சரியே அது செல்வாக்கற்றதாக இருந்தாலும். (...) நான் என்ன செய்ய முடியும் மற்றும் செய்ய உறுதிமொழி கொடுக்கமுடியும் ... சமூகத்தை கவனிப்பது என் வேலை என்று ஆகிறது.
  <p markdown="1" class="pquote-credit">
— @lee-dohm on [Atom's decisionmaking process](https://discuss.atom.io/t/prioritize-issues-feature-requests-based-on-voting-system/27642/2)
  </p>
</aside>

நீங்கள் ஒரு கருத்தொன்றைத் தேடும் நடைமுறையை உண்மையில் பின்பற்றவில்லை என்றால், ஒரு திட்ட பராமரிப்பாளராக, நீங்கள் கவனிப்பதை மக்கள் அறிந்திருப்பது அவசியம். மற்றவர்கள் கேட்டதை உணர்ந்து, தங்கள் கவலைகளை தீர்ப்பதில் ஈடுபடுவதால், சிக்கலான சூழ்நிலைகளைத் தூண்டுவதற்கு நீண்ட தூரம் செல்கிறது. பிறகு, உங்கள் வார்த்தைகளை செயல்களோடு பின்பற்றுங்கள்.

ஒரு தீர்மானம் எடுப்பதற்காக விரைந்து முடிவை எடுக்க வேண்டாம். எல்லோரும் கேட்டதை உணர்ந்து கொள்ளுங்கள் மற்றும் அனைத்துத் தகவலும் ஒரு தீர்மானம் நோக்கி நகரும் முன் பகிரங்கமாக்கப்பட்டுள்ளது.

### உரையாடலை நடவடிக்கைகளில் கவனம் செலுத்துக

கலந்துரையாடல் முக்கியம், ஆனால் உற்பத்தி மற்றும் ஆக்கபூர்வமற்ற உரையாடல்களுக்கு இடையே வேறுபாடு உள்ளது.

விவாதத்திற்கு ஊக்கமளிக்கும் வரை அது தீவிரமாக தீர்மானம் நோக்கி நகரும். உரையாடலைத் தாமதப்படுத்துவது அல்லது புறப்படுவது என்பது தெளிவாக இருந்தால், தனிப்பட்டவர்கள், அல்லது சிறு விவரங்களைப் பற்றி மக்கள் குற்றம் சாட்டுகிறார்கள், அதை மூடுவதற்கான நேரம்.

இந்த உரையாடல்களைத் தொடர அனுமதிப்பது நடப்பிலுள்ள பிரச்சினைக்குத் தீமை மட்டுமல்ல, உங்கள் சமூகத்தின் ஆரோக்கியத்திற்கு மோசமானது. இந்த வகையான உரையாடல்கள் அனுமதிக்கப்படுவதையோ, ஊக்கப்படுத்தினாலும், அது எதிர்கால பிரச்சினைகளை எழுப்புவதையோ அல்லது தீர்ப்பதிலோ இருந்து மக்களை ஊக்கங்கெடுக்கலாம்.

உங்களுக்கோ மற்றவர்களுக்கோ எவ்விதமான குறிப்பையும் கொண்டு, உங்களைக் கேட்டுக்கொள்ளுங்கள், _"இது எப்படி ஒரு தீர்மானத்திற்கு நெருக்கமாக உள்ளது?"_

உரையாடலை அவிழ்க்கத் தொடங்கினால், குழுவைக் கேட்கவும் _"அடுத்தடுத்து எடுக்கும் நடவடிக்கை என்ன?"_ உரையாடலை மறுசீரமைக்க.

ஒரு உரையாடல் தெளிவாக போகவில்லை என்றால், எடுக்கும் தெளிவான நடவடிக்கைகள் எதுவும் இல்லை, அல்லது அதற்கான நடவடிக்கை ஏற்கனவே எடுக்கப்பட்டு விட்டது, சிக்கலை மூடிவிட்டு நீங்கள் ஏன் மூடினீர்கள் என்பதை விளக்குங்கள்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  உந்துதல் இல்லாமல் ஒரு பிரியை பயன் தரும்படி வழிகாட்டுதல் ஒரு கலை. மக்கள் தங்கள் நேரத்தை வீணடிக்க வேண்டாம் என்று அறிவுறுத்துவது, அல்லது சொல்வதற்கு ஆக்கபூர்வமான ஒன்றை வைத்திருந்தாலன்றி, அவற்றை இடுகையிடத் தேவையில்லை. (...) அதற்கு பதிலாக, நீங்கள் இன்னும் முன்னேற்ற நிலைமைகள் பரிந்துரைக்க வேண்டும்: மக்கள் ஒரு வழி கொடுங்கள், நீங்கள் விரும்பும் முடிவை அடைய வழிவகுக்க என்று ஒரு பாதை, ஆனால் நீங்கள் நடத்தை ஆணையிடுவது போல் இருக்காது.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_OSS உருவாக்குதல்_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### உங்கள் போர்களை புத்திசாலித்தனமாக எடுக்கவும்

சூழல் முக்கியமானது. கலந்துரையாடலில் யார் ஈடுபட்டு உள்ளனர், எப்படி அவர்கள் மற்ற சமூகத்தை பிரதிநிதித்துவப்படுத்துகிறார்கள் என்பதையும் கவனியுங்கள்.

சமுதாயத்தில் எல்லோரும் சோகமாக இருக்கிறார்களா, அல்லது இந்த பிரச்சினையுடன் கூட ஈடுபடுகிறார்களா? அல்லது ஒரு தனி தொந்தரவு? செயலில் உள்ள குரல்களை மட்டுமல்ல, உங்கள் அமைதியான சமூக உறுப்பினர்களைக் கருத்தில் கொள்ள மறக்காதீர்கள்.

உங்கள் சமூகத்தின் பரந்த தேவைகளை சிக்கல் பிரதிநிதித்துவப்படுத்தவில்லை என்றால், சிலருடைய கவலையை நீங்கள் ஒப்புக் கொள்ள வேண்டும். இது ஒரு தெளிவான தீர்மானம் இல்லாமல் தொடர்ச்சியான பிரச்சினை என்றால், தலைப்பில் முந்தைய விவாதங்களை சுட்டிக்காட்டவும் மற்றும் பிரியை மூட வேண்டும்.

### ஒரு சமூக சமநிலை முறிகையாளரை அடையாளம் காணுங்கள்

ஒரு நல்ல அணுகுமுறை மற்றும் தெளிவான தகவல்தொடர்புடன், மிகக் கடினமான சூழ்நிலைகள் தீர்க்கத்தக்கவை. இருப்பினும், ஒரு செயல்திறன் கொண்ட உரையாடலில் கூட, எப்படி நடந்துகொள்வது என்பது பற்றி கருத்து வேறுபாடு இருக்கும். இந்த சந்தர்ப்பங்களில், ஒரு சமநிலை முறிகையாளராக இருக்க ஒரு தனிநபரோ அல்லது குழுவோ அடையாளம் காணுங்கள்.

ஒரு சமநிலை முறிகையாளராக திட்டத்தின் முதன்மை பராமரிப்பாளர் இருக்க முடியும், அல்லது இது வாக்களிக்கும் அடிப்படையில் ஒரு முடிவை எடுக்க மக்கள் ஒரு சிறிய குழு இருக்க முடியும். சமநிலை முறிகையாளரை பயன்படுத்தவதற்கு முன், அடையாளம் கண்டு செயல்முறையை ஆட்சி முறை (GOVERNANCE) கோப்பில் இணைக்கவேண்டும்.

உங்கள் சமநிலை முறிகையாளர் ஒரு கடைசி போக்கிடமாக இருக்க வேண்டும். உங்கள் சமூகம் வளரவும் கற்றுக்கொள்ளவும் பிளவுபடும் பிரச்சினைகள் ஒரு வாய்ப்பாகும். இந்த வாய்ப்புகளைத் தழுவி, முடிந்தவரை ஒரு தீர்மானத்திற்கு நகர்த்துவதற்கு ஒரு கூட்டு செயல்முறையைப் பயன்படுத்துங்கள்.

## சமூகமானது ❤️ திறந்த மூலம்

ஆரோக்கியமான, வளரும் சமுதாயங்கள் ஒவ்வொரு வாரமும் ஆயிரக்கணக்கான மணி நேரம் திறந்த மூலத்திற்கு ஊற்றப்படுகின்றன. பல பங்களிப்பாளர்கள் மற்றவர்களிடம் திறந்த மூலத்தில் - வேலை செய்வதற்கான - அல்லது ஏன் வேலை செய்யவில்லை காரணத்தை சுட்டிக்காட்டுகின்றனர். ஆக்கபூர்வமாக அந்த ஆற்றலை எவ்வாறு தட்டச்சு செய்வது என்பதைக் கற்றுக்கொள்வதன் மூலம், யாரோ ஒருவருக்கு மறக்கமுடியாத திறந்த மூல அனுபவத்தை பெற நீங்கள் உதவுவீர்கள்.
