---
lang: pt
title: Sendo Pago por Trabalhos Open Source
description: Mantenha seu trabalho open source conseguindo suporte financeiro por seu tempo ou seu porojeto.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Por que algumas pessoas buscam suporte financeiro

Muito do trabalho open source é voluntário. Por exemplo, alguém pode se deparar com um bug em um projeto que utiliza e submeter uma pequena correção, ou gostar de fazer ajustes em um projeto open source durante o tempo livre.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
Eu estive procurando por um projeto de programação por "hobby" e que iria me manter ocupado durante a semana em torno do Natal. (...) Eu tinha um computador em casa, e nada muito além disso em minhas mãos. Eu decidi escrever um interpretador para a nova linguagem de scripting em que estive pensando ultimamente. (...) Eu escolhi Python como um título de trabalho.
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Há inúmeras razões pelas quais as pessoas não gostariam de ser pagas pelos seus trabalhos open source.

* **Elas já podem possuir um trabalho em horário integral que elas amem,** o que as habilita a contribuir com o open source no seu tempo livre.
* **Elas gostam de pensar em open source como um hobby** ou escape criativo e não querem se sentir financeiramente obrigadas a trabalhar em seus projetos.
* **Elas conseguem outros benefícios a partir da contribuição com o open source,** como construir uma reputação ou portfolio, aprender uma nova habilidade, ou se sentirem mais próximas da comunidade.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Doações financeiras trazem um sentimento de responsabilidade, para alguns. (...) É importante para nós, no mundo globalmente conectado e em ritmo acelerado em que vivemos, ser capaz de dizer "agora não, tenho a intenção de fazer algo completamente diferente".
  <p markdown="1" class="pquote-credit">
— @alloy, ["Why We Don't Accept Donations"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Para outros, especialmente quando as contribuições estão em curso ou requerem um tempo significativo, ser pago para contribuir com open source é a única maneira através da qual eles podem participar, seja porque o projeto precisa disso ou por razões pessoais.

Manter projetos populares pode ser uma responsabilidade significativa, tomando até 10 ou 20 horas por semana, ao invés de algumas horas por mês.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Pergunte a qualquer mantenedor de um projeto open source, e eles lhe dirão sobre a real quantidade de trabalho envolvida na administração de um projeto. Você possui clientes. Você está resolvendo issues para eles. Você está criando novas features. Isso se torna uma demanda real pelo seu tempo.
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["The Ethics of Unpaid Labor and the OSS Community"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

O trabalho pago também permite a pessoas com diferentes contextos e esferas de vida a realizarem contribuições significativas. Algumas pessoas não podem gastar tempo "não-pago" em projetos open source, baseado em sua posição financeira atual, débito, família ou outras obrigações. Isso significa que o mundo nunca vê contribuições de pessoas talentosas que não podem voluntariar seu tempo. Isso tem implicações éticas, como @ashedryden [descreveu](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), uma vez que o trabalho que é feito é enviesado em favor daqueles que já possuem vantagens na vida, que então ganham vantagens adicionais baseadas em suas contribuições voluntárias, enquanto outros que não podem contribuir não conseguem oportunidades futuras, o que reforça a falta de diversidade na comunidade open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   OSS traz enormes benefícios à industria de tecnologia, o que, por sua vez, significa benefícios a todas as indústrias. (...) Todavia, se a únicas pessoas que podem focar nisso são as sortudas e as obcecadas, então existe um grande potencial inexplorado.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Money and Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c#.ftnd5qez0)
  </p>
</aside>

Se você está procurando por suporte financeiro, há dois caminhos a considerar. Você pode financiar o seu próprio tempo como contribuidor, ou pode encontrar um financiamento organizacional para o projeto.

## Financiando o seu próprio tempo

Hoje, muitas pessoas são pagas para trabalhar parcial ou integralmente com open source. A maneira mais comum de ser pago pelo seu tempo é falar com seu empregador.

É mais fácil convencer o seu empregador se sua empresa, de fato, utilizar o seu projeto, mas seja criativo com a sua proposta. Talvez seu projeto não seja utilizado, mas Python sim, e manter um projeto Python popular ajude a atrair novos desenvolvedores Python. Pode fazer com que sua empresa pareça mais developer-friendly, de um modo geral.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/hzoo?s=180" class="pquote-avatar" alt="avatar">
  Como muitos no open source, eu estava sustentando o fardo de manter um projeto. Quando eu comecei com o open source, eu costumava ficar acordado até tarde para trabalhar nisso ou assim que chegava em casa. (...) Eu tive a oportunidade de discutir com meu chefe sobre os problemas que estava enfrentando e tivemos várias ideias sobre como poderíamos incorporar tarefas open source baseadas no nosso próprio uso do Babel.
  <p markdown="1" class="pquote-credit">
— @hzoo, ["Maintainer Stories"](https://github.com/open-source/stories/hzoo)
  </p>
</aside>

Se você não tem um projeto open source no qual gostaria de contribuir, mas contribuiria se o que fosse produzido no seu trabalho fosse de open source, convença o seu empregador a abrir o código de alguns dos softwares internos da empresa.

Muitas empresas estão desenvolvendo programas open source para construir suar marca e recrutar talentos de qualidade.

@hueniverse, por exemplo, descobriu que haviam razões financeiras para justificar [o investimento do Walmart em open source](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). E @jamesgpearce descobriu que o programa de open source do Facebook [fez uma diferença](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) no recrutamento:

> Está intimamente relacionado a nossa cultura hacker, e a como nossa organização foi percebida. Nós perguntamos aos nossos funcionários, "Você estava sabendo do programa de software open source do Facebook?". Dois terços disseram "Sim". Metade disse que o programa contribuiu positivamente na sua decisão de trabalhar para nós. Esses não são números marginais e se trata de uma tendência que eu espero que continue.

Se sua empresa tomar tal caminho, é importante manter os limites entre comunidade e atividade corporativa claros. Ultimamente, o open source se mantém através das contribuições de pessoas do mundo todo, e isso é maior do que qualquer empresa ou lugar.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Ser pago para trabalhar em open source é uma oportunidade rara e maravilhosa, mas você não tem que desistir de sua paixão no processo. Sua paixão deve ser o porquê das empresas buscarem lhe pagar.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Se você não pode convencer o seu atual empregador a priorizar trabalho open source, considere encontrar um novo empregador que encorage as contribuições open source de seus funcionários. Procure empresas que façam a sua dedicação ao trabalho open source explícita. Por exemplo:

* Algumas empresas, como a [Netflix](https://netflix.github.io/) ou o [PayPal](https://paypal.github.io/), têm websites que destacam o seu envolvimento com open source
* [Rackspace](https://www.rackspace.com/en-us) publicou sua [política de contribuição com open source](https://blog.rackspace.com/rackspaces-policy-on-contributing-to-open-source/) para funcionários

Projetos que se originaram em uma grande empresa, como o [Go](https://github.com/golang) ou o [React](https://github.com/facebook/react), também irão possivelmente empregar pessoas para trabalhar com open source.

Dependendo de suas circunstâncias pessoais, você pode tentar conseguir dinheiro independentemente para financiar o seu trabalho open source. Por exemplo:

* @gaearon financiou seu trabalho no [Redux](https://github.com/reactjs/redux) através de uma [campanha de crowdfunding no Patreon](https://redux.js.org/)
* @andrewgodwin financiou seu trabalho no Django schema migrations [através de uma campanha no Kickstarter](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

Finalmente, as vezes, projetos open source põem recompensas em issues que você pode considerar ajudar a resolver. 

* @ConnorChristie conseguiu ser pago por [ajudar](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) @MARKETProtocol a trabalhar em sua biblioteca javascript [através de uma recompensa em gitcoin](https://gitcoin.co/).
* @mamiM fez traduções para o Japonês para @MetaMask após a [issue ser financiada na Bounties Network](https://explorer.bounties.network/bounty/134).

## Encontrando financiamento para o seu projeto

Além de arranjos para contribuidores individuais, algumas vezes os projetos conseguem dinheiro de empresas, indivíduos ou outros para financiar trabalho em andamento.

O financiamento organizacional pode ir além do pagamento dos contribuidores atuais, cobrindo os custos de rodar o projeto (como por exemplo hospedagem grátis), ou investindo em novas features ou ideias.

A medida em que a popularidade do open source cresce, encontrar financiamento para o seu projeto ainda é experimental, mas há algumas opções comuns disponíveis.

### Arrecade dinheiro para o seu trabalho através de campanhas de crowdfunding ou patrocínios

Encontrar patrocínio funciona bem se você já tem uma forte audiência ou reputação, ou seu projeto é bastante popular.
Alguns exemplos de patrocínio incluem:

* O **[webpack](https://github.com/webpack)** arrecada dinheiro de empresas e indivíduos [através do OpenCollective](https://opencollective.com/webpack)
* O **[Vue](https://github.com/vuejs/vue)** é [financiado através do Patreon](https://github.com/open-source/stories/yyx990803)
* A **[Ruby Together](https://rubytogether.org/),** é uma organização sem fins lucrativos que paga pelo trabalho no [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), e outros projetos de infraestrutura do Ruby.

### Crie um fluxo de receita

Dependendo do seu projeto, você pode ser capaz de cobrar por suporte comercial, opções de hospedagem, ou features adicionais. Alguns exemplos incluem:

* **[Sidekiq](https://github.com/mperham/sidekiq)** oferece versões pagas por suporte adicional
* **[Travis CI](https://github.com/travis-ci)** oferece versões pagas de seu produto
* **[Ghost](https://github.com/TryGhost/Ghost)** é uma organização sem fins lucrativos, com um serviço gerenciado pago

Alguns projetos populares, como o [npm](https://github.com/npm/npm) e o [Docker](https://github.com/docker/docker), conseguem até mesmo capital de risco para dar suporte ao crescimento de seu negócio.

### Solicite financiamento de subsídio

Algumas fundações de software e empresas oferencem subsídios pelo trabalho open source. Algumas vezes, os subsídios podem ser pagos a individuos sem a criação de uma entidade legal para o projetor.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** recebeu um subsídio do [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/)
* O trabalho da **[OpenMRS](https://github.com/openmrs)** foi financiado pelo [Stripe's Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees)
* O **[Libraries.io](https://github.com/librariesio)** recebeu um subsídio da [Sloan Foundation](https://sloan.org/programs/digital-technology)
* A **[Python Software Foundation](https://www.python.org/psf/grants/)** oferece subsídios para trabalhos relacionados ao Python

Para opniões mais detalhadas e estudos de caso, @nayafia [escreveu um guia](https://github.com/nayafia/lemonade-stand) de como ser pago por trabalho open source. Diferentes tipos de financiamento requerem diferentes habilidades, então considere suas capacidades para entender qual opção funciona melhor para você.

## Construindo um caso de suporte financeiro

Quer o seu projeto seja uma nova ideia, ou tenha estado por aí há anos, você deve esperar colocar um esforço mental significativo em identificar o seu financiador-alvo e fazer um caso convincente.

Quer você esteja querendo pagar pelo seu próprio tempo, ou angariando fundos para um projeto, você deve ser capaz de responder as seguintes questões.

### Impacto

Por que esse projeto é útil? Por que seus usuários, ou potenciais usuários, gostam tanto dele? Onde ele estará em cinco anos?

### Tração

Tente coletar evidências de que o seu projeto importa, sejam métricas, anedotas ou testemunhos. Há alguma empresa ou pessoa importante utilizando o seu projeto atualmente? Caso contrário, alguma pessoa proeminente o endossou?

### Valor para o financiador

Financiadores, seja o seu empregador ou fundação de grantmaking, são frequentemente abordadas por oportunidades. Por que elas deveriam dar suporte ao seu projeto ao invés de qualquer outra oportunidade? Como elas recebem algum benefício disso?

### Utilização dos financiamentos

O que, exatamente, você irá conquistar com o financiamento proposto? Foque nos objetivos ou resultados ao invés de pagar um salário.

### Como você irá receber os fundos

O financiador tem algum requisito acerca do desembolso? Por exemplo, pode ser necessário que você não tenha nenhum fim lucrativo ou que você tenha algum financiador fiscal sem fins lucrativos. Ou talvez os fundos devem ser dados a um contratante individual ao invés de uma organização. Tais requisitos variam entre financiadores, então tenha certeza de fazer sua pesquisa antecipadamente.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  Por anos, fomos o recurso líder do website friendly icons, com uma comunidade de mais de 20 milhões de pessoas e contando com mais de 70 milhões de websites, incluindo o Whitehouse.gov. (...) A versão 4 foi há três anos atrás. A tecnologia Web mudou bastante desde então, e, francamente, a do Font Awesome ficou um pouco obsoleta. (...) Por isso estamos introduzindo o Font Awesome 5. Estamos modernizando e reescrevendo o CSS e reprojetando cada ícone, de cima a baixo. Estamos falando de melhor design, melhor consistência e melhor legibilidade.
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Experimente e não desista

Conseguir dinheiro não é fácil, quer você seja um projeto open source, uma organização sem fins lucrativos ou uma startup de software, e, na maioria dos casos, requer que você seja criativo. Identificar o quanto você precisa ser pago, fazer sua pesquisa, e se colocar no lugar do seu financiador irá ajudá-lo a construir um caso convincente de financiamento.

>
