---
lang: ko
title: 오픈소스 측정항목
description: 성공을 측정하고 추적함으로써 오픈소스 프로젝트가 성공할 수 있도록 정보에 입각한 의사 결정을 하십시오.
class: metrics
order: 9
image: /assets/images/cards/metrics.png
related:
  - finding
  - best-practices
---

## Why measure anything?

데이터를 현명하게 사용하면, 오픈소스 메인테이너로서 더 나은 의사 결정을 내릴 수 있습니다.

자세한 정보를 통해 다음을 수행 할 수 있습니다:

* 사용자가 새로운 기능에 어떻게 반응하는지 이해하기
* 새로운 사용자가 어디서 왔는지 파악하기
* 이상한 사용 사례 또는 기능을 식별하거나 지원할지 여부를 결정하기
* 프로젝트의 인기를 정량화하기
* 프로젝트 사용 방법 이해하기
* 스폰서십과 보조금을 통해 돈을 모으기

예시로, [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Analytics.md)는 Google 웹 로그 분석으로 우선 순위를 결정하는 데 도움이 되는 것으로 나타났습니다:

> Homebrew는 무료로 제공되며, 여가 시간에 자원 봉사자들에 의해 전적으로 운영됩니다. 결과적으로, 우리는 미래의 기능을 설계하고 현재 작업의 우선 순위를 정하는 최선의 방법을 결정하기 위해 Homebrew 사용자에 대한 상세한 사용자 연구를 할 수 있는 자원이 없습니다. 익명 집계 사용자 분석을 사용하면 사람들이 Homebrew를 사용하는 방법, 장소 및 시기에 따라 수정 및 기능의 우선 순위를 지정할 수 있습니다.

인기가 모든 것이 아닙니다. 누구나 다른 이유로 오픈소스를 사용합니다. 오픈소스 메인테이너로서의 목표가 업무를 과시하거나, 코드에 대해 투명하게 표현하거나, 재미있게 만나는 것이라면, 측정이 중요하지 않을 수도 있습니다.

If you _are_ interested in understanding your project on a deeper level, read on for ways to analyze your project's activity.

## Discovery

누구든지 프로젝트를 사용하거나 기여할 수 있게 하기전에, 이것이 존재 하는 지를 알아야합니다. 자신에게 물어보십시오: _이 프로젝트를 찾는 사람들입니까?_

![Traffic graph](/assets/images/metrics/repo_traffic_graphs_tooltip.png)

얼마나 많은 사람들이 당신의 프로젝트에 도착했는지, 어디에서 왔는지를 볼 수 있습니다. 프로젝트 페이지에서 "그래프"를 클릭 한 다음, "트래픽"을 클릭하십시오. 이 페이지에서 다음을 볼 수 있습니다:

* **총 페이지 뷰:** 얼마나 많은 조회 횟수로 프로젝트를 보았는지 알려줍니다

* **총 고유 방문자수:** 얼마나 많은 사람들이 프로젝트를 보았는지 알려줍니다

* **참고한 사이트:** 방문자가 어디에서 왔는지 알려줍니다. 이 통계는 잠재 고객에게 도달할 수있는 위치와 홍보 활동의 효과를 파악하는 데 도움이됩니다.

* **인기 컨텐츠:** 방문자가 프로젝트에서 어디로 이동했는지 알려주며, 페이지 뷰와 고유 방문자별로 세분화됩니다.

[GitHub stars](https://help.github.com/articles/about-stars/)는 또한 인기의 기준치 측정을 제공하는 데 도움이 될 수 있습니다. GitHub star는 반드시 다운로드 및 사용량과 상관 관계가 있는 것은 아니지만, 얼마나 많은 사람들이 귀하의 작업에 주의를 기울이고 있는지 말해 줄 수 있습니다.

[특정 장소에서 검색 가능성을 추적](https://opensource.com/business/16/6/pirate-metrics) 할 수도 있습니다: 예를 들어, Google 페이지랭크, 프로젝트 웹 사이트의 추천 트래픽 또는 다른 오픈소스 프로젝트 또는 웹 사이트의 추천을 포함 할 수 있습니다.

## Usage

사람들은 우리가 인터넷이라고 부르는 이 거칠고 미친 일로 프로젝트를 찾고 있습니다. 이상적으로는, 프로젝트를 보았을 때 뭔가 할 것을 강요 당할 것입니다. 두 번째 질문은 다음과 같습니다: _이 프로젝트를 사용하는 사람들입니까?_

npm 또는 RubyGems.org와 같은 패키지 관리자를 사용하여 프로젝트를 배포하는 경우 프로젝트 다운로드를 추적할 수 있습니다.

각 패키지 매니저는 "다운로드"와 약간 다른 정의를 사용할 수 있으며, 다운로드가 반드시 설치 또는 사용과 관련이 있는 것은 아니지만 비교를 위한 기준을 제공합니다. [Libraries.io](https://libraries.io/)를 사용해 많은 인기있는 패키지 매니저의 사용 통계를 추적 해보십시오.

만약 프로젝트가 깃허브에 있다면, "Traffic"페이지로 사디 이동하보십시오. [clone graph](https://github.com/blog/1873-clone-graphs)를 사용하여 주어진 날에 프로젝트가 복제 된 횟수를 전체 클론 및 클론 받은 사람으로 세분화 할 수 있습니다.

![Clone graph](/assets/images/metrics/clone_graph.png)

프로젝트를 발견한 사람의 수에 비해 사용량이 적을 경우, 고려해야 할 두 가지 문제가 있습니다. 어느 한 쪽으로는:

* 프로젝트가 잠재 고객을 성공적으로 전환하지 못했거나, 또는
* 틀린 지지자를 끌어들이고 있습니다.

예를 들어, 프로젝트가 Hacker News의 첫 페이지에있는 경우, Hacker News의 모든 사용자에게 도달했기 때문에 발견(트래픽)은 증가하지만 전환율은 낮아질 수 있습니다. 그러나 Ruby 프로젝트가 Ruby 컨퍼런스에 등장한다면 타겟 잠재 고객의 전환율이 높아질 가능성이 큽니다.

잠재 고객이 어디에서 왔는지 파악하고 프로젝트 페이지에서 다른 사람들에게 당신이 직면한 두가지 문제점을 파악하도록 요청하십시오.

사람들이 프로젝트를 사용하고 있다는 것을 알게되면, 사람들이 프로젝트를 통해 무엇을 하고 있는지 파악하려고 할 수 있습니다. 그들은 당신의 코드를 포크하고 기능을 추가함으로써 그것을 구축하고 있습니까? 그들은 과학이나 비즈니스를 위해 그것을 사용하고 있습니까?

## Retention

사람들이 프로젝트를 찾고 있으며 프로젝트를 사용하고 있습니다. 다음 질문은 스스로에게 물어볼 것입니다: _이 프로젝트에 다시 기여한 사람들입니까?_

기여자를 생각하는 것은 너무 이릅니다.다른 사람이 참여하지 않으면 프로젝트가 _인기있고_(많은 사람들이 그것을 사용하지만) _지원_되지 않는(요구 사항을 충족시키는 데 필요한 유지 보수 시간이 충분하지 않음) 좋지 못한 상황에 처할 위험이 있습니다.

보유자는 이전에 활동적인 기여자가 결국 다른 것들로 이동하기 때문에 [새로운 기여자가 유입](http://blog.abigailcabunoc.com/increasing-developer-engagement-at-mozilla-science-learning-advocacy#contributor-pathways_2)되어야합니다.

정기적으로 추적할 수 있는 커뮤니티 측정 항목의 예는 다음과 같습니다:

* **기여자 중 총 기여 수 및 커밋 수 :** 얼마나 많은 기여자가 있고, 누가 더 많이 또는 적게 활동 하는지를 알려줍니다. GitHub에서는 "Graphs"-> "Contributors"에서 볼 수 있습니다. 현재 이 그래프는 저장소의 기본 브랜치에 작성한 기여자만 계산합니다.

![Contributor graph](/assets/images/metrics/repo_contributors_specific_graph.png)

* **처음, 캐주얼, 그리고 다시 기여한 사람:** 새로운 참여자를 얻었는지 여부와 그들이 다시 돌아 왔는지 여부를 추적하는 데 도움이됩니다. (캐주얼 기여자는 커밋 수가 적고 커밋 수가 5회 이하이거나, 또 다른 기준은 당신에게 달려 있습니다.) 새로운 참여자가 없으면 프로젝트 커뮤니티가 정체 될 수 있습니다.

* **열린 이슈와 pull requests의 수:**  수치가 너무 높으면 이슈 검토 및 코드 검토에 대한 도움이 필요할 수 있습니다.

* **_열렸던_ 이슈와 _열렸던_ pull requests의 수:** 열렸던 이슈는 누군가가 프로젝트의 이슈를 열어 신청할 수 있음을 의미합니다. 그 숫자가 시간이 지남에 따라 증가하면 사람들이 귀하의 프로젝트에 관심을 보였다고 나타낼수 있습니다.

* **기여 유형:** 예시로, 커밋, 오타 혹은 버그 수정, 또는 이슈에 답변하기가 있습니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/arfon?s=180" class="pquote-avatar" alt="avatar">
  Open source is more than just code. Successful open source projects include code and documentation contributions together with conversations about these changes.
  <p markdown="1" class="pquote-credit">
— @arfon, ["오픈소스의 형태"](https://github.com/blog/2195-the-shape-of-open-source)
  </p>
</aside>

## Maintainer activity

마지막으로, 프로젝트 메인테이너가 받은 기여 분량을 처리 할 수 있는지 확인하여 루프를 닫으십시오. 자신에게 묻고 싶은 마지막 질문은 다음과 같습니다: _나는 (또는 우리가) 우리 커뮤니티에 반응하고 있습니까?_

응답이 없는 메인테이너는 오픈소스 프로젝트의 병목 현상이 됩니다. 누군가 기여를 제출했지만 메인테이너가 듣지 못하면 기분이 나빠져서 떠나기도 합니다.

[Mozilla의 연구](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177)는 관리자의 응답성이 반복 기여도를 장려하는 중요한 요소임을 시사합니다.

당사자(또는 다른 메인테이너)가 이슈 또는 pull request 여부에 관계없이 기여에 응답하는 데 걸리는 시간을 고려하십시오. 응답은 조치를 취할 필요가 없습니다. 다음과 같이 간단하게 말할 수 있습니다: _"제출해 주셔서 감사합니다. 저는 다음 주에 이것을 검토 할 것입니다."_

다음과 같이 기여 프로세스의 단계간에 이동하는 데 걸리는 시간을 측정 할 수도 있습니다:

* 이슈가 열려있는 평균 시간
* 이슈가 PR에 의해 폐쇄되는지 여부
* 부실 이슈가 종결 되는지 여부
* pull request을 병합하는 평균 시간

## Use 📊 to learn about people

측정 기준을 이해하면 적극적으로 성장하는 오픈소스 프로젝트를 구축하는 데 도움이됩니다. 대시 보드의 모든 측정치를 추적하지 않더라도, 위의 프레임워크를 사용하여 프로젝트가 성공하는 데 도움이 되는 동작 유형에 주의를 기울이십시오.
