---
lang: ko
title: 프로젝트에서 사람찾기
description: 행복한 사용자의 손에 넣어져서 오픈소스 프로젝트의 성장을 도우십시오.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Spreading the word

출시할 때 오픈소스 프로젝트를 홍보해야한다는 규정은 없습니다. 인기와 아무런 관련이 없는 오픈소스에서 일하는 많은 성취 이유가 있습니다. 그러나 다른 사람들이 오픈소스 프로젝트를 찾고 사용할 수 있기를 희망한다면, 이제는 모든 사람들에게 열심히 일하게 할 시간입니다!

## Figure out your message

프로젝트를 홍보하기 위한 실제 작업을 시작하기 전에, 프로젝트의 기능과 중요한 이유를 설명할 수 있어야합니다.

무엇이 당신의 프로젝트를 다양하고 흥미롭게 만드나요? 왜 그것을 만들었습니까? 이러한 질문을 스스로 해결하면 다른 사람들을 설득하기가 더 쉬울 것입니다.

사람들이 문제를 해결하기 때문에, 사용자들은 궁극적으로는 참여자로서만 참여한다는 것을 기억하십시오. 프로젝트의 메시지와 가치에 대해 생각할 때 _그들이_ 무엇을 원하는 것인지에 대한 렌즈를 통해 보도록 하십시오.

예시로, @robb는 코드 예제를 사용하여 자신의 프로젝트인 [Cartography](https://github.com/robb/Cartography)를 효율적으로 했습니다:

![Cartography README](/assets/images/finding-users/cartography.jpg)

메시징에 대해 더 자세히 알고 싶으면, Mozilla의 ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) 개발자용 연습 personas를 확인하십시오.

## Help people find and follow your project

<aside markdown="1" class="pquote">
  You ideally need a single "home" URL that you can promote and point people to in relation to your project. You don't need to splash out on a fancy template or even a domain name, but your project needs a focal point.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["코드에 대한 단어 확산 방법"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

사람들이 단일 네임스페이스를 가리켜 프로젝트를 찾고 기억하도록 돕습니다.

**작업을 홍보하기 위해 명확히 처리를 하기.** 트위터 핸들, GitHub URL 또는 IRC 채널을 통해 사람들을 프로젝트에 쉽게 안내 할 수 있습니다. 그들은 또한 귀하의 프로젝트가 성장하는 커뮤니티에 모일 장소를 제공합니다.

프로젝트에 이 채널을 아직 설정하고 싶지 않다면, 자신의 모든 트위터 또는 GitHub 핸들을 홍보하십시오. 예를 들어, 만남이나 행사에서 말하는 경우, 소개 또는 슬라이드에 포함되어 있는지 확인하십시오. 그런식으로 사람들은 당신에게 연락하거나 일을 수행하는 방법을 알고 있습니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  A mistake I made in those early days (...) was not starting a Twitter account for the project. Twitter's a great way to keep people up to date about a project as well as constantly expose people to the project.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["Apache 폭풍의 역사와 교훈"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**프로젝트를 위한 웹 사이트를 만드는 것을 고려하기.** 웹 사이트는 프로젝트를 보다 편리하고 쉽게 탐색할 수 있게 해주며, 특히 명확한 문서 및 자습서와 함께 사용할 수 있습니다. 또한 프로젝트가 활성화되어있어 시청자가 더 편안하게 사용할 수 있습니다. 예시를 사용하여 사람들에게 프로젝트 사용 방법에 대한 아이디어를 제공하십시오.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), Django의 협력자가 말하기를 웹사이트는 _"by far the best thing we did with Django in the early days"_이라고 했습니다.

만약 당신의 프로젝트가 깃허브에 호스팅된다면, [GitHub 페이지](https://pages.github.com/)를 통해 웹사이트를 쉽게 만드는 것을 보실 수 있습니다. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/),와 [Middleman](https://middlemanapp.com/)은 포괄적인 사이트 중, 훌륭한 [예시입니다](https://github.com/showcases/github-pages-examples).

![Vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

이제 프로젝트에 대한 메시지와 사람들이 프로젝트를 쉽게 찾을 수 있는 방법을 얻었으므로, 거기서 나와서 고객과 대화를 나눠보십시오.

## Go where your project's audience is (online)

온라인 홍보는 단어를 빠르게 공유하고 전파 할 수 있는 좋은 방법입니다. 온라인 채널을 사용하면 매우 광범위한 잠재적 고객에게 도달 할 수 있습니다.

기존 온라인 커뮤니티 및 플랫폼을 활용하여 잠재 고객에게 도달하십시오. 만약 오픈소스 프로젝트가 소프트웨어 프로젝트라면, 아마도 [스택 오버플로우](https://stackoverflow.com/), [레딧](https://www.reddit.com), [해커 뉴스](https://news.ycombinator.com/), 또는 [Quora](https://www.quora.com/)에서 고객을 찾을 수 있을 것입니다. 사람들이 당신의 작품에 대해 가장 많은 이익을 보거나 즐거워한다고 생각하는 채널을 찾으십시오.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Each program has very specific functions that only a fraction of users will find useful. Don't spam as many people as possible. Instead, target your efforts to communities that will benefit from knowing about your project.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["오픈소스 프로젝트에서의 마케팅"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

관련 방법으로 프로젝트를 공유하는 방법을 찾을 수 있는지 확인하십시오:

* **관련 오픈소스 프로젝트와 커뮤니티에 대해 알아보십시오.** 때로는 프로젝트를 직접 홍보할 필요가 없습니다. 프로젝트가 파이썬을 사용하는 데이터 과학자에게 완벽하면, 파이썬 데이터 과학 커뮤니티에 대해 알아보십시오. 사람들이 당신을 알게되면, 자연스런 기회가 생겨 대화를 나누고 작업을 공유하게됩니다.
* **프로젝트가 해결하는 문제를 겪고있는 사람들을 찾으십시오.** 프로젝트의 타겟층에 속한 사람들을 관련 포럼을 통해 검색하십시오. 그들의 질문에 답하고 적절한 방법으로 프로젝트를 솔루션으로 제안하십시오.
* **피드백 요청하기.** 관련성 높고 흥미로운 청중에게 자신과 자신의 작업을 소개하십시오. 프로젝트에서 누가 이익을 얻을지 생각하는 사람에 대해 구체적으로 설명합시다. 이렇게 문장을 끝내봅니다: _"누군가 Y를 하려고하면, 나는 내 프로젝트가 정말로 X를 도울 것이라고 생각합니다_".단순히 귀하의 작업을 홍보하는 것이 아니라, 다른 사람들의 의견을 경청하고 이에 응답해봅니다.

일반적으로 말하면, 보답하기 전에 다른 사람들을 돕는 데 집중하십시오. 누구나 온라인으로 프로젝트를 홍보하기 쉽기 때문에, 많은 소음이 발생할 것입니다. 자신이 원하는 사람이 아니라, 무리에서 눈에 띄기 위해서 자신이 누구인지를 사람들에게 알릴 수 있습니다.

아무도 주의를 기울이지 않거나 초기 봉사 활동에 응답하지 않으면, 낙심하지 마십시오! 대부분의 프로젝트 시작은 수개월 또는 수년이 걸릴 수 있는 반복 과정입니다. 처음으로 응답을 얻지 못하면 다른 전술을 시도하거나 다른 사람들의 작품에 가치를 더하는 방법을 먼저 찾으십시오. 이러한 일에는 시간과 헌신이 필요합니다.

## Go where your project's audience is (offline)

![Public speaking](/assets/images/finding-users/public_speaking.jpg)

오프라인 이벤트는 새로운 프로젝트를 홍보하는 인기있는 방법입니다. 참여한 잠재 고객에게 도달하거나, 더 깊은 인간 관계를 구축할 수 있는 좋은 방법입니다. 특히 개발자에게 다가가려는 경우 더욱 그렇습니다.

만약 [새로운 공개 연설](https://speaking.io/)을 한다면, 프로젝트의 언어 또는 생태계와 관련된 지역 모임을 찾아보십시오.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  I was pretty nervous about going to PyCon. I was giving a talk, I was only going to know a couple of people there, I was going for an entire week. (...) I shouldn't have worried, though. PyCon was phenomenally awesome! (...) Everyone was incredibly friendly and outgoing, so much that I rarely found time not to talk to people!
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["나는 PyCon을 걱정하지않고 좋아하는 방법을 어떻게 배웠나"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

이전에 한번도 얘기 한 적이 없다면, 긴장을 하는 것이 정상입니다! 그들이 진정으로 당신의 일에 대해 듣고 싶어하기 때문에 청중이 거기 있다는 것을 기억합시다.

이야기를 할 때, 청중이 흥미롭고 가치있는 것을 얻는 것에 집중합니다. 귀하의 언어를 친절하고 친근하게 유지하십시오. 웃고, 숨 쉬고, 재미있게 보내십시오.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  When you start writing your talk, no matter what your topic is, it can help if you see your talk as a story that you tell people.
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["기술 컨퍼런스 대화를 준비하고 작성하는 방법"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

준비가 되었다면, 프로젝트 홍보를 위해 컨퍼런스에서 말하는 것을 고려하십시오. 때로는 컨퍼런스가 전 세계에서 더 많은 사람들에게 다가갈 수 있도록 도와줄겁니다.

귀하의 언어 또는 생태계에서 특정한 회의를 찾으십시오. 대화를 제출하기 전에, 미리 컨퍼런스를 조사하여 참석자와 대화를 나누고 수용 할 확률을 높입니다. 연사를 보면서 회의의 청중을 이해할 수 있습니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  I wrote very nicely to the JSConf people and begged them to give me a slot where I could present it at JSConf EU. (...) I was extremely scared, presenting this thing that I had been working on for six months. (...) The whole time I was just thinking, oh my God. What am I doing here?
  <p markdown="1" class="pquote-credit">
— @ry, ["Node.js의 기록" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Build a reputation

위에서 설명한 전략 외에도, 사람들을 초대하여 프로젝트에 기여하도록하는 가장 좋은 방법은 프로젝트를 공유하고 기여하는 것입니다.

신입 회원을 돕고, 자원을 공유하고, 다른 사람들의 일에 사려 깊은 공헌을 하는 것은 긍정적인 평판을 얻는 데 도움이 될 것입니다. 그러면 사람들은 당신의 일에 대한 맥락을 가지게 될 것이며 관심을 기울이고 자신이 하는 일을 공유할 가능성이 높아질 것입니다.

때로는, 이러한 관계가 더 넓은 생태계와의 공식 파트너십으로 이어질 수도 있습니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  The only reason urllib3 is the most popular third-party Python library today is because it's part of requests.
  <p markdown="1" class="pquote-credit">
— @shazow, ["오픈소스 프로젝트를 번성하게 만드는 방법"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

평판을 얻기 시작하는 것이 너무 빠르거나, 혹은 너무 늦지 않았습니다. 이미 자신의 프로젝트를 시작했더라도, 다른 사람들을 도울 수 있는 방법을 모색하십시오.

고객을 키우는 데는 밤새도 해결책이 없습니다. 다른 사람들의 신뢰와 존경심을 얻는 데는 시간이 걸리고 명성을 쌓는 작업은 끝나지 않습니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ariya?s=180" class="pquote-avatar" alt="avatar">
  PhantomJS was released for the first time in the beginning of 2011. (...) I spread the word in the usual ways: I tweeted about it, I wrote blog posts on things you could do with it, I mentioned it during various discussions in meetups. When it became more well known in 2014, I started giving presentations about it.
  <p markdown="1" class="pquote-credit">
— @ariya, ["메인테이너 이야기"](https://github.com/open-source/stories/ariya)
  </p>
</aside>

## Keep at it!

때로는, 사람들이 오픈소스 프로젝트에 주목하기까지는 시간이 오래 걸립니다. 괜찮습니다! 오늘날 가장 인기있는 프로젝트 중 일부는 높은 수준의 활동에 도달하기까지 수년이 걸렸습니다. 마술 총알 대신 관계를 구축하는 데에 집중하십시오. 인내심을 갖고, 감사해하는 사람들과 일하는 결과물을 계속 공유하십시오.
