---
lang: id
title: Kode Etik Anda
description: Fasilitasi perilaku komunitas yang sehat dan konstruktif dengan mengadopsi dan menerapkan kode etik.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## Kenapa saya perlu menerapkan kode etik?

Sebuah kode etik adalah dokumen yang menjelaskan perilaku yang diharapkan dari partisipan proyek Anda. Mengadopsi, dan menerapkan kode etik dapat membantu membuat atmosfir sosial yang positif pada komunitas Anda.

Kode etik membantu tidak hanya partisipan Anda, tetapi juga Anda sendiri. Jika Anda mengelola proyek, Anda akan mendapati bahwa tingkah laku tidak produktif dari partisipan lain bisa menguras energi Anda dan Anda merasa tidak bahagia terhadap pekerjaan Anda.

Kode etik menekankan Anda untuk memfasilitasi perilaku komunitas yang sehat dan konstruktif. Bersifat proaktif mengurangi kecenderungan bahwa Anda atau orang lain akan merasa capek dengan proyek Anda, dan membantu mengambil tindakan apabila seseorang melakukan sesuatu yang tidak Anda setujui.

## Membuat kode etik

Cobalah untuk membuat kode etik sedini mungkin: idealnya ketika Anda membuat proyek pertama Anda.

Selain mengkomunikasikan ekspektasi Anda, kode etik juga menjelaskan beberapa hal berikut:

* Dimana kode etik berlaku _(hanya pada masalah dan pull request, atau aktivitas komunitas?)_
* Kepada siapa kode etik berlaku _(anggota komunitas dan pengelola, tetapi bagaimana dengan sponsor?)_
* Apa yang terjadi jika seseorang melanggar kode etik
* Bagaimana seseorang dapat melaporkan pelanggaran

Apabila dimungkinkan, gunakan yang sudah ada. [Contributor Covenant](https://www.contributor-covenant.org/) adalah kode etik yang bisa digunakan dan sudah digunakan oleh lebih dari 40.000 proyek open source, termasuk Kubernetes, Rails, dan Swift.

[Kode etik Django](https://www.djangoproject.com/conduct/) dan [Kode etik Warga](http://citizencodeofconduct.org/) adalah dua contoh kode etik yang bagus.

Tempatkan dokumen CODE_OF_CONDUCT pada induk direktori proyek Anda, dan hubungkan dari dokumen README sehingga terlihat dengan jelas oleh komunitas Anda.

## Menentukan bagaimana Anda akan menerapkan kode etik

<aside markdown="1" class="pquote">
  Kode etik yang tidak (bisa) diterapkan jauh lebih jelek dibandingkan tanpa kode etik sama sekali: hal ini mengirimkan pesan bahwa nilai dari kode etik tidaklah penting atau dihargai pada komunitas Anda.
  <p markdown="1" class="pquote-credit">
— [Ada Initiative](https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community/)
  </p>
</aside>

Anda harus menjelaskan bagaimana kode etik Anda akan diterapkan **_sebelum_** pelanggaran terjadi. Terdapat beberapa alasan:

* Hal ini mendemonstrasikan bahwa Anda serius untuk mengambil tindakan apabila diperlukan.

* Komunitas Anda akan merasa lebih terjamin apabila komplain akan direview.

* Anda meyakinkan komunitas Anda bahwa proses review berjalan dengan adil dan transparan, apabila mereka mendapati dirinya diinvestigasi terhadap sebuah pelanggaran.

Anda harus memberikan sebuah jalan yang pribadi (seperti alamat email) untuk melaporkan pelanggaran kode etik dan menjelaskan siapa yang menerima laporan tersebut. Penerima laporan bisa jadi pengelola, sekelompok orang pengelola, atau tim kode etik.

Jangan lupa bahwa seseorang mungkin melaporkan pelanggaran terhadap orang yang akan menerima laporan tersebut. Pada kasus ini, berikan opsi untuk melaporkan pelanggaran pada orang lain. Misalnya, @ctb dan @mr-c [menjelaskan pada proyek mereka](https://github.com/dib-lab/khmer/blob/master/CODE_OF_CONDUCT.rst), [khmer](https://github.com/dib-lab/khmer):

> Perilaku kasar, melecehkan, atau perilaku lainnya yang tidak dapat diterima dapat dilaporkan dengan mengirimkan email pada **khmer-project@idyll.org** yang akan sampai pada C. Titus Brown dan Michael R. Crusoe. Untuk melaporkan masalah pada salah satu dari mereka, kirimkan email pada **Judi Brown Clarke, Ph.D.** Direktur  Diversity pada BEACON Center untuk Studi Evolusi, sebuah pusat studi NSF untuk Ilmu Pengetahuan dan Teknologi.*

Sebagai inspirasi, lihat [manual penerapan](https://www.djangoproject.com/conduct/enforcement-manual/) Django  (meskipun Anda mungkin tidak perlu sedetail ini, tergantung dari ukuran proyek Anda).

## Menerapkan kode etik

Seringkali, terlepas dari usaha Anda, seseorang akan melakukan pelanggaran terhadap kode etik. Terdapat beberapa cara untuk menyelesaikan perilaku negatif ketika hal itu terjadi.

### Mengumpulkan informasi tentang situasi

Perlakukan setiap suara anggota komunitas sama pentingnya seperti suara Anda sendiri. Jika Anda menerima laporan bahwa seseorang melanggar kode etik, perlakukan dengan serius dan investigasi hal tersebut, meskipun hal itu tidak sesuai dengan pengalaman Anda dengan orang tersebut. Dengan melakukan hal ini, Anda memberikan tanda kepada komunitas Anda bahwa Anda menghargai perspektif dan mempercayai penilaian mereka.

Anggota komunitas yang melanggar mungkin orang yang melakukannya berulang-ulang dan membuat orang lain menjadi tidak nyaman, atau mereka mungkin melakukannya hanya sekali. Kedua kasus tersebut bisa menjadi dasar untuk mengambil tindakan, tergantung dari konteks.

Sebelum Anda merespon, berikan Anda waktu untuk memahami apa yang terjadi. Baca komentar dan percakapan orang tersebut di masa lampau untuk memahami siapa mereka dan mengapa mereka bertindak seperti itu. Cobalah untuk mendapatkan perspektif diluar perspektif Anda sendiri tentang orang ini dan perilaku mereka.

<aside markdown="1" class="pquote">
  Jangan terbawa pada argumentasi. Jangan terpengaruh dengan perilaku orang lain sebelum Anda menyelesaikan satu masalah. Fokus pada apa yang Anda perlukan.
  <p markdown="1" class="pquote-credit">
— Stephanie Zvan, ["So You've Got Yourself a Policy. Now What?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### Mengambil tindakan yang sesuai

Setelah mengumpulkan dan memproses informasi yang cukup, Anda perlu memutuskan apa yang akan Anda lakukan. Ketika Anda mempertimbangkan langkah selanjutnya, ingatlah bahwa tujuan Anda sebagai moderator adalah untuk mengembangkan lingkungan yang aman, saling menghargai, dan kolaboratif. Pertimbangkan untuk tidak hanya memikirkan kondisi yang sedang ditangani, tetapi bagaimana respon Anda akan mempengaruhi perilaku komunitas Anda dan ekspektasi untuk masa depan.

Ketika seseorang melaporkan pelanggaran kode etik, hal itu merupakan tugas Anda, bukan mereka untuk menanganinya. Seringkali, pelapor membuka informasi yang bisa membahayakan karir, reputasi, atau keamanan fisik mereka. Memaksa mereka untuk mengkonfrontasi pelaku bisa menempatkan pelapor pada posisi yang membahayakan. Anda harus menangani komunikasi langsung dengan pelapor, kecuali pelapor meminta secara eksplisit.

Terdapat beberapa cara untuk merespon pada pelanggaran kode etik:

* **Berikan peringatan publik** dan jelaskan bagaimana perilaku mereka mempengaruhi orang lain secara negatif pada media tempat pelanggaran itu terjadi. Ketika memungkinkan, komunikasi publik memberikan tanda pada komunitas bahwa Anda menganggap kode etik secara serius. Harap sopan, tetapi tegas pada komunikasi Anda.

* **Hubungi orang tersebut secara pribadi** untuk menjelaskan bagaimana perilaku mereka mempengaruhi orang lain secara negatif. Anda mungkin akan menggunakan media komunikasi pribadi jika situasinya melibatkan informasi pribadi. Jika Anda berkomunikasi dengan seseorang secara pribadi, merupakan ide yang bagus untuk menggunakan CC kepada mereka yang melaporkan situasinya, sehingga mereka tahu bahwa Anda mengambil tindakan. Konfirmasikan kepada pelapor sebelum memberikan CC kepada mereka.

Seringkali, sebuah resolusi tidak dapat tercapai. Tersangka menjadi agresif dan bertindak kasar ketika dikonfrontasi atau tidak mengubah perilakunya. Pada situasi ini, Anda mungkin bisa mempertimbangkan tindakan yang lebih tegas. Sebagai contoh:

* **Skorsing** dari proyek, yang dilakukan melalui larangan sementara pada setiap partisipasi aspek proyek

* **Larangan permanen** dari proyek

Melarang anggota tidak boleh dianggap sepele dan merepresentasikan perbedaan perspektif yang permanen. Anda harus mengambil tindakan ketika resolusi tidak dapat dicapai.

## Tanggung jawab Anda sebagai pengelola

Kode etik bukanlah hukum yang diberlakukan secara sewenang-wenang. Anda adalah orang yang memberlakukan kode etik dan hal itu merupakan tanggung jawab Anda untuk mengikuti aturan yang ditetapkan oleh kode etik.

Sebagai pengelola, Anda membuat panduan untuk komunitas Anda dan memberlakukan panduan tersebut sesuai dengan aturan yang ditetapkan pada kode etik. Hal ini berarti memproses laporan pelanggaran kode etik secara serius. Pelapor berhak mendapatkan review yang adil terhadap komplain mereka. Jika Anda menentukan bahwa perilaku yang dilaporkan bukanlah sebuah pelanggaran, komunikasikan kepada mereka dan jelaskan mengapa Anda tidak melakukan tindakan apapun. Apa yang akan mereka lakukan terhadap keputusan Anda merupakan hak mereka: mentolerasi perilaku yang tidak sesuai atau berhenti berpartisipasi pada komunitas.

Sebuah laporan tentang perilaku yang secara _teknis_ melanggar kode etik masih tetap mengindikasikan bahwa ada masalah pada komunitas Anda, dan Anda harus menginvestigasi masalah ini. Hal ini mungkin termasuk merevisi kode etik untuk mengklarifikasi perilaku yang dapat diterima dan/atau berbicara pada orang yang dilaporkan dan memberitahukan bahwa meskipun mereka tidak melanggar kode etik, mereka membuat partisipan lain menjadi tidak nyaman.

Akhirnya, sebagai pengelola, Anda menentukan dan menerapkan standar untuk perilaku yang dapat diterima. Anda memiliki kemampuan untuk mengubah nilai komunitas pada proyek dan partisipan mengharapkan Anda untuk menerapkan nilai-nilai tersebut dengan cara yang adil.

## Mendorong perilaku yang Anda harapkan pada dunia 🌎

Ketika sebuah proyek tampak tidak ramah, meskipun hanya satu orang yang dapat ditoleransi oleh anggota lain, Anda memiliki resiko untuk kehilangan banyak kontributor. Bukanlah perkara mudah untuk mengadopsi dan menerapkan kode etik, tetapi mengembangkan lingkungan yang ramah akan membantu komunitas Anda untuk berkembang.
