---
lang: fr
title: Votre Code de Conduite
description: Faciliter un comportement communautaire sain et constructif en adoptant et en appliquant un code de conduite.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## Pourquoi un code de conduite

Un code de conduite est un document qui établit des attentes de comportement pour les participants de votre projet. Adopter et appliquer un code de conduite peut aider à créer une atmosphère sociale positive pour votre communauté.

Les codes de conduite aident à protéger non seulement vos participants, mais vous-même. Si vous maintenez un projet, vous constaterez peut-être que les attitudes improductives des autres participants peuvent vous fatiguer ou vous faire sentir malheureux au sujet de votre travail au fil du temps.

Un code de conduite vous permet de faciliter un comportement communautaire sain et constructif. Être proactif réduit la probabilité que vous, ou d'autres, soyez fatigué avec votre projet, et vous aide à agir lorsque quelqu'un fait quelque chose avec lequel vous n'êtes pas d'accord.

## Etablir un code de conduite

Essayez d'établir un code de conduite le plus tôt possible: idéalement, dès que vous créez votre projet.

En plus de communiquer vos attentes, un code de conduite décrit ce qui suit:

* Où le code de conduite prend effet _(uniquement sur les issues et les pull request, ou les activités communautaires comme les événements ?)_
* Qui le code de conduite s'applique-t-il _(membres de la communauté et les mainteneurs, mais qu'en est-il des sponsors ?)_
* Que se passe-t-il si quelqu'un enfreint le code de conduite
* Comment quelqu'un peut-il signaler les violations

Quand vous le pouvez, utilisez l'existant. Le [Contributor Covenant](https://contributor-covenant.org/) est un code de conduite qui est utilisé par plus de 40 000 projets open source, y compris Kubernetes, Rails et Swift.

Le [Django Code of Conduct](https://www.djangoproject.com/conduct/) et le [Citizen Code of Conduct](http://citizencodeofconduct.org/) sont également deux bons exemples de code de conduite.

Placez un fichier CODE_OF_CONDUCT dans le répertoire racine de votre projet et rendez-le visible pour votre communauté en le liant à votre fichier CONTRIBUTING ou README.

## D&eacute;cider comment vous allez appliquer votre code de conduite

<aside markdown="1" class="pquote">
  Un code de conduite qui n'est pas (ou ne peut pas être) appliqué est pire qu'aucun code de conduite: il envoie le message que les valeurs du code de conduite ne sont pas vraiment importantes ou respectées dans votre communauté.
  <p markdown="1" class="pquote-credit">
— [Ada Initiative](https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community/)
  </p>
</aside>

Vous devrez expliquer comment votre code de conduite sera appliqué **_avant_** une qu'une violation se produise. Il y a plusieurs raisons de le faire:

* Cela montre que vous êtes capable de prendre les mesures nécessaire quand il y a besoin.

* Votre communauté se sentira plus rassurée que les plaintes soient réellement examinées.

* Vous rassurez votre communauté sur le fait que le processus d'examen est juste et transparent, si jamais ils se retrouvaient à enquêter sur une violation.

Vous devriez donner aux gens un moyen privé (comme une adresse e-mail) de signaler une violation du code de conduite et d'expliquer qui reçoit ce rapport. Il pourrait s'agir d'un responsable, d'un groupe de responsables ou d'un groupe de travail sur le code de conduite.

N'oubliez pas que quelqu'un pourrait vouloir signaler une violation à propos d'une personne qui reçoit ces rapports. Dans ce cas, donnez-leur la possibilité de signaler les violations à quelqu'un d'autre. Par exemple, @ctb et @mr-c [expliquent sur leur projet](https://github.com/dib-lab/khmer/blob/master/CODE_OF_CONDUCT.rst), [khmer](https://github.com/dib-lab/khmer) :

> Les cas de comportement abusif, harcelant ou autrement inacceptable peuvent être signalés en envoyant un courriel à **khmer-project@idyll.org**, ce qui ne concerne que C. Titus Brown et Michael R. Crusoe. Pour signaler un problème concernant l'un ou l'autre d'entre eux, veuillez envoyer un courriel à **Judi Brown Clarke, Ph. D.** Directrice de la diversité au Centre BEACON pour l'étude de l'évolution en action, un centre NSF pour la science et la technologie.*

Pour l'inspiration, consultez le [manuel d'application](https://www.djangoproject.com/conduct/enforcement-manual/) de Django (bien que vous n'ayez pas besoin de quelque chose d'aussi complet, selon la taille de votre projet).

## Appliquer votre code de conduite

Parfois, malgré tous vos efforts, quelqu'un va faire quelque chose qui viole ce code. Il existe plusieurs façons d'aborder les comportements négatifs ou nuisibles quand ils surviennent.

### Recueillir des informations sur la situation

Traitez la voix de chaque membre de la communauté comme étant aussi importante que la vôtre. Si vous recevez un signalement de quelqu'un qui a enfreint le code de conduite, prenez-le au sérieux et faites une enquête, même si cela ne correspond pas à votre propre expérience avec cette personne. Cela indique à votre communauté que vous appréciez leur point de vue et faites confiance à leur jugement.

Le membre de la communauté en question peut être un récidiviste qui incite constamment les autres à se sentir mal à l'aise, ou il se peut qu'ils aient seulement dit ou fait quelque chose une fois. Les deux peuvent être des motifs d'action, selon le contexte.

Avant de répondre, donnez-vous le temps de comprendre ce qui s'est passé. Lisez les commentaires et les conversations passés de la personne pour mieux comprendre qui ils sont et pourquoi ils ont agis de cette façon. Essayez de recueillir des points de vues autres que le vôtre au sujet de cette personne et de son comportement.

<aside markdown="1" class="pquote">
  Ne vous laissez pas entraîner dans une dispute. Ne vous laissez pas distraire par le comportement de quelqu'un d'autre avant d'avoir réglé le problème. Concentrez-vous sur ce dont vous avez besoin.
  <p markdown="1" class="pquote-credit">
— Stephanie Zvan, ["So You've Got Yourself a Policy. Now What?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### Prendre les mesures appropriées

Après avoir recueilli et traité suffisamment d'informations, vous devrez décider quoi faire. Lorsque vous considérez vos prochaines étapes, n'oubliez pas que votre objectif en tant que modérateur est de favoriser un environnement sûr, respectueux et collaboratif. Ne considérez pas seulement comment faire face à la situation en question, mais comment votre réponse affectera le reste du comportement et les attentes de votre communauté à aller de l'avant.

Quand quelqu'un signale une violation du code de conduite, c'est votre travail, et non le leur, que de le gérer. Parfois, le déclarant divulgue des informations mettant en péril sa carrière, sa réputation ou sa sécurité physique. Les forcer à affronter son harceleur pourrait mettre le déclarant dans une position compromettante. Vous devez gérer la communication directe avec la personne en question, à moins que le déclarant ne demande explicitement le contraire.

Il existe plusieurs façons de répondre à une violation du code de conduite:

* **Donnez à la personne en question un avertissement public** et expliquez comment son comportement a eu un impact négatif sur les autres, de préférence dans le canal où il s'est produit. Dans la mesure du possible, la communication publique indique au reste de la communauté que vous prenez le code de conduite au sérieux. Soyez gentil, mais ferme dans votre communication.

* **Communiquer en privé avec la personne** en question pour lui expliquer comment son comportement a eu un impact négatif sur les autres. Vous pouvez utiliser un canal de communication privé si la situation implique des informations personnelles sensibles. Si vous communiquez avec quelqu'un en privé, c'est une bonne idée de metre en copie ceux qui ont d'abord signalé la situation, alors ils savent que vous avez pris des mesures. Dans ce cas, demandez le consentement du déclarant avant.

Parfois, une résolution ne peut pas être atteinte. La personne en question peut devenir agressive ou hostile lorsqu'elle est confrontée ou ne change pas son comportement. Dans cette situation, vous pouvez envisager de prendre des mesures plus énergiques. Par exemple:

* **Suspendre la personne** en question du projet, imposée par une interdiction temporaire de participer à tout aspect du projet

* **Interdire définitivement** la personne du projet

Interdire les membres ne devrait pas être pris à la légère et représente une différence de perspective permanente et irréconciliable. Vous ne devriez prendre ces mesures que lorsqu'il est clair qu'une résolution ne peut pas être atteinte.

## Vos responsabilités en tant que mainteneur

Un code de conduite n'est pas une loi imposée arbitrairement. Vous êtes l'exécutant du code de conduite et il est de votre responsabilité de suivre les règles établies par le code de conduite.

En tant que responsable, vous établissez les lignes directrices pour votre communauté et appliquez ces directives conformément aux règles énoncées dans votre code de conduite. Cela signifie prendre au sérieux tout rapport d'une violation du code de conduite. Les déclarants ont a droit a un examen approfondi et équitable de leur plaintes. Si vous déterminez que le comportement signalé n'est pas une violation, communiquez-le clairement et expliquez pourquoi vous n'allez pas agir. Ce qu'ils feront avec cela leur appartient: tolérer le comportement avec lequel ils ont un problème ou cesser de participer à la communauté.

Un rapport de comportement qui ne viole pas _théoriquement_ le code de conduite peut toujours indiquer qu'il y a un problème dans votre communauté, et vous devriez étudier ce problème potentiel et agir en conséquence. Cela peut inclure la révision de votre code de conduite pour clarifier un comportement acceptable et/ou parler à la personne dont le comportement a été signalé et lui signaler que bien qu'il n'ai pas enfreint le code de conduite, il est en train de contourner ce qui en est attendu et que certain participants en sont mal à l'aise.

En fin de compte, en tant que responsable, vous définissez et appliquez les normes pour un comportement acceptable. Vous avez la capacité de façonner les valeurs communautaires du projet, et les participants s'attendent à ce que vous appliquiez ces valeurs de manière juste et équitable.

## Encouragez le comportement que vous voulez voir dans le monde 🌎

Quand un projet semble hostile ou peu accueillant, même si ce n'est qu'une personne dont le comportement est toléré par les autres, vous risquez de perdre beaucoup plus de contributeurs, dont certains ne se rencontreront peut-être jamais. Il n'est pas toujours facile d'adopter ou d'appliquer un code de conduite, mais favoriser un environnement accueillant aidera votre communauté à grandir.
