---
lang: es
title: Encontrando Usuarios Para Tu Proyecto
description: Ayuda a tu proyecto de c&oacute;digo abierto a crecer poni&oacute;ndolo en manos de usuarios satisfechos.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Pasando la voz

No existe ninguna regla que diga que debes fomentar un proyecto de c&oacute;digo abierto cuando lo comienzas. Existen muchas razones satisfactorias para trabajar en c&oacute;digo abierto que no tienen nada relacionado con la popularidad. Si esperas que otros encuentren y usen tu proyecto de c&oacute;digo abierto, sin embargo, ¡es momento para decirles a todos acerca de tu arduo trabajo!

## Pensando tu mensaje

Antes de comenzar el verdadero trabajo de promover tu proyecto, deberías ser capaz de explicar qu&eacute; es lo que hace, y porqu&eacute; importa.

¿Qu&eacute; hace a tu proyecto diferente o interesante? ¿Porqu&eacute; lo creaste? Respondiendo estas preguntas para t&iacute; mismo har&aacute; más f&aacute;cil convencer a los dem&aacute;s.

Recuerda que las personas se involucran como usuarios, y eventualmente como contribuyentes, porque resuelve un problema para ellos. Mientras piensas sobre el mensaje para tu proyecto y su valor, trata de verlo a trav&eacute;s de los ojos de qu&eacute;_es_lo_que_ellos_querr&iacute;an.

Por ejemplo, @robb utiliza códigos de ejemplo para comunicar claramente porqué su proyecto, [Cartography](https://github.com/robb/Cartography), es útil:

![cartography readme](/assets/images/finding-users/cartography.jpg)

Para una vista más profunda sobre cómo comunicar tu mensaje, puedes ver el ejercicio en Mozilla ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) para el desarrollo de personas usuario.

## Ayuda a las personas a encontrar y seguir tu proyecto

<aside markdown="1" class="pquote">
 Idealmente solo necesitas una URL "home" que puedas promover e indicar a las personas en relaci&oacute;n a tu proyecto. No es necesario gastar en una plantilla de lujo o incluso un nombre de dominio, pero tu proyecto necesita un punto focal.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Ayuda a las personas a encontrar y recordar tu proyecto indicándoles un solo espacio de nombres.

**Consigue un gestor claro para promover tu trabajo.** Un usuario de Twitter, una URL de GitHub o un canal de IRC son maneras f&aacute;ciles de indicar a las personas sobre tu proyecto. Tambi&eacute;n le da a la creciente comunidad de tu proyecto un lugar donde reunirse.

Si todav&iacute;a  no deseas establecer estos canales para tu proyecto, promociona en tu usuario personal de Twitter o tu cuenta personal de GitHub todo lo que hagas. Por ejemplo, aseg&uacute;rate que est&eacute; inclu&iacute;do en tu biograf&iacute;a o tus diapositivas si te toca disertar en una reuni&oacute;n o evento. De esa manera, las personas sabr&aacute;n c&oacute;mo llegar hasta ti o seguir tu trabajo.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
 Un error que comet&iacute; en los primeros días (...) fue no suscribir una cuenta de Twitter para el proyecto. Twitter es una gran manera de mantener a la gente al día sobre un proyecto, así como exponer constantemente a las personas al mismo.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Considera crear un sitio web para tu proyecto.** Un sitio web hace más amigable a tu proyecto y más fácil de navegar, especialmente cuando se acompaña de documentación clara y de tutoriales. También sugiere que tu proyecto está activo, lo que hará que su audiencia se sienta más confortable usándolo. Utiliza ejemplos para dar a las personas ideas de cómo usar tu proyecto.
[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), co-creador of Django, dijo que un sitio web fue _"por lejos lo mejor que hicimos con Django en los promeros días"_.

Si el proyecto está alojado en GitHub, puedes utilizar [GitHub Pages](https://pages.github.com/) para construir un sitio web facilmente.[Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), y [Middleman](https://middlemanapp.com/) son [algunos ejemplos](https://github.com/showcases/github-pages-examples) de excelentes y completos sitios web.

![vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

Ahora que ya tienes un mensaje para tu proyecto, y una manera sencilla para que las personas encuentren su proyecto, ¡ve a hablar con tu audiencia!

## Ve donde est&aacute; la audiencia de tu proyecto (en l&iacute;nea)

El alcance en l&iacute;nea es una gran manera de compartir y diseminar la palabra r&aacute;pidamente

Saca ventaja de las comunidades en l&iacute;nea existentes y sus plataformas para alcanzar tu audiencia. Si tu proyecto es de codigo abierto es un proyecto de software, probablemente puedas encontrar tu audiencia en [Stack Overflow](https://stackoverflow.com/), [reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/), o [Quora](https://www.quora.com/). Encuentra los canales donde pienses que las personas obtendrán los mayores beneficios o se sentir&aacute;n más entusiasmadas acerca de tu trabajo.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
Cada programa tiene funciones muy espec&iacute;ficas, que solamente una fracci&oacute;n de los usuarios encontra &uacute;til. No env&iacute;es masivamente correo a todas las personas posibles. En su lugar, enfoca tus esfuerzos en comunidades que se beneficiar&aacute;n de conocer sobre tu trabajo.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Ve si puedes encontrar formas de compartir tu proyecto en maneras relevantes:

* **Conoce proyectos de c&oacute;digo abierto relevantes y comunidades.** Algunas veces, no necesitas promocionar tu proyecto directamente. Si tu proyecto es de inter&eacute;s para cient&iacute;ficos de datos que utilizan Python, conoce a la comunidad de cient&iacute;ficos de datos de Python. A medida que las personas lo conozcan, llegarán oportunidades de conversar y de compartir tu trabajo de manera natural.
* **Encuentra personas que est&eacute;n experimentando problemas como el que resuelve tu proyecto.** Busca en foros relacionados con personas que caen en la audiencia de tu proyecto. Responde sus preguntas y encuentra una forma diplom&aacute;tica, cuando sea apropiado, de sugerir tu proyecto como una soluci&oacute;n.
* **Pide comentarios.** Pres&eacute;ntate y presenta tu trabajo a una audiencia que lo encuentre relevante e interesante. Se espec&iacute;fico acerca de qui&eacute;nes crees que se beneficiar&aacute;n de tu proyecto. Trata de finalizar la oración: _"Creo que mi proyecto realmente ayudar&aacute; a X, quien está tratando de hacer Y_". Escucha y responde los comentarios, en lugar de simplemente promover tu trabajo.

En t&eacute;rminos generales, enf&oacute;cate en ayudar a los demás antes de solicitar cosas a cambio. Ya que es sencillo para cualquiera promover un proyecto en l&iacute;nea. habr&aacute; mucho ruido. Da a las personas el contexto de lo que eres, no solo de lo que quieres, para destacarte entre la multitud.

Si nadie presta atenci&oacute;n o responde a tu alcance inicial, ¡no te desanimes! La mayor&iacute;a de los lanzamientos de proyectos son un proceso iterativo que puede llevar meses o a&ntilde;os. Si no consigues una respuesta la primera vez, prueba con una t&aacute;ctica diferente, o busqua maneras de agregar valor al trabajo de los demás primero. Estas cosas llevan tiempo y dedicaci&oacute;n.

## Ve donde est&aacute; la audiencia de tu proyecto (fuera de l&iacute;nea)

![public speaking](/assets/images/finding-users/public_speaking.jpg)

Los eventos fuera de l&iacute;nea son una manera popular de promocionar nuevos proyectos. Es una gran manera de alcanzar una audiencia comprometida y de construir conexiones personales m&aacute;s profundas, especialmente si estás interesado en llegar a los desarrolladores.

Si no tienes [experiencia para hablar en p&uacute;blico](https://speaking.io/), comienza por encontrar una comunidad local de personas que est&eacute;n relacionados con el lenguaje o ecosistema de tu proyecto.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
Estaba muy nerviosa acerca de ir a Pycon. Estaba dando una charla, solo iba a conocer a un par de personas ah&iacute;, me iba por una semana entera. (...) No deber&iacute;a haberme preocupado, sin embargo. ¡Pycon fue fenomenalmente incre&iacute;ble! (...). ¡Todos eran incre&iacute;blemente amigables y extrovertidos, tanto que rara vez encontraba tiempo para no hablar con la gente!
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Si nunca hablaste en un evento anteriormente, es perfectamente normal sentirte nervioso. Recuerda que tu audiencia est&aacute; all&iacute; porque genuinamente quieren escuchar acerca de tu trabajo.

Mientras escribes tu charla, enf&oacute;cate en lo que el p&uacute;blico pueda encontrar interesante y valioso. Mant&eacute;n tu lenguaje amigable y accesible. Sonr&iacute;e, respira y divi&eacute;rtete.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
 Cuando comienzas a escribir tu charla, sin importar cu&aacute;l sea tu t&oacute;pico, puede ser de ayuda ver a tu charla como una historia que le cuentas a la gente.
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Cuando te sientas listo/a, considera dar una charla en una conferencia para promover tu proyecto. Las conferencias pueden ayudar a alcanzar a m&aacute;s personas, algunas veces de todo el mundo.

Busca conferencias que sean espec&iacute;ficas de tu lenguaje o ecosistema. Antes que enviar tu charla, investiga la conferencia de antemano, para adaptar tu charla a sus asistentes e incrementar tus oportunidades de ser aceptado. A menudo puedes tener una idea de la audiencia de una conferencia mirando a sus disertantes.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  Escribí muy amablemente a la gente de JSConf y les supliqué que me dieran un espacio donde pudiera presentarme en la JSConf EU. (...) Estaba extremadamente asustada, presentando esta cosa en la que había estado trabajando por seis meses. (...) Todo el tiempo estaba pensando ¡Oh Di&oacute;s m&iacute;o! ¿Qu&eacute; estoy haciendo aqu&iacute;?
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Construye una reputaci&oacute;n

Además de las estrategias mencionadas anteriormente, la mejor forma de invitar a las personas a compartir y contribuir con tu proyecto es compartir y contribuir con sus proyectos.

Ayudar a los reci&eacute;n llegados, compartir recursos y hacer contribuciones meditadas al trabajo de los dem&aacute;s ayudará a que construyas una reputaci&oacute;n positiva. Entonces, la gente tendr&aacute; contexto para su trabajo y ser&aacute; más probable que preste atenci&oacute;n y comparta lo que tu est&aacute;s haciendo.

Algunas veces, esas relaciones pueden llevar incluso a asociaciones oficiales con el ecosistema m&aacute;s amplio.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  La &uacute;nica raz&oacute;n por la que urllib3 es la librer&iacute;a de Python de terceros m&aacute;s popular es porque es parte de las solicitudes.
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Nunca es demasiado temprano, o muy tarde, para comenzar a construir tu reputaci&oacute;n. Incluso si ya lanzaste tu propio proyecto, continúa buscando las formas de ayudar a los demás.

No hay una soluci&oacute;n para construir una audiencia en una noche. Ganarse la confianza y el respeto de los dem&aacute;s lleva tiempo, y el trabajo de construir la reputaci&oacute;n no termina nunca.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ariya?s=180" class="pquote-avatar" alt="avatar">
  PhantomJS fue lanzado por primera vez a comienzos del 2011. (...)  Yo pas&eacute; la voz utilizando maneras convencionales: envi&eacute; posts en Tweeter sobre el mismo, escrib&iacute; posts en blogs sobre cosas que pod&iacute;an hacerse con &eacute;l, lo nombr&eacute; durante varias discuciones en encuentros. Cuando se hizo más conocido en el 2014, comenc&eacute; a hacer presentaciones sobre &eacute;l.
  <p markdown="1" class="pquote-credit">
— @ariya, ["Maintainer Stories"](https://github.com/open-source/stories/ariya)
  </p>
</aside>

## S&iacute;guelo!

Algunas veces, lleva mucho tiempo antes de que la gente note tu proyecto de c&oacute;digo abierto. ¡Está bien! Algunos de los proyectos más populares de hoy en día, tardaron años en alcanzar altos niveles de actividad. Enfócate en construir relaciones en lugar de una bala mágica. S&eacute; paciente, y continua compartiendo tu trabajo con aquellos que lo aprecian.
