---
lang: zh-hant
title: 開源衡量準則
description: 透過持續的追蹤專案，幫助你做出最佳決策，讓開源專案更成功。
class: metrics
order: 9
image: /assets/images/cards/metrics.png
related:
  - finding
  - best-practices
redirect_from: /zh-tw/metrics/
---

## 爲何要度量所有

數據，只有在充滿智慧的運用它，才能發揮出其應有的功效。作爲一名開源專案的維護者，可以利用數據來助自己一臂之力。

當獲取到很多的資訊之後，就可以做很多事，比如：

* 理解用戶對一個新功能是怎麼反應的
* 搞清楚新用戶是從哪裏來的
* 鑑別，並且決定是否支持一個跑偏的使用場景或者功能
* 量化你專案的流行程度
* 知道你的專案是怎樣被別人使用的
* 通過贊助商或者讚賞掙點小錢

舉個例子，[Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Analytics.md) 就利用Google數據分析，來幫助他們對工作進行了優先級的區分：

> Homebrew 是免費的，完全由志願者在業餘時間維護。所以，我們沒有資源去做詳細的Hemobrew用戶調查從而決定如何更好的設計未來的新功能以及對當前的工作分出優先級。匿名的聚合用戶數據分析讓我們基於用戶如何，何地，何時使用Homebrew來優先考慮某些補丁和功能。

流行程度並不能代表一切。每個人都是因爲不同的原因參與到開源專案中來，如果你做專案維護者的原因是展示你的工作成果，公開你的代碼，或者只是爲了好玩，那麼度量標準可能對你來說就不是那麼的重要。

如果你想對自己的專案有一個深層次的瞭解，那麼請繼續閱讀下文介紹的分析專案活躍度的方法。

## 發現專案

在有人能夠使用或者回饋你的專案之前，他們得知道是否有這樣的專案存在，問問你自己：_人們都在尋找這樣專案嗎？_

![traffic graph](/assets/images/metrics/repo_traffic_graphs_tooltip.png)

如果你的專案是託管在Github, 你可以[訪問](https://help.github.com/articles/about-repository-graphs/#traffic) 獲取諸如多少人訪問過你的專案，他們從哪裏得知的之類的資訊。在你的專案主頁，點擊"Graphs", 然後"Traffic"。在這個頁面，你可以看到:

* **總瀏覽量:** 專案被查看了多少次

* **總獨立訪問者:** 多少人查看了你專案

* **關聯網站:** 訪問者從哪裏來的。這個數據能幫助你搞清楚哪裏可以接觸到你的受衆和你爲推廣做出的努力是不是有效的。

* **受歡迎的內容:** 訪問者都查看了你專案的那些內容，按照頁面訪問量和獨立訪客數。

[GitHub stars](https://help.github.com/articles/about-stars/) 可以提供一個基本的衡量流行度的標準。然而GitHub 點贊數並不和下載量、使用量直接掛鉤，但是他可以告訴你有多少人在關注你的專案。

你也許想要[在特定的地方跟蹤可發現的內容](https://opensource.com/business/16/6/pirate-metrics): 舉個例子，Google PageRank，會跟蹤來自你專案網站的流量，或者跟蹤來自其他開源專案或者網站的流量。

## 使用專案

人們在這個廣袤而且瘋狂的我們稱之爲互聯網的地方，竟然找你了你的專案。理想情況下，當他們看到你的專案的時候，他們會情不自禁的做點什麼。第二個問題你要問自己的是：_人們在使用你的專案嗎？_

如果你使用一個包管理器，比如說npm或者RubyGems.org，來發佈你的專案，你就可以跟蹤到下載量。

每個包管理工具可能會對下載量有着大同小異的定義，而且下載量並不直接和安裝、使用有關，但是它提供了一個基本的比較標準。嘗試使用[Libraries.io](https://libraries.io/) 來跟蹤很多流行包管理工具的使用數據。

如果你的專案是託管在Github上，再一次切換到"Traffic" 頁面，你可以用[clone graph](https://github.com/blog/1873-clone-graphs)看看你的專案在一個給定的日期被克隆了多少次，按照獨立克隆者的總克隆數排序。

![clone graph](/assets/images/metrics/clone_graph.png)

如果使用專案的數量低於發現專案的數量的話，那麼就有兩個問題值得考慮。他們是：

* 你的專案沒有成功的轉化你的受衆，或者
* 你吸引了錯誤的受衆

舉個例子，如果你的專案佔據了Hacker News的頭版頭條，你可能會看到一個流量的高峰，但是與此同時，轉化率會比較低，因爲Hacker News上所有人都看見了你的專案。如果你的Ruby專案是在Ruby研討會上宣傳的，那麼，更有可能從目標受衆羣體中獲得較高的轉化率。

努力找出你的受衆是從哪裏來的，然後在你的專案主頁尋求他們的反饋，看看是上述兩種情況的哪一種。

一旦知道了都是有那些人在使用你的專案的話，接下來就是看看他們會做些什麼，他們是否基於源程式碼開始構建？爲專案增加新的特性？他們將專案用於科研？還是業務？

## 留下來

人們找到了你的專案，而且已經在使用了。那麼接下來你要問自己的問題就是：_人們有對這個專案做貢獻嗎?_

不管什麼時候考慮貢獻者這個問題都不能算早。沒有大眾的參與，你就可能會把自己置於一個尷尬的境地，那就是你的專案雖然很 _流行_（很多人用）但是並不被 _支持_（維護者沒有足夠的時間來滿足用戶的需求）。

保持專案的進展需要[貢獻者的流動](http://blog.abigailcabunoc.com/increasing-developer-engagement-at-mozilla-science-learning-advocacy#contributor-pathways_2)（意思是有進有出）因爲之前很活躍的貢獻者也可能會去幹別的事情。

可能會經常用的衡量社群的指標包括：

* **貢獻者的總數和每個貢獻者的提交次數：** 有多少貢獻者，哪些是活躍的，哪些是不活躍。github上，你可以在"Graphs" -> "Contributors"面板查看這些資訊。目前，這個圖標只計算了那些往倉庫默認分支推送的貢獻者。

![contributor graph](/assets/images/metrics/repo_contributors_specific_graph.png)

* **第一次，偶爾爲之的，和持續的貢獻者：** 幫助檢測是否有新的貢獻者，以及他們是不是會再來。（偶爾的貢獻者是那些提交的次數很少的人，當然啦，這個數目是多少取決於你，比如說五次。）如果沒有新的貢獻者，你的專案就會停滯不前。

* **打開的issue的數目和PR的數目：** 如果這些數目太高，就意味着你可能需要有人幫你給issue分類以及做代碼審查。

* **所有的打開過的issue和PR：** 一個issue被人提出說明你的專案對他來說比較重要。如果這個數目隨着時間在增長，這就意味着人們對你的專案感興趣。

* **不同種類的貢獻者：** 比如說，提交代碼，修復筆誤或者bug，或者在issue下面評論。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/arfon?s=180" class="pquote-avatar" alt="avatar">
開源遠遠不止程式碼，成功的開源專案包括程式碼、文件，以及它們在演進過程中的所有討論。
  <p markdown="1" class="pquote-credit">
— @arfon, ["開源的形態"](https://github.com/blog/2195-the-shape-of-open-source)
</p>
</aside>

## 維護者活躍度

最後，你還需要確定一件事，那就是維護者有足夠的能力和時間處理社群的貢獻。最後一個問題你要問自己的是：_我是不是有足夠的時間和精力來回應社群？_

沒有責任心的維護者絕對是開源專案的災難。想象一下就知道，假如一位貢獻者提交了代碼或其他貢獻，但從來沒有得到過維護者的回覆，他 100% 會感到灰心，並最終選擇離開。

[來自Mozilla的研究](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) 說： **維護者的回應是鼓勵更多貢獻者中非常重要的一環**。

考慮記錄一下你或者其他的專案維護者對一次貢獻（issue或者PR）回應的時間，回應並不需要花多少精力。哪怕只是說一句："謝謝你的貢獻，我下週會查看的。"

你也可以測量一在一個貢獻被處理的過程中狀態變化的時間。比如：

* 一個issue保持打開狀態的時間（也就代表一個問題保持沒有被解決狀態的時間）。
* 一個issue是否因爲一個PR得到解決。
* 陳舊的iuuse是否被關閉了（被解決的問題應該關閉）。
* 合併一個PR的時間。

## 使用 📊 學習關於人本身

理解一些細節能夠幫助你建設活躍的、成長的開源專案。哪怕是你無法追蹤每一個細節，通過使用上述的框架，將能夠讓你集中精力到該用力的地方，進而助專案成功！
