---
lang: zh-hans
title: 打造受欢迎的社区
description: 打造人们愿意使用、贡献、并主动宣传的人气社区。
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
redirect_from: /zh-cn/building-community/
---

## 让项目向成功方向迈进

现在的你，已经启动了属于自己的项目，而且正在传播它，更重要的是现在已经有人将之下载到本地进行观摩。这真是令人振奋！那么你现在要做的就是，怎么能够让这些有兴趣的人们坚持下去，持续跟进项目。

一个受欢迎的社区对于项目的未来至关重要，如果你的项目是刚刚开始收到他人的首次贡献，那么你需要给贡献者们一次愉悦的体验，以鼓励他们进一步的继续参与。

### 让大家感到受欢迎

可以通过被@MikeMcQuaid称之为[贡献者漏斗](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/)的方法思考项目的社区。

![contributor funnel](https://opensource.guide/assets/images/building-community/contributor_funnel_mikemcquaid.png)

当建立了自己的开源社区，你需要考虑如何让那些处在漏斗上方的人（潜在用户）转移到漏斗下方（活跃的维护者）。目标是减少贡献者们在每个阶段所遇到的摩擦。当人们能够轻易的取得成绩时，他们就会乐意去做更多事。

从你的文档开始：

* **让大家很容易上手。** [一份友好的 README](../starting-a-project/#撰写自述文件)以及清晰的代码示例将让大家很容易的上手。
* **清楚的解释如何做贡献**，使用[你的CONTRIBUTING file](../starting-a-project/#编写你的贡献指南)以及持续更新issues。

好的文档能够邀请他人参与你们项目的互动。最终，一些人会开一个issue或者pull request。将这些互动视为机会，将他们转移到漏斗的下方。

* **当一些人选择了你们的项目，请对他们表示感谢！** 一次糟糕的体验就可能失去一个用户。
* **及时回应。** 如果你们一个月都没有回答他们的问题，他们可能早已忘记了你们的项目。
* **对你以后接受的所有贡献者持开放态度。** 很多贡献者是从一份bug报告或者小的修复开始的。这里有[很多为项目做贡献的方式](../how-to-contribute/#贡献意味着什么)。让大家选择他们喜欢的方式。
* **如果你不赞成一个贡献，** 首先你需要对他们的想法表示感谢，同时 [解释为什么](../best-practices/#学会说不)它不适合项目，如果有必要的话你可以给出相关的文档链接。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  为开源做贡献对一些人来说很简单，但对另外一些人可能就不是这样了。有很多人因为没有做正确的事而害怕叫喊，或者只是不适合。（。。。）通过允许贡献者参与一些对技术要求比较低的工作（文档，web content markdown，etc），可以极大的减少你对这些情况的关注。
  <p markdown="1" class="pquote-credit">
— @mikeal, ["现代开源项目下如何增长贡献者"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

多数开源贡献者是"临时贡献者"，因为他们只是偶尔参与项目贡献。一位临时贡献者可能没有充足的时间全程跟踪你的项目，所以你的工作是能让他们很轻松地参与贡献。

鼓励其他的贡献者也是对项目的一种投资。当你们授权大量的粉丝做他们感兴趣的工作时，压力就会少很多。

### 记录一切

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  你是否参加过一个（技术）活动，你不认识在场的人，但是似乎每个人站在一个小组里像老朋友一样聊天？（。。。）现在想象下你想为一个开源项目做贡献，但是你不知道为什么或者这个是如何发生的。

  <p markdown="1" class="pquote-credit">
— @janl, ["让开源可持续发展"](https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

当你开始一个新项目，你会觉得保持工作的私有性是正常的。但是开源项目开始于你在公共平台记录自己的工作进程。

当你把事情记录下来，会有更多的人能够按照预定的方式参与到每一个过程中。你可能会得到意想不到的帮助。

书写东西不仅仅只是技术文档。任何时刻，你们有写一些东西或者私自讨论项目的冲动，请询问自己是否能将之公开。

保持项目透明的项目路线：你们期待什么类型的贡献者，如何审查贡献，或者你们为什么做某些决定。

如果你注意到有多个用户遇到过同样的问题，那么你应该将答案记录在 README 中。

对于经常遇到的问题，你们可以考虑发布你们的笔记或者相关的issue。在这种情况下得到的反馈常常会出乎意料。

记录一切也适用于你自身的工作。如果你正在进行大量的更新工作，请将其放入pull request并标记为正在进行（WIP）。这样，可以让其他人感觉参与过早期工作。

### 积极回应

一旦你[推广项目](https://github.com/liadbiz/opensource-contribute-guide-chinise/blob/master/github-open-source-guide-03.md)，人们将会给你们反馈。他们可能会问项目是如何工作的，或者参与项目初期需要你的帮助。

当有人列出一条issue，提交一个pull request，或者询问项目的有关问题时，你们应该尽量回答他们。当你们快速地做出回应时，人们将感觉到他们参与了对话，以及他们将会更热情地参与。

如果你无法及时审查请求，请尽早确认，这样会有助于提高参与度。这里是@tdreyno在[Middleman](https://github.com/middleman/middleman/pull/1466)上所回应的一个pull request：

![middleman pull request](/assets/images/building-community/middleman_pr.png)

[一份Mozilla研究发现](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) 如果贡献者在48小时内收到代码审查，他们会有很大的回头率，且极有可能会再次贡献。

与项目有关的话题也可能发生在互联网的其它地方，例如Stack Overflow，Twitter，或者Reddit。你可以在像这样的一些网站设置通知，这样当有人提及项目时，可以即时的收到提醒。

### 为你们的社区提供一个聚会的场所

有两个理由可以解释为什么要给社区提供一个聚会的场所。

第一个理由是为了贡献者。线下聚会可以帮助人们相互认识。因为有着共同兴趣的人会想要一个可以聊天的地方。同时当信息是公开的而且是适宜的时候，任何人可以阅读过去的档案以至于能够快速的追赶以及参与。

第二个理由是为了社区本身。如果社区没有提供一个公共的场所来谈论项目，他们可能会直接与你联系。刚开始时，回复私有来信可能对你来说很轻松。但是经过一段时间后，尤其是如果项目变得流行的时候，就会感到疲于应付。不要私下和人们谈论你们的项目，而是直接指明他们去指定的公共渠道。

公共交流和指明人们开一条issue一样简单，而不是直接发送电子邮件或者在博客上发表评论。你也可以为了方便人们谈论项目设置一个邮件列表，或者创建一个Twitter账号，Slack，IRC频道。或者尝试上述的所有方式。

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) 每隔一周抽出办公时间帮助社区成员：

> Kops每隔一周都会留出时间为社区提供帮助和指导。Kops维护者已经同意留出时间专门与新手一起工作，帮助PRs，以及讨论新特性。

公开交流需要特别注意的事项：1）有关安全方面的issues 2）敏感的行为准则。应该为大家提供一个私下报告这些issue的方式。若不想使用自己的个人邮箱，那么就创建一个公用的邮箱。

## 发展你们的社区

社区拥有强大的能量。这种能量可能是正面的也可能是负面的，这一切都取决于你如何驾驭它。随着项目社区的成长，要想办法让之成为建设性的力量，而不是具有破坏性的。

### 不纵容坏人

一些流行的项目将不可避免地会吸引到一些破坏它们的人。这些人可能会从一些没必要的争论开始，对一些细枝末节进行纠缠不清，甚或用语言伤及他人。

对于这类人，必须采取零容忍的政策。一旦犹豫不决，那么这些消极的人会给社区的其他人带来不愉快的感觉。那时就会出现劣币驱逐良币的现象。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">

  事实上是，拥有一个支持性社区才是项目成功的关键。如果没有来自我的同事，互联网上一些友好的陌生人，以及聊天渠道IRC的帮助，我不可能做好这些工作。（。。。）不要退而求其次。不要容忍混蛋。

  <p markdown="1" class="pquote-credit">
— @okdistribute, ["如何运营一个 FOSS 项目"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

关于项目琐碎方面的定期辩论会分散其他人（包括您）的注意力，使他们无法专注于重要任务。新人可能会看到这些对话而不想参加。

当发现社区中有消极的行为时，要即时、公然的指出来。特别说明的是，要用坚定的语气解释他们的行为为什么是不可接受的。如果这种问题继续发生，你有必要[要求他们离开](../code-of-conduct/#执行你们的行为守则)。你的[行为准则](../code-of-conduct/)是为这些情景准备的建设性指南。

### 知道贡献者在哪里

随着项目的成长，好的文档会变得愈加重要。临时贡献者或路人是不可能一下子就对项目非常熟悉，一份好的文档，能够很快找到他们需要的。

在 CONTRIBUTING 文件里，需要明确告诉新来的贡献者该如何开始。而且若是可能为了想要达到这个目的，还需要准备一个专门的部分。

![django new contributors page](/assets/images/building-community/django_new_contributors.png)

在issue列表中，缺陷的标签需要做到适合不同类型的贡献者：例如，[_"仅供入门者"_](https://kentcdodds.com/blog/first-timers-only), _"优质Bug首秀"_, 或者 _"文档"_. [这些标签](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14)能够帮助新人快速浏览issues以及开始。

最后，撰写让人赏心悦目的文档，进一步让人感到愉悦和舒服。

你不可能做到与项目中的绝大多数人产生互动，你们可能没有收到一些贡献，因为有些人感到害怕或者不知道该从何处开始，有时候即使是几个字也能阻止一些人沮丧地离开你们的项目。

例如，这里是[Rubinius](https://github.com/rubinius/rubinius/)如何开始[它的贡献指南](https://github.com/rubinius/rubinius/blob/master/.github/contributing.md)：

> 我们想感谢你们使用Rubinius。这个项目是一个充满爱的工作，我们希望所有用户查找bugs，取得性能上的提升，以及帮助完善文档。每一个贡献都是有意义的，所以感谢你们的参与。话虽如此，但我们还是要求你们遵守一些指南，这样我们就能够找到你们的issue。

### 共享项目所有权

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  社区的领导者们有着不一样的意见，而这也是所有健康社区能够成长的原因之所在！终究你会明白，粗暴鲁莽的做法不能得到大家的认同，谦虚低调的做法更容易让大家接受，才是王道。
  <p markdown="1" class="pquote-credit">
— @sagesharp, ["是什么成就一个好的社区？"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

当大家觉得自己就是项目的主人时，他们就会非常乐意为项目做贡献。但这并不意味着要去改变项目的愿景，又或者接受不想要的贡献。但是社区越信任他们，他们就会越忠实。

要尝试去尽快的找到让人们觉得社区就是自己的路径，这里有一些经验和大家分享：

* **不要亲自去修复简单（非关键）的缺陷。** 相反，将这些缺陷作为招募新贡献者的工具，或者指导想要参与贡献的人。开始时可能效果不是很理想，但经过一段时间你们会得到想要的结果。例如，@michaeljoseph要求一位贡献者提交一个pull request在一个[Cookiecutter](https://github.com/audreyr/cookiecutter) issue的下面，而不是自己修复它。

![cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **在项目中添加一个贡献者或者作者文件** 用于记录每一个参与贡献的人。

* 如果社区有了一定的规模，那么 **发送一封信或者发表一篇博客** 感谢贡献者们。Rust的[Rust周报](https://this-week-in-rust.org/)和Hoodie的[Shoutouts](http://hood.ie/blog/shoutouts-week-24.html)就是两个非常好的范例。

* **给每个贡献者提交的通道。**@felixge发现这样会使大家[越发乐意斟酌他们的补丁](https://felixge.de/2013/03/11/the-pull-request-hack.html)，以及他甚至发现，在他没有工作的一段时间，项目依然有新的维护者进来。

* 如果项目是托管在GitHub上，那么 **将项目从你们的个人账号转移到一个组织**，以及添加至少一个备份管理员。组织能让与其他人一起工作在同一个项目在变得更加容易。

事实上很多项目只有一个或者两个做大量工作的维护者。随着项目以及社区越来越大，就会有更多的人参与进来。

虽然并不是一直都有人在回答问题，但是你可以去增加一些信号，以让他人有能够接触的机会，越是尽早开始，越是能够获得帮助。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  你们最大的兴趣是招募喜欢你们项目以及能够做你们不能做的事的贡献者。你喜欢编码，但不喜欢回答issues？那么让社区中能做这件事的人去做。
  <p markdown="1" class="pquote-credit">
— @gr2m, ["打造受欢迎的社区"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## 解决冲突

在项目的早期，做决定是件蛮容易的事。几乎是想做什么就可以做什么。

随着项目的越加流行，会有更多的人对社区的决策开始感兴趣。即使社区没有大量的贡献者，如果项目拥有很多用户，就会发现大家的重点在决策上或者增加他们的issues。

在大多数情况下，如果你们培养了一个友好，颇受尊重的社区并公开记录你的过程，社区应该能够找到解决方案。但也有时候会遇到难以解决麻烦。

### 建立友好的氛围

当社区正在讨论一个很难的issue时，气氛会很激烈。人们可能会为此变得愤怒或者沮丧，甚至会遭到直接的人身攻击。

作为一名维护者的工作是不要让这种情况出现。即使这些你对话题有很强烈的观点，也要尽量站在一个主持者或者推动者的位置，而不是参与争吵以及推动自己的观点。如果有人不友好或者垄断话题，那么[立即采取行动](https://ocselected.github.io/open-source-guide/building-community/)，以保持有礼貌和丰富的讨论。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  作为一名维护者，尊重你们的贡献者非常重要。他们经常处理一些你们描述亲切的事情。

  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["保持和善，要么滚蛋"](https://www.kennethreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

一些人希望得到指导。撰写一个优势的示例。当然仍然可以表达失望、不高兴或者忧虑，但得心平气和。

保持你们的酷并不容易，但是展示领导力能促进社区健康的发展。互联网感谢你们。

### 将你们的README视为最高法则

README [不仅仅是一组指令](../starting-a-project/#撰写自述文件)。它也是一个谈论目标、产品愿景和路线的地方。
如果人们过分专注于讨论特定功能的优点，它可能有助于重新审视您的README，并谈论项目的更高的愿景。关注README也会使对话变得个人化，所以可以进行建设性的讨论。

### 专注过程，而不是结果

一些项目用投票的方式做重要决定。虽然看上去是明智的，投票强调的是得到一个"答案"，而不是倾听以及解决每个人的顾虑。

投票会变成政治，社区成员在做感兴趣的事或者表决一个明确的方法时会感到压力。不是每个人都参与了投票，可能在你们的社区中[保持沉默的人占了多数](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users)，或者用户不知道投票这件事正在发生。

有时候，投票是必要的手段。尽你们所能强调["寻求共识"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making)而不是共识本身。

在寻求共识的过程中，社区成员讨论主要问题，直到他们感到他们的意见已经得到充分的表达。当仅遗留下一些无关紧要的问题时，社区需要向前迈进。"寻求共识"不能确保社区能得到一个完美的答案。而是侧重聆听和讨论。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
Atom Issues不存在投票系统的部分原因是因为Atom团队在所有情况下都不会遵循投票系统。有时我们必须选择我们认为是对的事，即使它不流行。（。。。）我能通过社区的反馈知道我能够提供什么以及做什么样的工作。

  <p markdown="1" class="pquote-credit">
— @lee-dohm on [Atom 决策流程](https://discuss.atom.io/t/prioritize-issues-feature-requests-based-on-voting-system/27642/2)
  </p>
</aside>

即使不确定是否采用寻求共识的方式，作为维护者，让大家知道他们正在受到关注。让其他人知道，以及承诺解决他们的问题，这在很大程度上减少了敏感情况的发生。然后，就去坚决的执行。

**不要为了获得决议而急于做出决定。在做一个决议之前请确保每个人已经知道以及所有的信息以及公开。**

### 将对话的重点聚焦于行动

讨论很重要，但是富有成效和没有效果的对话是有很大区别的。

鼓励讨论，只要它正积极地朝着解决问题的方向进行着。如果对话已经无法再进行下去，只有很少的人在参与或者大家正在讨论无关紧要的问题，这时候就该结束对话了。

允许这些对话进行下去不仅对解决问题没有帮助，而且不利于社区的健康发展。它释放了这样一个信号，表示允许或甚至鼓励这种类型的对话，它可能阻止人们提高或者解决未来的问题。

当你们或者其他人每提出一个观点时，请自问："这如何使我们更接近一个决议？"

如果对话开始有解散的征兆，问团队："我们下一步该做什么?"才能重新对话。

如果一个对话没有清晰的方向，没有明确的措施可以采取，或者合适的措施已经被使用，那么关掉issue并解释为什么关掉它。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  指导一件事朝着正确的方向发展是一门艺术。它对阻止人们浪费时间或者要求他们发表有建设性的看法没有作用。（。。。）反而，你们必须为接下来的进展给出条件：给大家一个路线，跟随一个可以得到你们想要的结果的途径，这样就不像是些无用的口头行为。

  <p markdown="1" class="pquote-credit">
— @kfogel, [_打造开源软件_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### 挑战你们的智慧

上下文很重要。考虑谁参与讨论，以及他们如何代表社区的其他人。

社区中的每个人都为这个问题而烦恼，或者参与讨论了吗？或者只是一部分人感到困惑吗？不要仅关心活跃的声音，也请不要忘记考虑社区中保持沉默的人。

如果这个问题不代表社区的更广泛的需求，你们可能要承认只是少数人的担心。如果这是一个反复出现的issue，没有一个清晰的解决方案，那么指向他们以前讨论的话题。

### 找出社区中的决策者

通过一个态度端正和目标清晰的对话，很多困难都是可以解决的。即使在富有成效的对话中，对于如何进行的意见也可能存在差异。在这些情况下，确定一个人或一组人，可以作为决策者。

决策者可以是项目的主要维护者，或者是大家投票选出的一个小团体。理想情况下，在使用GOVERNANCE文件之前，其实已经确定了决策者和与之相关的事宜。

使用决策者应该是你们最后才能采取的手段。分离issues是一个你们社区成长和学习的机会。利用这些机会并精诚合作，尽量找出问题的解决方案。

## 社区是开源的❤️

健康，蓬勃的社区每周都会为开源付出大量辛勤的劳动。许多贡献者指出其他人在开源工作或不在开源工作的原因。通过学习如何建设性地利用这股力量，你们会帮助他人有一个难忘的开源体验。
