---
lang: tr
title: Açık Kaynak Çalışmalar İçin Ödeme Alma
description: Zamanınız veya projeniz için maddi destek alarak açık kaynak çabanızı sürdürün.
class: getting-paid
toc:
  why-some-people-seek-financial-support: Neden bazı insanlar finansal destek ister?
  funding-your-own-time: Kendi zamanınızı finanse etme
  finding-funding-for-your-project: Projeniz için finansman bulma
  building-a-case-for-financial-support: Finansal destek için bir süreç oluşturma
order: 7
image: /assets/images/cards/getting-paid.png
related:
- best-practices
- leadership
---

## Neden bazı insanlar finansal destek ister?

Açık kaynaklı çalışmaların çoğu gönüllüdür. Örneğin, birileri kullandıkları bir projede bir hatayla karşılaşabilir hızlı bir düzeltme yapabilirler veya boş zamanlarında açık kaynak kodlu bir proje ile uğraşmanın tadını çıkarabilirler.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
  Noel haftası boyunca beni meşgul edecek bir "hobi" programlama projesi arıyordum. (...) Evimde bir bilgisayarım vardı ve elimde başka bir şey yoktu. Son zamanlarda düşündüğüm yeni betik dili için yorumlayıcı yazmaya karar verdim. (...) Python'u çalışma başlığı olarak seçtim.
  <p markdown="1" class="pquote-credit">
- @gvanrossum, ["Python Programlama"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Bir kişinin açık kaynak çalışmaları için ödeme almak istememesinin birçok nedeni vardır.

* Boş zamanlarında açık kaynağa katkıda bulunmalarını sağlayan, **sevdikleri bir tam zamanlı işleri olabilir**.
* **Açık kaynaklı projeyi bir hobi olarak düşünmekten hoşlanıyor olabilirler**, işlerinde gösteremedikleri yaratıcılığı gösterebildikleri bir alan olarak da değerlendirebilir ve projeleri üzerinde çalışmak için mali olarak zorunluluk hissetmek istemeyebilirler.
* İtibar veya portföylerini oluşturmak, yeni bir beceri öğrenmek veya bir topluluğa daha yakın hissetmek gibi **açık kaynağa katkıda bulunarak başka faydalar elde** etmek istiyor olabilirler.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Mali bağışlar, bazıları için bir sorumluluk duygusu yaratır. (...) Yaşadığımız küresel bağlantılı, hızlı tempolu dünyada, "şimdi değil, tamamen farklı bir şeyler yapmak gibi hissediyorum" diyebilmemiz bizim için önemlidir.
  <p markdown="1" class="pquote-credit">
- @alloy, ["Neden Bağışları Kabul Etmiyoruz]](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Bazıları içinse, özellikle katkıların devamlı olduğu veya önemli bir zaman gerektirdiğinde, açık kaynağa katkıda bulunmak için ödeme almak, projenin gerektirdiği veya kişisel nedenlerden dolayı kabul edebilecekleri tek yoldur.

Popüler projeleri sürdürmek, ayda birkaç saat yerine haftada 10 veya 20 saat süren önemli bir sorumluluk gerektirebilir.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Herhangi bir açık kaynaklı proje sorumlusuna danışın, size bir projeyi yönetecek olan işin miktarının gerçekliğinden bahsedecekler. Müşterilerin var. Onlar için sorunları çözüyorsun. Yeni özellikler yaratıyorsunuz. Bu sizin zamanınızda gerçek bir paya sahip olur.
  <p markdown="1" class="pquote-credit">
- @ashedryden, ["Ödenmemiş Emeğin ve OSS Topluluğunun Etiği"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Ücretli işler aynı zamanda farklı yaşam alanlarından insanların anlamlı katkılar yapmalarını sağlar. Bazı insanlar şu anki mali durumları, borçları veya aileleri veya diğer sorumluluklarından açık kaynaklı projeler için ücretsiz zaman harcayamazlar. Bu, zamanını gönüllü olarak kullanamayan yetenekli insanların katkılarını asla dünyanın ile paylaşamamaları anlamına gelir. Bu, @ashedryden'in [açıkladığı](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community) gibi etik tartışmalara yola açar, çünkü yapılan çalışmalar, yaşamda zaten avantajları olanlara, gönüllü katkılarına dayanarak ek avantajlar sağlarken, gönüllü olarak katkısı olamayanlar için dezavantajlar oluşturur. Bu açık kaynak toplumdaki mevcut çeşitlilik eksikliğini pekiştiren bir durumdur.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
  OSS, teknoloji endüstrisine muazzam faydalar sağlar ve bu da diğer endüstrilere dolaylı faydalar anlamına gelir. (...) Ancak, buna odaklanabilecek tek kişi şanslı ve takıntılıysa, o zamanlar ortada büyük bir keşfedilmemiş potansiyel var.
  <p markdown="1" class="pquote-credit">
- @isaacs, ["Para ve Açık Kaynak"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Finansal destek arıyorsanız, dikkate alınması gereken iki yol vardır. Kendi zamanınızı katkıda bulunan kişi olarak fonlayabilir veya proje için organizasyonel fon bulabilirsiniz.

## Kendi zamanınızı fonlamak

Bugün, birçok insana yarı zamanlı veya tam zamanlı olarak açık kaynak üzerinde çalışmak için ödeme yapılır. Vaktiniz için ödeme almanın en yaygın yolu işvereninizle konuşmaktır.

Eğer işvereniniz projeyi gerçekten kullanıyorsa, işiniz daha kolay, ancak adımınızda yaratıcı olun. Belki işvereniniz projeyi kullanmaz, ancak Python'u kullanır ve popüler bir Python projesini sürdürmek yeni Python geliştiricilerini çekmeye yardımcı olur. Belki işvereninizin genel olarak geliştirici dostu görünmesini sağlar.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/hzoo?s=180" class="pquote-avatar" alt="avatar">
  Açık kaynak kodlu birçok kişi gibi ben de bir projeyi sürdürme yüküyle mücadele ediyordum. Açık kaynak yapmaya ilk başladığımda, üzerinde çalışmak için geç saatlere kadar ofiste kaldım ya da eve geldiğimde uğraştım. (...) Patronumla karşılaştığım sorunları tartışabildim ve Babel'i kendi kullanımımıza göre açık kaynak kodlu görevleri nasıl dahil edebileceğimize dair fikirler bulduk.
  <p markdown="1" class="pquote-credit">
- @hzoo, ["Geliştirici Hikayeleri"](https://github.com/open-source/stories/hzoo)
  </p>
</aside>

Üzerinde çalışmak istediğiniz bir açık kaynak projeniz yoksa, ancak mevcut iş çıktınızın açık kaynaklı olmasını tercih ederseniz, işvereninizin kendi iç yazılımlarının bir kısmının kaynağını açması için bir öneride bulunun.

Birçok şirket markalarını geliştirmek ve kaliteli yetenekler kazanmak için açık kaynaklı programlar geliştiriyor.

Örneğin @hueniverse, [Walmart'ın açık kaynak yatırımını](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html) haklılaştırmak için finansal sebeplerin olduğunu belirtti. Ve @jamesgpearce, Facebook'un açık kaynak programının işe alımda [bir fark](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) yarattığını keşfetti:

> Programlama kültürümüz ve kuruluşumuzun nasıl algılandığı ile yakından ilişkilidir. Çalışanlarımıza “Facebook'taki açık kaynaklı yazılım programının farkında mıydınız?” diye sorduk. Üçte ikisi "Evet" dedi. Yarısı, programın bizim için çalışma kararlarına olumlu katkıda bulunduğunu söyledi. Bunlar marjinal sayılar değildir ve umarım devam eden bir eğilimdir.

Şirketiniz bu rotadan geçerse, topluluk ve kurumsal faaliyet arasındaki sınırları net tutmak önemlidir. Sonuçta, açık kaynak, tüm dünyadaki insanlardan sağlanan katkılarla kendisini sürdürüyor ve bu, herhangi bir şirket veya konumdan daha büyüktür.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Açık kaynak üzerinde çalışmak için para kazanmak nadir ve harika bir fırsattır, ancak süreçte tutkunuzu bırakmak zorunda değilsiniz. Tutkunuz, şirketlerin size ödeme yapmak istediğinin sebebi olmalı.
  <p markdown="1" class="pquote-credit">
- @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Mevcut işvereninizi açık kaynak çalışmasına öncelik vermeye ikna edemiyorsanız, çalışan katkılarını açık kaynağa teşvik eden yeni bir işveren bulmayı düşünün. Açık kaynak kodlu çalışmalara açık bir şekilde kendini adadıklarını söyleyen şirketleri arayın. Örneğin:

* [Netflix](https://netflix.github.io/) veya [PayPal](https://paypal.github.io/) gibi bazı şirketler, açık kaynaklara katılımını vurgulayan web sitelerine sahiptir.
* [Zalando](https://opensource.zalando.com) , çalışanlara yönelik [açık kaynak katkı politikasını](https://opensource.zalando.com/docs/using/contributing/) yayınladı

[Go](https://github.com/golang) veya [React](https://github.com/facebook/react) gibi büyük bir şirketten gelen projeler, muhtemelen açık kaynak üzerinde çalışmak için insanları istihdam edecek.

Kişisel durumunuza bağlı olarak, açık kaynaklı işinize para yatırmak için bağımsız olarak para toplamayı deneyebilirsiniz. Örneğin:

* @gaearon, [Redux](https://github.com/reactjs/redux) ile ilgili çalışmalarını bir [Patreon kitlesel fonlama kampanyası](https://redux.js.org/) yoluyla finanse etti
* @andrewgodwin [, bir Kickstarter kampanyasıyla](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django) Django şema göçleri konusundaki çalışmaları finanse etti

Son olarak, bazen açık kaynaklı projeler, yardım etmeyi düşündüğünüz meselelere güçlükler getirir.

* @ConnorChristie, @MARKETProtocol'un javascript paketlerinde [yardımcı olarak](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) gitcoin'deki bir [ödülle{/a2} para kazanabildi.](https://gitcoin.co/)
* @mamiM, [sorun Bounties Network'te finanse](https://explorer.bounties.network/bounty/134) edildikten sonra @MetaMask için Japonca çeviriler yaptı.

## Projeniz için finansman bulma

Bireysel katılımcılar için yapılan düzenlemelerin ötesinde, bazen projeler devam eden çalışmaları finanse etmek için şirketler, bireyler veya başkalarından para toplarlar.

Örgütsel finansman, projenin yürütülmesi (barındırma ücreti gibi) maliyetlerini kapsayan veya yeni özelliklere veya fikirlere yatırım yapma gibi mevcut katkı paylarını ödemeye yönelebilir.

Açık kaynağın popülaritesi arttıkça, projelere fon bulmak için hala deneysel olmakla birlikte, birkaç seçenek vardır.

### Topluluk fonlama kampanyaları veya sponsorluklarıyla işiniz için para toplayın

Sponsorluk bulmak, zaten güçlü bir kitleye veya şöhrete sahipseniz veya projeniz çok popülerse işe yarar. Sponsorlu projelere birkaç örnek:

* **[webpack](https://github.com/webpack)** [OpenCollective](https://opencollective.com/webpack) üzerinden şirketler ve bireylerden para topladı
* **[Vue](https://github.com/vuejs/vue)** [Patreon](https://github.com/open-source/stories/yyx990803) üzerinden finanse ediliyor
* **[Ruby Together](https://rubytogether.org/) ,** [paketleyici](https://github.com/bundler/bundler) , [RubyGems](https://github.com/rubygems/rubygems) ve diğer Ruby altyapı projelerinde işe yarayan kar amacı gütmeyen bir organizasyon

### Bir gelir akışı oluşturun

Projenize bağlı olarak, ticari destek, barındırılan seçenekler veya ek özellikler için ücret alabilirsiniz. Birkaç örnek şunları içerir:

* **[Sidekiq](https://github.com/mperham/sidekiq)** , ek destek için ücretli sürümler sunar
* **[Travis CI](https://github.com/travis-ci)** ürünlerinin ücretli sürümlerini sunuyor
* **[Ghost](https://github.com/TryGhost/Ghost)** ücretli bir yönetim servisi olan kar amacı gütmeyen bir kurumdur.

[Npm](https://github.com/npm/npm) ve [Docker](https://github.com/docker/docker) gibi bazı popüler projeler iş büyümelerini desteklemek için risk sermayesini desteği arıyorlar.

### Hibe fonu için başvur

Bazı yazılım kurumları ve şirketleri açık kaynak kodlu çalışmalar için hibe sunar. Bazen, hibeler proje için tüzel kişilik oluşturmadan bireylere ödenebilir.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** projesi [Mozilla Açık Kaynak Desteği'nden](https://www.mozilla.org/en-US/grants/) hibe aldı
* **[OpenMRS](https://github.com/openmrs)** çalışması [Stripe's Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees) ile finanse edildi
* **[Libraries.io](https://github.com/librariesio)** projesi [Sloan Vakfı'ndan](https://sloan.org/programs/digital-technology) burs aldı.
* **[Python Yazılım Vakfı](https://www.python.org/psf/grants/)** Python ile ilgili işler için bağışlar sunuyor

Daha ayrıntılı seçenekleri ve vaka çalışmaları için, açık kaynak çalışmalarına finansman bulma için @nayafia [bir rehber yazdı](https://github.com/nayafia/lemonade-stand). Farklı finansman türleri farklı beceriler gerektirir, bu nedenle hangi seçeneğin sizin için en uygun olduğunu bulmak için güçlü yönlerinizi değerlendirin.

## Finansal destek için bir süreç oluşturma

Projeniz yeni bir fikir olsun ya da yıllardır sürüyor olsun, hedef kitlenizi belirlemek ve teşvik edici bir öneri oluşturmak için kafa yormalısınız.

Kendi zamanınız için ödeme almak veya bir projeye fon sağlamak için aşağıdaki soruları cevaplayabilmeniz gerekir.

### Etki

Bu proje neden faydalıdır? Kullanıcılarınız veya potansiyel kullanıcılar neden bu kadar hoşlanıyor? Beş yıl sonra nerede olacak?

### Çekiş

Projenizin metrikleri, tecrübeleri veya referansları olsun ve önemli olduğuna dair kanıt toplamaya çalışın. Şu anda projenizi kullanan şirketler veya kayda değer insanlar var mı? Olmazsa, tanınmış bir kişi bunu onayladı mı?

### Fon verene katkı

İşvereninize veya bir hibe veren vakıf olup olmadığına bakılmaksızın fon sağlayıcılara sıklıkla fırsatlar ile yaklaşılmalıdır. Projenizi neden başka bir fırsat üzerinde desteklemeliler? Kişisel olarak nasıl yararlanabilirler?

### Fon kullanımı

Önerilen fonla tam olarak ne yapacaksınız? Maaş ödemek yerine proje kilometre taşlarına veya sonuçlarına odaklanın.

### Fonları nasıl alacaksınız?

Fon verenin ödeme çevresinde herhangi bir şartı var mı? Örneğin, kar amacı gütmeyen veya kar amacı gütmeyen bir mali sponsora sahip olmanız gerekebilir. Veya belki de fonlar bir organizasyon yerine bireysel bir yükleniciye verilmelidir. Bu gereklilikler fon sağlayıcılar arasında farklılık gösterir, bu yüzden araştırmanızı önceden yaptığınızdan emin olun.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  Yıllardır, 20 milyondan fazla topluluğu olan web sitesi dostu ikonların lider kaynağı olduk ve Whitehouse.gov da dahil olmak üzere 70 milyondan fazla web sitesinde yer aldık. (...) Sürüm 4 üç yıl önceydi. Web teknolojisi o zamandan beri çok değişti ve açıkçası, Font Awesome'in biraz eskimiş olduğu açık. (...) Bu yüzden Font Awesome 5'i tanıtıyoruz. CSS'yi modernize edip yeniden yazıyoruz ve her simgeyi baştan aşağı yeniden tasarlıyoruz. Daha iyi tasarım, daha iyi tutarlılık ve daha iyi okunabilirlikten bahsediyoruz.
  <p markdown="1" class="pquote-credit">
- @davegandy, [Font Awesome Kickstarter videosu](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Denemeyin ve pes etmeyin

Açık kaynak kodlu bir proje, kar amacı gütmeyen veya bir yazılım başlangıcı olsanız da, para kazanmak kolay değildir ve çoğu durumda yaratıcı olmanızı gerektirir. Nasıl ödeme almak istediğinizi belirlemek, araştırmanızı yapmak ve kendinizi fon sağlayıcınızın yerine koymak, finansman için ikna edici bir durum oluşturmanıza yardımcı olacaktır.
