---
lang: ta
title: திறந்த மூல சட்டப் பிரிவு
description: திறந்த மூலத்தின் சட்ட பக்கத்தைப் பற்றி நீங்கள் எப்போதாவது யோசித்ததுண்டா, மற்றும் நீங்கள் யோசிக்காத சில விடயங்கள்.
class: legal
order: 10
image: /assets/images/cards/legal.png
related:
  - contribute
  - leadership
---

## திறந்த மூலத்தின் சட்ட உட்குறிப்புகளை புரிந்துகொள்வது

உலகம் முழுவதும் உங்கள் படைப்பு பணி பகிர்வது என்பது ஒரு அற்புதமான மற்றும் வெகுமதி உள்ள அனுபவமாக இருக்க முடியும். உங்களுக்குத் தெரியாத சட்ட விஷயங்களைக் குறித்து நீங்கள் கவலைப்பட வேண்டிய அவசியம் இருக்கும். Tஅதிர்ஷ்டவசமாக, நீங்கள் முதலில் இருந்து தொடங்க வேண்டும் என்றில்லை. உங்கள் சட்டப்பூர்வ தேவைகளை விளக்க நாங்கள் இருக்கிறோம். நீங்கள் தோண்டுவதற்கு முன், எங்கள் [மறுப்பை](/notices/) வாசிக்கவும்.)

## திறந்த மூலத்தின் சட்ட பக்கத்தைப் பற்றி மக்கள் ஏன் அதிகம் கவலைப்படுகிறார்கள்?

நீங்கள் கேட்டது மகிழ்ச்சி! நீங்கள் ஒரு படைப்பாற்றல் வேலை (எழுத்து, வரைகலை அல்லது குறியீடு போன்றவை) செய்யும்போது, அந்த வேலை இயல்பாகவே பிரத்யேக பதிப்புரிமையின் கீழ் உள்ளது. அதாவது, உங்கள் வேலையின் ஆசிரியராக, மற்றவர்களுடன் என்ன செய்யலாம் என்று ஒரு சொல் உள்ளது என்று சட்டம் கூறுகிறது.

பொதுவாக, வேறு எவரும் பயன்படுத்த முடியாது, நகலெடுக்கலாம், விநியோகிக்கவோ அல்லது மாற்றவோ உங்கள் வேலையை எடுத்துக்கொள்வதன் மூலம், வீழ்ச்சி, மறுசீரமைப்பு அல்லது வழக்கு அபாயங்கள் ஆகியவை இல்லாமல் இருக்கலாம்.

திறந்த மூலம் ஒரு அசாதாரண சூழ்நிலையாகும், ஏனென்றால் மற்றவர்கள் பயன்படுத்துவதை, மாற்ற, மற்றும் பகிர்வைப் பகிர்ந்து கொள்வார்கள் என ஆசிரியர் எதிர்பார்க்கிறார். ஆனால் இயல்பான சட்டப்பூர்வ தனிப்பட்ட பதிப்புரிமை உடையது என்பதால், இந்த அனுமதிகளை வெளிப்படையாகக் குறிப்பிடும் உரிமம் உங்களுக்குத் தேவை.

திறந்த மூல உரிமத்தை நீங்கள் பயன்படுத்தவில்லை என்றால், உங்கள் திட்டத்தில் பங்களிப்பவர்கள் எல்லோரும் தங்கள் வேலையின் ஒரு பிரத்தியேக பதிப்புரிமை வைத்திருப்பார்கள். இதன் பொருள் யாரும் தங்கள் பங்களிப்புகளை பயன்படுத்தவோ, நகலெடுக்கவோ, விநியோகிக்கவோ, மாற்றவோ முடியாது - மற்றும் "யாரும்" நீங்கள் உட்பட.

இறுதியாக, உங்களுடைய திட்டம் உங்களுக்குத் தெரியாத உரிமத் தேவைகளை சார்ந்திருக்கும். உங்கள் திட்டத்தின் சமூகம், அல்லது உங்கள் முதலாளியின் கொள்கைகள், உங்கள் திட்டத்தில் குறிப்பிட்ட திறந்த மூல உரிமங்களைப் பயன்படுத்த வேண்டியிருக்கும். கீழே உள்ள சூழ்நிலைகளை நாங்கள் பாதுகாக்கிறோம்.

## கிட்ஹப்பில் உள்ள பொது திட்டங்கள் திறந்த மூலமா?

கிட்ஹப்பில் நீங்கள் [புதிய திட்டம் ஒன்றை உருவாக்கும்](https://help.github.com/articles/creating-a-new-repository/) போது, **தனிப்பட்ட** அல்லது **பகிரங்கமான** களஞ்சியமாக உருவாக்க விருப்பத்தேர்வுகள் உள்ளன.

![களஞ்சியத்தை உருவாக்கவும்](/assets/images/legal/repo-create-name.png)

**உங்கள் கிட்ஹப் திட்டப்பணியை பொதுவில் வைப்பது என்பது உங்கள் திட்டத்திற்கு உரிமம் அளிப்பதை போல் அல்ல.** பொது திட்டங்கள் [கிட்ஹப் இன் சேவை விதிமுறைகளால்](https://help.github.com/en/github/site-policy/github-terms-of-service#3-ownership-of-content-right-to-post-and-license-grants) பாதுகாக்கப்படுகின்றது,இது உங்கள் திட்டத்தை மற்றவர்களுக்குக் காண்பிப்பதற்கு மற்றும் கவைய அனுமதிக்கிறது, ஆனால் உங்கள் வேலை அனுமதி இன்றி வருகிறது.

மற்றவர்கள் பயன்படுத்த விரும்பினால், விநியோகிக்கவும், மாற்றவும் அல்லது உங்கள் திட்டத்திற்கு பங்களிக்கவும் விரும்பினால், நீங்கள் திறந்த மூல உரிமத்தை சேர்க்க வேண்டும். எடுத்துக்காட்டுக்கு, உங்கள் கிட்ஹப் திட்டத்தின் எந்தவொரு பகுதியையும் அவர்கள் குறியீட்டில் சட்டபூர்வமாகப் பயன்படுத்த முடியாது, பொதுவில் இருந்தாலும், அவற்றை வெளிப்படையாக வழங்குவதற்கு உரிமை இல்லை.

## என் திட்டத்தை நான் பாதுகாக்க வேண்டும் என்பதற்காக டி.எல்;டி.ஆர் தாருங்கள்

உங்கள் அதிர்ஷ்டம், இன்று திறந்த மூல உரிமங்கள் தரநிலையானது மற்றும் பயன்படுத்த எளிதானது. ஏற்கனவே உள்ள உரிமத்தை நேரடியாக உங்கள் திட்டத்தில் நகலெடுக்கலாம்.

[MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/), மற்றும் [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) ஆகியவை மிகவும் பிரபலமான திறந்த மூல உரிமங்கள், இன்னும் தேர்வு செய்ய பிற விருப்பங்களும் உள்ளன. இந்த உரிமங்களின் முழு உரைகளையும், அவற்றை எவ்வாறு பயன்படுத்துவது என்பதையும் [choosealicense.com](https://choosealicense.com/) காணலாம்.

நீங்கள் கிட்ஹப்பில் ஒரு புதிய திட்டத்தை உருவாக்கும்போது, நீங்கள் [உரிமத்தைச் சேர்க்கும்படி கேட்கப்படும்](https://help.github.com/articles/open-source-licensing/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/benbalter?s=180" class="pquote-avatar" alt="avatar">
  ஒரு நிலையான உரிமமானது, சட்டப்பூர்வ பயிற்சி இல்லாதவர்களுக்கு, அவர்கள் மென்பொருள் மூலம் என்ன செய்ய முடியும், முடியாது என்பதைத் தெரிந்து கொள்ளவும் உதவுகிறது. முற்றிலும் தேவைப்பட்டால், தனிப்பயன், மாற்றம், அல்லது தரமற்ற விதிமுறைகளை தவிர்க்கவும், இது நிறுவன குறியீட்டின் கீழ்நிலை பயன்பாட்டிற்கு ஒரு தடையாக செயல்படும்.
  <p markdown="1" class="pquote-credit">
— @benbalter, ["திறந்த மூல மென்பொருள் உரிமம் பற்றி ஒரு அரசாங்க வழக்கறிஞர் அறிந்திருக்க வேண்டியவை"](https://ben.balter.com/2014/10/08/open-source-licensing-for-government-attorneys/)
  </p>
</aside>

## எனது திட்டத்திற்கு எந்த திறந்த மூல உரிமம் பொருத்தமானது?

நீங்கள் ஒரு வெற்று கற்பலகையில் தொடங்கி இருந்தால், [MIT உரிமத்துடன்](https://choosealicense.com/licenses/mit/) செல்வதில் தவறிருக்காது. இது சிறியது, புரிந்து கொள்ள மிகவும் எளிது, உங்கள் காப்புரிமை அறிவிப்பு உள்ளிட்ட உரிமத்தின் நகல் ஒன்றை வைத்திருக்கும் வரை யாரும் எதையாவது செய்ய அனுமதிக்கிறார்கள். Yஉங்களுக்கு எப்போது வேண்டுமானாலும் நீங்கள் வேறு உரிமத்தின் கீழ் இந்த திட்டத்தை வெளியிட முடியும்.

இல்லையெனில், உங்கள் திட்டத்திற்கான சரியான திறந்த மூல உரிமத்தை தேர்ந்தெடுப்பது உங்கள் நோக்கங்களைப் பொறுத்தது.

Yஉங்கள் திட்டம் **சார்புகள்** கொண்டிருக்க (அல்லது கொள்ள) மிகவும் சாத்தியம் உள்ளது. உதாரணமாக, நீங்கள் ஒரு Node.js திட்டத்தை திறந்தால், ஒருவேளை நீங்கள் Node தொகுப்பு மேலாளர் (npm) இலிருந்து நூலகங்களைப் பயன்படுத்துவீர்கள். நீங்கள் சார்ந்துள்ள அந்த நூலகங்களில் ஒவ்வொன்றும் அதன் சொந்த திறந்த மூல உரிமம் பெற்றிருக்கும். அவற்றின் உரிமங்களில் ஒவ்வொன்றும் "அனுமதி" (கீழ்நிலை உரிமத்திற்கான எந்தவொரு நிபந்தனையும் இல்லாமல், பயன்படுத்த, மாற்ற, மற்றும் பகிர்வதற்கு பொது அனுமதி அளிக்கிறது), நீங்கள் விரும்பும் உரிமத்தை நீங்கள் பயன்படுத்தலாம். MIT, Apache 2.0, ISC, மற்றும் BSD.q ஆகியவை பொதுவான அனுமதிப்பத்திர உரிமங்களாகும்.

மறுபுறம், உங்கள் சார்பற்ற உரிமங்களில் ஏதேனும் "வலுவான நகல்" (அதே பொது உரிமத்தை கீழ்க்கண்ட உரிமத்தைப் பயன்படுத்தி நிபந்தனைக்கு உட்படுத்தலாம்), உங்கள் திட்டம் அதே உரிமத்தைப் பயன்படுத்த வேண்டும். GPLv2, GPLv3, மற்றும் AGPLv3 ஆகியவை பொது வலுவான அளிப்புரிமை உரிமங்களாகும்.

மேலும் நீங்கள் உங்கள் திட்டத்தினைப் பயன்படுத்தம் மற்றும் பங்களிக்கும் **சமூகங்களை** கருத்தில் கொள்ள வேண்டும்.

* **மற்ற திட்டங்களின் சார்பாக உங்கள் திட்டம் பயன்படுத்தப்பட வேண்டுமா?** உங்கள் தொடர்புடைய சமூகத்தில் மிகவும் பிரபலமான உரிமையைப் பயன்படுத்த சிறந்தது. உதாரணமாக, [எம்ஐடி] (https://choosealicense.com/licenses/mit/) என்பது [npm நூலகங்களுக்கு](https://libraries.io/npm) மிகவும் பிரபலமான உரிமம்.
* **உங்கள் திட்டம் பெரிய வணிகங்களுக்கு மேல் முறையிட வேண்டுமா?** ஒரு பெரிய வணிக வாய்ப்பு அனைத்து பங்களிப்பாளர்கள் ஒரு வெளிப்படையான காப்புரிமை உரிமம் வேண்டும். இந்த வழக்கில், [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/) உங்களை (மற்றும் அவற்றை) பாதுகாக்கும்.
* **மூடப்பட்ட மூல மென்பொருள் தங்கள் பங்களிப்புகளை பயன்படுத்த விரும்பாத பங்களிப்பாளர்களுக்கு உங்கள் திட்டம் மேல்முறையீடு செய்ய விரும்புகிறீர்களா?** [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) or (அவர்கள் மூடிய மூல சேவைகள் பங்களிக்க விரும்பவில்லை என்றால்) [AGPLv3](https://choosealicense.com/licenses/agpl-3.0/) நன்றாக இருக்கும்.

உங்கள் **நிறுவனம்** அதன் திறந்த மூல திட்டங்களுக்கான குறிப்பிட்ட உரிமத் தேவைகளைக் கொண்டிருக்கலாம். உதாரணமாக, நிறுவனத்தின் மூடப்பட்ட மூல தயாரிப்புகளில் உங்கள் திட்டத்தை நிறுவனம் பயன்படுத்த முடியும் என்பதற்கு ஒரு அனுமதிக்கப்பட்ட உரிமம் தேவைப்படலாம். அல்லது உங்களுடைய நிறுவனம் ஒரு வலுவான கோப்பாய் உரிமம் மற்றும் கூடுதலான பங்களிப்பு ஒப்பந்தம் (கீழே பார்க்கவும்) தேவைப்படலாம், அதனால் உங்கள் நிறுவனம் மட்டுமே மூல மென்பொருள் உங்கள் திட்டத்தை மட்டுமே பயன்படுத்த முடியும், வேறு யாரும் பயன்படுத்த முடியாது. அல்லது உங்களுடைய நிறுவனம் தரநிலைகள், சமூக பொறுப்புக்கள் அல்லது வெளிப்படைத்தன்மை தொடர்பான சில தேவைகளைக் கொண்டிருக்கலாம், அதில் எந்தவொரு குறிப்பிட்ட உரிம மூலோபாயம் தேவைப்படும். உங்கள் [நிறுவனத்தின் சட்ட துறையிடம்](#எனது-நிறுவனத்தின்-சட்ட-குழு-என்ன-அறிந்து-கொள்ள-வேண்டும்) பேசுங்கள்.

நீங்கள் கிட்ஹப்பில் புதிய திட்டத்தை உருவாக்கும்போது, உரிமம் ஒன்றைத் தேர்ந்தெடுக்க உங்களுக்கு விருப்பத்தேர்வு உள்ளது. மேலே குறிப்பிட்ட உரிமங்களில் ஒன்று உங்கள் கிட்ஹப் திட்டத்தின் திறந்த மூலத்தை உருவாக்கும். பிற விருப்பங்களை நீங்கள் காண விரும்பினால், உங்கள் திட்டத்திற்கு சரியான உரிமம் கண்டுபிடிக்க [choosealicense.com](https://choosealicense.com), அது [மென்பொருள் இல்லையென்றாலும்](https://choosealicense.com/non-software/).

## எனது திட்டத்தின் உரிமத்தை மாற்ற விரும்பினால் என்ன செய்வது?

பெரும்பாலான திட்டங்கள் உரிமங்களை மாற்ற வேண்டியதில்லை. ஆனால் எப்போதாவது சூழ்நிலைகள் மாறுகின்றன.

உதாரணமாக, உங்கள் திட்டம் வளர்ந்தால், சார்புகள் அல்லது பயனர்களை சேர்க்கிறது அல்லது உங்கள் நிறுவனத்தின் உத்திகளில் மாற்றங்கள், அவற்றில் ஏதேனும் வேறு உரிமம் தேவைப்படலாம் அல்லது விரும்பும். மேலும், உங்கள் திட்டத்தை தொடக்கத்திலிருந்து உரிமையாக்குவதற்கு நீங்கள் புறக்கணிக்கப்பட்டால், ஒரு உரிமத்தைச் சேர்ப்பது உரிமங்களை மாற்றுவது போலவே. உங்கள் திட்டத்தின் உரிமத்தை சேர்ப்பது அல்லது மாற்றியமைக்கும் போது மூன்று அடிப்படை விஷயங்கள் உள்ளன:

**இது சிக்கலானது.** உரிமம் பொருந்தக்கூடிய தன்மை மற்றும் இணக்கத்தைத் தீர்மானித்தல் மற்றும் பதிப்புரிமை வைத்திருப்பவர் சிக்கலையும் மற்றும் மிக விரைவாக குழப்பத்தை ஏற்படுத்தும். புதிய வெளியீடுகள் மற்றும் பங்களிப்புகளுக்கான புதிய ஆனால் இணக்கமான உரிமத்திற்கு மாறுதல் என்பது ஏற்கனவே உள்ள அனைத்து பங்களிப்புகளையும் மறுசீரமைப்பதில் இருந்து வேறுபட்டதாகும். உரிமங்களை மாற்ற விரும்பும் எந்தவொரு விருப்பத்திற்கும் உங்கள் சட்டக் குழுவை ஈடுபடுத்தவும். உங்களுடைய திட்டத்தின் காப்புரிமை வைத்திருப்பவர்களிடமிருந்து உரிமம் மாற்றத்திற்கான அனுமதி கிடைத்திருந்தாலும் அல்லது உங்கள் திட்டத்தின் மற்ற பயனர்கள் மற்றும் பங்களிப்பாளர்களின் மாற்றத்தின் தாக்கத்தை கருத்தில் கொள்ளுங்கள். உங்கள் திட்டத்தின் ஒரு "ஆளுமை நிகழ்வு" என உரிம மாற்றத்தை பற்றி யோசிக்கவும், இது உங்கள் திட்டத்தின் பங்குதாரர்களுடன் தெளிவான தகவல்தொடர்பு மற்றும் ஆலோசனைகளுடன் மென்மையாக செல்லலாம். உங்கள் திட்டத்திற்கான சரியான உரிமம் ஒன்றைத் தேர்வுசெய்து அதைப் பயன்படுத்துவதற்கான அனைத்து காரணங்களும் அதன் துவக்கத்திலிருந்து!

**உங்கள் திட்டத்தின் தற்போதைய உரிமம்.** உங்கள் திட்டத்தின் தற்போதைய உரிமம் நீங்கள் மாற்ற விரும்பும் அனுமதிப்பத்திரத்துடன் இணக்கமாக இருந்தால், புதிய உரிமத்தைப் பயன்படுத்த ஆரம்பிக்கலாம். ஏனெனில் உரிமம் A உரிமம் B உடன் இணக்கமாக இருந்தால், நீங்கள் B இன் விதிமுறைகளை கடைப்பிடிப்பதன் மூலம் (ஆனால் மறுதலையாக அல்லாமல்) இணங்குவீர்கள். எனவே, நீங்கள் தற்போது அனுமதிப்பத்திர அனுமதிப்பத்திரத்தை (எ.கா., MIT) பயன்படுத்துகிறீர்கள் என்றால், MIT உரிமத்தின் நகல் மற்றும் தொடர்புடைய பதிப்புரிமை அறிவிப்புகளை (அதாவது, MIT உரிமத்தின் குறைந்தபட்ச நிலைமைகளுக்கு இணங்குதல்). ஆனால் உங்கள் தற்போதைய உரிமம் அனுமதி இல்லை என்றால் (எ.கா., நகலெடுப்பு அல்லது உங்களுக்கு உரிமம் இல்லை) மற்றும் நீங்கள் ஒரே பதிப்புரிமை வைத்திருப்பவர் அல்ல, உங்கள் திட்டத்தின் உரிமத்தை MITஐ மாற்ற முடியாது. அடிப்படையில், அனுமதிப்பத்திர உரிமம், திட்டத்தின் பதிப்புரிமை வைத்திருப்பவர்கள் உரிமங்களை மாற்ற முன்கூட்டியே அனுமதியளித்தனர்.

**உங்கள் திட்டத்தின் தற்போதைய பதிப்புரிமை வைத்திருப்பவர்கள்.** நீங்கள் உங்கள் திட்டத்திற்கு ஒரே பங்களிப்பாளராக இருந்தால், நீங்கள் அல்லது உங்கள் நிறுவனம் திட்டத்தின் ஒரே பதிப்புரிமை வைத்திருப்பவர். நீங்கள் அல்லது உங்களுடைய நிறுவனம் விரும்பும் உரிமையை நீங்கள் சேர்க்கலாம் அல்லது மாற்றலாம். இல்லையெனில் உரிமங்களை மாற்றுவதற்கு உங்களிடம் உடன்பாடு தேவை என்று பிற பதிப்புரிமை வைத்திருப்பவர்கள் இருக்கலாம். அவர்கள் யார்? உங்கள் திட்டத்தில் ஈடுபடும் மக்கள் தொடங்க ஒரு நல்ல இடம். ஆனால் சில சந்தர்ப்பங்களில் அந்த நபர்களின் முதலாளிகளின் பதிப்புரிமை வைத்திருப்பர். சில சந்தர்ப்பங்களில் மக்கள் குறைந்த பட்ச பங்களிப்புகளை மட்டுமே செய்துள்ளனர், ஆனால் சில வரிகளின் கீழ் பதிப்புரிமைக்கு உட்பட்ட பங்களிப்பு இல்லை என்பதற்கு கடுமையான மற்றும் வேகமான விதி இல்லை. என்ன செய்ய? அது சார்ந்துள்ளது. ஒப்பீட்டளவில் சிறிய மற்றும் இளம் திட்டத்திற்காக, ஒரு சிக்கலில் உள்ள அனைத்து உரிமையாளர்களுக்கும் உரிமம் மாற்றத்தை ஏற்றுக்கொள்ள அல்லது இழு கோரிக்கையை ஏற்றுக்கொள்வது சாத்தியமானதாக இருக்கலாம். பெரிய மற்றும் நீண்ட கால திட்டங்களுக்கு, நீங்கள் பல பங்களிப்பாளர்கள் மற்றும் அவர்களது வாரிசுகளைத் தேட வேண்டும். பயர்பாக்ஸ், தண்டர்பேர்ட் மற்றும் அதனுடன் தொடர்புடைய மென்பொருட்களை மேம்படுத்த மொசில்லாவிற்கு ஆண்டுகள் (2001-2006) எடுத்தது.

மாற்றாக, உங்கள் தற்போதைய திறந்த மூல உரிமத்தால் அனுமதிக்கப்படும் சில நிபந்தனைகளின் கீழ், சில உரிமங்களில் சில உரிம மாற்றங்களுக்கு முன்கூட்டியே நீங்கள் பங்களிப்பாளர்கள் (கூடுதல் பங்களிப்பு ஒப்பந்தம் வழியாக - பார்க்கவும்) ஒப்புக் கொள்ள முடியும். இது சிறிதளவு உரிமங்களை மாற்றியமைக்கும் சிக்கலான மாற்றத்தை மாற்றுகிறது. உங்களுடைய வழக்கறிஞர்களின் உதவியுடன் உங்களுக்கு அதிக உதவி தேவைப்படலாம், மேலும் உங்கள் திட்டத்தின் உரிமையாளரின் உரிமையாளர் மாற்றத்தை நிறைவேற்றும்போது நீங்கள் தெளிவாகத் தெரிவிக்க வேண்டும்.

## எனது திட்டத்திற்கு கூடுதல் பங்களிப்பு ஒப்பந்தம் வேண்டுமா?

அநேகமாக இல்லை. பெரும்பாலான திறந்த மூல திட்டங்களுக்கு,திறந்த மூல உரிமம் உட்குறிப்பாக (பங்களிப்பாளர்களிடமிருந்து) மற்றும் வெளியில் (மற்ற பங்களிப்பாளர்களுக்கும் பயனர்களுக்கும்) உரிமம் வழங்கப்படுகிறது. உங்கள் திட்டம் கிட்ஹப்பில் இருந்தால், கிட்ஹப் சேவை விதிமுறைகள் "inbound=outbound" [வெளிப்படையான இயல்புநிலை](https://help.github.com/en/github/site-policy/github-terms-of-service#6-contributions-under-repository-license).

ஒரு கூடுதல் பங்களிப்பு ஒப்பந்தம் - பெரும்பாலும் ஒரு பங்களிப்பு உரிம ஒப்பந்தம் (CLA) - திட்டம் பராமரிப்பாளர்களுக்கு நிர்வாக வேலை உருவாக்க முடியும். திட்டம் மற்றும் செயல்படுத்தலில் ஒரு ஒப்பந்தம் எவ்வளவு வேலை செய்கிறது என்பதைப் பொறுத்தது. ஒரு எளிய உடன்படிக்கை பங்களிப்பாளர்கள், திட்டத்தின் திறந்த மூல உரிமத்தின் கீழ் பங்களிப்பு செய்வதற்கு அவசியமான உரிமைகள் இருப்பதாக ஒரு சொடுக்கு மூலம் உறுதிப்படுத்திக்கொள்ள வேண்டும். ஒரு சிக்கலான ஒப்பந்தம், பங்களிப்பாளர்களின் முதலாளிகளிடமிருந்து சட்டப்பூர்வ மதிப்பாய்வு மற்றும் கையொப்பமிட வேண்டும்.

மேலும், "காகித வேலைப்பாடு" சேர்ப்பதன் மூலம், சிலர் தேவையற்றவர்கள், புரிந்து கொள்ள முடியாதவர்கள், அல்லது நியாயமற்றவர்களாக இருக்கிறார்கள் (உடன்படிக்கை பெறுபவர் பங்களிப்பாளர்களைக் காட்டிலும் அதிகமான உரிமைகள் பெற்றால் அல்லது திட்டத்தின் திறந்த மூல உரிமத்தின் மூலம்), ஒரு கூடுதல் பங்களிப்பு ஒப்பந்தம் திட்டத்தின் சமூகத்திற்க பிரதிகூலமானது.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/bcantrill?s=180" class="pquote-avatar" alt="avatar">
    நாம் CLA ஐ Node.js க்கு அகற்றினோம். இதை செய்வதால், Node.js பங்களிப்பாளர்களுக்கு நுழைவுக்கான தடையை குறைக்கிறது, இதனால் பங்களிப்பு தளத்தை அதிகரிக்கிறது.
  <p markdown="1" class="pquote-credit">
— @bcantrill, ["Node.js பங்களிப்புகளை அதிகரிக்கிறது"](https://www.joyent.com/blog/broadening-node-js-contributions)
  </p>
</aside>

உங்கள் திட்டத்திற்கான கூடுதலான பங்களிப்பு ஒப்பந்தத்தை நீங்கள் பரிசீலிக்க விரும்பும் சில சூழ்நிலைகளில் பின்வருவன அடங்கும்:

* உங்கள் வழக்கறிஞர்கள் பங்களிப்பவர்கள் எல்லோரும் பங்களிப்பு விதிமுறைகளை வெளிப்படையாக ஏற்றுக்கொள்ள வேண்டும் (_கையொப்பமிடல்_, இயக்கலை அல்லது முடக்கலை) திறந்த மூல உரிமம் தானே போதுமானது அல்ல (இருப்பினும் கூட!). இது மட்டுமே கவலையாக இருந்தால், திட்டத்தின் திறந்த மூல உரிமத்தை உறுதிப்படுத்தும் பங்களிப்பு ஒப்பந்தம் போதுமானதாக இருக்க வேண்டும். [JQuery தனிநபர் பங்களிப்பாளர் உரிம ஒப்பந்தம்](https://contribute.jquery.org/CLA/) இலகுரக கூடுதல் பங்களிப்பு ஒப்பந்தத்தின் சிறந்த உதாரணம். சில திட்டங்கள், ஒரு [உருவாக்குபவர் துவக்க சான்றிதழ்](https://github.com/probot/dco) ஒரு மாற்று இருக்க முடியும்.
* உங்கள் திட்டம் ஒரு வெளிப்படையான ஆதார உரிமையைப் பயன்படுத்துகிறது, இது ஒரு வெளிப்படையான காப்புரிமை வழங்கலை (MIT போன்றவை) உள்ளடக்குவதில்லை, மேலும் அனைத்து பங்களிப்பாளர்களிடமிருந்தும் ஒரு காப்புரிமை வழங்கல் உங்களுக்கு தேவைப்படுகிறது, அவர்களில் சிலர் உங்களிடமுள்ள பெரிய காப்புரிமை பிரிவில் உள்ள நிறுவனங்களுக்கு வேலை செய்யலாம், உங்களை அல்லது திட்டத்தின் மற்ற பங்களிப்பாளர்கள் மற்றும் பயனர்கள் குறி வைக்கலாம். [அப்பாச்சி உரிமையாளர் உரிம ஒப்பந்தம்](https://www.apache.org/licenses/icla.pdf) பொதுவாகப் பயன்படுத்தப்படும் கூடுதலான பங்களிப்பு ஒப்பந்தம் ஆகும், இது அப்பாச்சி உரிமம் 2.0 இல் காணப்பட்ட ஒரு காப்புரிமை மானியத்தை பிரதிபலிக்கிறது.
* உங்கள் திட்டம் நகலெடுப்பு உரிமத்தின் கீழ் உள்ளது, ஆனால் நீங்கள் திட்டத்தின் தனியுரிம பதிப்புகளை விநியோகிக்க வேண்டும். உங்களிடம் பதிப்புரிமையை வழங்குவதற்கு அல்லது பங்களிப்பு உரிமத்தை உங்களுக்கு வழங்க (ஆனால் பொதுமக்கள் அல்ல) உங்களுக்கு ஒவ்வொரு பங்காளருக்கும் தேவைப்படும். [மாங்கோ பங்களிப்பாளர் ஒப்பந்தம்](https://www.mongodb.com/legal/contributor-agreement) என்பது இந்த வகை ஒப்பந்தத்தின் ஒரு எடுத்துக்காட்டு.
* உங்கள் திட்டம் அதன் வாழ்நாளில் உரிமங்களை மாற்ற வேண்டும் மற்றும் பங்களிப்பாளர்களுக்கு அத்தகைய மாற்றங்களுக்கு முன்கூட்டியே ஒப்புக் கொள்ள வேண்டும் என்று நீங்கள் நினைக்கிறீர்கள்.

உங்கள் திட்டத்தில் கூடுதலான பங்களிப்பு ஒப்பந்தத்தை நீங்கள் பயன்படுத்த வேண்டியிருந்தால், பங்களிப்பு திசைதிருப்பலை குறைக்க [CLA உதவியாளர்](https://github.com/cla-assistant/cla-assistant) போன்ற ஒரு ஒருங்கிணைப்பைப் பயன்படுத்துங்கள்.

## எனது நிறுவனத்தின் சட்ட குழு என்ன அறிந்து கொள்ள வேண்டும்?

ஒரு நிறுவனம் பணியாளராக ஒரு திறந்த மூல திட்டத்தை வெளியிடுகிறீர்கள் என்றால், முதலில், உங்கள் சட்ட குழு உங்களுக்கு ஒரு திட்டத்தை திறக்கிறது என்பதை அறிந்திருக்க வேண்டும்.

சிறந்த அல்லது மோசமான, அது ஒரு தனிப்பட்ட திட்டத்தை கூட அவர்களுக்கு தெரியப்படுத்துங்கள். உங்கள் நிறுவனத்துடன் ஒரு "பணியாளர் ஐபி உடன்படிக்கை" உங்களிடம் உள்ளது, அவை உங்கள் திட்டங்களை சில கட்டுப்பாட்டிற்குக் கொடுக்கின்றன, குறிப்பாக நிறுவனத்தின் வணிகத்துடன் தொடர்புடையதாக இருந்தால் அல்லது நீங்கள் திட்டத்தை உருவாக்க எந்த நிறுவன வளங்களையும் பயன்படுத்த வேண்டும். உங்கள் நிறுவனம் உங்களை அனுமதிக்க _வேண்டும்_, ஏற்கனவே ஒரு ஊழியர் நட்பு ஐபி ஒப்பந்தம் அல்லது ஒரு நிறுவன கொள்கை மூலம் ஏற்கனவே இருக்கலாம். இல்லையென்றால், நீங்கள் பேச்சுவார்த்தை நடத்தலாம் (உதாரணமாக, உங்களுடைய திட்டம் நிறுவனத்தின் தொழில்முறை கற்றல் மற்றும் வளர்ச்சி இலக்குகளை உங்களுக்கு உதவுகிறது) அல்லது நீங்கள் ஒரு சிறந்த நிறுவனத்தை கண்டுபிடிக்கும் வரை உங்கள் திட்டத்தில் பணிபுரிய வேண்டாம்.

**நீங்கள் உங்கள் நிறுவனத்திற்கு ஒரு திட்டத்தை திறந்தால்,** கண்டிப்பாக அவர்களுக்கு தெரியப்படுத்தவும். உங்கள் சட்ட குழு ஏற்கனவே உங்கள் உரிமையாளர்களின் அனுமதிப்பத்திரங்களுடன் இணங்குகையில் உங்கள் திட்டத்தை உறுதி செய்வதை உறுதிப்படுத்துவதன் மூலம் நிறுவனத்தின் வணிகத் தேவைகள் மற்றும் நிபுணத்துவத்தை அடிப்படையாகக் கொண்டிருக்கும் திறந்த மூல உரிமம் (ஒருவேளை கூடுதல் பங்களிப்பு ஒப்பந்தம்) ஆகியவற்றிற்கான கொள்கைகள் ஏற்கனவே உள்ளன. இல்லையென்றால், நீங்களும் அவர்கள் அதிர்ஷ்டமும் உள்ளவர்கள்! உங்களுடைய சட்ட குழு உங்களுடன் பணியாற்ற ஆர்வமாக இருக்க வேண்டும். சில விஷயங்களை பற்றி சிந்திக்க:

* **மூன்றாம் கட்சி பொருள்:** உங்கள் திட்டத்தை மற்றவர்கள் உருவாக்கிய நம்பகத்தன்மை கொண்டிருக்கிறார்களா அல்லது மற்றவர்களின் குறியீடு அடங்கும் அல்லது பயன்படுத்துகிறார்களா? இவை திறந்த மூலமாக இருந்தால், நீங்கள் பொருள்களின் திறந்த மூல உரிமங்களுக்கு இணங்க வேண்டும். இது மூன்றாம் தரப்பு திறந்த மூல உரிமங்களை (மேலே பார்க்கவும்) வேலை செய்யும் உரிமத்தைத் தேர்ந்தெடுப்பதில் தொடங்குகிறது. மூன்றாம் தரப்பு திறந்த மூல உள்ளடக்கத்தை மாற்றியமைக்கிறீர்கள் அல்லது விநியோகிக்கிறீர்கள் என்றால், உங்கள் சட்ட குழு நீங்கள் பதிப்புரிமை அறிவிப்புகளைத் தொடர்ந்து மூன்றாம் தரப்பு திறந்த மூல உரிமத்தின் ஏனைய நிலைமைகளை சந்திக்கிறீர்கள் என்பதை அறிய விரும்புகிறேன். உங்கள் திட்டம் திறந்த மூல உரிமம் இல்லாத மற்றவர்களின் குறியீட்டைப் பயன்படுத்தினால், மூன்றாம் தரப்பு பராமரிப்பாளர்களை [திறந்த மூல உரிமத்தை சேர்க்க](https://choosealicense.com/no-license/#for-users) ஒருவேளை நீங்கள் கேட்கலாம், மற்றும் நீங்கள் ஒன்றை பெற முடியாது என்றால், உங்கள் திட்டத்தில் தங்கள் குறியீடு பயன்படுத்தி நிறுத்துங்கள்.

* **வாணிப ரகசியம்:** நிறுவனம் பொது மக்களுக்கு கிடைக்க விரும்பாத திட்டத்தில் ஏதேனும் உள்ளதா என்று கருதுங்கள். அப்படியானால், உங்கள் திட்டத்தின் மீதத்தை நீங்கள் திறக்க முடியும், நீங்கள் தனிப்பட்ட முறையில் வைக்க விரும்பும் பொருள் பிரித்தெடுத்த பிறகு.

* **காப்புரிமை:** உங்களுடைய நிறுவனம் உங்கள் காப்புரிமையை திறந்தால், உங்கள் திட்டம் [பகிரங்கமான வெளியீடு](https://en.wikipedia.org/wiki/Public_disclosure) இருக்குமா? துரதிருஷ்டவசமாக, நீங்கள் காத்திருக்கக் கூடும் (அல்லது நிறுவனம் விண்ணப்பத்தின் ஞானத்தை மறுபரிசீலனை செய்யும்). பெரிய காப்புரிமை பிரிவில் உள்ள நிறுவனங்களின் பணியாளர்களிடமிருந்து உங்கள் திட்டப்பணியில் பங்களிப்புகளை எதிர்பார்க்கிறீர்கள் என்றால், பங்களிப்பாளர்களிடமிருந்து (Apache 2.0 அல்லது GPLv3 போன்றவை) பங்களிப்பாளர்களிடமிருந்து வெளிப்படையான காப்புரிமை மானியத்துடன், அல்லது கூடுதல் பங்களிப்பு ஒப்பந்தம் (அல்லது கூடுதல் பங்களிப்பு ஒப்பந்தம்) மேலே பார்க்க).

* **வர்த்தக முத்திரைகள்:** உங்கள் திட்டத்தின் பெயர் [ஏற்கனவே இருக்கும் வர்த்தக முத்திரைகளுடன் மோதல் இல்லை என சரி பாருங்கள்](../starting-a-project/#பெயர்-முரண்பாடுகளைத்-தவிர்த்தல்). நீங்கள் திட்டத்தில் உங்கள் சொந்த நிறுவன வர்த்தக சின்னங்களைப் பயன்படுத்தினால், அது எந்த மோதலையும் ஏற்படுத்தாது என்பதைச் சரிபார்க்கவும். [FOSSmarks](http://fossmarks.org/) இலவச மற்றும் திறந்த மூல திட்டங்களின் சூழலில் வணிக முத்திரைகளை புரிந்து கொள்ள நடைமுறை வழிகாட்டியாகும்.

* **தனியுரிமை:** பயனர்கள் குறித்த தரவுகளை உங்கள் திட்டம் சேகரிக்கிறதா? நிறுவனம் சேவையகங்களுக்கு "தொலைபேசி வீடு"? நிறுவன சட்டங்கள் மற்றும் புற ஒழுங்குமுறைகளுடன் இணங்குமாறு உங்கள் சட்ட குழு உங்களுக்கு உதவும்.

உங்கள் நிறுவனத்தின் முதல் திறந்த மூல திட்டத்தை வெளியிடுகிறீர்கள் என்றால், மேலே உள்ளதை விட அதிகமானதை விட அதிகமாக உள்ளது (ஆனால் கவலை வேண்டாம், பெரும்பாலான திட்டங்கள் எந்த முக்கிய கவலையும் எழுப்பக்கூடாது).

நீண்ட காலமாக, உங்கள் சட்ட குழு நிறுவனம், திறந்த மூலத்தில் அதன் ஈடுபாட்டிலிருந்து நிறுவனத்தின் உதவியை அதிகரிக்க உதவ முடியும், மேலும் பாதுகாப்பாக இருக்கவும்:

* **Eபணியாளர் பங்களிப்பு கொள்கைகள்:** உங்கள் பணியாளர்கள் மூல திட்டங்களை திறக்க எப்படி உதவுகிறது என்பதைக் குறிப்பிடும் ஒரு பெருநிறுவனக் கொள்கையை உருவாக்குங்கள். ஒரு தெளிவான கொள்கை உங்கள் ஊழியர்களிடையே குழப்பத்தை குறைக்கும் மற்றும் நிறுவனங்களின் சிறந்த வட்டி, அவர்களது வேலைகள் அல்லது தங்களின் இலவச நேரத்திலோ, மூல திட்டங்களை திறக்க உதவுகிறது. A good example is Rackspace's [Model IP and Open Source Contribution Policy](https://processmechanics.com/2015/07/22/a-model-ip-and-open-source-contribution-policy/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/vanl?s=180" class="pquote-avatar" alt="avatar">
  ஒரு இணைப்புடன் தொடர்புடைய ஐபி முகவரியை ஊழியர் அறிவுத் தளம் மற்றும் புகழ் உருவாக்குகிறது. அந்த நிறுவனம் அந்த ஊழியரின் வளர்ச்சியில் முதலீடு செய்யப்பட்டு, அதிகாரமளித்தல் மற்றும் சுயாட்சியை உருவாக்குவதற்கான உணர்வுகளை உருவாக்குகிறது என்பதை இது காட்டுகிறது. இந்த நன்மைகள் அனைத்தும் உயர்ந்த மன வலிமையயும், சிறந்த பணியாளருக்கும் தக்கவைக்கும்.
  <p markdown="1" class="pquote-credit">
— @vanl, ["மாதிரி ஐபி மற்றும் திறந்த மூல பங்களிப்பு கொள்கை"](https://processmechanics.com/2015/07/22/a-model-ip-and-open-source-contribution-policy/)
  </p>
</aside>

* **எதை வெளியிடுவது:** [(கிட்டத்தட்ட) எல்லாவற்றையும்?](http://tom.preston-werner.com/2011/11/22/open-source-everything.html) உங்கள் சட்ட குழு புரிந்துகொண்டு உங்கள் நிறுவனத்தின் திறந்த மூலோபாயத்தில் முதலீடு செய்திருந்தால், உங்கள் முயற்சிகளை தடுப்பதை காட்டிலும் உதவி செய்ய முடியும்.
* **இணக்கம்:** உங்கள் நிறுவனம் திறந்த மூல திட்டங்களை வெளியிடாவிட்டாலும், அது மற்றவரின் திறந்த மூல மென்பொருள் பயன்படுத்துகிறது. [விழிப்புணர்வு மற்றும் செயல்முறை](https://www.linuxfoundation.org/blog/2015/06/why-companies-that-use-open-source-need-a-compliance-program/) தலைவலி, தயாரிப்பு தாமதங்கள் மற்றும் வழக்குகள் ஆகியவற்றை தடுக்கலாம்.

<aside markdown="1" class="pquote">
  நிறுவனங்கள் ["இசைவு தருகிற" and "அளிப்புரிமை"] வகைகளை பொருந்தும் வகையில் உரிமம் மற்றும் இணக்கம் மூலோபாயம் இருக்க வேண்டும். நீங்கள் பயன்படுத்தும் திறந்த மூல மென்பொருளுக்கு பொருந்தும் உரிம விதிகளின் பதிவுகளை வைத்து இது தொடங்குகிறது - துணைக்குழுக்கள் மற்றும் சார்புகள் உட்பட.
  <p markdown="1" class="pquote-credit">
— ஹெதர் மீக்கர், ["திறந்த மூல மென்பொருள்: இணக்கம் அடிப்படைகள் மற்றும் சிறந்த நடைமுறைகள்"](https://techcrunch.com/2012/12/14/open-source-software-compliance-basics-and-best-practices/)
  </p>
</aside>

* **காப்புரிமை:** உங்கள் நிறுவனம் [திறந்த கண்டுபிடிப்பு கட்டமைப்பு](https://www.openinventionnetwork.com/), முக்கிய திறந்த மூல திட்டங்களை உறுப்பினர்கள் பயன்படுத்துவதைப் பாதுகாக்க ஒரு பகிரப்பட்ட தற்காப்பு காப்புப்பத்திரத்தில் சேர விரும்பலாம் அல்லது பிற [மாற்று காப்புரிமை உரிமங்களை](https://www.eff.org/document/hacking-patent-system-2016) ஆராயலாம்.
* **ஆட்சி முறை:** குறிப்பாக, ஒரு திட்டத்தை [நிறுவனத்திற்கு வெளியில் ஒரு சட்ட நிறுவனத்திடம்](../leadership-and-governance/#எனது-திட்டத்தை-ஆதரிக்க-எனக்கு-ஒரு-சட்ட-நிறுவனம்-தேவைதானா). கொண்டு செல்வது
