---
lang: ta
title: தலைமை மற்றும் ஆளுமை
description: வளர்ந்து வரும் திறந்த மூல திட்டங்கள் முடிவுகளை எடுக்க முறையான விதிகளால் நன்மை அடைய முடியும்.
class: leadership
order: 6
image: /assets/images/cards/leadership.png
related:
  - best-practices
  - metrics
---

## உங்கள் வளரும் திட்டத்திற்கான ஆளுமையை புரிந்துகொள்ளுதல்

உங்கள் திட்டம் வளர்ந்து வருகிறது, மக்கள் ஈடுபட்டுள்ளனர், நீங்கள் இந்த காரியத்தை வைத்துக் கொள்ள கடமைப்பட்டுள்ளீர்கள். Aஇந்த கட்டத்தில், உங்கள் பணிப்பகுதிக்கு வழக்கமான திட்ட பங்களிப்பாளர்களை எவ்வாறு இணைப்பது என்பது குறித்து நீங்கள் யோசித்து இருக்கலாம், யாரோ ஒருவருக்கு அணுகல் வழங்குவது அல்லது சமூக விவாதங்களை தீர்த்து வைப்பதாக இருக்கலாம். உங்களிடம் கேள்விகள் இருந்தால், எங்களிடம் பதில்கள் உள்ளன.

## திறந்த மூல திட்டங்களில் பயன்படுத்தப்படும் முறையான பாத்திரங்களுக்கு எடுத்துக்காட்டுகள் என்ன?

பல திட்டங்கள் பங்களிப்பவருக்கும் அங்கீகாரத்திற்கும் ஒத்த கட்டமைப்பைப் பின்பற்றுகின்றன.

உண்மையில் இந்த பாத்திரங்களுக்கு என்ன அர்த்தம் என்பது உங்களை சார்ந்தது. நீங்கள் அடையாளம் காணக்கூடிய சில வகை பாத்திரங்கள் இங்கே:

* **பராமரிப்பாளர்**
* **பங்களிப்பாளர்**
* **ஒப்புவிப்பவர்**

**சில திட்டங்களில், "பராமரிப்பாளர்கள்"** மட்டுமே ஒப்புவி அணுகல் உள்ள மக்கள். மற்ற திட்டங்களில், README இல் பராமரிப்பாளர்களாக பட்டியலிடப்பட்ட நபர்கள் தான்.

ஒரு பராமரிப்பாளர் உங்கள் திட்டத்திற்கான குறியீட்டை எழுதுபவராக இருக்க அவசியம் இல்லை. இவர் உங்கள் திட்டத்தை மேம்படுத்துவதற்காக நிறைய வேலைகளை செய்திருக்கலாம், அல்லது மற்றவர்களுக்கு திட்டத்தை அணுகக்கூடிய ஆவணமாக்கல் செய்திருக்கலாம். அவர்கள் தினமும் என்ன செய்தாலும், ஒரு பராமரிப்பாளர் திட்டத்தின் திசைக்கு பொறுப்பாளராக இருப்பார், அதை மேம்படுத்துவதற்கு கடமைப்பட்டுள்ளார்.

**ஒரு "பங்களிப்பாளர்" என்பவர்** ஒரு சிக்கல் அல்லது இழு கோரிக்கையைப் பற்றி கருத்துத் தெரிவிக்கும், திட்டத்திற்கு மதிப்பைச் சேர்க்கும் நபர்கள் (இது சிக்கல்களை உயர்த்துவது, குறியீடு எழுதுதல், அல்லது நிகழ்வுகளை ஒழுங்குபடுத்துதல்) அல்லது இணைக்கப்பட்ட இழு கோரிக்கையுடன் (ஒருவேளை மிகக் குறுகிய ஒரு பங்களிப்பாளரின் வரையறை).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  \[Node.js க்கு,\] ஒரு சிக்கலில் கருத்து தெரிவிக்க அல்லது குறியீட்டை சமர்ப்பிக்க ஒவ்வொரு நபர் ஒரு திட்டத்தின் சமூகத்தின் உறுப்பினராக உள்ளார். அவர்களால் பார்க்க முடிந்தால் அவர்கள் ஒரு பயனாளராக இருப்பதை தாண்டி பங்களிப்பவராக மாறிவிட்டார்கள் என்பதாகும்.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["ஆரோக்கியமான திறந்த மூலம்"](https://medium.com/the-javascript-collection/healthy-open-source-967fa8be7951)
  </p>
</aside>

**"ஒப்புவிப்பவர்" என்ற சொல்** மற்ற வகையான பங்களிப்புகளிலிருந்து பொறுப்பான ஒரு குறிப்பிட்ட வகையிலான பொறுப்பை ஒப்புக் கொள்ளுதல் ஆகியவற்றுக்கு பயன்படுத்தலாம்.

உங்கள் திட்டப்பணியை நீங்கள் விரும்பும் எந்த வழியையும் வரையறுக்க முடியும், மேலும் பங்களிப்பு வடிவங்களை ஊக்குவிக்க [பரந்த வரையறைகளைப் பயன்படுத்துங்கள்](../how-to-contribute/#பங்களிப்பதின்-அர்த்தம்-என்ன). உங்கள் தொழில்நுட்ப திறமையைப் பொருட்படுத்தாமல், உங்கள் திட்டத்தில் சிறந்த பங்களிப்பை செய்தவர்களை அங்கீகரிக்க நீங்கள் தலைமைப் பாத்திரங்களைப் பயன்படுத்தலாம்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jacobian?s=180" class="pquote-avatar" alt="avatar">
  உங்களுக்கு ஜான்கோவின் "கண்டுபிடிப்பாளர்" ஆக என்னை தெரிந்திருக்கலாம்...ஆனால் உண்மையில் நான் ஒரு ஆண்டுக்கு முன் ஒரு விஷயத்திற்கு பணியமர்த்தப்பட்டவன்.  (...) என் நிரலாக்க திறமை காரணமாக நான் வெற்றிகரமாக இருப்பதாக மக்கள் சந்தேகிக்கிறார்கள்...ஆனால் நான் ஒரு சராசரி நிரலாளர்.
  <p markdown="1" class="pquote-credit">
— @jacobian, ["PyCon 2015 சிறப்புக்குறிப்பு" (video)](https://www.youtube.com/watch?v=hIJdFxYlEKE#t=5m0s)
  </p>
</aside>

## இந்த தலைமைப் பாத்திரங்களை நான் எப்படி ஒழுங்கமைப்பது?

உங்கள் தலைமைத்துவ பாத்திரங்களை ஒழுங்குபடுத்துவது மக்களுக்கு உரிமையைக் காட்ட உதவுகிறது, மேலும் உதவியைப் பார்க்க மற்ற சமூக உறுப்பினர்களைக் கூறுகிறது.

ஒரு சிறிய திட்டம், தலைவர்கள் நியமனம் என்பது உங்கள் என்னைவாசி(README) அல்லது ஒரு பங்களிப்பாளர்கள்(CONTRIBUTORS) உரை கோப்பில் தங்கள் பெயர்களை சேர்ப்பது போன்ற எளிமையாக இருக்க முடியும்.

ஒரு பெரிய திட்டத்திற்கு, உங்களுக்கு ஒரு வலைத்தளம் இருந்தால், ஒரு குழு பக்கத்தை உருவாக்கவும் அல்லது உங்கள் திட்டத் தலைவர்களை பட்டியலிடவும். உதாரணமாக, [போஸ்கிரஸ்](https://github.com/postgres/postgres/) ஒவ்வொரு பங்களிப்பாளருக்கும் குறுகிய சுயவிவரங்களுடன்  [விரிவான குழு பக்கம்](https://www.postgresql.org/community/contributors/) கொண்டு உள்ளது.

உங்கள் திட்டம் மிகவும் சுறுசுறுப்பான பங்களிப்புச் சமுதாயத்தைக் கொண்டிருந்தால், நீங்கள் பராமரிப்பாளர்களின் ஒரு "உள்ளக குழு" அல்லது வெவ்வேறு சிக்கல் பகுதிகளை (எடுத்துக்காட்டாக, பாதுகாப்பு, சிக்கல் மிக்கது, அல்லது சமூக நடத்தை) உரிமையாளர்களாக எடுத்துக் கொள்ளும் உபகுழுக்களாக இருக்கலாம். மக்களுக்கு சுய ஒழுங்கமைப்பையும், தன்னார்வத் தொண்டுகளையும் அவர்கள் மிகவும் உற்சாகமாக அளித்து விட வேண்டும், மாறாக அவர்களை ஒதுக்குவதை விட.

<aside markdown="1" class="pquote">
  \[நாங்கள்\] உள்ளக அணிக்கு பல "துணைஅணிகளை" பிற்சேர்ப்பு செய்கிறோம். ஒவ்வொரு துணைஅணியும் ஒரு குறிப்பிட்ட பகுதியில் கவனம் செலுத்துகிறது, எ.கா., மொழி வடிவமைப்பு அல்லது நிரலகங்கள். (...) உலகளாவிய ஒருங்கிணைப்பு மற்றும் முழுமையான திட்டத்திற்கான வலுவான, ஒத்திசைவான பார்வைக்கு, ஒவ்வொரு துணைத் தலைமையும் முக்கிய குழுவின் உறுப்பினரால் வழிநடத்தப்படுகிறது.
  <p markdown="1" class="pquote-credit">
— ["ரஸ்ட் ஆளுமை RFC"](https://github.com/rust-lang/rfcs/blob/master/text/1068-rust-governance.md)
  </p>
</aside>

தலைமை குழுக்கள் நியமிக்கப்பட்ட சேனலை (ஐஆர்சி போன்றவை) உருவாக்குவதற்கு அல்லது திட்டத்தை (கிட்டர் அல்லது கூகுள் ஹாங்க் அவுட் போன்றவை) விவாதிப்பதற்கு எண்ணலாம். அந்த கூட்டங்களைப் பொதுவில் வைப்பபதபதால் மற்றவர்கள் கேட்கலாம். உதாரணத்திற்கு [கூக்கூம்பர்-ரூபி](https://github.com/cucumber/cucumber-ruby), [ஒவ்வொரு வாரமும் அலுவல் நேரத்தை நடத்துகிறது](https://github.com/cucumber/cucumber-ruby/blob/master/CONTRIBUTING.md#talking-with-other-devs).

தலைமைத்துவப் பாத்திரங்களை நீங்கள் உருவாக்கியிருந்தால், மக்களை எவ்வாறு அடைவது என்பதை ஆவணப்படுத்த மறக்காதீர்கள்! யாரேனும் ஒருவர் பராமரிப்பாளராக அல்லது உங்கள் திட்டத்தில் துணைக்குழுவில் சேரலாம் என்பதற்கும், அதை உங்கள் GOVERNANCE.md இல் எழுதுவதற்கும் ஒரு தெளிவான வழிமுறையை உருவாக்குங்கள்.

[Vossibility](https://github.com/icecrime/vossibility-stack) போன்ற கருவிகள் திட்டத்திற்கு யார் பங்களிப்புகளை தருகிறார் (அல்லது தரவில்லை) என்பதைத் தெரிந்துகொள்ள உதவும். இந்த தகவலை ஆவணப்படுத்துவது, பராமரிப்பாளர்கள் தனிப்பட்ட முறையில் அதன் முடிவுகளை எடுக்கும் ஒரு குழு என்று சமூக அக்கறை தவிர்க்கிறது.

இறுதியாக, உங்கள் திட்டம் கிட்ஹப்பில் இருந்தால், உங்கள் திட்டத்தை உங்கள் தனிப்பட்ட கணக்கிலிருந்து ஒரு நிறுவனத்திற்கு நகர்த்துவதைக் கருத்தில் கொண்டு, குறைந்தது ஒரு காப்பு நிர்வாகி ஒன்றைச் சேர்ப்பதை கருத்தில் கொள்ளுங்கள். [கிட்ஹப் நிறுவனங்கள்](https://help.github.com/articles/creating-a-new-organization-account/) அனுமதிகள் மற்றும் பல களஞ்சியங்களை நிர்வகிக்க எளிதாக்குகின்றன, மேலும் உங்கள் திட்டத்தின் மரபுரிமைகளை [பகிரப்பட்ட உரிமையாளர்](../building-community/#share-ownership-of-your-project) மூலம் பாதுகாக்கின்றன.

## எப்போது யாருக்கு ஒப்புவிக்கும் அணுகல் கொடுக்க வேண்டும்?

சிலர் நீங்கள் ஒரு பங்களிப்பை செய்கிற அனைவருக்கும் அனுமதி வழங்க வேண்டும் என்று நினைக்கிறார்கள். அவ்வாறு செய்வது உங்கள் திட்டத்தின் உரிமையை உணர இன்னும் பலரை ஊக்குவிக்கும்.

மறுபுறம், குறிப்பாக பெரிய, மிகவும் சிக்கலான செயல்திட்டங்களுக்கான, நீங்கள் அவர்களின் அர்ப்பணிப்பை நிரூபிக்கியுள்ள மக்களுக்கு மட்டுமே அனுமதி வழங்க வேண்டும். அதை செய்ய எந்த ஒரு சரியான வழி இல்லை - உங்களுக்கு மிகவும் வசதியாக உள்ள வழியில் செய்க!

உங்கள் திட்டம் கிட்ஹப்பில் இருந்தால், ஒரு குறிப்பிட்ட கிளைக்கு யார் தள்ள முடியும், எந்த சூழ்நிலையிலும் நிர்வகிக்க நீங்கள் [பாதுகாக்கப்பட்ட கிளைகள்](https://help.github.com/articles/about-protected-branches/) பயன்படுத்தலாம்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/felixge?s=180" class="pquote-avatar" alt="avatar">
  யாராவது உங்களிடம் ஒரு இழு கோரிக்கையை அனுப்புகின்ற போதெல்லாம், உங்கள் திட்டத்திற்கான அணுகலை அவர்களுக்குக் கொடுங்கள். முதலில் இது நம்பமுடியாத முட்டாள்தனமாக இருக்கலாம், இந்த வியூகத்தை பயன்படுத்தி நீங்கள் கிட்ஹப்பின் உண்மையான திறனை கட்டவிழ்த்துவிட அனுமதிக்கும். (...) மக்கள் ஒப்புவி அணுகல் இருந்து விட்டால், அவர்களது சீரமைப்பு அலைந்து கொண்டே போகும் என்ற கவலை அவர்களுக்கு இல்லை...இன்னும் அதிக வேலையைச் செய்வதற்கு அவை காரணமாகின்றன.
  <p markdown="1" class="pquote-credit">
— @felixge, ["இழு கோரிக்கை Hack"](https://felixge.de/2013/03/11/the-pull-request-hack.html)
  </p>
</aside>

## திறந்த மூல திட்டங்களுக்கான பொது ஆளுமை கட்டமைப்புகள் சில யாவை?

திறந்த மூல திட்டங்களுடனான மூன்று பொது ஆளுமை கட்டமைப்புகள் உள்ளன.

* **BDFL:** BDFL "வாழ்வாதாரத்திற்கான சர்வாதிகாரி". இந்த கட்டமைப்பின் கீழ், ஒரு நபர் (பொதுவாக திட்டத்தின் ஆரம்ப எழுத்தாளர்) அனைத்து முக்கிய திட்ட முடிவுகளிலும் இறுதி சொல் உள்ளவரார். [பைதான்](https://github.com/python) ஒரு உன்னதமான உதாரணம். ஒன்று அல்லது இரண்டு பராமரிப்பாளர்கள் இருப்பதால் சிறிய திட்டங்கள் பெரும்பாலும் இயல்பான BDFL ஆகும். ஒரு நிறுவனம் தோற்றுவிக்கப்பட்ட ஒரு திட்டம் BDFL பிரிவில் விழக்கூடும்.

* **தகுதி முறை:** **(குறிப்பு: "தகுதி" என்ற வார்த்தை சில சமூகங்களுக்கு எதிர்மறையான கருத்துகளை கொண்டுள்ளது, மேலும் [சிக்கலான சமூக மற்றும் அரசியல் வரலாறு](http://geekfeminism.wikia.com/wiki/Meritocracy).)** ஒரு தகுதித்துவத்தின் கீழ், செயலில் உள்ள திட்ட பங்களிப்பாளர்கள் ("தகுதியை" நிரூபிப்பவர்கள்) முறையான முடிவு எடுக்கும் பங்கை வழங்கியுள்ளனர். தூய வாக்களிப்பு கருத்தை அடிப்படையாக கொண்ட முடிவுகள் பொதுவாக செய்யப்படுகின்றன. தகுதி முறை கருத்துப் படிவம் [அப்பாச்சி அறக்கட்டளையின்](https://www.apache.org/) முன்னோடியாக இருந்தது; [அனைத்து அப்பாச்சி திட்டங்கள்](https://www.apache.org/index.html#projects-list) தகுதி முறை உள்ளவை. தனிநபர்கள் தங்களைக் குறிக்கும் நபர்களால் மட்டுமே பங்களிப்பு செய்ய முடியும், நிறுவனத்தால் அல்ல.

* **தாராளவாத பங்களிப்பு:** Uதாராளமான பங்களிப்பு மாதிரியின் கீழ், அதிக வேலை செய்யும் மக்கள் மிகவும் செல்வாக்காளர்களாக அங்கீகரிக்கப்படுகின்றனர், ஆனால் இது நடப்பு வேலைகளை அடிப்படையாகக் கொண்டது, வரலாற்று பங்களிப்பு அல்ல. முக்கிய திட்ட முடிவுகள், முழுமையான வாக்கெடுப்புக்கு பதிலாக ஒரு கருத்தொன்றைத் தேடும் செயல்முறையை அடிப்படையாகக் கொண்டு (பெரும் கவலையைப் பற்றிக் கொள்ளுதல்), மற்றும் சாத்தியமான பல சமூக முன்னோக்குகளை உள்ளடக்கியது. தாராளவாத பங்களிப்பு மாதிரி பயன்படுத்தும் திட்டங்களின் பிரபலமான உதாரணங்கள் [Node.js](https://foundation.nodejs.org/) and [Rust](https://www.rust-lang.org/).

நீங்கள் எதைப் பயன்படுத்த வேண்டும்? அதை நீங்கள் தான் முடிவு செய்ய வேண்டும்! ஒவ்வொரு மாதிரியிலும் நன்மைகள் மற்றும் ஈடுகட்டல் உள்ளன. அவை முதலில் வித்தியாசமாக தோன்றினாலும், மூன்று மாதிரிகளுக்கு காண்பதை காட்டிலும் பொதுவானவை அதிகமுள்ளது. இந்த ஒப்புருக்களில் ஒன்றை ஏற்றுக்கொள்ள ஆர்வமாக இருந்தால், இந்த வார்ப்புருக்களைப் பார்க்கவும்:

* [BDFL மாதிரி வார்ப்புரு](http://oss-watch.ac.uk/resources/benevolentdictatorgovernancemodel)
* [தகுதி முறை மாதிரி வார்ப்புரு](http://oss-watch.ac.uk/resources/meritocraticgovernancemodel)
* [Node.js-ன் தாராளவாத பங்களிப்பு கொள்கை](https://medium.com/the-node-js-collection/healthy-open-source-967fa8be7951)

## நான் என் திட்டத்தை தொடங்கும்போது ஆளுகை ஆவணங்கள் தேவையா?

உங்கள் திட்டத்தின் நிர்வாகத்தை எழுதி வைக்க சரியான நேரம் என்று எதுவுமில்லை, ஆனால் உங்கள் சமூக இயக்கவியலை பார்த்தபின்பு, அதை வரையறுப்பது மிகவும் எளிது. Tதிறந்த மூல ஆளுமை பற்றி சிறந்த (மற்றும் கடினமான) பகுதியாக இது சமூகத்தால் வடிவமைக்கப்பட்டது!

சில ஆரம்ப ஆவணங்கள் தவிர்க்க முடியாமல் உங்கள் திட்டத்தின் ஆளுமைக்கு பங்களிக்கின்றன, இருப்பினும், நீங்கள் என்ன செய்ய முடியுமென்பதை எழுதுங்கள். உதாரணமாக, நடத்தைக்கான தெளிவான எதிர்பார்ப்புகளை நீங்கள் வரையறுக்கலாம் அல்லது உங்கள் திட்டத்தின் தொடக்கத்தில் கூட, உங்கள் பங்களிப்பாளரின் செயல் எவ்வாறு இயங்குகிறது என்பதை நீங்கள் வரையறுக்கலாம்.

நீங்கள் ஒரு திறந்த மூல திட்டத்தை துவக்கும் நிறுவனத்தின் ஒரு அங்கமாக இருந்தால், உங்கள் நிறுவனமானது எவ்வாறு பராமரிப்பது மற்றும் திட்டத்தை முன்னோக்கி நகர்த்துவதற்கான முடிவுகளை எடுப்பது பற்றி அறிமுகப்படுத்துவதற்கு முன்பாக ஒரு உள் விவாதத்தை வைத்திருப்பது நன்று. திட்டத்தில் உங்கள் நிறுவனம் எப்படி ஈடுபடுவது (அல்லது முடியாது!) என்பது குறித்த அனைத்தையும் பகிரங்கமாக விளக்க விரும்பலாம்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/caabernathy?s=180" class="pquote-avatar" alt="avatar">
  பேஸ்புக்கில் உண்மையில் பணிபுரியும் கிட்ஹப் திட்டங்களை நிர்வகிக்க சிறிய குழுக்களை நாங்கள் நியமிக்கிறோம். உதாரணமாக React, React பொறியாளரால் செயல்படுத்தப்படுகிறது.
  <p markdown="1" class="pquote-credit">
— @caabernathy, ["பேஸ்புக்கில் உள்ள திறந்த மூலத்தில் ஒரு பார்வை"](https://opensource.com/life/15/10/ato-interview-christine-abernathy-facebook)
  </p>
</aside>

## பெருநிறுவன ஊழியர்கள் பங்களிப்புகளை சமர்ப்பிக்க ஆரம்பித்தால் என்ன நடக்கும்?

வெற்றிகரமான திறந்த மூல திட்டங்கள் பல மக்களாலும் நிறுவனங்களாலும் பயன்படுத்தப்படுகின்றன, மேலும் சில நிறுவனங்களில் வருவாய் நீரோடைகள் திட்டத்தில் இணைந்திருக்கலாம். உதாரணமாக, ஒரு நிறுவனம் ஒரு வணிகச் சேவை வழங்கும் திட்டத்தின் ஒரு பகுதியாக திட்டத்தின் குறியீட்டைப் பயன்படுத்தலாம்.

திட்டம் மிகவும் பரவலாக பயன்படுத்தப்படும் பொழுது, நிபுணத்துவம் கொண்ட மக்கள் தேவை அதிகலாம்- நீங்கள் ஒருவராக இருக்கலாம்! - மற்றும் சில நேரங்களில் அவர்கள் திட்டத்தில் வேலை செய்ய பணம் கிடைக்கும்.

சாதாரணமாக வணிக ரீதியிலான செயல்பாடு மற்றும் அபிவிருத்தி ஆற்றலை மற்றொரு ஆதாரமாகக் கருதுவது முக்கியம். Pபணம் பெறும் நிரலாளர்கள் நிச்சயமாக செலுத்தப்படாதவர்களைவிட சிறப்பு சிகிச்சை பெறக்கூடாது; ஒவ்வொரு பங்களிப்பும் அதன் தொழில்நுட்ப தகுதிகளில் மதிப்பீடு செய்யப்பட வேண்டும். இருப்பினும், வணிக செயல்பாடுகளில் வசதியாக ஈடுபடுவதை உணர வேண்டும், மேலும் ஒரு குறிப்பிட்ட மேம்பாட்டிற்கோ அல்லது அம்சத்திற்கோ ஆதரவாக வாதிடும்போது, அவற்றின் பயன்பாடு வழக்குகள் குறித்து வசதியாக இருக்கும்.

"வணிகம்" என்பது "திறந்த மூலத்திற்கு" ஏற்புடையது. "வணிகம்" என்பது எங்காவது பணத்தை வைத்திருப்பது என்பது பொருள் - மென்பொருளானது வர்த்தகத்தில் பயன்படுத்தப்படுகிறது, இது ஒரு திட்டத்தை வெற்றிகரமாக ஏற்றுக்கொள்வது போன்றது. (திறந்த மூல மென்பொருளானது அல்லாத திறந்த மூல தயாரிப்புகளின் ஒரு பகுதியாக பயன்படுத்தப்படும்போது, மொத்த தயாரிப்பு இன்னும் "தனியுரிமை" மென்பொருளாகும், இருப்பினும், திறந்த மூலத்தைப் போல, இது வணிக ரீதியான அல்லது வணிகரீதியான நோக்கங்களுக்காக பயன்படுத்தப்படலாம்.)

மற்றவர்களைப் போல, வணிக ரீதியாக ஊக்கமளிக்கும் நிரலாளர்கள் தங்கள் பங்களிப்புகளின் தரம் மற்றும் அளவு மூலம் திட்டத்தில் செல்வாக்கைப் பெறுகின்றனர். வெளிப்படையாக, பணம் பெறும் ஒரு நிரலாளர் பணம் இல்லாத ஒருவரைவிட அதிகமாகச் செய்யலாம், ஆனால் அது பரவாயில்லை: பணம் ஒருவர் எவ்வளவு செய்யலாம் என்பதை . பாதிக்கக்கூடிய பல காரணிகளில் ஒன்றாகும்.. உங்கள் திட்ட விவாதங்களை பங்களிப்புகளில் கவனம் செலுத்துங்கள், மக்களுக்கு அந்த பங்களிப்பை வழங்குவதற்கு வெளிப்புற காரணிகளில் அல்ல.

## எனது திட்டத்தை ஆதரிக்க எனக்கு ஒரு சட்ட நிறுவனம் தேவைதானா?

பணத்தை கையாளும் வரை உங்கள் திறந்த மூல திட்டத்தை ஆதரிக்க உங்களுக்கு ஒரு சட்ட நிறுவனம் தேவையில்லை.

உதாரணமாக, நீங்கள் ஒரு வணிக வணிகத்தை உருவாக்க விரும்பினால், நீங்கள் ஒரு சி கார்ப் அல்லது எல்எல்சி ஒன்றை (நீங்கள் அமெரிக்க அடிப்படையிலேயே இருந்தால்) அமைக்க வேண்டும். உங்களுடைய திறந்த மூல திட்டத்துடன் தொடர்புடைய ஒப்பந்த வேலைகளை நீங்கள் செய்தால், நீங்கள் ஒரு தனி உரிமையாளராக பணத்தை ஏற்றுக்கொள்ளலாம் அல்லது எல்.எல்.சி (நீங்கள் அமெரிக்க அடிப்படையிலேயே இருந்தால்) ஒன்றை அமைக்கலாம்.

உங்கள் திறந்த மூல திட்டத்திற்கான நன்கொடைகளை நீங்கள் ஏற்றுக் கொள்ள விரும்பினால், நீங்கள் நன்கொடை பொத்தானை (உதாரணமாக பேபால் அல்லது ஸ்டரைப் பயன்படுத்தி) அமைத்துக்கொள்ளலாம், ஆனால் நீங்கள் தகுதியற்ற இலாப நோக்கில் இல்லாதபட்சத்தில் வரி விதிக்கப்படாது (ஒரு 501c3, நீங்கள் அமெரிக்காவில் இருந்தால்).

பல திட்டங்கள் ஒரு இலாப நோக்கமற்ற அமைப்பை உருவாக்கும் சிக்கல் மூலம் செல்ல விரும்பவில்லை, எனவே அவர்கள் அதற்கு பதிலாக ஒரு லாப நோக்கற்ற நிதி ஆதரவாளரைக் காண்கிறார்கள். ஒரு நிதியளிப்பவர் உங்கள் சார்பில் நன்கொடைகளை ஏற்றுக்கொள்கிறார், வழக்கமாக நன்கொடையின் ஒரு சதவீதத்திற்கு பதிலாக. [மென்பொருள் சுதந்திர பாதுகாப்பு](https://sfconservancy.org/), [அப்பாச்சி அறக்கட்டளை](https://www.apache.org/), [எக்லிப்ஸ் அறக்கட்டளை](https://eclipse.org/org/foundation/), [லினக்ஸ் அறக்கட்டளை](https://www.linuxfoundation.org/projects) மற்றும் [திறந்த கூட்டு](https://opencollective.com/opensource) திறந்த மூல திட்டங்களுக்கு நிதி ஆதரவாளர்களாக செயல்படும் நிறுவனங்களின் எடுத்துக்காட்டுகள் ஆகும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/piamancini?s=180" class="pquote-avatar" alt="avatar">
  சமூகங்கள் தன்னையே நிலைநிறுத்திக் கொள்ளக்கூடிய ஒரு உள்கட்டமைப்பை வழங்குவதே எங்கள் இலக்கு, இதனால் அனைவருக்கும் - பங்களிப்பாளர்கள், ஆதரவாளர்கள், உபயதாரர்கள் - இதில் உறுதியான நன்மைகளை பெறுலாம்.
  <p markdown="1" class="pquote-credit">
— @piamancini, ["தொண்டு கட்டமைப்பிற்கு அப்பால் நகர்வது"](https://medium.com/open-collective/moving-beyond-the-charity-framework-b1191c33141)
  </p>
</aside>

உங்கள் திட்டம் ஒரு குறிப்பிட்ட மொழியோ அல்லது சுற்றுச்சூழலுக்கோ நெருங்கிய தொடர்புடையதாக இருந்தால், நீங்கள் வேலை செய்யக்கூடிய தொடர்புடைய மென்பொருள் அடித்தளம் இருக்கலாம். உதாரணமாக, [பைத்தான் மென்பொருள் அறக்கட்டளை](https://www.python.org/psf/) [PyPI](https://pypi.python.org/pypi) பைத்தான் தொகுப்பு மேலாளரை, மற்றும் [Node.js அறக்கட்டளை](https://foundation.nodejs.org/)  [Express.js](https://expressjs.com/), a ஒரு நோட் Node-சார்ந்த கட்டமைப்பை ஆதரிக்க உதவுகிறது.
