---
lang: ta
title: திறந்த மூலத்திற்கு எவ்வாறு பங்களிப்பது
description: திறந்த மூலத்திற்கு பங்களிக்க விரும்புகிறீர்களா? புதியவர்கள் மற்றும் துறைத்தேர்ந்தோர்க்கான, திறந்த மூல பங்களிப்புகளை உருவாக்கும் ஒரு வழிகாட்டி.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## ஏன் திறந்த மூலத்திற்கு பங்களிக்க வேண்டும்?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  \[Freenode\] இல் பணிபுரிந்து, பின்னர் நான் பல்கலைக்கழகத்தில் என் படிப்பிற்காகவும், எனது வேலைக்காகவும் பயன்படுத்தப்படும் பல திறன்களை எனக்குப் பெற்றுத்தந்த்து. பணித் திட்டத்தில் வேலை செய்வது எந்த அளவிற்கு உதவியதோ அந்த அளவிற்கு திறந்த மூல திட்டத்தில் பணி செய்வது எனக்கு உதவுகிறது என்று நினைக்கிறேன்!
  <p markdown="1" class="pquote-credit">
— @errietta, ["நான் ஏன் திறந்த மூலத்திற்கு பங்களிக்க விரும்புகிறேன்?"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

திறந்த மூலத்திற்கான பங்களிப்பு, நீங்கள் கற்பனை செய்யக்கூடிய எந்தவொரு திறனுடனும் கற்றல், கற்பித்தல் மற்றும் அனுபவத்தை உருவாக்க ஒரு பயனளிக்கும் வழியாகும்.

ஏன் மக்கள் திறந்த மூலத்திற்கு பங்களிக்க வேண்டும்? நிறைய காரணங்கள்!

### இருக்கும் திறன்களை மேம்படுத்தவும்

நீங்கள் பயிற்சிக்காக குறியீட்டு, பயனர் இடைமுக வடிவமைப்பு, வரைகலை திட்டம், எழுதுதல் அல்லது ஒழுங்குபடுத்துதல் போன்றவற்றை தேடுகிறீர்கள் என்றால், திறந்த மூல திட்டத்தில் உங்களுக்கு ஒரு பணி உள்ளது.

### ஒப்பான விஷயங்களில் ஆர்வமாக உள்ளவர்களை சந்திக்க

நல்ல, வரவேற்பு சமூகங்களைக் கொண்ட திறந்த மூல திட்டங்கள், மக்களை பல ஆண்டுகளுக்கு பங்களிப்பை பெறுகின்றன. பல மக்கள் திறந்த மூலத்தில் பங்கேற்பதன் மூலம் வாழ்நாள் முழுவதும் நட்பை உருவாக்குகிறார்கள், இது மாநாட்டில் ஒருவருக்கொருவர் சந்திக்கவோ அல்லது பொரிட்டோஸைப் பற்றிய தாமதமான இரவு அரட்டைகளில் பேசும் வரை கொண்டு செல்லும்.

### வழிகாட்டிகளை கண்டறிதல் மற்றும் பிறருக்கு கற்பித்தல்

ஒரு பகிர்வு திட்டத்தில் மற்றவர்களுடன் வேலை செய்வது என்றால் நீங்கள் விஷயங்களை எவ்வாறு செய்வது என்பதை விளக்க வேண்டும், மேலும் உதவிக்காக பிறரிடம் கேட்கவும். கற்றல் மற்றும் கற்பித்தல் செயல்கள் சம்பந்தப்பட்ட அனைவருக்கும் ஒரு பூரணமான செயலாகும்.

### பொது கலைப்பொருட்களை உருவாக்குவதன் மூலம் உங்கள் நற்பெயர் (மற்றும் ஒரு தொழில்) வளர உதவும்

அடிப்படையில், உங்கள் திறந்த மூல வேலை அனைத்தையும் பொதுமக்கட்குரியது, அதாவது நீங்கள் அவற்றை இலவச செயல் விளக்கமாக எங்கு வேண்டுமானாலும் எடுத்துக்கொள்ளலாம்.

### மக்கள் திறன்களை அறிக

திறந்த மூல தலைமை மற்றும் முகாமைத்துவ திறன்களை நடைமுறைப்படுத்துவதற்கான வாய்ப்பை வழங்குகிறது, முரண்களை தீர்ப்பது, மக்களை அணிகள் ஒழுங்குபடுத்துதல், வேலைகளை முக்கிய வரிசைப்படுத்துதல்.

### மாற்றங்கள் செய்ய அதிகாரம் அளிக்கவல்லது, சிறிய மாற்றங்களாயினும்

திறந்த மூலத்தில் பங்கேற்க நீங்கள் வாழ்நாள் முழுவதும் பங்களிப்பு செய்ய வேண்டியதில்லை. நீங்கள் எப்போதாவது ஒரு வலைத்தளத்தில் ஒரு தட்டச்சுப் பிழையை பார்த்திருக்கிறீர்களா, யாரேனும் அதை சரிசெய்வார்கள் என கருதியிரிக்கிறீர்களா? திறந்த மூல திட்டத்தில், நீங்கள் அதை செய்ய முடியும். திறந்த மூல மக்கள் தங்கள் வாழ்வில் செயலாண்மையை உணர உதவுகிறது மற்றும் அவர்கள் உலக அனுபவத்தை பெறுவது, அதுவே மன நிறைவு தருகிறன்தாகும்.

## பங்களிப்பதின் அர்த்தம் என்ன

நீங்கள் ஒரு புதிய திறந்த மூல பங்களிப்பாளராக இருந்தால், செயல்முறை அச்சுறுத்தும். சரியான திட்டத்தை எப்படி கண்டுபிடிப்பது? உங்களுக்கு குறியீடு தெரியாது என்றால் என்ன செய்வது? ஏதாவது தவறு நடந்தால் என்ன செய்வது?

வருத்தப்பட வேண்டாம்! திறந்த மூல திட்டத்தில் ஈடுபடுவதற்கான எல்லாவித வழிகளும் உள்ளன, மேலும் சில உதவிக்குறிப்புகள் உங்கள் அனுபவத்தை பெருக்க மிகவும் உதவியாக இருக்கும்.

### நீங்கள் குறியீடு பங்களிக்க வேண்டியதில்லை

திறந்த மூலத்திற்கு பங்களிப்பதைப் பற்றி பொதுவான தவறான கருத்து நீங்கள் குறியீட்டை பங்களிக்க வேண்டும். உண்மையில், இது பெரும்பாலும் ஒரு திட்டத்தின் [மிகவும் புறக்கணிக்கப்பட்ட அல்லது கண்காணிக்கவில்லை](https://github.com/blog/2195-the-shape-of-open-source) பிற பகுதிகளாகும். இந்த வகையான பங்களிப்புகளை வழங்குவதன் மூலம் நீங்கள் திட்டத்திற்கு  _மிகப்பெரிய_ நன்மை செய்வீர்கள்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
நான் கோகோபாட்களில் எனது பணிக்காக புகழ் பெற்றிருக்கிறேன், ஆனால் கோகோபாட்ஸ் கருவியில் எந்தவொரு உண்மையான வேலையும் செய்யவில்லை என்று பெரும்பாலான மக்களுக்கு தெரியாது. திட்டத்தில் என் நேரம் பெரும்பாலும் ஆவணங்கள் மற்றும் வர்த்தக வேலை போன்ற விஷயங்களை செய்வதாகும்.
  <p markdown="1" class="pquote-credit">
— @orta, ["இயல்பாகவே OSS க்கு நகரவும்"](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

நீங்கள் குறியீட்டை எழுத விரும்பினால் கூட, பிற வகையான பங்களிப்புகள் ஒரு திட்டத்துடன் தொடர்பு கொள்ளவும் மற்ற சமூக உறுப்பினர்களை சந்திக்கவும் சிறந்த வழியாகும். அந்த உறவுகளை கட்டியெழுப்புதல் திட்டத்தின் மற்ற பகுதிகளிலும் வேலை செய்ய உங்களுக்கு வாய்ப்பளிக்கும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/brettcannon?s=180" class="pquote-avatar" alt="avatar">
 ஜூன் 17, 2002 அன்று என் சீரமைப்புகளை ஏற்றுக்கொள்வதைப் பற்றி நான் அஞ்சல் பட்டியலில் பைத்தான் மேம்பாட்டுக் குழுவிடம் (அதாவது பைத்தான்-டெவ்) மின்னஞ்சல் அனுப்பினேன். நான் விரைவாக திறந்த மூல பிழையைப் கண்டறிந்தேன், குழுவிற்கு மின்னஞ்சல் சுருக்கத் தொகுப்புக்களைத் தொகுத்து அனுப்ப முடிவு செய்தேன். ஒரு தலைப்பைப் பற்றிய விளக்கங்களைக் கேட்கும் பொழுது அவர்கள் பொறுத்துக்கொள்ள சொன்ன பொழுது, ஆனால் யாரோ ஒருவர் நெருக்கடி உள்ள ஒன்றை செய்ய வேண்டி சுட்டிக்காட்டியதை நான் கவனிக்க முடிந்தது.
  <p markdown="1" class="pquote-credit">
— @brettcannon, ["பராமரிப்பாளர் கதைகள்"](https://github.com/open-source/stories/brettcannon)
  </p>
</aside>

### நிகழ்வு திட்டமிடல்களை விரும்புகிறீர்களா?

* திட்டம் பற்றி பட்டறைகள் அல்லது சந்திப்புகளை ஏற்பாடு செய்யுங்கள், [@fzamperin NodeSchoolக்கு செய்ததை போல](https://github.com/nodeschool/organizers/issues/406)
* திட்டத்தின் கலந்தாய்வு ஒழுங்குபடுத்துதல் (அப்படி ஒன்று இருந்தால்)
* உதவி சமூக உறுப்பினர்கள் சரியான கலந்தாய்வுகளை கண்டுபிடித்து பேசுவதற்கான திட்டங்களை சமர்ப்பிக்கவும்

### நீங்கள் வடிவமைக்க விரும்புகிறீர்களா?

* திட்டத்தின் பயன்பாட்டினை மேம்படுத்துவதற்கு மறுகட்டமைப்பு வடிவமைப்புகளை அமைத்தல்
* திட்டத்தின் வழிசெலுத்தல் அல்லது பட்டியல்களை மறுசீரமைக்கவும் புதுப்பிக்கவும் பயனர் ஆராய்ச்சி நடத்திடுங்கள்,  [Drupal கூறுவதைப்போல்](https://www.drupal.org/community-initiatives/drupal-core/usability)
* திட்டத்தின் ஒரு நிலையான காட்சி வடிவமைப்புக்கு உதவும் ஒரு பாணி வழிகாட்டி உருவாக்கவும்
* டி-சர்ட்டுகளுக்கு ஓவியம் அல்லது புதிய சின்னம் உருவாக்கவும், [hapi.js's பங்களிப்பாளர்கள் செய்ததைப்போல](https://github.com/hapijs/contrib/issues/68)

### நீங்கள் எழுத விரும்புகிறீர்களா?

* திட்டத்தின் ஆவணங்களை எழுதுவது மற்றும் மேம்படுத்துவது
* திட்டம் எவ்வாறு பயன்படுத்தப்படுகிறது என்பதை காட்டும் உதாரணங்கள் ஒரு கோப்புறையை தொகுத்தல்
* திட்டத்திற்கான ஒரு செய்திமடலைத் தொடங்கவும் அல்லது அஞ்சல் பட்டியலிலிருந்த சிறப்பம்சங்களைக் தொகுக்கவும்
* திட்டத்திற்கான பயிற்சியை எழுதுங்கள், [PyPA's பங்களிப்பாளர்கள் செய்ததைப்போல](https://github.com/pypa/python-packaging-user-guide/issues/194)
* திட்டத்தின் ஆவணங்களுக்கான ஒரு மொழிபெயர்ப்பை எழுதுங்கள்

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  உண்மையாக, \[ஆவணங்கள்\] மிகவும் முக்கியம். இதுவரை ஆவணங்கள் Babel-ன் ஒரு முக்கிய அம்சமாக இருந்தது. திட்டத்தின் சில பகுதிகள் பங்களிப்பை உபயோகப்படுத்திக் கொள்வதோடு, பத்தியில் இங்கும் அங்கும் மாற்றம் செய்வதுகூட பாராட்டத்தக்கதாகும்.
  <p markdown="1" class="pquote-credit">
— @kittens, ["பங்களிப்பாளர்களுக்கு அழைப்பு"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### உங்களுக்கு ஒழுங்குபடுத்துவதில் விருப்பமுண்டா?

* விஷயங்களை ஒழுங்காக வைக்க, நகல் சிக்கல்களை இணைக்கவும், புதிய சிக்கல் அடையாளச் சிட்டை பரிந்துரைக்கவும்
* திறந்த சிக்கல்களில் பழையவற்றை மூடுமாறு பரிந்துரைக்கவும், [@nzakas ESLint-ல் செய்ததைப்போல](https://github.com/eslint/eslint/issues/6765)
* விவாதத்தை முன்னோக்கி நகர்த்துவதற்காக சமீபத்தில் திறக்கப்பட்ட சிக்கல்கள் குறித்து கேள்விகளைக் கேளுங்கள்

### நீங்கள் குறிமுறையாக்கத்தை விரும்புகிறீர்களா?

* ஒரு திறந்த சிக்கலைக் கண்டறிந்து கையாளுதல், [@dianjin Leaflet-ல் செய்ததைப்போல](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* புதிய அம்சத்தை எழுதுவதற்கு நீங்கள் உதவ முடியுமா எனக் கேளுங்கள்
* தானியங்கு திட்டம் அமைப்பு
* கருவியாக்கல் மற்றும் சோதனைகளை மேம்படுத்தவும்

### நீங்கள் மக்களுக்கு உதவ விரும்புகிறீர்களா?

* திட்டத்தின் பற்றிய கேள்விகளுக்கு பதிலளிக்கவும் எ.கா., Stack Overflow ([இந்த Postgres உதாரணம் போல](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) அல்லது Reddit
* திறந்த சிக்கல்கள் உள்ளவர்களின் கேள்விகளுக்கு விடையளிக்கவும்
* கலந்துரையாடல் பலகைகள் அல்லது உரையாடல் தடங்களை மிதமாக்க உதவுங்கள்

### நீங்கள் மற்றவர்களுக்கான குறியீடுக்கு உதவ விரும்புவரா?

* மற்றவர்களின் குறியீடு சமர்ப்பிப்புகளை மதிப்பாய்வு செய்தல்
* ஒரு திட்டம் எவ்வாறு பயன்படுத்தப்படலாம் என்ற பயிற்சியை எழுதுங்கள்
* மற்றொரு பங்களிப்பாளருக்கு வழிகாட்டியாக இருத்ததலதல்,[@ereichert @bronzdocக்கு Rustல் இருந்ததைப்போல](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### நீங்கள் மென்பொருள் திட்டங்களில் மட்டுமே வேலை செய்ய வேண்டியதில்லை!

"திறந்த மூலம்" பெரும்பாலும் மென்பொருளைக் குறிக்கும் போது, நீங்கள் எதைப் பற்றியும் கூடி வேலைச்செய்யயலாம். திறந்த மூல திட்டங்களாக உருவாக்கப்பட்ட புத்தகங்கள், சமையல் குறிப்புகள், பட்டியல்கள் மற்றும் வகுப்புகள் உள்ளன.

உதாரணத்திற்கு:

* @sindresorhus ["அற்புதமான" பட்டியல்களின் பட்டியல்](https://github.com/sindresorhus/awesome) தொகுத்தார்
* @h5bp முன்-முனை மேம்பாட்டர் தேர்வர்களுக்கான [சாத்தியமான நேர்காணல் கேள்விகளை](https://github.com/h5bp/Front-end-Developer-Interview-Questions) பராமரிக்கிறார்
* @stuartlynn மற்றும் @nicole-a-tesla [puffins-பெரிய அலகுடைய கடற்பறவைகள் பற்றி வேடிக்கை உண்மைகள் சேகரிப்பு](https://github.com/stuartlynn/puffin_facts) செய்தனர்

நீங்கள் ஒரு மென்பொருள் உருவாக்குநராக இருந்தாலும்கூட, ஆவணங்கள் திட்டத்தில் பணிபுரியும் திறந்த மூலத்தில் நீங்கள் தொடங்குவதற்கு உதவலாம். இது குறியீட்டை உள்ளடக்கிய திட்டங்களில் பணிபுரியும் அளவுக்கு குறைவான அச்சுறுத்தலாகும், மற்றும் ஒத்துழைப்பு செயல்முறை உங்களுக்கு நம்பிக்கையும் அனுபவத்தையும் உருவாக்கும்.

## ஒரு புதிய திட்டத்திற்காக உங்களை நெறிப்படுத்துதல்

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  நீங்கள் ஒரு சிக்கல் தடமிக்கு சென்று விஷயங்கள் குழப்பமானதாக தோன்றினால், உங்களுக்கு மட்டும் அல்ல. இந்த கருவிகளில் நிறைய அறிவுத்திறன் தேவைப்படுகிறது, ஆனால் மற்றவர்கள் உங்களுக்கு வழிநடத்த உதவுவார்கள், நீங்கள் அவர்களிடம் கேள்விகளை கேட்கலாம்.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["திறந்த மூலத்திற்கு எவ்வாறு பங்களிப்பது"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

ஒரு தட்டச்சுப் பிழையை சரி செய்வதை விட அதிகம், ஓப்பன் சோர்ஸ் பங்களிப்பு என்பது அந்நியர்களின் கொண்டாட்டத்தில் ஒரு குழுவினருடன் நடப்பது போலாகும். அவர்கள் தங்கமீன் பற்றி ஒரு விவாதத்தில் ஆழமாக இருந்தபோது, நீங்கள் இலாமா (கம்பள ஒட்டக இனம்) பற்றி பேச ஆரம்பித்தால், அவர்கள் ஒருவேளை உங்களை ஒரு வித்தியாசமான முறையில் பார்ப்பார்கள்.

உங்கள் சொந்த ஆலோசனையுடன் கண்மூடித்தனமாக குதிக்கும்முன், அறையை படிக்க எப்படி கற்பது என்பதிலிருந்து தொடங்கவும். அவ்வாறு செய்யும்போது, உங்கள் கருத்துக்கள் கவனிக்கப்பட்டு, கேட்கப்படும் வாய்ப்புகளை அதிகரிக்கிறது.

### திறந்த மூல திட்டத்தின் உடற்கூறியல்

ஒவ்வொரு திறந்த மூல சமூகமும் மாறுபட்டவை.

ஒரு திறந்த மூல திட்டத்தில் ஆண்டுகள் செலவழித்து நீங்கள் ஒரு திறந்த மூல திட்டத்தை அறிந்து கொள்ள முடிந்தது. வேறொரு திட்டத்திற்கு செல்லும் பொழுது, சொல்லகராதி, நெறிமுறைகள் மற்றும் தகவல்தொடர்பு பாணிகள் முற்றிலும் வேறுபட்டதாக காணலாம்.

பல திறந்த மூல திட்டங்கள் இதே அமைப்பு முறையை பின்பற்றின. வெவ்வேறு சமூகப் பணிகளைப் புரிந்துகொள்வது மற்றும் மொத்த செயல்முறை ஆகியவை எந்தவொரு புதிய திட்டத்திற்கும் விரைவாகப் பெற உதவும்.

ஒரு பொதுவான திறந்த மூல திட்டம் பின்வரும் வகையான மக்களைக் கொண்டுள்ளது:

* **படைப்பாளர்:** திட்டத்தை உருவாக்கிய நபர்/கள் அல்லது அமைப்பு
* **உரிமையாளர்:** அமைப்பு அல்லது களஞ்சியத்தில் நிர்வாக உரிமையுள்ள நபர்/கள்(எப்போதும் அசல் படைப்பாளர் அல்ல)
* **பராமரிப்பாளர்கள்:** திட்டத்தின் நோக்கம் மற்றும் நிறுவன அம்சங்களை நிர்வகிப்பதற்கும் பொறுப்புள்ள பங்களிப்பாளர்கள். (அவர்கள் திட்டத்தின் படைப்பாளர்கள் அல்லது உரிமையாளர்களாக இருக்கலாம்.)
* **பங்களிப்பாளர்கள்:** திட்டத்திற்கு ஏதேனும் பங்களித்த அனைவருக்கும்.
* **சமூக உறுப்பினர்கள்:** திட்டத்தை பயன்படுத்தும் மக்கள். அவர்கள் உரையாடலில், செயலில் அல்லது திட்டத்தின் திசையைப் பற்றி தங்கள் கருத்தை தெரிவிக்கலாம்.

பெரிய திட்டங்கள், உபகாரம், சமுதாயம் மிதமிடுதல் மற்றும் நிகழ்வு ஏற்பாடு போன்ற பல்வேறு பணிகளைக் கருத்தில் கொண்ட உப குழு அல்லது பணிக்குழுக்கள் இருக்கலாம். இந்தத் தகவலைக் கண்டறிய, ஒரு "குழு" பக்கத்திற்கான ஒரு திட்டத்தின் வலைத்தளத்தைப் பார்க்கவும், அல்லது ஆட்சி ஆவணத்திற்கான களஞ்சியத்தில் பாருங்கள்.

ஒரு திட்டத்தில் ஆவணங்களும் உள்ளன. இந்த கோப்புகள் வழக்கமாக ஒரு களஞ்சியத்தின் மேல் மட்டத்தில் பட்டியலிடப்பட்டுள்ளன.

* **உரிமம்(LICENSE):** வரையறையின்படி, ஒவ்வொரு திறந்த மூல திட்டமும் [திறந்த மூல உரிமத்தை](https://choosealicense.com) கொண்டிருக்க வேண்டும். திட்டத்திற்கு ஒரு உரிமம் இல்லை என்றால், அது திறந்த மூலம் அல்ல.
* **என்னைவாசி(README):** README என்பது புதிய சமூக உறுப்பினர்களை திட்டத்திற்கு வரவேற்கும் வழிமுறை கையேடு ஆகும். ஏன் திட்டம் பயனுள்ளதாக இருக்கும் மற்றும் எப்படி தொடங்குவது என இது விளக்குகிறது.
* **பங்களிப்பு(CONTRIBUTING):** READMEs மக்கள் உதவுகிறது திட்டத்தை _பயன்படுத்த_ உதவுகிறது, CONTRIBUTING ஆவணங்கள் திட்டத்திற்கு மக்கள் _பங்களிக்க_ உதவுகிறது. இது எவ்விதமான பங்களிப்புகள் தேவைப்படுகின்றன மற்றும் செயல்முறை எவ்வாறு செயல்படுகிறது என்பதையும் இது விளக்குகிறது. ஒவ்வொரு திட்டமும் ஒரு பங்களிப்புக் கோப்பில் இல்லை என்றாலும், அதன் இருப்பு சமிக்ஞைகள் இது பங்களிக்க ஒரு வரவேற்புத் திட்டம் ஆகும்.
* **நடத்தை_குறியீடு(CODE_OF_CONDUCT):** நடத்தை குறியீடு தொடர்புடைய பங்கேற்பாளர்கள் நடத்தை தர விதிகள் அமைக்கிறது மற்றும் ஒரு நட்பு, வரவேற்பு சூழலை எளிதாக்கும் உதவுகிறது. ஒவ்வொரு திட்டமும் CODE_OF_CONDUCT கோப்பைக் கொண்டிருக்கவில்லை என்றாலும், இது பங்களிப்பு செய்வதற்கான வரவேற்புத் திட்டம் என்று அதன் இருப்பு சமிக்ஞைகள் உள்ளன.
* **பிற ஆவணங்கள்:** பயிற்சிகள், மேலோட்டப்பார்வைகள் அல்லது ஆளுமைக் கொள்கை போன்ற கூடுதல் ஆவணங்கள் இருக்கலாம், குறிப்பாக பெரிய திட்டங்களில்.

இறுதியாக, திறந்த மூல திட்டங்கள் விவாதத்தை ஒழுங்கமைக்க பின்வரும் கருவிகளைப் பயன்படுத்துகின்றன. ஆவணக்கிடங்குகளை படித்தல் மூலம் சமூகம் எப்படி சிந்திக்கிறது மற்றும் வேலை செய்கிறது என அறிய முடியும்.

* **சிக்கல் தடமி(Issue tracker):** திட்டப்பணியுடன் தொடர்புடைய பிரச்சினைகளை மக்கள் விவாதிக்கும் இடம்.
* **இழு கோரிக்கைகள்(Pull requests):** முன்னேற்றத்தில் இருக்கும் மாற்றங்களை விவாதிக்கும் மற்றும் மதிப்பாய்வு செய்யுமிடம்.
* **கலந்துரையாடல் மன்றங்கள் அல்லது அஞ்சல் பட்டியல்கள்:** சில திட்டங்கள் இந்த உரையாடல்களை உரையாடல் தலைப்புகளில் பயன்படுத்தலாம் (எடுத்துக்காட்டாக, _"நான் எப்படி ..."_ அல்லது _"என்ன நினைக்கிறீர்கள் ..."_ பிழை அறிக்கைகள் அல்லது அம்ச கோரிக்கைகளுக்கு பதிலாக). மற்றவர்கள் எல்லா உரையாடல்களுக்கும் சிக்கல் தடமியை பயன்படுத்துகின்றனர்.
* **ஒத்திசைவு அரட்டை அலைத்தடம்:** சில திட்டங்கள் சாதாரண உரையாடல், ஒத்துழைப்பு, மற்றும் விரைவான பரிமாற்றங்களுக்கான அரட்டைத் தடங்களை (Slack அல்லது IRC போன்றவற்றை) பயன்படுத்துகின்றன.

## பங்களிக்க ஒரு திட்டத்தை கண்டறிதல்

இப்பொழுது திறந்த மூல திட்டங்கள் எப்படி இயங்குகின்றன என்பதை நீங்கள் அறிந்தீர்கள், இது பங்களிக்க ஒரு திட்டத்தை கண்டறியும் நேரம்!

நீங்கள் இதற்கு முன்னர் திறந்த மூலத்திற்கு பங்களித்திருக்கவில்லை எனில், அமெரிக்க ஜனாதிபதி ஜான் எஃப். கென்னடி சில ஆலோசனையை எடுத்துக் கொண்டால், "நாடு உங்களுக்கு என்ன செய்தது என்று கேட்காதீர்கள் - நீங்கள் நாட்டிற்கு என்ன செய்ய முடியும் என்று கேளுங்கள்."

திறந்த மூலத்திற்கான பங்களிப்பு, அனைத்து மட்டங்களிலும் திட்டங்கள்தோறும் நடக்கிறது. உங்களுடைய முதல் பங்களிப்பு என்னவாக இருக்கும், அல்லது அது எப்படி இருக்கும் என்பதை நீங்கள் அதிகம் ஆலோசனை செய்ய வேண்டியதில்லை.

அதற்கு பதிலாக, நீங்கள் ஏற்கனவே பயன்படுத்திய, அல்லது பயன்படுத்த விரும்பும் திட்டங்களை பற்றி யோசித்து தொடங்கவும். நீங்கள் தீவிரமாக பங்களித்த திட்டங்களை நீங்கள் திரும்பி வருகிறீர்கள்.

அந்த திட்டங்களுள், எப்போதாவது நீங்கள் ஏதாவது ஒன்றை சிறப்பாக அல்லது வித்தியாசமாக இருந்திருக்கலாம் என கருதுவீர்கள், உங்கள் உள்ளுணர்வு சொல்வதைக் கேட்டு செயல்படுங்கள்.

திறந்த மூலமானது ஒரு பிரத்யேக சங்கம் அல்ல; இது உங்களைப் போன்ற மக்கள் உருவாக்கியது. உலகின் பிரச்சினைகளை சரிசெய்யக்கூடிய வகையில் "திறந்த மூல" என்பது ஒரு கற்பனையான சொல்.

நீங்கள் ஒரு README ஐ ஸ்கேன் செய்து உடைந்த இணைப்பு அல்லது ஒரு தட்டச்சுப் பிழையை காணலாம். அல்லது நீங்கள் புதிய பயனராக இருக்கின்றீர்கள், நீங்கள் ஏதாவது உடைந்துவிட்டதா என்று கவனித்தீர்களா அல்லது ஒரு சிக்கல் ஆவணத்தில் இருக்க வேண்டும் என்று நீங்கள் நினைக்கிறீர்களா . அதை புறக்கணித்துவிட்டு, நகர்த்துவதற்கு அல்லது வேறு யாராவது அதை சரிசெய்வதற்குப் பதிலாக, நீங்கள் உந்துதல் மூலம் உதவ முடியுமா என்பதைப் பார்க்கவும்.

> திறந்த மூலத்திற்கான [28% தற்காலிக பங்களிப்புகள்](https://www.igor.pro.br/publica/papers/saner2016.pdf) ஒரு தட்டச்சுப் பிழை சரி செய்வது, மறுசீரமைப்பு அல்லது மொழிபெயர்ப்பு எழுதுதல் போன்ற ஆவணங்கள் ஆகும்.

நீங்கள் புதிய திட்டங்களை கண்டறிய மற்றும் பங்களிக்க உதவுவதற்கு பின்வரும் வளங்களில் ஒன்றைப் பயன்படுத்தலாம்:

* [கிட்ஹப் ஆராய்தல்](https://github.com/explore/)
* [திறந்த மூல வெள்ளிக்கிழமை](https://opensourcefriday.com)
* [முதல் முறையாளர்கள் மட்டுமே](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 இழு கோரிக்கைகள்](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [பங்களிப்பாளர்-நிஞ்ஜா](https://contributor.ninja)

### பங்களிக்கும் முன் ஒரு சரிபார்ப்புப் பட்டியல்

நீங்கள் பங்களிக்க விரும்பும் ஒரு திட்டத்தை நீங்கள் கண்டறிந்தால், பங்களிப்புகளை ஏற்றுக்கொள்வதற்கு திட்டம் பொருத்தமானதா என்பதை உறுதிப்படுத்த விரைவான ஆய்வு செய்யுங்கள். இல்லையெனில், உங்களுடைய கடின உழைப்பு ஒரு மறு மொழியை பெறாது.

ஒரு திட்டம் புதிய பங்களிப்பாளர்களுக்கு பொருத்தமானதா என்பதை மதிப்பீடு செய்வதற்கான ஒரு கையேடு பட்டியல்.

**திறந்த மூலத்தின் வரையறைகளை சந்திக்கிறது**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  அதற்கு ஒரு உரிமம் உள்ளதா? பொதுவாக, இது LICENSE எனப்படும் கோப்பு களஞ்சியத்தின் வேரில் உள்ளது.
  </label>
</div>

**திட்டம் தீவிரமாக பங்களிப்பை ஏற்றுக்கொள்கிறது**

master கிளையில் ஒப்படைப்பு செயல்களை பாருங்கள். கிட்ஹப்பில், இந்த தகவலை ஒரு களஞ்சியத்தின் முகப்புப்பக்கத்தில் காணலாம்.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  சமீபத்திய ஒப்படைப்பு செயல் எப்போது?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  திட்டத்தில் எத்தனை பங்களிப்பாளர்கள் உள்ளனர்?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  எத்தனை முறை மக்கள் ஒப்படைப்பு செய்கின்றனர்? (கிட்ஹப் மீது, நீங்கள் மேல் பட்டியில் "ஒப்படைப்புகள்" என்பதை கிளிக் செய்வதன் மூலம் இதை கண்டுபிடிக்க முடியும்.)
  </label>
</div>

அடுத்து, திட்டத்தின் சிக்கல்களை பாருங்கள்.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    எத்தனை திறந்த சிக்கல்களை உள்ளன?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    பராமரிப்பாளர்கள் சிக்கல்கள் திறந்திருக்கும் போது எவ்வளவு விரைவாக பதிலளிக்கிறார்கள்?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    சிக்கல்கள் குறித்து இயக்கத்திலுள்ள விவாதம் இருக்கிறதா?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    சிக்கல்கள் சமீபத்தியவையா?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    சிக்கல்கள் மூடப்பட்டுவிட்டனவா? (கிட்ஹப்பில், மூடப்பட்ட சிக்கல்களைக் காண, சிக்கல் பக்கத்தின் மீது "மூடப்பட்ட" தாவலைக் கிளிக் செய்யவும்.)
  </label>
</div>

இப்போது இதையே திட்டத்தின் இழு கோரிக்கைகளுக்கு செய்யுங்கள்.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    எத்தனை திறந்த இழு கோரிக்கைகள் உள்ளன?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    பராமரிப்பாளர்கள் இழு கோரிக்கைகள் திறந்திருக்கும் போது எவ்வளவு விரைவாக பதிலளிக்கிறார்கள்?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    இழு கோரிக்கைகள் குறித்து இயக்கத்திலுள்ள விவாதம் இருக்கிறதா?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    இழு கோரிக்கைகள் சமீபத்தியவையா?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    சமீபத்தில் ஏதேனும் இழு கோரிக்கைகள் இணைக்கப்பட்டனவா? (கிட்ஹப்பில், மூடிய PRs ஐ பார்க்க இழு கோரிக்கைகள் பக்கத்தில் "மூடிய" தாவலை கிளிக் செய்யவும்.)
  </label>
</div>

**திட்டம் வரவேற்க்கக்கூடியது**

நட்பு மற்றும் வரவேற்பு சமிக்ஞைகள் உள்ள ஒரு திட்டம், புதிய பங்களிப்பாளர்களுக்கு வரவேற்கும் பண்புடையதாகும்.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    சிக்கல்கள் குறித்த கேள்விகளுக்கு பராமரிப்பாளர்களுக்கு உதவுகிறார்களா?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    சிக்கல்கள், கலந்துரையாடல் மன்றம் மற்றும் அரட்டை (உதாரணமாக, IRC அல்லது Slack) இல் மக்கள் நட்புடன் உள்ளனரா?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    இழு கோரிக்கைகளை மீளாய்வு செய்யப்படுகின்றதா?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    பராமரிப்பாளர்கள் பங்களிப்புக்காக மக்களுக்கு நன்றி தெரிவிக்கிறார்களா?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  நீங்கள் ஒரு நீண்ட புரியை பார்க்கும் போதெல்லாம், உள்ளக மேம்பாட்டர்களின் பதில்களைத் தாமதமாக வருகின்றதா என பார்க்கவும். அவர்கள் ஆக்கபூர்வமாக சுருக்கமாகக் கூறுகிறார்களா, முடிவெடுப்பதற்கு நடவடிக்கை எடுக்கிறார்களா அதே வேளையில் பணிவுடன் இருக்கிறார்களா ? நீங்கள் அனல் பறக்கும் நிறையப் விவாதங்களை பார்த்தால், அது சக்தி வளர்ச்சிக்கு பதில் வாதத்திற்கு செல்லும் ஒரு அடையாளமாக இருக்கிறது.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_OSS உருவாக்குதல்_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## பங்களிப்பை எப்படி சமர்ப்பிக்க வேண்டும்

நீங்கள் விரும்பும் ஒரு திட்டத்தை நீங்கள் கண்டுபிடித்து, பங்களிப்பு செய்யத் தயாராக உள்ளீர்கள். இறுதியாக! இங்கே சரியான வழியில் உங்கள் பங்களிப்பு பெறுவது எப்படி.

### திறம்பட தொடர்பு கொள்ளுதல்

நீங்கள் ஒரு முறை பங்களிப்பாளராகவோ அல்லது சமூகத்தில் சேர முயற்சிக்கிறோமா, மற்றவர்களுடன் சேர்ந்து செயல்படுவது திறந்த மூலத்தில் நீங்கள் வளர்த்துக்கொள்ளும் மிக முக்கியமான திறமைகளில் ஒன்றாகும்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[புதிய பங்களிப்பாளராக,\] நான் சிக்கலை மூடிவிட முடிந்தால் நான் கேள்விகளைக் கேட்க வேண்டியிருந்ததை விரைவில் உணர்ந்தேன். நான் குறியீடு அடிப்படை மூலத்தை மேலோட்டமாய் படித்தேன். ஒரு முறை நடந்துகொண்டிருந்ததைப் பற்றி அறிந்து கொண்ட பிறகு, நான் மேலும் வழிகாட்டுதல் குறித்து கேட்டேன். மற்றும் voilà! எனக்கு தேவையான எல்லா விவரங்களையும் பெற்றுக் கொண்டபின் இந்த சிக்கலை தீர்க்க முடிந்தது .
  <p markdown="1" class="pquote-credit">
— @shubheksha, [திறந்த மூல உலகத்தின் மூலம் ஒரு தொடக்கநிலையாளரின் மிகவும் அதிரச்செய்கிற பயணம்](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

நீங்கள் ஒரு சிக்கலைத் திறக்க அல்லது கோரிக்கையை முன்வைக்க அல்லது அரட்டையில் ஒரு கேள்வியைக் கேட்க முன், இந்த நுட்பங்களை உங்கள் கருத்துக்களுக்கு திறம்பட உதவுவதற்காக மனதில் வைத்துக் கொள்ளுங்கள்.

**சூழ்நிலையை கொடுங்கள்.** விரைவாக மற்றவர்கள் வேகத்திற்கு வர உதவுங்கள். நீங்கள் ஒரு பிழையை கண்டீர்கள் என்றால், நீங்கள் என்ன செய்ய முயற்சிக்கிறீர்கள் என்பதை விளக்கவும், அதை எப்படி மீண்டும் செய்யலாம் என்பதை விளக்கவும். நீங்கள் ஒரு புதிய கருத்தை தெரிவித்திருந்தால், திட்டத்திற்கு பயனுள்ளதாக இருக்கும் என்று நீங்கள் ஏன் நினைக்கிறீர்கள் என்பதை விளக்குங்கள் (உங்களுக்கு மட்டுமல்ல!).

> 😇 _"நான் X செய்யும் போது Y நடக்கவில்லை"_
>
> 😢 _"X உடைந்ததுள்ளது! தயவுசெய்து அதை சரிசெய்யவும்."_

**முன்னதாக உங்களின் வீட்டுப்பாடம் செய்யுங்கள்.** விஷயங்களைத் தெரியாமல் இருப்பது தவறல்ல, ஆனால் நீங்கள் முயற்சித்ததைக் காட்டுங்கள். உதவி கேட்டு முன், ஒரு திட்டத்தின் README, ஆவணங்கள், சிக்கல்கள் (திறந்ததுள்ள அல்லது மூடப்பட்ட), அஞ்சல் பட்டியல், மற்றும் ஒரு பதிலை இணையத்தில் தேடுங்கள். நீங்கள் கற்றுக்கொள்ள முயற்சிக்கிறீர்கள் என்பதை நீங்கள் நிரூபிக்கும் போது மக்கள் பாராட்டுவார்கள்.

> 😇 _"X ஐ எவ்வாறு நடைமுறைப்படுத்துவது என்பது எனக்குத் தெரியவில்லை. உதவி ஆவணங்களை நான் சரிபார்த்தேன், எந்த குறிப்பும் இல்லை."_
>
> 😢 _"X ஐ எப்படி செய்வது??"_

**கோரிக்கைகளை சிறிது மற்றும் நேரடியாக வைத்திருங்கள்.** ஒரு மின்னஞ்சலை அனுப்புவது போல, ஒவ்வொரு பங்களிப்பும், எவ்வளவு எளிய அல்லது உதவிகரமாக இருந்தாலும், வேறொருவருடைய மதிப்பாய்வு தேவைப்படுகிறது. உதவக்கூடிய மக்களை விட பல திட்டங்கள் இன்னும் உள்வரும் கோரிக்கைகளை கொண்டிருக்கின்றன. சுருக்கமாக இருங்கள். மற்றவர்கள் யாராவது உங்களுக்கு உதவ முடியும் என்ற வாய்ப்பை அதிகரிக்க முடியும்.

> 😇 _"நான் ஒரு API பயிற்சி எழுத விரும்புகிறேன்."_
>
> 😢 _"நான் ஒரு நாள் நெடுஞ்சாலையில் வாகனம் ஓட்டி சென்று எரிவாயு நிறுத்தியபோது, பின்னர் நாம் செய்ய வேண்டும் என்ற இந்த அற்புதமான யோசனை இருந்தது, ஆனால் நான் அதை விளக்க முன், நான் உங்களுக்கு காண்பிக்க..."_

**எல்லா தகவல்தொடர்புகளையும் பொதுவில் வைக்கவும்.** Aஇது ஆவலைத் தூண்டும் என்றாலும், முக்கியமான தகவலை (பாதுகாப்புப் பிரச்சினை அல்லது கடுமையான நடத்தை மீறல் போன்றவை) பகிர்ந்து கொள்ளாதவரை தனிப்பட்ட முறையில் பராமரிப்பாளர்களை அடைய வேண்டாம். நீங்கள் உரையாடலை பொதுவில் வைத்திருக்கும்போது, அதிகமான மக்கள் உங்கள் பரிமாற்றத்திலிருந்து கற்றுக் கொள்ளலாம் மற்றும் நன்மை அடையலாம். கலந்துரையாடல்கள்கூட, பங்களிப்புகளாக இருக்கும்.

> 😇 _(ஒரு கருத்துரையாக) "@-maintainer ஹாய்! இந்த PR- ஐ எவ்வாறு தொடர வேண்டும்?"_
>
> 😢 _(ஒரு மின்னஞ்சலாக) "ஹாய், உங்களை மின்னஞ்சலில் தொந்தரவு செய்ய மன்னிக்கவும், ஆனால் என் PR ஐ மறுபரிசீலனை செய்வதற்கான வாய்ப்பைப் பெற்றிருக்கிறதா என அறிய ஆவலாய் இருக்கிறேன்"_

**கேள்விகளைக் கேட்பது பரவாயில்லை (ஆனால் பொறுமையாக இருங்கள்).** எல்லோரும் ஒரு கட்டத்தில் திட்டத்திற்கு புதியவர்களாவர், மேலும் அனுபவமிக்க பங்களிப்பாளர்கள் கூட ஒரு புதிய திட்டத்தை பார்க்கும்போது வேகத்தை அதிகரிக்க வேண்டும். அதே அறிகுறி மூலம், நீண்டகால பராமரிப்பாளர்கள் எப்போதும் திட்டத்தின் ஒவ்வொரு பகுதியையும் நன்கு அறிந்திருப்பதில்லை. அவர்களுக்கு நீங்கள் காட்ட விரும்பும் அதே பொறுமையைக் காட்டுங்கள்.

> 😇 _"இந்த பிழையை பார்த்ததற்கு நன்றி. நான் உங்கள் பரிந்துரைகளை பின்தொடர்ந்தேன். அதன் வெளிப்பாடு."_
>
> 😢 _"என் பிரச்சனையை நீங்கள் ஏன் சரிசெய்ய முடியாது? இது உங்கள் திட்டம்தானே?"_

**சமூகத்தின் முடிவுகளை மதித்தல்.** சமூகத்தின் முன்னுரிமைகள் அல்லது பார்வைகளில் இருந்து உங்கள் கருத்து வேறுபடலாம். அவர்கள் பின்னூட்டம் வழங்கலாம் அல்லது உங்கள் கருத்தைத் தொடரக்கூடாது என்று முடிவு செய்யலாம். நீங்கள் விவாதிக்க மற்றும் சமரசத்திற்குத் தேடும்போது, பராமரிப்பாளர்கள் உங்களுடைய முடிவைக் காட்டிலும் நீண்ட காலம் வாழ வேண்டும். நீங்கள் அவர்களின் திசையில் கருத்து வேறுபாடு கொண்டால், நீங்கள் எப்போதும் உங்கள் சொந்த கவையில் வேலை செய்யலாம் அல்லது உங்கள் சொந்த திட்டத்தை தொடங்கலாம்.

> 😇 _"நீங்கள் என் பயன்பாடு வழக்கை ஆதரிக்க முடியாது என்பது எனக்கு ஏமாற்றம் தான், ஆனால் நீங்கள் விளக்கிய பின்னர் அது ஒரு சிறிய பகுதியை பயனர்களையே பாதிக்கும், நான் ஏன் என்று புரிந்து கொண்டேன். கவனித்தமைக்கு நன்றி."_
>
> 😢 _"என் பயன்பாடு வழக்கு ஏன் நீங்கள் ஆதரிக்கவில்லை? இது ஏற்றுக்கொள்ள முடியாதது!"_

**எல்லாவற்றிற்கும் மேலாக, அது கம்பீரமானதாக வைத்துக்கொள்ளுங்கள்.** திறந்த மூல உலகம் முழுவதும் இருந்து கூட்டுப்பணியாளர்களால் உருவாக்கப்பட்டது. மொழிகள், கலாச்சாரங்கள், புவியியல், மற்றும் நேர மண்டலங்கள் ஆகியவற்றில் சூழல் தொலைந்து போகிறது. கூடுதலாக, எழுதப்பட்ட தொடர்பு ஒரு தொனியை அல்லது மனநிலையை வெளிப்படுத்த கடினமாக்குகிறது. இந்த உரையாடல்களில் நல்ல எண்ணங்களைக் கொள்ளுங்கள். ஒரு யோசனையை மனதுக்குள் தள்ளுவதே நல்லது, மேலும் சூழலைக் கேட்கவும் அல்லது உங்கள் நிலைப்பாட்டை மேலும் தெளிவுபடுத்தவும். இணையத்தை நீங்கள் கண்டறிந்ததைவிட சிறந்த இடத்தை விட்டு விட முயற்சி செய்யுங்கள்.

### சூழல் சேகரித்தல்

எதையும் செய்வதற்கு முன், உங்கள் யோசனை பிற இடங்களில் விவாதிக்கப்படவில்லை என்பதை உறுதிப்படுத்த விரைவாகச் சரிபார்த்துக் கொள்ளுங்கள். திட்டத்தின் README, சிக்கல்கள் (திறந்த மற்றும் மூடியது), அஞ்சல் பட்டியல் மற்றும் ஸ்டாக் ஓவர்ஃப்ளோ நீங்கள் எல்லாவற்றையும் நேரத்திற்கு செலவழிக்க வேண்டிய அவசியமில்லை, ஆனால் சில முக்கிய சொற்களுக்கு ஒரு விரைவான தேடல் நீண்ட தூரம் செல்கிறது.

வேறு எங்காவது உங்கள் யோசனை கண்டுபிடிக்க முடியாவிட்டால், நீங்கள் ஒரு நகர்வு செய்ய தயாராக இருக்கிறோம். திட்டம் கிட்ஹப்பில் இருந்தால், நீங்கள் ஒரு சிக்கலைத் திறப்பதன் மூலம்;

* **சிக்கல்கள்** ஒரு உரையாடல் அல்லது கலந்துரையாடலைத் தொடங்குகிறது
* **இழு கோரிக்கைகள்** ஒரு தீர்வைத் தொடங்குவதற்கான வேலைகள்
* **இலகுரக தகவல்கள்,** என்பது ஒரு தெளிவு பெறுவதோ அல்லது எப்படி கேள்வி கேட்கிறது என்று, திட்டத்தில் ஒன்று இருந்தால், ஸ்டேக் ஓவர்ஃப்ளோ, ஐஆர்சி, ஸ்லேக் அல்லது பிற அரட்டை சேனல்களை கேட்டு முயற்சி செய்யுங்கள்

நீங்கள் ஒரு சிக்கலைத் திறக்க அல்லது கோரிக்கையை முன்வைக்கும் முன், திட்டத்தின் பங்களிப்பு ஆவணங்களை (வழக்கமாக கோப்பினைக் குறிக்கும் CONTRIBUTING அல்லது README இல்) பார்க்கவும். உதாரணமாக, நீங்கள் ஒரு வார்ப்புருவை பின்தொடர வேண்டுமென அவர்கள் கேட்கலாம் அல்லது நீங்கள் சோதனையைப் பயன்படுத்த வேண்டும்.

நீங்கள் கணிசமான பங்களிப்பைச் செய்ய விரும்பினால், அதைத் தொடங்குவதற்கு முன் ஒரு சிக்கலைத் திறக்கவும். இது சிறிது நேரம் திட்டத்தைக் கவனிக்க உதவுகிறது (கிட்ஹப்பில், [நீங்கள் "கவனி" என்பதை கிளிக் செய்யலாம்](https://help.github.com/articles/watching-repositories/) அனைத்து உரையாடல்களையும் தெரியப்படுத்த வேண்டும்), மற்றும் சமுதாய உறுப்பினர்களை தெரிந்துகொள்ளுங்கள், ஏற்றுக்கொள்ள முடியாத வேலைகளை செய்வதற்கு முன்.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  நீங்கள் தீவிரமாக பயன்படுத்தும் ஒரு திட்டத்தில் இருந்து <em> நிறைய </em> கற்றுக் கொள்ளலாம், ஒவ்வொரு பிரச்சனையும் PR ஐப் படிக்கவும் அதை கிட்ஹப்பில் "கவனி"
<p markdown="1" class="pquote-credit">
— @gaearon [திட்டத்தில் சேர்வதற்கு](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### ஒரு சிக்கலைத் திறப்பது

பின்வரும் சூழ்நிலைகளில் நீங்கள் பொதுவாக ஒரு சிக்கலைத் திறக்க வேண்டும்:

* உங்களால் தீர்த்துவிடாத ஒரு பிழையை அறிக்கையிடவும்
* உயர்-நிலை தலைப்பு அல்லது கருத்தை (எடுத்துக்காட்டாக, சமூகம், பார்வை அல்லது கொள்கைகள்)
* ஒரு புதிய அம்சம் அல்லது பிற யோசனையை முன்மொழியுங்கள்

சிக்கல்கள் தொடர்பாக உதவிக்குறிப்புகள்:

* **நீங்கள் சமாளிக்க விரும்பும் திறந்த சிக்கலைக் கண்டால்,** நீங்கள் அதைப் பற்றி கருத்துரை கூறினால் மக்கள் நீங்கள் பணியாற்றுவதை அறிவர் . அந்த வழியில், உங்கள் வேலையை நகல் எடுப்பதற்கு மக்கள் குறைவாகவே இருப்பர்.
* **சிறிது காலமாக முன்பு ஒரு சிக்கல் திறந்திருந்தால்,** இது வேறு எங்காவது உரையாடப்பட்டிருக்கலாம் அல்லது ஏற்கெனவே தீர்மானிக்கப்பட்டுவிட்டது, எனவே வேலை செய்யத் தொடங்குவதற்கு முன் உறுதிப்படுத்திக்கொள்ளவும்.
* **நீங்கள் ஒரு சிக்கலைத் திறந்துவிட்டால், அதற்கு விடையை அறிந்திருந்தால்,** பிரச்சனையைப் பற்றி கருத்து தெரிவித்து, மக்களுக்குத் தெரியப்படுத்துங்கள். அந்த விளைவை ஆவணப்படுத்தியதும் கூட திட்டத்திற்கான பங்களிப்பாகும்.

### ஒரு இழு கோரிக்கையைத் திறத்தல்

வழக்கமாக பின்வரும் சூழல்களில் ஒரு இழு கோரிக்கை திறக்க வேண்டும்:

* எளிதான மாற்றங்களை சமர்ப்பிக்கவும் (எடுத்துக்காட்டாக, ஒரு தட்டச்சுப் பிழை, உடைந்த இணைப்பு அல்லது ஒரு வெளிப்படையான பிழை)
* ஏற்கெனவே கேட்டிருந்த ஒரு பங்களிப்பைத் தொடங்கவும் அல்லது ஒரு விவாதத்தில் ஏற்கனவே விவாதித்திருக்கவும்

ஒரு இழுப்பு கோரிக்கை முடிக்கப்பட்ட பணியை பிரதிநிதித்துவப்படுத்த வேண்டிய அவசியமில்லை. பொதுவாக ஒரு மிகுதிக் கோரிக்கையை திறக்க இது மிகவும் சிறந்தது, எனவே உங்கள் முன்னேற்றம் குறித்து மற்றவர்கள் பார்க்க அல்லது கருத்து தெரிவிக்கலாம். அதை ஒரு வரியில் "WIP" (செயலில் உள்ள வேலை) குறிக்கவும். நீங்கள் எப்போது வேண்டுமானாலும் சேர்க்கலாம்.

திட்டம் கிட்ஹப்பில் இருந்தால், இங்கே எப்படி ஒரு இழு கோரிக்கை சமர்ப்பிக்க வேண்டும்:

* **[களங்சியத்தை கவர்வழி](https://guides.github.com/activities/forking/)** மற்றும் அதை உள்நாட்டில் நகலெடுக்கவும். அசல் "பாய்வு மேற்புறம்(upstream)" களஞ்சியத்தை தொலைதூரமாக சேர்ப்பதன் மூலம் உங்கள் உள்ளூர் இணைப்பை இணைக்கவும். "பாய்வு மேற்புறத்தில்" இருந்து மாற்றங்களை இழுக்கவும், அதனால் நீங்கள் புதுப்பித்த நிலையில் இருப்பீர்கள், உங்கள் குறைநிரப்புக் கோரிக்கையைச் சமர்ப்பிக்கும் போது, மோதல்கள் குறைவாக இருக்கும். (மேலும் விரிவான விவரங்களுக்கு [இங்கே](https://help.github.com/articles/syncing-a-fork/) பார்க்கவும்.)
* **[கிளை ஒன்றை உருவாக்கவும்](https://guides.github.com/introduction/flow/)** உங்கள் திருத்தங்களுக்கு.
* **எந்தவொரு தொடர்படைய விடயங்களையும்** அல்லது ஆதரிக்கும் ஆவணங்களை உங்கள் PR இல் குறிப்பிடவும்(எடுத்துக்காட்டாக, "# 37 மூடுகிறது.")
* உங்கள் மாற்றங்கள் HTML / CSS இல் உள்ள வேறுபாடுகளை உள்ளடக்கியிருந்தால்,**அதற்கு முன்பும் பின்பும் திரைக்காட்சிகளையும் சேர்க்கவும்**. உங்கள் இழு கோரிக்கையின் உடலில் படங்களை இழுத்து விடுங்கள்.
* **உங்கள் மாற்றங்களைச் சோதிக்கவும்!** Rதேவைப்பட்டால் இருக்கும் எந்தவொரு சோதனைகளிலும் உங்கள் மாற்றங்களை இயக்கவும், புதியவற்றை உருவாக்கவும். சோதனைகள் இல்லையா அல்லது இல்லாவிட்டாலும், உங்கள் மாற்றங்கள் ஏற்கனவே இருக்கும் திட்டத்தை உடைக்கவில்லை என்பதை உறுதிப்படுத்திக் கொள்ளுங்கள்.
* **திட்டத்தின் பாணியில் பங்களிக்கவும்** உங்கள் சிறந்த திறமைகளை கொண்டு. இது உங்கள் சொந்த களஞ்சியத்தில் நீங்கள் விரும்பும் விடயங்களை விட வித்தியாசமாக உள்தள்ளல்கள், அரை-கோல்கன்கள் அல்லது கருத்துக்களைப் பயன்படுத்துவதாகும். ஆனால் எதிர்காலத்தில் மற்றவர்கள் புரிந்து கொள்ளவும், பராமரிக்கவும் பராமரிப்பாளரை எளிதாக்குகிறது.

இது உங்கள் முதல் இழு கோரிக்கை என்றால், [ஒரு இழு கோரிக்கை செய்ய](http://makeapullrequest.com/) பாருங்கள், ஒரு ஒத்திகையும் கற்றல் காணொலியும் @kentcdodds உருவாக்கியுள்ளார். நீங்கள் முதலில் [First Contributions](https://github.com/Roshanjossey/first-contributions) களஞ்சியத்தில் ஒரு இழுப்பு கோரிக்கையை உருவாக்கலாம், @Roshanjossey உருவாக்கியது.

## ஒரு பங்களிப்பை சமர்ப்பித்தபின் என்ன நடக்கிறது

நீங்கள் செய்தீர்கள்! திறந்த மூல பங்களிப்பாளராக வாழ்த்துக்கள். இது பலவற்றில் முதன்மையானது என்று நாங்கள் நம்புகிறோம்.

நீங்கள் ஒரு பங்களிப்பைச் சமர்ப்பித்த பின், பின்வரும் ஒன்று நடக்கும்:

### 😭 உங்களுக்கு பதில் கிடைக்கவில்லை.

ஒரு பங்களிப்பைச் செய்வதற்கு முன்னர் [செயற்பாட்டு அறிகுறிகளுக்கான திட்டத்தை சரிபார்க்க](#பங்களிக்கும்-முன்-ஒரு-சரிபார்ப்புப்-பட்டியல்). ஒரு செயல்கபடக்கூடுய திட்டத்தில் கூட, உங்கள் பங்களிப்பு ஒரு பதிலை பெறாது.

நீங்கள் ஒரு வாரத்திற்குள் பதிலைப் பெறவில்லை என்றால், மறுபரிசீலனைக்காக யாராவது கேட்டு, அதே பிரியில் மரியாதையுடன் பதிலளிப்பது நியாயமானது. உங்கள் பங்களிப்பை மதிப்பாய்வு செய்ய சரியான நபரின் பெயரை உங்களுக்குத் தெரிந்தால், நீங்கள் பிரியில் அவரை @-குறியிடலாம்.

** தனிப்பட்ட முறையில் அந்த நபரிடம் அடைய வேண்டாம்; பொதுத் தகவல்தொடர்பு மூலங்களை திறக்க முக்கியம் என்பதை நினைவில் கொள்ளுங்கள்.

நீங்கள் ஒரு கண்ணியமான கோரிக்கை செய்தால், இன்னும் யாரும் பதிலளிக்கவில்லை என்றால், எப்போதும் யாரும் பதிலளிக்க மாட்டார்கள். இது ஒரு பெரிய உணர்வு அல்ல, ஆனால் அதை நீங்கள் ஊக்கப்படுத்த வேண்டாம். இது அனைவருக்கும் நடந்தது! உங்கள் கட்டுப்பாட்டிலிரு ந்து வெளியேறக்கூடிய தனிப்பட்ட சூழ்நிலைகள் உட்பட, பதிலைப் பெறாததற்கு பல காரணங்கள் உள்ளன. பங்களிக்க மற்றொரு திட்டம் அல்லது வழி கண்டுபிடிக்க முயற்சி. ஏதாவது இருந்தால், இது மற்ற சமூக உறுப்பினர்கள் ஈடுபாடு மற்றும் பதிலளிக்கும் முன் ஒரு பங்களிப்பு செய்வதற்கு அதிக நேரத்தை முதலீடு செய்ய ஒரு நல்ல காரணம்.

### 🚧 உங்கள் பங்களிப்பில் யாரோ ஒருவர் மாற்றங்களைக் கோருகிறார்.

உங்கள் பங்களிப்புக்கு மாற்றங்களை செய்யும்படி கேட்கப்படும், இது உங்கள் யோசனையின் நோக்கம் பற்றிய கருத்து அல்லது உங்கள் குறியீட்டில் மாற்றம் கோரப்பபடபடலாம்.

யாராவது மாற்றங்களை கோரினால், பதிலளிக்க வேண்டும். உங்கள் பங்களிப்பை மதிப்பாய்வு செய்ய அவர்கள் நேரம் எடுத்துள்ளனர். ஒரு PR திறந்துவிட்டு பின்பு விட்டு விலகுவது மோசமானதாகும். மாற்றங்களைச் செய்ய உங்களுக்குத் தெரியாவிட்டால், சிக்கலை ஆராயுங்கள், உங்களுக்கு உதவி தேவைப்பட்டால் கேட்கவும்.

இனி பிரச்சினையில் வேலை செய்ய நேரம் இல்லை என்றால் (எடுத்துக்காட்டாக, உரையாடல் மாதங்களுக்கு நடக்கிறது என்றால், உங்கள் சூழ்நிலைகள் மாறிவிட்டன), பராமரிப்பாளர் அவர்கள் ஒரு பதிலை எதிர்நோக்குவதில்லை என்று தெரிந்து கொள்ளட்டும். வேறு யாராவது எடுத்துக்கொள்ள தயாராக இருக்கலாம்.

### 👎 உங்கள் பங்களிப்பு ஏற்றுக்கொள்ளப்படாது.

உங்கள் பங்களிப்பு இறுதியில் ஏற்றுக்கொள்ளப்படலாம் அல்லது ஏற்றுக்கொள்ளப்படாமல் இருக்கலாம். நீங்கள் ஏற்கனவே அதில் அதிக வேலை செய்யவில்லை. இது ஏன் ஏற்றுக்கொள்ளப்படவில்லை என்பதை உறுதியாக தெரியாவிட்டால், கருத்துரை மற்றும் தெளிவுபடுத்துதலுக்கான பராமரிப்பாளரைக் கேட்பது நியாயமானது. ஆனால் இறுதியில், இது அவர்களின் முடிவு என்று நீங்கள் மதிக்க வேண்டும். வாதிடாதீர்கள் அல்லது விரோதம் கொள்ள வேண்டாம். நீங்கள் கருத்து தெரிவிக்கிறீர்கள் என்றால், நீங்கள் எப்போது வேண்டுமானாலும் வரவேற்பைப் பெறுவீர்கள்.

### 🎉 உங்கள் பங்களிப்பு ஏற்றுக்கொள்ளப்பட்டது..

ஓஹோ! திறந்த மூல பங்களிப்பை வெற்றிகரமாகச் செய்துள்ளீர்கள்!

## நீங்கள் செய்தீர்கள்!

உங்கள் முதல் திறந்த மூல பங்களிப்பை நீங்கள் செய்திருந்தாலும் அல்லது பங்களிக்க புதிய வழிகளைத் தேடுகிறீர்களோ இல்லையோ,நீங்கள் நடவடிக்கை எடுக்க ஈர்க்கப்பட்டிருப்பதாக நம்புகிறோம். உங்கள் பங்களிப்பு ஏற்றுக்கொள்ளப்படவில்லை என்றால், ஒரு பராமரிப்பாளர் உங்களுக்கு உதவ முயற்சிக்கும் போது நன்றி சொல்ல மறக்காதீர்கள். திறந்த மூல உங்களைப் போன்ற நபர்களால் செய்யப்படுகிறது: ஒரு சிக்கல், கோரிக்கையை, கருத்துரை அல்லது high-five (வெற்றியைக் கொண்டாட இருவர், தங்கள் உள்ளங்கைகளை மேலே தூக்கித் தட்டிக்கொள்ளுதல்).
