---
lang: ro
title: Cum să fii plătit pentru muncă open source
description: Susține-ți munca în open source obținând sprijin financiar pentru timpul sau proiectul tău.
class: getting-paid
toc:
  why-some-people-seek-financial-support: "De ce unii oameni caută sprijin financiar"
  funding-your-own-time: "Finanțarea propriului tău timp"
  finding-funding-for-your-project: "Găsirea de finanțare pentru proiectul tău"
  building-a-case-for-financial-support: "Construirea unui caz pentru sprijin financiar"
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## De ce unii oameni caută sprijin financiar

O mare parte din munca open source este voluntară. De exemplu, cineva ar putea da peste un bug într-un proiect pe care îl folosește și să trimită o reparație rapidă, sau ar putea să se bucure să meșterească pe un proiect cu sursă deschisă în timpul său liber.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
  <p>
    Căutam un proiect de programare ca „hobby” care să mă țină ocupat în săptămâna din jurul Crăciunului. (...) Aveam un calculator acasă, și nu mai mult în mâinile mele. Am decis să scriu un interpretor pentru noul limbaj de scripting la care mă gândeam în ultimul timp. (...) Am ales Python ca un titlu de lucru.
  </p>  
  <p>
    <em>
      I was looking for a "hobby" programming project that would keep me occupied during the week around Christmas. (...) I had a home computer, and not much else on my hands. I decided to write an interpreter for the new scripting language I had been thinking about lately. (...) I chose Python as a working title.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Există multe motive pentru care o persoană nu ar dori să fie plătită pentru munca ei open source.

* **Este posibil ca ea să aibă deja un loc de muncă cu normă întreagă pe care îl iubește,** ceea ce îi permite să contribuie la open source în timpul liber.
* **Ea se bucură de a gândi la open source ca la un hobby** sau ca despre o evadare creativă și nu vrea să se simtă obligată financiar să lucreze pe proiectele sale.
* **Ea obține alte beneficii de la contribuirea pe open source,** cum ar fi construirea reputației sau a portofoliului său, învățarea de noi abilități, sau se simte mai aproape de comunitate.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  <p>
    Donațiile financiare adaugă un sentiment de resposabilitate, pentru unii. (...) Este important pentru noi, în lumea global conectată, rapidă în care trăim, să putem spune „nu acum, simt că îmi doresc să fac ceva complet diferit”.
  </p>
  <p>
    <em>
      Financial donations do add a feeling of responsibility, for some. (...) It's important for us, in the globally connected, fast-paced world we live in, to be able to say "not now, I feel like doing something completely different".
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @alloy, ["Why We Don't Accept Donations"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Pentru alții, în special când contribuțiile sunt în curs de desfășurare sau necesită timp semnificativ, a fi plătiți să contribuie la open source este singura cale în care ei pot participa, fie fiindcă proiectul cere asta, fie din motive personale.

Întreținerea de proiecte populare poate fi o responsabilitate semnificativă, luând până la 10 sau 20 de ore pe săptămână în loc de câteva ore pe lună.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  <p>
    Întreabă oricare întreținător de proiect cu sursă deschisă, și el îți va spune de realitatea cantității de muncă ce merge în gestionarea unui proiect. Ai clienți. Rezolvi probleme pentru ei. Creezi noi facilități. Aceasta devine o reală cerere din timpul tău.
  </p>
  <p>
    <em>
      Ask any open source project maintainer, and they will tell you about the reality of the amount of work that goes into managing a project. You have clients. You are fixing issues for them. You are creating new features. This becomes a real demand on your time.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["The Ethics of Unpaid Labor and the OSS Community"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Munca plătită de asemenea dă șanse oamenilor cu diferite moduri de viață să facă contribuții semnificative. Unii oameni nu-și pot permite să petreacă timp neplătit pe proiecte cu sursă deschisă, bazat pe poziția lor financiară curentă, datorii, sau familie sau alte obligații de îngrijire. Aceasta înseamnă că lumea nu ajunge niciodată să vadă contribuții de la oameni talentați care nu-și pot permite să facă voluntariat cu timpul lor. Aceasta are implicații etice, după cum @ashedryden [a descris](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), fiindcă munca făcută este părtinitoare în favoarea acelora care deja au avantaje în viață, care apoi obțin avantaje în plus bazate pe contribuțiile lor voluntare, în timp ce alții care nu sunt capabili să facă voluntariat apoi nu mai primesc oportunitați mai încolo, ceea ce consolidează lipsa de diversitate din prezent în comunitatea open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
  <p>
    OSS oferă beneficii masive industriei tehnologice, care, în schimb, înseamnă beneficii pentru toate industriile. (...) Totuși, dacă singurii oameni care se pot concentra pe ea sunt norocoșii și obsedații, atunci există un potențial gigantic neexploatat.
  </p>
  <p>
    <em>
      OSS yields massive benefits to the technology industry, which, in turn, means benefits to all industries. (...) However, if the only people who can focus on it are the lucky and the obsessed, then there's a huge untapped potential.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Money and Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Dacă ești în căutare de sprijin financiar, există două căi pe care să le consideri. Îți poți finanța propriul timp în calitate de contributor, sau poți găsi finanțare organizațională pentru proiect.

## Finanțarea propriului tău timp

Astăzi, mulți oameni sunt plătiți să lucreze cu normă parțială sau întreagă pe open source. Cea mai obișnuită modalitate de a fi plătit pentru timpul tău este să vorbești cu angajatorul tău.

Este mai ușor să faci un caz pentru muncă open source dacă angajatorul tău folosește de fapt proiectul, dar devino creativ cu pasul tău. Poate angajatorul tău nu folosește proiectul, dar el folosește Python, și întreținerea unui proiect popular Python ajută la atragerea de noi dezvoltatori Python. Poate îl face pe angajatorul tău să arate mai prietenos cu dezvoltatorii în general.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/hzoo?s=180" class="pquote-avatar" alt="avatar">
  <p>
    La fel ca mulți în open source, mă luptam cu povara de a întreține un proiect. Când am început prima dată să fac open source, obișnuiam doar să stau până târziu la muncă pe asta sau chiar când ajungeam acasă. (...) Puteam să discut cu șeful meu despre problemele cu care mă confruntam și noi am venit cu idei despre cum am putea să încorporăm sarcini open source dată fiind propria noastră utilizare Babel.
  </p>
  <p>
    <em>
      Like many in open source, I was struggling with the burden of maintaining a project. When I first started doing open source, I used to just stay late to work on it or right when I got home. (...) I was able to discuss with my boss the issues I was facing and we came up with ideas on how we could incorporate open source tasks given our own use of Babel.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @hzoo, ["Maintainer Stories"](https://github.com/open-source/stories/hzoo)
  </p>
</aside>

Dacă nu ai un proiect cu sursă deschisă existent pe care ți-ar plăcea să lucrezi, dar preferi ca să se deschidă sursa rezultatelor muncii tale curente, fă un caz pentru angajatorul tău să deschidă sursa unei părți din software-urile sale interne.

Multe companii dezvoltă programe open source pentru a-și construi marca și a recruta talent de calitate.

@hueniverse, de exemplu, a constatat că există motive financiare pentru a justifica [investiția Walmart în open source](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). Și @jamesgpearce a constatat că programul open source al Facebook [a făcut o diferență](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) în recrutare:

> Este strâns aliniată cu cultura noastră a hackerilor, și cu felul în care organizația noastră a fost percepută. Ne-am întrebat angajații, „Ai fost conștient de programul software open source la Facebook?”. Două treimi au zis „Da”. O jumătate a zis că programul a contribuit în mod pozitiv la decizia de a lucra pentru noi. Acestea nu sunt numere marginale, ci, sper eu, o tendință care continuă.
> 
> It is closely aligned with our hacker culture, and how our organization was perceived. We asked our employees, "Were you aware of the open source software program at Facebook?". Two-thirds said "Yes". One-half said that the program positively contributed to their decision to work for us. These are not marginal numbers, and I hope, a trend that continues.

Dacă compania ta coboară pe acest traseu, este important să păstrezi granițele între comunitate și activitatea corporativă clare. În fine, open source se susține pe sine prin contribuții de la oameni din întreaga lume, și aceasta este mai mare decât oricare companie sau locație.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  <p>
    A fi plătit să lucrezi pe open source este o oportunitate rară și minunată, dar nu ar trebui să fie necesar să renunți la pasiunea ta în proces. Pasiunea ta ar trebui să fie motivul pentru care companiile vor să te plătească.
  </p>
  <p>
    <em>
      Getting paid to work on open source is a rare and wonderful opportunity, but you should not have to give up your passion in the process. Your passion should be why companies want to pay you.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Dacă nu îți poți convinge angajatorul curent să acorde prioritate muncii open source, consideră să găsești un nou angajator care încurajează contribuțiile angajaților la open source. Caută companii care își fac dedicarea la munca open source în mod explicit. De exemplu:

* Unele companii, cum ar fi [Netflix](https://netflix.github.io/) sau [PayPal](https://paypal.github.io/), au site-uri web care evidențiază implicarea lor în open source
* [Rackspace](https://www.rackspace.com/en-us) și-a publicat [politica de contribuire la open source](https://blog.rackspace.com/rackspaces-policy-on-contributing-to-open-source/) pentru angajați

Proiectele care provin de la o companie mare, cum ar fi [Go](https://github.com/golang) sau [React](https://github.com/facebook/react), probabil vor angaja de asemenea oameni să lucreze pe open source.

În funcție de circumstanțele tale personale, poți încerca să strângi bani în mod independent pentru a-ți finanța munca open source. De exemplu:

* @gaearon și-a finanțat munca pe [Redux](https://github.com/reactjs/redux) printr-o [campanie de finanțare colectivă Patreon](https://redux.js.org/)
* @andrewgodwin a finanțat munca pe migrațiile de scheme Django [printr-o campanie Kickstarter](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

În cele din urmă, uneori proiectele cu sursă deschisă pun recompense pe probleme la care ai putea considera să ajuți.

* @ConnorChristie a putut să fie plătită pentru că [a ajutat](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) @MARKETProtocol să lucreze pe biblioteca lor JavaScript [printr-o recompensă pe gitcoin](https://gitcoin.co/).
* @mamiM a făcut traduceri în japoneză pentru @MetaMask după ce [problema a fost finanțată pe Bounties Network](https://explorer.bounties.network/bounty/134).

## Găsirea de finanțare pentru proiectul tău

Dincolo de aranjamente pentru contributori individuali, uneori proiectele strâng bani de la companii, indivizi, sau alții pentru a finanța muncă în derulare.

Finanțarea organizațională ar putea să vină în favoarea contributorilor actuali, acoperind costurile de derulare a proiectului (cum ar fi taxe de găzduire), sau în favoarea investirii în noi facilități și idei.

Pe măsură ce popularitatea open source crește, a găsi finanțare pentru proiecte este încă experimental, dar există câteva opțiuni comune disponibile.

### Strângerea de bani pentru munca ta prin campanii de finanțare colectivă sau sponsorizări

Găsirea sponsorizărilor funcționează bine dacă ai deja un public puternic sau o reputație puternică, sau dacă proiectul tău este foarte popular.
Câteva exemple de proiecte sponsorizate includ:

* **[webpack](https://github.com/webpack)** strânge bani de la companii și indivizi [prin OpenCollective](https://opencollective.com/webpack)
* **[Vue](https://github.com/vuejs/vue)** este [finanțat prin Patreon](https://github.com/open-source/stories/yyx990803)
* **[Ruby Together](https://rubytogether.org/),** o organizație nonprofit care plătește pentru munca pe [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), și alte proiecte de infrastructură Ruby

### Creează un flux de venit

Depinzând de proiectul tău, ai putea să taxezi sprijin comercial, opțiuni de găzduire, sau facilități în plus. Câteva exemple includ:

* **[Sidekiq](https://github.com/mperham/sidekiq)** oferă versiuni plătite pentru asistență în plus
* **[Travis CI](https://github.com/travis-ci)** oferă versiuni plătite ale produsului său
* **[Ghost](https://github.com/TryGhost/Ghost)** este un nonprofit cu un serviciu gestionat plătit

Unele proiecte populare, cum ar fi [npm](https://github.com/npm/npm) și [Docker](https://github.com/docker/docker), chiar strâng capital de risc pentru a susține creșterea afacerii lor.

### Aplicați pentru finanțare nerambursabilă

Unele fundații software și companii oferă subvenții pentru muncă pe sursă deschisă. Uneori, subvențiile pot fi plătite către indivizi fără să se stabilească o entitate juridică pentru proiect.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** a primit o subvenție de la [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/)
* Munca **[OpenMRS](https://github.com/openmrs)** a fost finanțată de [Open-Source Retreat al Stripe](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** a primit o subvenție de la [Fundația Sloan](https://sloan.org/programs/digital-technology)
* **[Python Software Foundation](https://www.python.org/psf/grants/)** oferă subvenții pentru muncă legată de Python

Pentru mai multe opțiuni detaliate și studii de caz, @nayafia [a scris un ghid](https://github.com/nayafia/lemonade-stand) pentru a deveni plătit pentru muncă pe sursă deschisă. Diferite tipuri de finanțare necesită abilități diferite, deci consideră-ți punctele forte pentru a afla care opțiune funcționează cel mai bine pentru tine.

## Construirea unui caz pentru sprijin financiar

Fie că proiectul tău este o idee nouă, fie că a fost prin preajmă de ani, ar trebui să te aștepți să pui gândire semnificativă în identificarea finanțatorului tău țintă și să faci un caz convingător.

Fie că ești în căutare să plătești pentru propriul tău timp, fie ca să strângi fonduri pentru un proiect, ar trebui să fii capabil să răspunzi la următoarele întrebari.

### Impact

De ce este acest proiect folositor? De ce utilizatorii tăi, sau utilizatori potențiali, îl plac atât de mult? Unde va fi el în cinci ani?

### Tracțiune

Încearcă să colectezi dovezi că proiectul tău contează, fie că sunt măsurători, anecdote, sau mărturii. Există companii sau oameni remarcabili care îți folosesc proiectul chiar acum? Dacă nu, l-a susținut o persoană importantă?

### Valoare finanțatorului

Finanțatorii, fie că este angajatorul tău sau o fundație de finanțare, sunt deseori abordați cu oportunități. De ce ar trebui să susțină ei proiectul tău deasupra oricărei alte oportunitați? Cum beneficiază ei personal?

### Folosirea fondurilor

Ce, mai exact, vei reuși cu finanțarea propusă? Concentrează-te pe etapele de proiect sau rezultate mai degrabă decât pe plătirea unui salariu.

### Cum vei primi fondurile

Are finanțatorul vreo cerință în legătură cu plata? De exemplu, ar putea să fie necesar să fii o organizație nonprofit sau să ai un sponsor fiscal nonprofit. Sau poate fondurile trebuie date unui contractant individual în loc de o organizație. Aceste cerințe variază între finanțatori, deci asigură-te că îți faci cercetarea în prealabil.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  <p>
    De ani de zile, am fost resursa principală a pictogramelor prietenoase pentru site-uri web, cu o comunitate de peste 20 de milioane de oameni și am fost recomandați pe mai mult de 70 de milioane de site-uri web, inclusiv Whitehouse.gov. (...) Versiunea 4 a fost acum 3 ani. Tehnologiile web s-au schimbat mult de atunci, și sincer, Font Awesome a devenit puțin învechit. (...) De aceea introducem Font Awesome 5. Modernizăm și rescriem CSS-ul și reproiectăm fiecare pictogramă de la cap la coadă. Vorbim de aspect mai bun, consistență mai bună, și lizibilitate mai bună.
  </p>
  <p>
    <em>
      For years, we've been the leading resource of website friendly icons, with a community of over 20 million people and been featured on over 70 million websites, including Whitehouse.gov. (...) Version 4 was three years ago. Web tech's changed a lot since then, and frankly, Font Awesome's gotten a bit stale. (...) That's why we're introducing Font Awesome 5. We're modernizing and rewriting the CSS and redesigning every icon from top to bottom. We're talking better design, better consistency, and better readability.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @davegandy, [video-ul Kickstarter al Font Awesome](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Experimentează și nu renunța

A strânge bani nu este ușor, fie că ai un proiect cu sursă deschisă, o organizație nonprofit, sau un startup software, și în cele mai multe cazuri trebuie să fii creativ. Identificând cum vrei să fii plătit, făcându-ți cercetarea, și punându-te pe tine însuți în pantofii finanțatorului te vor ajuta să construiești un caz convingător pentru finanțare.
