---
lang: ro
title: Găsirea de utilizatori pentru proiectul tău
description: Ajută-ți proiectul cu sursă deschisă să crească punându-l în mâinile utilizatorilor fericiți.
class: finding
toc:
  spreading-the-word: "Răspândirea cuvântului"
  figure-out-your-message: "Găsește-ți mesajul"
  help-people-find-and-follow-your-project: "Ajută oamenii să-ți găsească și să-ți urmeze proiectul"
  go-where-your-projects-audience-is-online: "Mergi acolo unde este audiența proiectului tău (online)"
  go-where-your-projects-audience-is-offline: "Mergi acolo unde este audiența proiectului tău (offline)"
  build-a-reputation: "Construiește-ți o reputație"
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Răspândirea cuvântului

Nu există o regulă care spune că trebuie să-ți promovezi proiectul cu sursă deschisă când îl lansezi. Există multe motive împlinitoare de a lucra în open source care nu au nimic de a face cu popularitatea. În loc să speri că alții vor găsi și vor folosi proiectul tău cu sursă deschisă, trebuie să răspândești cuvântul despre munca ta grea!

## Găsește-ți mesajul

Înainte de a începe activitatea propriu-zisă de promovare a proiectului tău, ar trebui să poți să explici ce face, și de ce contează.

Ce face proiectul tău diferit sau interesant? De ce l-ai creat? Răspunzându-ți ție la aceste întrebări te va ajuta să comunici semnificația proiectului tău.

Ține minte că oamenii se implică în calitate de utilizatori, și eventual devin contributori, deoarece proiectul tău rezolvă o problemă pentru ei. Pe măsură ce te gândești la mesajul și valoarea proiectului tău, încearcă să le vezi prin lentilele a ceea ce ar putea vrea _utilizatorii și contributorii_.

De exemplu, @robb folosește exemple de cod pentru a comunica clar de ce proiectul lui, [Cartography](https://github.com/robb/Cartography), este folositor:

![README Cartography](/assets/images/finding-users/cartography.jpg)

Pentru o vedere mai adâncă în mesagerie, aruncă o privire la exercițiul ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) al Mozilla pentru dezvoltarea persona-urilor pentru utilizatori.

## Ajută oamenii să-ți găsească și să-ți urmeze proiectul

<aside markdown="1" class="pquote">
  <p>
    În mod ideal, ai nevoie de un singurl URL „acasă” pe care îl poți promova și indica oamenilor în legătură cu proiectul tău. Nu trebuie să folosești un șablon extravagant sau chiar un nume de domeniu, dar proiectul tău are nevoie de un punct focal.
  </p>
  <p>
    <em>
      You ideally need a single "home" URL that you can promote and point people to in relation to your project. You don't need to splash out on a fancy template or even a domain name, but your project needs a focal point.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Ajută oamenii să îți găsească și să îți țină minte proiectul direcționându-i către un singur domeniu.

**Obține un mâner clar pentru a-ți promova munca.** Un mâner Twitter, un URL GitHub, sau canal IRC este un mod ușor de a direcționa oamenii către proiectul tău. Aceste prize oferă de asemenea comunității în creștere a proiectului tău un loc de convocare.

Dacă nu dorești să configurezi prize pentru proiectul tău încă, promovează-ți propriul tău mâner Twitter sau GitHub în orice faci. Promovarea mânerului tău Twitter sau GitHub va înștiința oamenii cum să te contacteze sau să-ți urmeze munca. Dacă vorbești la o întâlnire sau un eveniment, asigură-te că informațiile tale de contact sunt incluse în biografia ta sau în diapozitive.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  <p>
    O greșeală pe care am făcut-o în acele zile timpurii (...) a fost să nu încep un cont Twitter pentru proiect. Twitter este o modalitate excelentă de a ține oamenii la curent cu privire la un proiect precum și de a expune constant oameni la proiect.
  </p>
  <p>
    <em>
      A mistake I made in those early days (...) was not starting a Twitter account for the project. Twitter's a great way to keep people up to date about a project as well as constantly expose people to the project.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Consideră crearea unui site web pentru proiectul tău.** Un site web face proiectul tău mai prietenos și mai ușor de navigat, în special când este cuplat cu documentație și tutoriale clare. Având un site web sugerează de asemenea că proiectul tău este activ ceea ce îți va face publicul să se simtă mai confortabil folosindu-l. Furnizează exemple pentru a oferi oamenilor idei despre cum să folosească proiectul tău.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), co-creator al Django, a spus că un site web era _„de departe cel mai bun lucru pe care l-am făcut cu Django în primele zile”_.

Dacă proiectul tău este găzduit pe GitHub, poți folosi [GitHub Pages](https://pages.github.com/) pentru a face cu ușurință un site web. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), și [Middleman](https://middlemanapp.com/) sunt [câteva exemple](https://github.com/showcases/github-pages-examples) de site-uri web excelente, cuprinzătoare.

![pagina de pornire Vagrant](/assets/images/finding-users/vagrant_homepage.png)

Acum că ai un mesaj pentru proiectul tău, și o cale ușoară pentru oameni să-ți găsească proiectul, haide să mergem acolo și să vorbim cu publicul!

## Mergi acolo unde este audiența proiectului tău (online)

Extinderea online este o modalitate excelentă de a împărtăși și răspândi cuvântul mai repede. Utilizând canale online, ai potențialul de a ajunge la un public foarte larg.

Profită de comunitățile online și platformele existente pentru a ajunge la publicul tău. Dacă proiectul tău open source este un proiect software, probabil îți poți găsi publicul pe [Stack Overflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/), sau [Quora](https://www.quora.com/). Găsește canalele unde tu crezi că oamenii vor beneficia cel mai mult de munca ta sau vor fi cei mai încântați de munca ta.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  <p>
    Fiecare program are facilități foarte specifice pe care doar o fracțiune din utilizatori le va găsi folositoare. Nu spam-ui cât poți de mulți oameni. În schimb, țintește-ți eforturile înspre comunități care vor beneficia de a ști de proiectul tău.
  </p>
  <p>
    <em>
      Each program has very specific functions that only a fraction of users will find useful. Don't spam as many people as possible. Instead, target your efforts to communities that will benefit from knowing about your project.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Vezi dacă poți găsi metode relevante de a-ți împărtăși proiectul:

* **Fă cunoștință cu proiecte și comunități open source relevante.** Câteodată, nu trebuie să îți promovezi direct proiectul. Dacă proiectul tău este perfect pentru cercetători de date care folosesc Python, fă cunoștință cu comunitatea de știința datelor în Python. Pe măsură ce oamenii fac cunoștință cu tine, oportunități naturale vor răsări pentru a vorbi despre și a-ți împărtăși munca.
* **Găsește oameni care experimentează problema pe care proiectul tău o rezolvă.** Caută prin forumuri similare oameni care intră în publicul țintă al proiectului tău. Răspunde la întrebarea lor și găsește o cale cu tact, când este adecvat, pentru a-ți sugera proiectul ca o soluție.
* **Cere feedback.** Introdu-te și introdu-ți munca ta unui public care ar găsi-o relevantă și interesantă. Fii specific despre cine crezi că ar beneficia de pe urma proiectului tău. Încearcă să completezi enunțul: _„Cred că proiectul meu l-ar putea ajuta cu adevărat pe X, care încearcă să facă Y”_. Ascultă și răspunde la feedback-ul altora, în loc să-ți promovezi pur și simplu munca.

În general vorbind, concentrează-te pe a ajuta pe alții înainte de a cere lucruri în schimb. Deoarece oricine poate promova ușor un proiect online, va exista mult zgomot. Pentru a ieși din mulțime, dă oamenilor context în legătură cu cine ești și nu doar ce vrei.

Dacă nimeni nu acordă atenție sau nu răspunde la mobilizarea ta inițială, nu te descuraja! Cele mai multe lansări de proiecte sunt un proces iterativ care poate lua luni sau ani. Dacă nu primești un răspuns prima dată, încearcă o tactică diferită, sau caută modalități de a adăuga valoare la munca celorlalți întâi. Promovarea și lansarea unui proiect necesită timp și dedicare.

## Mergi acolo unde este audiența proiectului tău (offline)

![Vorbind în public](/assets/images/finding-users/public_speaking.jpg)

Evenimentele offline sunt o modalitate populară de a promova noi proiecte publicurilor. Ele sunt o cale excelentă de a ajunge la un public angajat și de a construi conexiuni umane mai profunde, în special dacă ești interesat în a ajunge la dezvoltatori.

Dacă ești [începător la vorbitul în public](https://speaking.io/), începe prin a găsi o întâlnire locală care are o legătură cu limbajul sau ecosistemul proiectului tău.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  <p>
    Eram destul de nervoasă în legătură cu a merge la PyCon. Urma să țin un discurs, știam doar pe câțiva oameni acolo, mergeam acolo pentru o săptămână întreagă. (...) Nu trebuia să mă îngrijorez, totuși. PyCon a fost fenomenal de grozav! (...) Toată lumea era incredibil de prietenoasă și liberă, atât de mult încât rar am găsit timp să nu vorbesc cu oameni!
  </p>
  <p>
    <em>
      I was pretty nervous about going to PyCon. I was giving a talk, I was only going to know a couple of people there, I was going for an entire week. (...) I shouldn't have worried, though. PyCon was phenomenally awesome! (...) Everyone was incredibly friendly and outgoing, so much that I rarely found time not to talk to people!
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Dacă nu ai vorbit niciodată la un eveniment înainte, este perfect normal să te simți nervos! Ține minte că publicul tău este acolo deoarece ei sincer își doresc să audă despre munca ta.

Pe măsură ce-ți scrii discursul, concentrează-te pe ce va găsi interesant publicul tău și din ce va obține valoare. Păstrează-ți limbajul prietenos și abordabil. Zâmbește, respiră, și distrează-te.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  <p>
    Când începi să-ți scrii primul discurs, indiferent de care este subiectul tău, te poate ajuta să-ți vezi discursul ca pe o poveste pe care o spui oamenilor.
  </p>
  <p>
    <em>
      When you start writing your talk, no matter what your topic is, it can help if you see your talk as a story that you tell people.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Când te simți pregătit, consideră a vorbi la o conferință pentru a-ți promova proiectul. Conferințele te pot ajuta să ajungi la mai mulți oameni, câteodată din toate colțurile lumii.

Caută conferințe care sunt specifice limbajului sau ecosistemului tău. Înainte de a-ți trimite discursul, cercetează conferința pentru a-ți adapta discursul pentru participanți și a-ți mări șansele de a fi acceptat să vorbești la conferință. Deseori poți obține un simț al publicului tău privind vorbitorii conferinței.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  <p>
    Am scris foarte drăguț către oamenii de la JSConf și i-am implorat să-mi dea o bucată de timp în care aș fi putut să-l prezint la JSConf EU. (...) Eram extrem de speriat, prezentând acest lucru pe care lucram de șase luni. (...) Tot timpul doar mă gândeam, o Doamne. Ce fac aici?
  </p>
  <p>
    <em>
      I wrote very nicely to the JSConf people and begged them to give me a slot where I could present it at JSConf EU. (...) I was extremely scared, presenting this thing that I had been working on for six months. (...) The whole time I was just thinking, oh my God. What am I doing here?
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Construiește-ți o reputație

Pe lângă strategiile schițate mai sus, cea mai bună cale de a invita oameni să împărtășească și să contribuie la proiectul tău este să împărtășești și să contribui la proiectele lor.

Ajutând nou-veniții, împărțind resurse, și făcând contribuții gândite bine la proiectele altora te va ajuta să-ți construiești o reputație pozitivă. Fiind un membru activ în comunitatea open source îi va ajuta pe oameni să aibă context despre munca ta și să fie mai probabil să acorde atenție la și să împărtășească proiectul tău. Dezvoltarea relațiilor cu alte proiecte cu sursă deschisă poate duce chiar la parteneriate oficiale.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  <p>
    Singurul motiv pentru care urllib3 este cea mai populară bibliotecă Python din terță parte azi este fiindcă este parte din cereri.
  </p>
  <p>
    <em>
      The only reason urllib3 is the most popular third-party Python library today is because it's part of requests.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Nu este niciodată prea devreme, sau prea tâziu, să începi să-ți construiești reputația. Chiar dacă ți-ai lansat deja propriul tău proiect, continuă să cauți căi de a-i ajuta pe ceilalți.

Nu există o soluție peste noapte de a construi un public. Obținerea încrederii și respectului celorlalți ia timp, și construirea reputației tale nu se sfârșește niciodată.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ariya?s=180" class="pquote-avatar" alt="avatar">
  <p>
    PhantomJS a fost lansat prima dată la începutul lui 2011. (...) Am răspândit cuvântul prin căile obișnuite: am tweet-uit despre el, am scris postări de blog despre lucruri pe care le poți face cu el, l-am menționat în timpul variatelor discuții din întâlniri. Când a devenit mai cunoscut în 2014, am început să țin prezentări despre el.
  </p>
  <p>
    <em>
      PhantomJS was released for the first time in the beginning of 2011. (...) I spread the word in the usual ways: I tweeted about it, I wrote blog posts on things you could do with it, I mentioned it during various discussions in meetups. When it became more well known in 2014, I started giving presentations about it.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @ariya, ["Maintainer Stories"](https://github.com/open-source/stories/ariya)
  </p>
</aside>

## Continuă!

Este posibil să dureze mult înainte ca utilizatorii să observe proiectul tău cu sursă deschisă. Este în regulă! Unele dintre cele mai populare proiecte de astăzi au avut nevoie de ani pentru a atinge nivele înalte de activitate. Concentrează-te pe a construi relații în loc de a spera că proiectul tău va câștiga popularitate în mod spontan. Fii răbdător, și continuă să împărtășești munca ta cu cei care o apreciază.
