---
lang: ro
title: Clădirea comunităților primitoare
description: Construirea unei comunități care încurajează oamenii să folosească, să contribuie la, și să promoveze proiectul tău
class: building
toc:
  setting-your-project-up-for-success: "Configurarea proiectului tău pentru succes"
  growing-your-community: "Dezvoltarea comunității tale"
  resolving-conflicts: "Rezolvarea conflictelor"
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Configurarea proiectului tău pentru succes

Ți-ai lansat proiectul, răspândești cuvântul, și oamenii îi aruncă priviri. Minunat! Acum, cum îi faci să rămână prin preajmă?

O comunitate primitoare este o investiție în viitorul și reputația proiectului tău. Dacă proiectul tău abia începe să își vadă primele contribuții, începe prin a da contributorilor timpurii o experiență pozitivă, și fă-le ușor să se tot întoarcă.

### Fă oamenii să se simtă bineveniți

Un mod de a te gândi la comunitatea proiectului tău este prin ceea ce @MikeMcQuaid numește [pâlnia contributorilor](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/):

![Pâlnia contributorilor](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

Pe măsură ce îți construiești comunitatea, consideră cum cineva din partea de sus a pâlniei (un utilizator potențial) ar putea teoretic să își facă un drum către partea din jos (un întreținător activ). Scopul tău este să reduci fricțiunea la fiecare etapă a experienței contributorilor. Când oamenii înving ușor, se vor simți stimulați să facă mai mult.

Începe cu documentația ta:

* **Fă ușor pentru cineva să-ți folosească proiectul.** [Un README prietenos](../starting-a-project/#scrierea-unui-readme) și exemple clare de cod vor face mai ușor pentru oricine care ajunge la proiectul tău să înceapă.
* **Explică clar cum se contribuie**, folosind [fișierul tău CONTRIBUTING](../starting-a-project/#scrierea-direcțiilor-tale-de-contribuție) și păstrându-ți problemele actualizate.

[Sondajul open source 2017 al GitHub](http://opensourcesurvey.org/2017/) a arătat că documentația incompletă sau confuzionantă este cea mai mare problemă pentru utilizatorii de sursă deschisă. Documentația bună invită oamenii să interacționeze cu proiectul tău. În cele din urmă, cineva va deschide o problemă sau o cerere de pull. Folosește aceste interacții ca oportunități de a-i muta în jos pe pâlnie.

* **Când cineva nou ajunge la proiectul tău, mulțumește-i pentru interesul său!** E nevoie de doar o singură experiență negativă pentru a face pe cineva să nu vrea să se întoarcă.
* **Fii receptiv.** Dacă nu răspunzi la problema lui/ei timp de o lună, șansele sunt că a uitat deja de proiectul tău.
* **Deschide-ți mintea în legătură cu tipurile de contribuții pe care le vei accepta.** Mulți contributori încep cu un raport de bug sau o corectare mică. Există [multe căi de a contribui](../how-to-contribute/#ce-înseamnă-să-contribui) la un proiect. Lasă-i pe oameni să ajute cum vor ei să ajute.
* **Dacă există o contribuție cu care nu ești de acord,** mulțumește-i pentru ideea sa și [explică de ce](../best-practices/#învățând-să-spui-nu) nu se încadrează în domeniul proiectului, legând către documentație relevantă dacă ai una.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  <p>
    A contribui la open source este mai ușor pentru unii decât pentru alții. Există multă frică de a se țipa pentru că nu s-a făcut ceva corect sau pur și simplu pentru că nu se potrivește. (...) Dând contributorilor un loc unde să contribuie cu competențe tehnice foarte scăzute (documentație, conținut web markdown, etc) poți reduce aceste probleme foarte mult.
  </p>
  <p>
    <em>
      Contributing to open source is easier for some than others. There's a lot of fear of being yelled at for not doing something right or just not fitting in. (...) By giving contributors a place to contribute with very low technical proficiency (documentation, web content markdown, etc) you can greatly reduce those concerns.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Growing a contributor base in modern open source"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

Majoritatea contributorilor la sursă deschisă sunt „contributori ocazionali”: oameni care contribuie la un proiect doar ocazional. Un contributor ocazional ar putea să nu aibă timp să ajungă la maximă viteză cu proiectul tău, deci sarcina ta este să faci să fie ușor să contribuie.

Încurajarea altor contributori este o investiție în tine însuți, de asemenea. Când împuternicești cei mai mari fani să meargă cu munca de care sunt încântați, este mai puțină presiune să faci totul de unul singur.

### Documentează totul

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  <p>
    Ai fost vreodată la un eveniment (despre tehnologie) unde nu ai știut pe nimeni, dar toți ceilalți păreau că stau în grupuri și conversează ca prieteni vechi? (...) Acum imaginează-ți că vrei să contribui la un proiect cu sursă deschisă, dar nu vezi de ce sau cum are loc asta.
  </p>
  <p>
    <em>
      Have you ever been to a (tech-) event where you didn't know anyone, but everyone else seemed to stand in groups and chat like old friends? (...) Now imagine you want to contribute to an open source project, but you don't see why or how this is happening.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @janl, ["Sustainable Open Source"](https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Când începi un proiect nou, poate să se simtă natural să-ți păstrezi munca privată. Dar proiectele cu sursă deschisă prosperă când tu documentezi procesul tău în public.

Când notezi lucruri, mai mulți oameni pot participa la fiecare pas al drumului. Ai putea primi ajutor la ceva despre care nici nu știai că e necesar.

Scriind lucruri înseamnă mai mult decât doar documentație tehnică. În oricare moment în care simți nevoia de a scrie ceva sau de a discuta în privat proiectul tău, întreabă-te dacă poți să faci acel lucru public.

Fii transparent în legătură cu foaia de parcurs a proiectului tău, tipurile de contribuții pe care le cauți, cum sunt examinate contribuțiile, sau de ce ai făcut anumite decizii.

Dacă observi mai mulți utilizatori care dau peste aceeași problemă, documentează răspunsul în README.

Pentru întâlniri, consideră publicarea notițelor sau a pachetelor tale într-o problemă relevantă. Feedback-ul pe care îl vei primi de la acest nivel de transparență te poate surprinde.

Documentarea a tot se aplică și muncii pe care o faci. Dacă lucrezi pe o actualizare substanțială pentru proiectul tău, pune-o într-o cerere de pull și marcheaz-o ca lucrare în desfășurare (WIP). În acest mod, alți oameni pot să se simtă implicați în proces mai devreme.

### Fii receptiv

Pe măsură ce [îți promovezi proiectul](../finding-users), oamenii vor avea feedback pentru tine. Ei ar putea avea întrebări despre cum merg lucrurile, sau să aibă nevoie de ajutor să înceapă.

Încearcă să fii receptiv când cineva completează o problemă, trimite o cerere de pull, sau pune o întrebare despre proiectul tău. Când răspunzi repede, oamenii vor simți că sunt o parte din dialog, și ei vor fi mai entuziaști în legătură cu participarea.

Chiar dacă nu poți examina cererea imediat, recunoașterea ei devreme ajută mărirea implicării. Iată cum @tdreyno a răspuns unei cereri de pull pentru [Middleman](https://github.com/middleman/middleman/pull/1466):

![cerere de pull Middleman](/assets/images/building-community/middleman_pr.png)

[Un studiu Mozilla a găsit că](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) contributorii care au primit examinări de cod în 48 de ore au avut o rată de întoarcere și de contribuire repetată mult mai mare.

Conversațiile despre proiectul tău ar putea de asemenea să aibă loc în alte locuri de pe Internet, cum ar fi Stack Overflow, Twitter, sau Reddit. Poți configura notificări în unele din aceste locuri astfel încât ești alertat când cineva îți menționează proiectul.

### Dă comunității tale un loc de adunare

Există două motive pentru care să dai comunității tale un loc de adunare.

Primul motiv este pentru ei. Ajută oamenii să se cunoască între ei. Oamenii cu interese comune vor dori în mod inevitabil un loc unde să vorbească despre acestea. Și când comunicarea este publică și accesibilă, oricine poate citi arhivele trecutului pentru a ajunge la viteză și a participa.

Al doilea motiv este pentru tine. Dacă nu dai oamenilor un loc public pentru a vorbi despre proiectul tău, ei probabil te vor contacta direct. La început, ar putea părea destul de ușor să răspunzi la mesaje private „doar de data asta”. Dar cu timpul, în special dacă proiectul tău devine mai popular, te vei simți epuizat. Rezistă tentației de a comunica cu oameni despre proiectul tău în privat. În schimb, direcționează-i către un canal public desemnat.

Comunicarea publică poate fi atât de ușoară ca direcționarea oamenilor către deschiderea unei probleme în schimbul trimiterii de email direct ție sau comentarea pe blogul tău. Ai putea de asemenea configura o listă de email-uri, sau crea un cont Twitter, Slack, sau un canal IRC pentru oameni să vorbească despre proiectul tău. Sau încearcă-le pe toate de mai sus!

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) pune deoparte ore de birou din 2 în 2 săptămâni pentru a ajuta membrii comunității:

> Kops de asemenea are timp pus deoparte din 2 în 2 săptămâni pentru a oferi ajutor și îndrumare comunitații. Întreținătorii Kops au căzut de acord să pună timp deoparte specific dedicat lucrului cu nou-veniții, ajutării cu PR-urile, și discutării de noi facilități.
> 
> Kops also has time set aside every other week to offer help and guidance to the community. Kops maintainers have agreed to set aside time specifically dedicated to working with newcomers, helping with PRs, and discussing new features.

Excepții notabile pentru comunicarea publică sunt: 1) probleme de securitate și 2) încălcări sensibile ale codului de conduită. Ar trebui să ai întotdeauna o cale pentru oameni să raporteze aceste probleme în mod privat. Dacă nu dorești să folosești adresa ta de email personală, configurează o adresă de email dedicată.

## Dezvoltarea comunității tale

Comunitățile sunt extrem de puternice. Acea putere poate fi o binecuvântare sau un blestem, depinzând de cum o mânuiești. Pe măsură ce comunitatea proiectului tău crește, există moduri de a o ajuta să devină o forță a construirii, nu a distrugerii.

### Nu tolera actori răi

Oricare proiect popular va atrage inevitabil oameni care rănesc, în loc de a ajuta, comunitatea ta. Ei ar putea începe dezbateri inutile, să se certe asupra unor facilități triviale, sau să hărțuiască pe alții.

Fă tot ce poți pentru a adopta o politică de toleranță zero față de aceste tipuri de oameni. Dacă rămân neverificați, oamenii negativi vor face alți oameni în comunitatea ta incomozi. Ei ar putea chiar să plece.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  <p>
    Adevărul este că a avea o comunitate susținătoare este cheia. Niciodată nu aș putea face această muncă fără ajutorul colegilor mei, străinilor prietenoși de pe Internet, și canale flecare IRC. (...) Nu te mulțumi cu mai puțin. Nu te mulțumi cu nenorociți.
  </p>
  <p>
    <em>
      The truth is that having a supportive community is key. I'd never be able to do this work without the help of my colleagues, friendly internet strangers, and chatty IRC channels. (...) Don't settle for less. Don't settle for assholes.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @okdistribute, ["How to Run a FOSS Project"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Dezbateri obișnuite asupra unor aspecte triviale ale proiectului tău îi distrag pe alții, inclusiv pe tine, de la concentrarea pe sarcinile importante. Noi oameni care ajung la proiectul tău ar putea vedea aceste conversații și să nu dorească să participe.

Când vezi comportament negativ întâmplându-se pe proiectul tău, numește-l în public. Explică, cu un ton bun dar ferm, de ce comportamentul lor nu este acceptabil. Dacă problema persistă, ar putea fi nevoie să [le ceri să plece](../code-of-conduct/#impunerea-codului-tău-de-conduită). [Codul tău de conduită](../code-of-conduct/) poate fi un ghid constructiv pentru aceste conversații.

### Întâlnește-i pe contributori unde lucrează

Documentația bună devine doar mai importantă pe măsură ce comunitatea ta crește. Contributorii ocazionali, care ar putea să nu fie în caz contrar familiari cu proiectul tău, citesc documentația ta pentru a primi rapid contextul de care au nevoie.

În fișierul tău CONTRIBUTING, spune-le în mod explicit contributorilor noi cum să înceapă. Ai putea chiar să vrei să faci o secțiune dedicată cu acest scop. [Django](https://github.com/django/django), de exemplu, are o pagină specială de destinație pentru primirea noilor contributori.

![Pagina pentru noi contributori Django](/assets/images/building-community/django_new_contributors.png)

În coada ta de probleme, etichetează bug-urile care sunt potrivite pentru diferite tipuri de contributori: de exemplu, [_"first timers only"_](https://kentcdodds.com/blog/first-timers-only), _"good first issue"_, sau _"documentation"_. [Aceste etichete](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) fac ușor pentru un nou-venit la proiectul tău să scaneze rapid problemele tale și să înceapă.

În cele din urmă, folosește-ți documentația pentru a-i face pe oameni să se simtă bineveniți la fiecare pas pe drum.

Nu vei interacționa niciodată cu marea majoritate a oamenilor care ajung la proiectul tău. Ar putea fi contribuții pe care nu le-ai primit deoarece cineva s-a simțit intimidat sau nu a știut de unde să înceapă. Chiar câteva cuvinte puține pot ține un om să nu părăsească frustrat proiectul tău.

De exemplu, iată cum [Rubinius](https://github.com/rubinius/rubinius/) începe [ghidul său de contribuire](https://github.com/rubinius/rubinius/blob/master/.github/contributing.md):

> Vrem să începem prin a vă mulțumi că folosiți Rubinius. Acest proiect este o muncă a iubirii, și apreciem toți utilizatorii care descoperă bug-uri, fac îmbunătățiri de performanță, și ajută cu documentația. Orice contribuție este semnificativă, deci vă mulțumim pentru participare. Acestea fiind spuse, iată câteva instrucțiuni pe care vă cerem să le urmați pentru ca să vă abordăm cu succes problema.
> 
> We want to start off by saying thank you for using Rubinius. This project is a labor of love, and we appreciate all of the users that catch bugs, make performance improvements, and help with documentation. Every contribution is meaningful, so thank you for participating. That being said, here are a few guidelines that we ask you to follow so we can successfully address your issue.

### Împarte proprietatea proiectului tău

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  <p>
    Liderii voștri vor avea păreri diferite, așa cum ar trebui să aibă toate comunitățile sănătoase! Totuși, trebuie să faceți niște pași să asigurați că cea mai tare voce nu învinge întotdeauna obosind oamenii, și că vocile mai puțin proeminente și cele minoritare sunt auzite.
  </p>
  <p>
    <em>
      Your leaders will have different opinions, as all healthy communities should! However, you need to take steps to ensure the loudest voice doesn't always win by tiring people out, and that less prominent and minority voices are heard.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @sagesharp, ["What makes a good community?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Oamenii sunt stârniți să contribuie la proiecte când au un sens al proprietății. Aceasta nu înseamnă că trebuie să întorci viziunea proiectului tău sau să accepți contribuții pe care nu le vrei. Dar cu cât dai mai mult credit altora, cu atât vor sta prin preajmă mai mult.

Vezi dacă poți găsi moduri de a împărți proprietatea cu comunitatea ta cât de mult poți. Iată câteva idei:

* **Rezistă la rezolvarea bug-urilor ușoare (non-critice).** În schimb, folosește-le ca oportunități pentru a recruta noi contributori, sau mentorează pe cineva care ar dori să contribuie. I-ar putea părea nenatural la început, dar investiția ta va plăti în timp. De exemplu, @michaeljoseph a cerut unui contributor să trimită o cerere de pull la o problemă a [Cookiecutter](https://github.com/audreyr/cookiecutter) de mai jos, în loc să o rezolve el însuși.

![problemă Cookiecutter](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Începe un fișier CONTRIBUTORS sau AUTHORS în proiectul tău** care listează pe toți cei care au contribuit la proiectul tău, la fel cum face [Sinatra](https://github.com/sinatra/sinatra/blob/master/AUTHORS.md).

* Dacă ai o comunitate considerabilă, **trimite un buletin informativ sau scrie o postare de blog** mulțumind contributorilor. [This Week in Rust](https://this-week-in-rust.org/) al Rust și [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) al Hoodie sunt două exemple bune.

* **Dă tuturor contributorilor accesul pentru a face commit-uri** @felixge a găsit că aceasta a făcut oamenii [mai încântați să-și finiseze patch-urile](https://felixge.de/2013/03/11/the-pull-request-hack.html), și el chiar a găsit noi întreținători pentru proiecte la care n-a lucrat de ceva timp.

* Dacă proiectul tău este pe GitHub, **mută-ți proiectul din contul tău personal într-o [Organizație](https://help.github.com/articles/creating-a-new-organization-account/)** și adaugă cel puțin un administrator de rezervă. Organizațiile fac mai ușor să lucrezi pe proiecte cu colaboratori externi.

Realitatea este că [cele mai multe proiecte au doar](https://peerj.com/preprints/1233.pdf) unul sau doi întreținători care fac cea mai multă muncă. Cu cât mai mare este proiectul tău, și mai mare comunitatea ta, cu atât mai ușor este să găsești ajutor.

În timp ce poate tu nu găsești întotdeauna pe cineva să răspundă la apel, punând un semnal acolo crește șansele ca alți oameni să intre pe teren. Și cu cât începi mai devreme, cu atât mai devreme oamenii pot ajuta.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  <p>
    [Este al tău] cel mai mare interes de a recruta contributori care se bucură și care sunt capabili de a face lucrurile de care tu nu ești capabil. Te încântă programarea, dar nu răspunderea la probleme? Atunci identifică pe acei indivizi din comunitatea ta pe care îi încântă și lasă-le să fie ale lor.
  </p>
  <p>
    <em>
      [It's in your] best interest to recruit contributors who enjoy and who are capable of doing the things that you are not. Do you enjoy coding, but not answering issues? Then identify those individuals in your community who do and let them have it.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @gr2m, ["Welcoming Communities"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Rezolvarea conflictelor

În stadiile de început ale proiectului tău, a face decizii majore este ușor. Când vrei să faci ceva, pur și simplu faci.

Pe măsură ce proiectul tău devine mai popular, mai mulți oameni se vor interesa de deciziile pe care le faci. Chiar dacă nu ai o comunitate mare de contributori, dacă proiectul tău are mulți utilizatori, vei găsi oameni cântărind deciziile sau ridicând probleme pe cont propriu.

În cea mai mare parte, dacă ai cultivat o comunitate prietenoasă și respectuoasă și ai documentat procesele tale în mod deschis, comunitatea ta ar trebui să poată să găsească soluționare. Dar câteodată dai peste o problemă care este puțin mai greu de abordat.

### Stabilește standardul pentru bunătate

Când comunitatea ta se luptă cu o problemă dificilă, mânia poate crește. Oamenii pot deveni nervoși sau frustrați și pot să arunce asupra altora, sau asupra ta.

Slujba ta în calitate de întreținător este să ferești aceste situații de la escaladare. Chiar dacă ai o părere solidă cu privire la subiect, încearcă să iei poziția de moderator sau facilitator, în loc să sari în luptă și să-ți împingi părerile. Dacă cineva este aspru sau monopolizează conversația, [acționează imediat](../building-community/#nu-tolera-actori-răi) pentru a menține discuțiile politicoase și productive.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  <p>
    În calitate de întreținător de proiect, este extrem de important să fii respectuos față de contributorii tăi. Ei deseori iau ce spui foarte personal.
  </p>
  <p>
    <em>
      As a project maintainer, it's extremely important to be respectful to your contributors. They often take what you say very personally.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Be Cordial or Be on Your Way"](https://www.kennethreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

Alți oameni vă caută pentru îndrumare. Stabilește un exemplu bun. Încă poți exprima dezamăgire, nefericire, sau îngrijorare, dar fă aceasta cu calm.

A-ți păstra calmul nu este ușor, dar conducerea demonstrată îmbunătățește sănătatea comunității tale. Internetul îți mulțumește.

### Tratează-ți README-ul ca pe o constituție

README-ul tău este [mai mult decât doar o mulțime de instrucțiuni](../starting-a-project/#scrierea-unui-readme). Este de asemenea un loc pentru a vorbi despre scopurile tale, viziunea produsului, și foaia de parcurs. Dacă oamenii sunt prea concentrați pe a dezbate meritul unei anumite facilități, poate ajuta să-ți revizuiești README-ul și să vorbești despre viziunea superioară a proiectului tău. Concentrarea pe README-ul tău de asemenea depersonalizează conversația, astfel încât puteți avea o discuție constructivă.

### Concentrează-te pe călătorie, nu pe destinație

Unele proiecte folosesc un proces de votare pentru a face decizii majore. În timp ce e sensibilă la prima privire, votarea accentuează mai degrabă ajungerea la un „răspuns,” în loc de a asculta și a aborda fiecare îngrijorările celuilalt.

Votarea poate deveni politică, situație în care membrii comunității se simt presați să facă favoruri unul celuilalt sau să voteze într-un anumit mod. Și nu toți votează, fie că este [majoritatea tăcută](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) din comunitatea ta, fie utilizatorii curenți care nu știau că un vot avea loc.

Uneori, votarea este o departajare necesară. Totuși, cât de mult poți, accentuează mai degrabă [„căutarea de consens”](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making) în locul unui consens.

În cadrul unui proces de căutare a consensului, membrii comunității discută îngrijorările majore până când se simt că au fost auziți în mod adecvat. Când doar îngrijorări minore rămân, comunitatea merge înainte. „Căutarea consensului” recunoaște că o comunitate ar putea să nu fie capabilă să ajungă la un răspuns perfect. În schimb, ea prioritizează ascultarea și discuția.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  <p>
    O parte din motivele pentru care un sistem de votare nu există pentru Problemele Atom este fiindcă echipa Atom nu va urma un sistem de votare în toate cazurile. Uneori trebuie să alegem ceea ce simțim că este corect chiar dacă este nepopular. (...) Ce pot oferi și la ce mă angajez să fac...e că este slujba mea să ascult comunitatea.
  </p>
  <p>
    <em>
      Part of the reason why a voting system doesn't exist for Atom Issues is because the Atom team isn't going to follow a voting system in all cases. Sometimes we have to choose what we feel is right even if it is unpopular. (...) What I can offer and pledge to do...is that it is my job to listen to the community.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @lee-dohm privind [procesul de luare a deciziilor al Atom](https://discuss.atom.io/t/prioritize-issues-feature-requests-based-on-voting-system/27642/2)
  </p>
</aside>

Chiar dacă nu adopți de fapt un proces de căutare a consensului, în calitate de întreținător de proiect, este important ca oamenii să știe că asculți. A face alți oameni să se simtă auziți, și a te angaja să le rezolvi îngrijorările, merge mult spre a împrăștia situațiile sensibile. Apoi, urmează-ți cuvintele cu acțiuni.

Nu te grăbi să iei o decizie de dragul de a avea o soluționare. Asigură-te că toți se simt auziți și că toate acele informații au fost făcute publice înainte de a înainta către o rezoluție.

### Menține conversația axată pe acțiune

Discuția este importantă, dar există o diferență între conversațiile productive și cele neproductive.

Încurajează discuția atâta timp cât înaintează activ către o soluționare. Dacă este clar că acea conversație se stinge sau merge în afara subiectului, împunsăturile devin personale, sau oamenii se ceartă asupra unor detalii minore, este timpul să o oprești.

Permițând acestor conversații să continue nu este rău doar pentru problema la îndemână, ci și pentru sănătatea comunității tale. Aceasta trimite mesajul că aceste tipuri de conversații sunt permise sau chiar încurajate, și aceasta poate descuraja oameni de la a ridica sau rezolva probleme viitoare.

Cu fiecare punct făcut de tine sau de alții, întreabă-te, _„Cum ne aduce aceasta mai aproape de o soluționare?”_

Dacă conversația începe să se dezvăluie, întreabă grupul, _„Care sunt pașii pe care să-i facem în continuare?”_ pentru a reorienta conversația.

Dacă o conversație în mod clar nu merge nicăieri, nu sunt măsuri clare de luat, sau măsura potrivită a fost deja luată, închide problema și explică de ce ai închis-o.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  <p>
    Îndrumarea unui fir de discuție către utilitate fără a fi insistent/ă este o artă. Nu va funcționa pur și simplu să mustrați oamenii să se oprească din a-și pierde timpul, sau să le ceri să nu mai posteze decât dacă au ceva constructiv de spus. (...) În schimb, trebuie să sugerezi condiții pentru progres mai departe: dă oamenilor o rută, o cale de urmat care duce la rezultatele pe care le vrei, totuși fără a suna ca și cum ești o conduită dictatoare.
  </p>
  <p>
    <em>
      Guiding a thread toward usefulness without being pushy is an art. It won't work to simply admonish people to stop wasting their time, or to ask them not to post unless they have something constructive to say. (...) Instead, you have to suggest conditions for further progress: give people a route, a path to follow that leads to the results you want, yet without sounding like you're dictating conduct.
    </em>
  </p>
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### Alege-ți bătăliile cu înțelepciune

Contextul este important. Consideră cine este implicat în discuție și cum reprezintă ei/ele restul comunității.

Este toată lumea din comunitate supărată pe, sau chiar angajată în, această problemă? Sau este un scandalagiu singuratic? Nu uita să consideri membrii tăcuți ai comunitații tale, nu doar vocile active.

Dacă problema nu reprezintă nevoile extinse ale comunității tale, ar trebui doar să recunoști îngrijorările câtorva oameni. Dacă aceasta este o problemă recurentă fără o soluționare clară, indică-le discuțiile anterioare asupra subiectului și închide firul de discuție.

### Identifică o departajare a comunității

Cu o atitudine bună și o comunicare clară, cele mai dificile situații sunt rezolvabile. Totuși, chiar într-o conversație productivă, poate exista pur și simplu o diferență de opinie cu privire la cum să se procedeze. În aceste cazuri, identifică un individ sau un grup de oameni care pot servi ca o departajare.

O departajare ar putea fi principalul întreținător al proiectului, sau poate fi un grup mic de oameni care fac o decizie bazată pe votare. În mod ideal, ai identificat o departajare și procesul asociat într-un fișier GOVERNANCE înainte de a avea vreodată nevoie să o folosești.

Departajarea ta ar putea fi ultima soluție. Problemele dezbinătoare sunt o oportunitate pentru comunitatea ta de a crește și a învăța. Îmbrățișează aceste oportunități și folosește un proces colaborativ pentru a te mișca înspre o soluționare oriunde este posibil.

## Comunitatea este ❤️ a open source

Comunități sănătoase, înfloritoare alimentează miile de ore turnate în open source săptămânal. Mulți contributori indică spre alți oameni ca fiind motivul muncii lor - sau non-muncii - pe open source. Învățând cum să accesezi acea putere constructiv, vei ajuta pe cineva acolo să aibă o experiență open source de neuitat.
