---
lang: pl
title: Starting an Open Source Project
description: Dowiedz się więcej o świecie open source i przygotuj się do uruchomienia własnego projektu.
class: beginners
order: 2
image: /assets/images/cards/beginner.png
related:
  - finding
  - building
---

## „Co” i „dlaczego” oprogramowania typu open source

Więc myślisz o rozpoczęciu pracy z oprogramowaniem typu open source? Gratulacje! Świat docenia twój wkład. Porozmawiajmy o tym, czym jest open source i dlaczego ludzie to robią.

### Co oznacza „open source”?

To znaczy, gdy projekt jest open source **każdy może swobodnie korzystać, studiować, modyfikować i rozpowszechniać Twój projekt w dowolnym celu.** Uprawnienia te są egzekwowane poprzez [licencję typu open source](https://opensource.org/licenses).

Open source jest potężny, ponieważ obniża bariery adopcji i współpracy, umożliwiając ludziom szybkie rozprzestrzenianie i ulepszanie projektów. Również dlatego, że daje użytkownikom możliwość kontrolowania własnego przetwarzania w odniesieniu do zamkniętego źródła. Na przykład firma korzystająca z oprogramowania typu open source ma możliwość zatrudnienia kogoś, kto wprowadzi niestandardowe ulepszenia oprogramowania, zamiast polegać wyłącznie na decyzjach dostawcy zamkniętego źródła.

_Wolne oprogramowanie_ odnosi się do tego samego zestawu projektów, co _otwarte źródło_. Czasami zobaczysz również [niniejsze warunki](https://en.wikipedia.org/wiki/Free_and_open-source_software) w połączeniu jako „bezpłatne i otwarte oprogramowanie” (FOSS) lub „wolne, darmowe i otwarte oprogramowanie” (OPLĄT). _Free_ i _libre_ odnoszą się do wolności, [nie ceny](../starting-a-project/#czy-open-source-oznacza-bezpłatnie).

### Dlaczego ludzie open source-ują swoją pracę?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kentcdodds?s=180" class="pquote-avatar" alt="avatar">
  <i>
  One of the most rewarding experiences I get out of using and collaborating on open source comes from the relationships that I build with other developers facing many of the same problems I am.
  </i>
  <p markdown="1" class="pquote-credit">
— @kentcdodds, ["How getting into Open Source has been awesome for me"](https://kentcdodds.com/blog/how-getting-into-open-source-has-been-awesome-for-me)
  </p>
</aside>

[Jest wiele powodów](https://ben.balter.com/2015/11/23/why-open-source/) dlaczego osoba lub organizacja chciałaby otworzyć projekt. Niektóre przykłady obejmują:

* **Współpraca:** Projekty open source mogą akceptować zmiany od każdego na świecie. [Exercism](https://github.com/exercism/), na przykład, jest platformą ćwiczeń programistycznych z ponad 350 uczestnikami.

* **Adopcja i remiksowanie:** projekty open source mogą być wykorzystywane przez każdego do prawie dowolnego celu. Ludzie mogą nawet używać go do budowania innych rzeczy. [WordPress](https://github.com/WordPress), na przykład, zaczął się jako rozwidlenie istniejącego projektu o nazwie[b2](https://github.com/WordPress/book/blob/master/Content/Part%201/2-b2-cafelog.md).

* **Transparentność:** Każdy może sprawdzić projekt open source pod kątem błędów lub niespójności. Przejrzystość ma znaczenie dla rządów takich jak [Bułgaria](https://medium.com/@bozhobg/bulgaria-got-a-law-requiring-open-source-98bf626cf70a) lub [Stany Zjednoczone](https://sourcecode.cio.gov/), regulowane branże, takie jak bankowość lub opieka zdrowotna, oraz oprogramowanie zabezpieczające, takie jak [Let's Encrypt](https://github.com/letsencrypt).

Open source to nie tylko oprogramowanie. Możesz otworzyć wszystko, od zbiorów danych po książki. Sprawdź [GitHub Explore](https://github.com/explore), aby uzyskać pomysły na to, co jeszcze możesz otworzyć.

### Czy open source oznacza bezpłatnie

Jednym z największych losowań open source jest to, że nie kosztuje. „Bezpłatny” jest jednak produktem ubocznym ogólnej wartości open source.

Ponieważ [wymaga licencji typu open source](https://opensource.org/osd-annotated) że każdy może używać, modyfikować i udostępniać Twój projekt do prawie dowolnego celu, same projekty są zazwyczaj bezpłatne. Jeśli korzystanie z projektu kosztuje, każdy może legalnie wykonać kopię i zamiast tego skorzystać z darmowej wersji.

W rezultacie większość projektów typu open source jest darmowa, ale „bezpłatnie” nie jest częścią definicji open source. Istnieją sposoby pobierania opłat za projekty typu open source pośrednio poprzez podwójne licencjonowanie lub ograniczone funkcje, przy jednoczesnym zachowaniu zgodności z oficjalną definicją open source.

## Czy powinienem uruchomić własny projekt open source?

Krótka odpowiedź brzmi „tak”, ponieważ bez względu na wynik uruchomienie własnego projektu to świetny sposób, aby dowiedzieć się, jak działa open source.

Jeśli nigdy wcześniej nie korzystałeś z projektu, możesz być zdenerwowany tym, co powiedzą ludzie lub czy ktoś w ogóle to zauważy. Jeśli to brzmi jak ty, nie jesteś sam!

Praca open source jest jak każde inne działanie twórcze, czy to pisanie, czy malowanie. Dzielenie się pracą ze światem może być przerażające, ale jedynym sposobem na poprawę jest ćwiczenie - nawet jeśli nie masz publiczności.

Jeśli nie jesteś jeszcze przekonany, poświęć chwilę, aby pomyśleć o swoich celach.

### Wyznaczanie celów

Cele mogą pomóc Ci dowiedzieć się, nad czym pracować, w czym powiedzieć „nie” i gdzie potrzebujesz pomocy od innych. Zacznij od zadania sobie pytania: _dlaczego jestem otwarty na pozyskiwanie tego projektu?_

Nie ma jednej właściwej odpowiedzi na to pytanie. Możesz mieć wiele celów dla jednego projektu lub różnych projektów o różnych celach.

Jeśli Twoim jedynym celem jest pochwalenie się swoją pracą, możesz nawet nie chcieć wkładów, a nawet powiedzieć to w swoim README. Z drugiej strony, jeśli chcesz współpracowników, zainwestujesz czas w przejrzystą dokumentację i sprawi, że nowicjusze będą mile widziani.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mavris?s=180" class="pquote-avatar" alt="avatar">
  <i>
  At some point I created a custom UIAlertView that I was using...and I decided to make it open source. So I modified it to be more dynamic and uploaded it to GitHub. I also wrote my first documentation explaining to other developers how to use it on their projects. Probably nobody ever used it because it was a simple project but I was feeling good about my contribution.
  </i>
  <p markdown="1" class="pquote-credit">
— @mavris, ["Self-taught Software Developers: Why Open Source is important to us"](https://medium.com/rocknnull/self-taught-software-engineers-why-open-source-is-important-to-us-fe2a3473a576)
  </p>
</aside>

W miarę rozwoju projektu Twoja społeczność może potrzebować czegoś więcej niż tylko kodu. Odpowiadanie na problemy, przeglądanie kodu i ewangelizacja projektu to ważne zadania w projekcie typu open source.

Chociaż ilość czasu poświęcanego na zadania niekodujące będzie zależeć od wielkości i zakresu projektu, powinieneś być przygotowany jako opiekun, aby zająć się nimi samodzielnie lub znaleźć kogoś, kto ci pomoże.

**Jeśli jesteś częścią firmy, która pozyskuje projekt,** upewnij się, że Twój projekt ma wewnętrzne zasoby potrzebne do rozwoju. Będziesz chciał określić, kto jest odpowiedzialny za utrzymanie projektu po uruchomieniu i jak udostępnisz te zadania swojej społeczności.

Jeśli potrzebujesz specjalnego budżetu lub personelu na promocję, operacje i utrzymanie projektu, rozpocznij te rozmowy wcześniej.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/captainsafia?s=180" class="pquote-avatar" alt="avatar">
  <i>
  As you begin to open source the project, it's important to make sure that your management processes take into consideration the contributions and abilities of the community around your project. Don't be afraid to involve contributors who are not employed in your business in key aspects of the project — especially if they are frequent contributors.
  </i>
  <p markdown="1" class="pquote-credit">
— @captainsafia, ["So you wanna open source a project, eh?"](https://dev.to/captainsafia/so-you-wanna-open-source-a-project-eh-5779)
  </p>
</aside>

### Wkład w inne projekty

Jeśli Twoim celem jest nauczenie się, jak współpracować z innymi lub zrozumieć, jak działa open source, rozważ przyczynienie się do istniejącego projektu. Zacznij od projektu, którego już używasz i który kochasz. Wkład w projekt może być tak prosty, jak poprawianie literówek lub aktualizacja dokumentacji.

Jeśli nie masz pewności, jak rozpocząć pracę jako współpracownik, zapoznaj się z naszym [Jak przyczynić się do tworzenia otwartego oprogramowania](../how-to-contribute/).

## Uruchomienie własnego projektu open source

Nie ma idealnego czasu na otwarcie swojej pracy. Możesz otworzyć pomysł, projekt w toku lub po latach zamkniętego źródła.

Ogólnie rzecz biorąc, powinieneś otworzyć swój projekt, gdy czujesz się dobrze, gdy inni oglądają twoją pracę i wyrażają opinie na jej temat.

Bez względu na to, na jakim etapie zdecydujesz się na otwarcie projektu, każdy projekt powinien zawierać następującą dokumentację:

* [Open source license](https://help.github.com/articles/open-source-licensing/#where-does-the-license-live-on-my-repository)
* [README](https://help.github.com/articles/create-a-repo/#commit-your-first-change)
* [Contributing guidelines](https://help.github.com/articles/setting-guidelines-for-repository-contributors/)
* [Code of conduct](../code-of-conduct/)

Jako opiekun, te komponenty pomogą ci komunikować oczekiwania, zarządzać składkami i chronić prawa wszystkich osób (w tym własnych). Znacząco zwiększają twoje szanse na pozytywne doświadczenie.

Jeśli Twój projekt jest w GitHub, umieszczenie tych plików w katalogu głównym z zalecanymi nazwami plików pomoże GitHub rozpoznać i automatycznie udostępnić je czytelnikom.

### Wybór licencji

Licencja typu open source gwarantuje, że inni mogą używać, kopiować, modyfikować i wnosić wkład w projekt bez żadnych konsekwencji. Chroni również przed trudnymi sytuacjami prawnymi. **Musisz dołączyć licencję podczas uruchamiania projektu typu open source.**

Legalna praca to nie zabawa. Dobrą wiadomością jest to, że możesz skopiować i wkleić istniejącą licencję do swojego repozytorium. Ochrona twojej ciężkiej pracy zajmie tylko chwilę.

[MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/), i [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) są najpopularniejszymi licencjami typu open source, ale [istnieją inne opcje](https://choosealicense.com) do wyboru.

Podczas tworzenia nowego projektu w GitHub masz możliwość wybrania licencji. Dołączenie licencji open source sprawi, że Twój projekt GitHub stanie się open source.

![Pick a license](/assets/images/starting-a-project/repository-license-picker.png)

Jeśli masz inne pytania lub wątpliwości związane z aspektami prawnymi zarządzania projektem typu open source, [zapewniamy Ci ochronę](../legal/).

### Pisanie README

Pliki README nie tylko wyjaśniają, jak korzystać z projektu. Wyjaśniają również, dlaczego Twój projekt ma znaczenie i co użytkownicy mogą z nim zrobić.

W README spróbuj odpowiedzieć na następujące pytania:

* Co robi ten projekt?
* Dlaczego ten projekt jest przydatny?
* Jak zacząć?
* Gdzie mogę uzyskać dodatkową pomoc, jeśli jej potrzebuję?

Możesz użyć swojego README, aby odpowiedzieć na inne pytania, takie jak sposób obsługi wkładów, jakie są cele projektu oraz informacje na temat licencji i atrybucji. Jeśli nie chcesz przyjmować datków lub twój projekt nie jest jeszcze gotowy do produkcji, zapisz te informacje.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/tracymakes?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Better documentation means more users, less support requests, and more contributors. (...) Remember that your readers aren't you. There are people who might come to a project who have completely different experiences.
  </i>
  <p markdown="1" class="pquote-credit">
— @tracymakes, ["Writing So Your Words Are Read (video)"](https://www.youtube.com/watch?v=8LiV759Bje0&list=PLmV2D6sIiX3U03qc-FPXgLFGFkccCEtfv&index=10)
  </p>
</aside>

Czasami ludzie unikają pisania pliku README, ponieważ uważają, że projekt jest niedokończony lub nie chcą wkładów. Są to bardzo dobre powody, aby napisać jeden.

Aby uzyskać więcej inspiracji, spróbuj użyć przewodnika @dguo ['Make README'](https://www.makeareadme.com/) lub @PurpleBooth w [szablon README](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2) napisać kompletny plik README.

Po dołączeniu pliku README do katalogu głównego GitHub automatycznie wyświetli go na stronie głównej repozytorium.

### Pisanie swoich wytycznych

Plik CONTRIBUTING  mówi odbiorcom, jak wziąć udział w projekcie. Na przykład możesz podać informacje o:

* Jak złożyć raport o błędzie (spróbuj użyć [szablonów zgłaszania problemów i pobierania](https://github.com/blog/2111-issue-and-pull-request-templates))
* Jak zasugerować nową funkcję
* Jak skonfigurować środowisko i uruchomić testy

Oprócz szczegółów technicznych plik CONTRIBUTING jest także okazją do wyrażenia swoich oczekiwań dotyczących wkładów, takich jak:

* Rodzaje składek, których szukasz
* Twoja mapa drogowa lub wizja projektu
* W jaki sposób współpracownicy powinni (lub nie powinni) się z Tobą skontaktować

Używanie ciepłego, przyjaznego tonu i oferowanie konkretnych sugestii dotyczących wkładu (takich jak pisanie dokumentacji lub tworzenie strony internetowej) może znacznie przyczynić się do tego, że nowo przybyli poczują się mile widziani i podekscytowani uczestnictwem.

Na przykład [Active Admin](https://github.com/activeadmin/activeadmin/) uruchamia [swój przewodnik pomocniczy](https://github.com/activeadmin/activeadmin/blob/master/CONTRIBUTING.md) z:

> Po pierwsze, dziękuję za rozważenie włączenia się w Active Admin. Ludzie tacy jak Ty sprawiają, że Active Admin jest tak doskonałym narzędziem.

Na najwcześniejszych etapach projektu plik WKŁADU może być prosty. Zawsze powinieneś wyjaśniać, jak zgłaszać błędy lub problemy z plikami, a także wszelkie wymagania techniczne (takie jak testy), aby wnieść swój wkład.

Z czasem możesz dodawać inne często zadawane pytania do pliku WKŁAD. Zapisanie tych informacji oznacza, że coraz mniej osób będzie zadawać ci te same pytania w kółko.

Aby uzyskać więcej pomocy w pisaniu pliku WKŁAD, sprawdź @nayafia [contributing guide template](https://github.com/nayafia/contributing-template/blob/master/CONTRIBUTING-template.md) lub @mozilla ["How to Build a CONTRIBUTING.md"](https://mozillascience.github.io/working-open-workshop/contributing/).

Link do pliku CONTRIBUTING  z README, dzięki czemu więcej osób go zobaczy. Jeśli [umieścisz plik CONTRIBUTING w repozytorium swojego projektu](https://help.github.com/articles/setting-guidelines-for-repository-contributors/), GitHub automatycznie doda link do Twojego pliku, gdy współtwórca utworzy problem lub otworzy żądanie ściągnięcia.

![Contributing guidelines](/assets/images/starting-a-project/Contributing-guidelines.jpg)

### Ustanowienie kodeksu postępowania

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mlynch?s=180" class="pquote-avatar" alt="avatar">
  <i>
  We’ve all had experiences where we faced what was probably abuse either as a maintainer trying to explain why something had to be a certain way, or as a user...asking a simple question. (...) A code of conduct becomes an easily referenced and linkable document that indicates that your team takes constructive discourse very seriously.
  </i>
  <p markdown="1" class="pquote-credit">
— @mlynch, ["Making Open Source a Happier Place"](https://medium.com/ionic-and-the-mobile-web/making-open-source-a-happier-place-3b90d254f5f)
  </p>
</aside>

Wreszcie kodeks postępowania pomaga ustalić podstawowe zasady postępowania dla uczestników projektu. Jest to szczególnie cenne, jeśli uruchamiasz projekt open source dla społeczności lub firmy. Kodeks postępowania umożliwia ci zdrowe, konstruktywne zachowanie społeczności, które zmniejszy stres jako opiekuna.

Aby uzyskać więcej informacji, zapoznaj się z naszym [Przewodnikiem Kodeksu Postępowania](../code-of-conduct/).

Oprócz informowania, w jaki sposób oczekuje się, że uczestnicy będą się zachowywać, kodeks postępowania ma również na celu opisanie, do kogo odnoszą się te oczekiwania, kiedy mają zastosowanie, i co zrobić, gdy nastąpi naruszenie.

Podobnie jak licencje typu open source, pojawiają się również nowe standardy kodeksów postępowania, więc nie musisz pisać własnych. [Porozumienie dla współautorów](https://contributor-covenant.org/) to rozwijany kodeks postępowania używany przez [ponad 40 000 projektów open source](https://www.contributor-covenant.org/adopters), w tym Kubernetes, Rails i Swift. Bez względu na to, jakiego tekstu użyjesz, powinieneś być przygotowany do egzekwowania swojego kodeksu postępowania, jeśli to konieczne.

Wklej tekst bezpośrednio do pliku CODE_OF_CONDUCT w repozytorium. Zachowaj plik w katalogu głównym projektu, aby łatwo go znaleźć i połączyć go z README.

## Nazewnictwo i branding twojego projektu

Branding to coś więcej niż efektowne logo lub chwytliwa nazwa projektu. Chodzi o to, jak mówisz o swoim projekcie i do kogo docierasz z przesłaniem.

### Wybór właściwej nazwy

Wybierz nazwę, która jest łatwa do zapamiętania i najlepiej daje wyobrażenie o tym, co robi projekt. Na przykład:

* [Sentry](https://github.com/getsentry/sentry) monitoruje aplikacje pod kątem zgłaszania awarii
* [Thin](https://github.com/macournoyer/thin) to szybki i prosty serwer internetowy Ruby

Jeśli bazujesz na istniejącym projekcie, użycie ich nazwy jako prefiksu może pomóc wyjaśnić, co robi twój projekt (na przykład, [node-fetch](https://github.com/bitinn/node-fetch) przynosi `window.fetch` do Node.js).

Rozważ przede wszystkim przejrzystość. Kalambury są zabawne, ale pamiętaj, że niektóre żarty mogą nie przekładać się na inne kultury lub osoby z różnymi doświadczeniami. Niektórzy z potencjalnych użytkowników mogą być pracownikami firmy: nie chcesz, aby czuli się niekomfortowo, gdy muszą wyjaśniać Twój projekt w pracy!

### Unikanie konfliktów nazw

[Sprawdź projekty open source o podobnej nazwie](http://ivantomic.com/projects/ospnc/), szczególnie jeśli korzystasz z tego samego języka lub ekosystemu. Jeśli twoje imię pokrywa się z popularnym istniejącym projektem, możesz pomylić odbiorców.

Jeśli chcesz, aby witryna internetowa, uchwyt na Twitterze lub inne właściwości reprezentowały Twój projekt, upewnij się, że możesz uzyskać odpowiednie nazwy. Najlepiej jest [zarezerwować teraz te nazwy](https://instantdomainsearch.com/) dla spokoju ducha, nawet jeśli jeszcze nie zamierzasz ich używać.

Upewnij się, że nazwa twojego projektu nie narusza żadnych znaków towarowych. Firma może poprosić cię o późniejsze wycofanie projektu, a nawet podjęcie kroków prawnych przeciwko tobie. To po prostu nie jest warte ryzyka.

Możesz sprawdzić [WIPO Global Brand Database](http://www.wipo.int/branddb/en/) pod kątem konfliktów znaków towarowych. Jeśli pracujesz w firmie, jest to jedna z rzeczy, w których [zespół prawny może ci pomóc](../legal/).

Na koniec wykonaj szybkie wyszukiwanie w Google nazwy swojego projektu. Czy ludzie będą mogli łatwo znaleźć Twój projekt? Czy w wynikach wyszukiwania pojawia się coś jeszcze, czego nie chciałbyś, żeby zobaczyli?

### To, jak piszesz (i kodujesz), wpływa również na twoją markę!

Przez cały czas trwania projektu będziesz dużo pisać: CZYTELNIKI, samouczki, dokumenty społeczności, odpowiadanie na problemy, może nawet biuletyny i listy mailingowe.

Niezależnie od tego, czy jest to oficjalna dokumentacja, czy zwykły e-mail, styl pisania jest częścią marki Twojego projektu. Zastanów się, w jaki sposób możesz dotrzeć do odbiorców i czy to jest ton, który chcesz przekazać.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  <i>
  I tried to be involved with every thread on the mailing list, and showing exemplary behaviour, being nice to people, taking their issues seriously and trying to be helpful overall. After a while, people stuck around not to only ask questions, but to help with the answering as well, and to my complete delight, they mimicked my style.
  </i>
  <p markdown="1" class="pquote-credit">
— @janl on [CouchDB](https://github.com/apache/couchdb), ["Sustainable Open Source"](https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Używanie ciepłego, inkluzywnego języka (takiego jak „je”, nawet w odniesieniu do jednej osoby) może znacznie przyczynić się do tego, aby Twój projekt był przyjemny dla nowych współpracowników. Trzymaj się prostego języka, ponieważ wielu czytelników może nie być rodzimym językiem angielskim.

Poza tym, jak piszesz słowa, twój styl kodowania może również stać się częścią marki twojego projektu. [Angular](https://angular.io/guide/styleguide) i [jQuery](https://contribute.jquery.org/style-guide/js/) to dwa przykłady projektów z rygorystycznymi stylami kodowania i wytycznymi.

Nie musisz pisać przewodnika po stylu dla swojego projektu, gdy dopiero zaczynasz, i może się okazać, że lubisz włączać różne style kodowania do swojego projektu. Ale powinieneś przewidzieć, w jaki sposób Twój styl pisania i kodowania może przyciągać lub zniechęcać różne typy ludzi. Najwcześniejsze etapy projektu to okazja do ustanowienia precedensu, który chcesz zobaczyć.

## Twoja lista kontrolna przed uruchomieniem

Gotowy do otwarcia twojego projektu? Oto lista kontrolna, która pomoże. Zaznacz wszystkie pola? Jesteś gotowy! [Kliknij „opublikuj”](https://help.github.com/articles/making-a-private-repository-public/) i poklep się po plecach.

**Dokumentacja**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
    Project has a LICENSE file with an open source license
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
    Project has basic documentation (README, CONTRIBUTING, CODE_OF_CONDUCT)
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
    The name is easy to remember, gives some idea of what the project does, and does not conflict with an existing project or infringe on trademarks
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
    The issue queue is up-to-date, with issues clearly organized and labeled
  </label>
</div>

**Kod**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Project uses consistent code conventions and clear function/method/variable names
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    The code is clearly commented, documenting intentions and edge cases
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    There are no sensitive materials in the revision history, issues, or pull requests (for example, passwords or other non-public information)
  </label>
</div>

**Ludzie**

Jeśli jesteś osobą fizyczną:

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
  You've talked to the legal department and/or understand the IP and open source policies of your company (if you're an employee somewhere)
  </label>
</div>

Jeśli jesteś firmą lub organizacją:

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    You've talked to your legal department
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    You have a marketing plan for announcing and promoting the project
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Someone is committed to managing community interactions (responding to issues, reviewing and merging pull requests)
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    At least two people have administrative access to the project
  </label>
</div>

## Zrobiłeś to!

Gratulujemy otwartego zaopatrzenia pierwszego projektu. Bez względu na wynik, praca publiczna jest darem dla społeczności. Z każdym żądaniem zatwierdzenia, komentarza i wyciągnięcia tworzysz możliwości dla siebie i innych do nauki i rozwoju.
