---
lang: pl
title: Zarabianie za pracę Open Source
description: Utrzymaj swoją pracę w otwartym kodzie źródłowym, uzyskując wsparcie finansowe na Twój czas lub projekt.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Dlaczego niektórzy ludzie szukają wsparcia finansowego

Duża część pracy open source jest dobrowolna. Na przykład ktoś może natknąć się na błąd w projekcie, z którego korzysta, i przesłać szybką poprawkę, lub może w wolnym czasie majstrować przy projekcie open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
  <i>
I was looking for a "hobby" programming project that would keep me occupied during the week around Christmas. (...) I had a home computer, and not much else on my hands. I decided to write an interpreter for the new scripting language I had been thinking about lately. (...) I chose Python as a working title.
</i>
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Istnieje wiele powodów, dla których dana osoba nie chce otrzymywać wynagrodzenia za pracę typu open source.

* **Mogą już mieć pracę na pełny etat, którą kochają,** co pozwala im wnieść wkład w open source w wolnym czasie.
* **Lubią myśleć o otwartym źródle jako hobby** lub kreatywnej ucieczce i nie chcą czuć się zobowiązani finansowo do pracy nad swoimi projektami.
* **Dostają inne korzyści z wkładu w open source,** takie jak budowanie reputacji lub portfolio, uczenie się nowych umiejętności lub zbliżenie się do społeczności.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Financial donations do add a feeling of responsibility, for some. (...) It's important for us, in the globally connected, fast-paced world we live in, to be able to say "not now, I feel like doing something completely different".
  <p markdown="1" class="pquote-credit">
  </i>
— @alloy, ["Why We Don't Accept Donations"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Dla innych, szczególnie gdy składki są w toku lub wymagają znacznego czasu, zarabianie na wkładach w open source jest jedynym sposobem, w jaki mogą wziąć udział, ponieważ wymaga tego projekt lub z powodów osobistych.

Utrzymanie popularnych projektów może być znaczącą odpowiedzialnością, ponieważ zajmuje 10 lub 20 godzin tygodniowo zamiast kilku godzin miesięcznie.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Ask any open source project maintainer, and they will tell you about the reality of the amount of work that goes into managing a project. You have clients. You are fixing issues for them. You are creating new features. This becomes a real demand on your time.
  </i>
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["The Ethics of Unpaid Labor and the OSS Community"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Płatna praca umożliwia także osobom z różnych środowisk życiowych wniesienie znaczącego wkładu. Niektóre osoby nie mogą sobie pozwolić na niepłatne spędzanie czasu na projektach typu open source, w oparciu o ich obecną sytuację finansową, zadłużenie, rodzinę lub inne obowiązki opiekuńcze. Oznacza to, że świat nigdy nie dostrzega wkładu utalentowanych ludzi, których nie stać na poświęcenie swojego czasu. Ma to implikacje etyczne, jak to [opisał](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community) @ashedryden, ponieważ praca, która jest wykonana, jest uprzedzony na korzyść tych, którzy już mają zalety w życiu, którzy następnie zyskują dodatkowe korzyści na podstawie swojego wkładu wolontariuszy, podczas gdy inni, którzy nie są w stanie zgłosić się na ochotnika, nie dostają później możliwości, co wzmacnia obecny brak różnorodności w otwartym oprogramowaniu społeczność.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
  <i>
   OSS yields massive benefits to the technology industry, which, in turn, means benefits to all industries. (...) However, if the only people who can focus on it are the lucky and the obsessed, then there's a huge untapped potential.
   </i>
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Money and Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Jeśli szukasz wsparcia finansowego, musisz rozważyć dwie ścieżki. Możesz sfinansować swój czas jako współpracownik lub możesz znaleźć fundusze organizacyjne dla projektu.

## Finansowanie własnego czasu

Obecnie wiele osób otrzymuje wynagrodzenie za pracę w niepełnym lub pełnym wymiarze godzin na otwartym oprogramowaniu. Najczęstszym sposobem zarabiania za czas jest rozmowa z pracodawcą.

Łatwiej jest uzasadnić pracę z otwartym kodem źródłowym, jeśli Twój pracodawca faktycznie korzysta z projektu, ale wykaż się kreatywnością. Być może twój pracodawca nie korzysta z projektu, ale używa Pythona, a utrzymanie popularnego projektu w Pythonie pomaga przyciągnąć nowych deweloperów języka Python. Być może sprawia to, że Twój pracodawca wydaje się bardziej przyjazny dla programistów.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/hzoo?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Like many in open source, I was struggling with the burden of maintaining a project. When I first started doing open source, I used to just stay late to work on it or right when I got home. (...) I was able to discuss with my boss the issues I was facing and we came up with ideas on how we could incorporate open source tasks given our own use of Babel.
  </i>
  <p markdown="1" class="pquote-credit">
— @hzoo, ["Maintainer Stories"](https://github.com/open-source/stories/hzoo)
  </p>
</aside>

Jeśli nie masz istniejącego projektu typu open source, nad którym chciałbyś pracować, ale wolisz, aby twoje bieżące wyniki pracy były typu open source, poproś pracodawcę o otwarcie częściowego oprogramowania wewnętrznego.

Wiele firm opracowuje programy typu open source, aby budować swoją markę i rekrutować talenty wysokiej jakości.

@hueniverse, na przykład stwierdzono, że istnieją finansowe powody, aby uzasadnić [inwestycję Walmarta w open source](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). I @jamesgpearce stwierdził, że program open source Facebooka [zrobił różnicę](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) w rekrutacji:

> It is closely aligned with our hacker culture, and how our organization was perceived. We asked our employees, "Were you aware of the open source software program at Facebook?". Two-thirds said "Yes". One-half said that the program positively contributed to their decision to work for us. These are not marginal numbers, and I hope, a trend that continues.

Jeśli Twoja firma pójdzie tą drogą, ważne jest, aby zachować wyraźne granice między działalnością społeczności a działalnością firmy. Ostatecznie, open source utrzymuje się dzięki wkładom ludzi z całego świata, a to jest większe niż jakakolwiek jedna firma lub lokalizacja.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Getting paid to work on open source is a rare and wonderful opportunity, but you should not have to give up your passion in the process. Your passion should be why companies want to pay you.
  </i>
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Jeśli nie możesz przekonać swojego obecnego pracodawcy do priorytetowego traktowania pracy typu open source, zastanów się nad znalezieniem nowego pracodawcy, który zachęca pracowników do korzystania z oprogramowania typu open source. Poszukaj firm, które wyrażają swoje zaangażowanie w pracę z otwartym oprogramowaniem. Na przykład:

* Niektóre firmy, jak [Netflix](https://netflix.github.io/) lub [PayPal](https://paypal.github.io/), mają strony internetowe, które podkreślają ich zaangażowanie w open source
* [Zalando](https://opensource.zalando.com) opublikował [politykę dotyczącą wkładu typu open source](https://opensource.zalando.com/docs/using/contributing/) dla pracowników

Projekty, które powstały w dużej firmie, takie jak [Go](https://github.com/golang) lub [React](https://github.com/facebook/react), prawdopodobnie również zatrudnią ludzi do pracy na otwartym oprogramowaniu.

W zależności od osobistych okoliczności możesz spróbować samodzielnie zebrać pieniądze, aby sfinansować swoją pracę typu open source. Na przykład:

* @gaearon sfinansował swoją pracę [Redux](https://github.com/reactjs/redux) poprzez [kampanię crowdfundingową Patreon](https://redux.js.org/)
* @andrewgodwin sfinansował prace nad migracjami schematu Django [poprzez kampanię Kickstarter](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

Wreszcie, czasami projekty open source dają nagrody za problemy, z którymi możesz pomyśleć o pomocy.

* @ConnorChristie był w stanie otrzymać wynagrodzenie za [pomoc](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) @MARKETProtocol pracować nad biblioteką javascript [poprzez nagrodę za gitcoin](https://gitcoin.co/).
* @mamiM zrobiłem japońskie tłumaczenia dla @MetaMask po tym, jak [problem został sfinansowany przez Bounties Network](https://explorer.bounties.network/bounty/134).

## Znajdowanie funduszy na swój projekt

Oprócz ustaleń dotyczących indywidualnych uczestników, czasami projekty zbierają pieniądze od firm, osób fizycznych lub innych osób na finansowanie bieżącej pracy.

Finansowanie organizacyjne może zostać przeznaczone na opłacenie obecnych uczestników, pokrycie kosztów prowadzenia projektu (takich jak opłaty za hosting) lub inwestowanie w nowe funkcje lub pomysły.

Wraz ze wzrostem popularności oprogramowania typu open source znalezienie funduszy na projekty jest nadal eksperymentalne, ale dostępnych jest kilka typowych opcji.

### Zbieraj pieniądze na swoją pracę poprzez kampanie crowdfundingowe lub sponsoring

Znalezienie sponsorów działa dobrze, jeśli masz już silną publiczność lub reputację lub twój projekt jest bardzo popularny.
Kilka przykładów sponsorowanych projektów to:

* **[webpack](https://github.com/webpack)** zbiera pieniądze od firm i osób prywatnych [poprzez OpenCollective](https://opencollective.com/webpack)
* **[Vue](https://github.com/vuejs/vue)** jest [finansowany przez Patreon](https://github.com/open-source/stories/yyx990803)
* **[Ruby Together](https://rubytogether.org/),** organizacja non-profit, która płaci za pracę [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), i inne projekty infrastruktury Ruby

### Utwórz strumień przychodów

W zależności od projektu możesz być w stanie pobierać opłaty za wsparcie komercyjne, opcje hostowane lub dodatkowe funkcje. Kilka przykładów obejmuje:

* **[Sidekiq](https://github.com/mperham/sidekiq)** oferuje płatne wersje dodatkowego wsparcia
* **[Travis CI](https://github.com/travis-ci)** oferuje płatne wersje swojego produktu
* **[Ghost](https://github.com/TryGhost/Ghost)** jest organizacją non-profit z płatną usługą zarządzaną

Niektóre popularne projekty, takie jak [npm](https://github.com/npm/npm) oraz [Docker](https://github.com/docker/docker), nawet pozyskały kapitał wysokiego ryzyka w celu wsparcia rozwoju ich działalności.

### Złóż wniosek o dofinansowanie

Niektóre fundacje i firmy oferują granty na prace typu open source. Czasami dotacje można wypłacać osobom fizycznym bez zakładania osobowości prawnej dla projektu.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** otrzymał dotację od [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/)
* **[OpenMRS](https://github.com/openmrs)** praca została sfinansowana przez [Stripe's Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** otrzymał dotację z [Sloan Foundation](https://sloan.org/programs/digital-technology)
* **[Python Software Foundation](https://www.python.org/psf/grants/)** oferuje granty na prace związane z Pythonem

Aby uzyskać bardziej szczegółowe opcje i studia przypadków, @nayafia [napisał przewodnik](https://github.com/nayafia/lemonade-stand) jak zarabiać za pracę typu open source. Różne rodzaje finansowania wymagają różnych umiejętności, więc rozważ swoje mocne strony, aby dowiedzieć się, która opcja będzie dla Ciebie najlepsza.

## Budowanie uzasadnienia wsparcia finansowego

Niezależnie od tego, czy Twój projekt jest nowym pomysłem, czy istnieje już od lat, powinieneś się zastanowić, czy nie zidentyfikować docelowego fundatora i przedstawić przekonujący argument.

Niezależnie od tego, czy chcesz zapłacić za swój czas, czy zbierać fundusze na projekt, powinieneś być w stanie odpowiedzieć na następujące pytania.

### Wpływ

Dlaczego ten projekt jest przydatny? Dlaczego tak lubią Twoi użytkownicy lub potencjalni użytkownicy? Gdzie będzie za pięć lat?

### Trakcja

Postaraj się zebrać dowody na to, że projekt ma znaczenie, czy to metryki, anegdoty czy referencje. Czy są teraz jakieś firmy lub godne uwagi osoby korzystające z Twojego projektu? Jeśli nie, czy wybitna osoba to poparła?

### Wartość do finansowania

Do fundatorów, czy to pracodawcy, czy fundacji przyznającej granty, często zwraca się szansa. Dlaczego powinni wesprzeć Twój projekt w jakikolwiek inny sposób? Jakie korzyści odnoszą osobiście?

### Wykorzystanie funduszy

Co dokładnie osiągniesz dzięki proponowanemu finansowaniu? Skoncentruj się na kamieniach milowych projektu lub jego wynikach, zamiast płacić pensję.

### Jak otrzymasz fundusze

Czy podmiot finansujący ma jakieś wymagania dotyczące wypłaty? Na przykład być może trzeba być organizacją non-profit lub mieć sponsora podatkowego typu non-profit. A może fundusze należy przekazać indywidualnemu kontrahentowi, a nie organizacji. Wymagania te różnią się w zależności od fundatora, dlatego należy wcześniej przeprowadzić badania.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  <i>
  For years, we've been the leading resource of website friendly icons, with a community of over 20 million people and been featured on over 70 million websites, including Whitehouse.gov. (...) Version 4 was three years ago. Web tech's changed a lot since then, and frankly, Font Awesome's gotten a bit stale. (...) That's why we're introducing Font Awesome 5. We're modernizing and rewriting the CSS and redesigning every icon from top to bottom. We're talking better design, better consistency, and better readability.
  </i>
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Eksperymentuj i nie poddawaj się

Zbieranie pieniędzy nie jest łatwe, bez względu na to, czy jesteś projektem typu open source, organizacją non-profit, czy też uruchomieniem oprogramowania, aw większości przypadków wymaga kreatywności. Określenie, w jaki sposób chcesz otrzymać zapłatę, przeprowadzenie badań i postawienie się w sytuacji gracza finansującego, pomoże ci zbudować przekonującą argumentację za finansowaniem.
