---
lang: pl
title: Twój kodeks postępowania
description: Ułatwienie zdrowego i konstruktywnego zachowania społeczności poprzez przyjęcie i egzekwowanie kodeksu postępowania.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## Dlaczego potrzebuję kodeksu postępowania?

Kodeks postępowania to dokument, który określa oczekiwania dotyczące zachowania uczestników projektu. Przyjęcie i egzekwowanie kodeksu postępowania może pomóc stworzyć pozytywną atmosferę społeczną dla społeczności.

Kodeksy postępowania chronią nie tylko uczestników, ale i ciebie. Jeśli utrzymasz projekt, może się okazać, że nieproduktywne postawy innych uczestników mogą z czasem powodować wyczerpanie lub niezadowolenie z pracy.

Kodeks postępowania umożliwia ci zdrowe, konstruktywne zachowanie społeczności. Aktywne podejście zmniejsza prawdopodobieństwo zmęczenia twojego projektu i pomaga podejmować działania, gdy ktoś robi coś, z czym się nie zgadzasz.

## Ustanowienie kodeksu postępowania

Postaraj się ustalić kodeks postępowania tak wcześnie, jak to możliwe: najlepiej przy pierwszym tworzeniu projektu.

Oprócz przekazywania swoich oczekiwań kodeks postępowania opisuje następujące kwestie:

* Gdzie obowiązuje kodeks postępowania _(tylko w przypadku problemów i wniosków lub działań społeczności, takich jak wydarzenia?)_
* Do kogo odnosi się kodeks postępowania _(członkowie społeczności i opiekunowie, ale co ze sponsorami?)_
* Co się stanie, jeśli ktoś naruszy kodeks postępowania
* Jak ktoś może zgłaszać naruszenia

Gdziekolwiek możesz, skorzystaj ze stanu techniki. [Przymierze współautorów](https://contributor-covenant.org/) to rozwijany kodeks postępowania używany przez ponad 40 000 projektów open source, w tym Kubernetes, Rails i Swift.

[Kodeks postępowania Django](https://www.djangoproject.com/conduct/) oraz [Kodeks postępowania obywatelskiego](http://citizencodeofconduct.org/) to także dwa przykłady dobrego kodeksu postępowania.

Umieść plik CODE_OF_CONDUCT w katalogu głównym projektu i uczyń go widocznym dla społeczności, łącząc go z plikiem CONTRIBUTING  lub README.

## Decydowanie o tym, jak będziesz egzekwować swój kodeks postępowania

<aside markdown="1" class="pquote">
  A code of conduct that isn't (or can't be) enforced is worse than no code of conduct at all: it sends the message that the values in the code of conduct aren't actually important or respected in your community.
  <p markdown="1" class="pquote-credit">
— [Ada Initiative](https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community/)
  </p>
</aside>

Musisz wyjaśnić, w jaki sposób Twój kodeks postępowania będzie egzekwowany **_zanim_** nastąpi naruszenie. Istnieje kilka powodów:

* To pokazuje, że poważnie podchodzisz do działania, gdy jest to potrzebne.

* Twoja społeczność poczuje się bardziej pewnie, że skargi faktycznie zostaną rozpatrzone.

* Zapewnisz swoją społeczność, że proces sprawdzania jest uczciwy i przejrzysty, jeśli kiedykolwiek zostaną zbadani pod kątem naruszenia.

Powinieneś dać ludziom prywatny sposób (np. Adres e-mail), aby zgłosić naruszenie zasad postępowania i wyjaśnić, kto otrzyma to zgłoszenie. Może to być opiekun, grupa opiekunów lub grupa robocza ds. Kodeksu postępowania.

Nie zapominaj, że ktoś może chcieć zgłosić naruszenie dotyczące osoby, która je otrzyma. W takim przypadku daj im możliwość zgłaszania naruszeń komuś innemu. Na przykład, @ctb oraz @mr-c [explain on their project](https://github.com/dib-lab/khmer/blob/master/CODE_OF_CONDUCT.rst), [khmer](https://github.com/dib-lab/khmer):

> Przypadki obraźliwych, nękających lub w inny sposób niedopuszczalnych zachowań można zgłaszać, wysyłając wiadomość e-mail na adres **khmer-project@idyll.org**, który jest wysyłany tylko do C. Titusa Browna i Michaela R. Crusoe. Aby zgłosić problem dotyczący któregokolwiek z nich, wyślij wiadomość e-mail **dr Judi Brown Clarke** dyrektor ds. Różnorodności w Centrum Badań nad Ewolucją w Działaniu BEACON, Centrum Nauki i Technologii NSF.*

Aby uzyskać inspirację, zapoznaj się z [instrukcją egzekwowania Django](https://www.djangoproject.com/conduct/enforcement-manual/) (chociaż możesz nie potrzebować czegoś tak kompleksowego, w zależności od wielkości twojego projektu).

## Egzekwowanie Twojego kodeksu postępowania

Czasami, pomimo twoich starań, ktoś zrobi coś, co narusza ten kod. Istnieje kilka sposobów przeciwdziałania negatywnym lub szkodliwym zachowaniom.

### Zbierz informacje o sytuacji

Traktuj głos każdego członka społeczności tak samo ważny jak własny. Jeśli otrzymasz zgłoszenie, że ktoś naruszył kodeks postępowania, podejmij go poważnie i zbadaj sprawę, nawet jeśli nie pasuje on do twoich doświadczeń z tą osobą. Takie postępowanie sygnalizuje społeczności, że cenisz ich perspektywę i ufasz ich osądowi.

Członek społeczności, o którym mowa, może być wielokrotnym przestępcą, który konsekwentnie sprawia, że inni czują się niekomfortowo, lub mogą powiedzieć coś lub zrobić tylko raz. Oba mogą być podstawą do podjęcia działania, w zależności od kontekstu.

Zanim odpowiesz, daj sobie czas na zrozumienie, co się stało. Przeczytaj wcześniejsze komentarze i rozmowy tej osoby, aby lepiej zrozumieć, kim ona jest i dlaczego mogła postąpić w taki sposób. Spróbuj zebrać inne niż własne opinie na temat tej osoby i jej zachowania.

<aside markdown="1" class="pquote">
  Don’t get pulled into an argument. Don’t get sidetracked into dealing with someone else’s behavior before you’ve finished dealing with the matter at hand. Focus on what you need.
  <p markdown="1" class="pquote-credit">
— Stephanie Zvan, ["So You've Got Yourself a Policy. Now What?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### Podejmij odpowiednie działania

Po zebraniu i przetworzeniu wystarczających informacji musisz zdecydować, co robić. Rozważając kolejne kroki, pamiętaj, że Twoim celem jako moderatora jest promowanie bezpiecznego, pełnego szacunku i współpracy środowiska. Zastanów się nie tylko, jak poradzić sobie z daną sytuacją, ale także, w jaki sposób twoja reakcja wpłynie na dalsze zachowania i oczekiwania twojej społeczności.

Gdy ktoś zgłosi naruszenie kodeksu postępowania, jego zadaniem jest zająć się nim, a nie jego obowiązkiem. Czasami reporter ujawnia informacje z dużym ryzykiem dla ich kariery, reputacji lub bezpieczeństwa fizycznego. Zmuszenie ich do konfrontacji z napastnikiem może postawić reportera w kompromitującej sytuacji. Należy obsługiwać bezpośrednią komunikację z daną osobą, chyba że reporter wyraźnie zażąda inaczej.

Istnieje kilka sposobów reagowania na naruszenie kodeksu postępowania:

* **Daj osobie, o której mowa, publiczne ostrzeżenie** i wyjaśnij, w jaki sposób ich zachowanie wpłynęło negatywnie na innych, najlepiej w kanale, w którym miało miejsce. Tam, gdzie to możliwe, komunikacja publiczna przekazuje reszcie społeczności, że poważnie podchodzisz do kodeksu postępowania. Bądź miły, ale stanowczy w swojej komunikacji.

* **Prywatnie skontaktuj się z osobą** w celu wyjaśnienia, w jaki sposób ich zachowanie wpłynęło negatywnie na innych. Możesz skorzystać z prywatnego kanału komunikacji, jeśli sytuacja dotyczy poufnych danych osobowych. Jeśli komunikujesz się z kimś prywatnie, dobrym pomysłem jest skontaktowanie się z osobami, które jako pierwsze zgłosiły sytuację, aby wiedziały, że podjąłeś działania. Poproś osobę zgłaszającą o zgodę przed jej wysłaniem.

Czasami nie można osiągnąć rozdzielczości. Dana osoba może stać się agresywna lub wroga, gdy zostanie skonfrontowana lub nie zmieni swojego zachowania. W tej sytuacji możesz rozważyć podjęcie silniejszych działań. Na przykład:

* **Zawieś osobę** w kwestii projektu, egzekwowane przez tymczasowy zakaz uczestnictwa w jakimkolwiek aspekcie projektu

* **Trwale zbanuj** tę osobę w projekcie

Zbanowanych członków nie należy lekceważyć, stanowią trwałą i niemożliwą do pogodzenia różnicę perspektyw. Powinieneś podjąć te środki tylko wtedy, gdy jest jasne, że nie można osiągnąć rozwiązania.

## Twoje obowiązki jako opiekuna

Kodeks postępowania nie jest prawem egzekwowanym arbitralnie. Jesteś podmiotem egzekwującym kodeks postępowania i Twoim obowiązkiem jest przestrzegać zasad ustanowionych w tym kodeksie postępowania.

Jako opiekun ustalasz wytyczne dla swojej społeczności i egzekwujesz je zgodnie z zasadami określonymi w kodeksie postępowania. Oznacza to poważne potraktowanie każdego zgłoszenia naruszenia kodeksu postępowania. Zgłaszającemu należy się dokładna i rzetelna ocena jego skargi. Jeśli stwierdzisz, że zgłoszone przez nich zachowanie nie stanowi naruszenia, przekaż im to jasno i wyjaśnij, dlaczego nie zamierzasz podjąć działań w związku z tym. To, co zrobią z tym, zależy od nich: tolerować zachowanie, z którym mieli problem, lub przestać uczestniczyć w społeczności.

Raport o zachowaniu, który nie narusza kodeksu postępowania technicznego, może nadal wskazywać na problem w Twojej społeczności i powinieneś zbadać ten potencjalny problem i podjąć odpowiednie działania. Może to obejmować rewizję twojego kodeksu postępowania w celu wyjaśnienia dopuszczalnego zachowania i / lub rozmowę z osobą, której zachowanie zostało zgłoszone i poinformowanie ich, że chociaż nie naruszyli kodeksu postępowania, omijają granicę oczekiwań i upewniają się uczestnicy czują się niekomfortowo.

W końcu, jako opiekun, ustalasz i egzekwujesz standardy dotyczące akceptowalnego zachowania. Masz możliwość kształtowania wartości społeczności w ramach projektu, a uczestnicy oczekują, że egzekwujesz te wartości w uczciwy i zrównoważony sposób.

## Zachęcaj do zachowań, które chcesz zobaczyć na świecie 🌎

Kiedy projekt wydaje się wrogi lub niechciany, nawet jeśli jest to tylko jedna osoba, której zachowanie jest tolerowane przez innych, ryzykujesz utratą znacznie większej liczby współpracowników, z którymi niektórzy mogą nawet nie spotkać. Przyjęcie lub egzekwowanie kodeksu postępowania nie zawsze jest łatwe, ale promowanie przyjaznego środowiska pomoże Twojej społeczności w rozwoju.
