---
lang: ko
title: 프로젝트에 기여할 사람 찾기
description: 당신의 오픈소스 프로젝트가 행복한 사용자들의 손길 아래 성장할 수 있게 만드세요.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Spreading the word

시작할 때부터 오픈소스 프로젝트를 홍보해야 한다는 규칙은 없습니다. 오픈소스에 기여하는 데는 인기와 무관한 많은 이유가 있습니다. 사람들이 여러분의 오픈소스 프로젝트를 찾고 이용해주기를 기대하지만 말고 여러분의 노력에 대한 이야기를 퍼뜨려야 합니다!

## Figure out your message

프로젝트를 홍보하기 위한 실질적인 작업을 시작하기 전에 프로젝트가 무엇을 하고 왜 중요한지 설명할 수 있어야 합니다.

무엇이 여러분의 프로젝트를 색다르고 흥미롭게 만드나요? 왜 프로젝트를 시작했나요? 이러한 질문에 직접 답하면 프로젝트의 중요성을 알리는 데 도움이 됩니다.

여러분의 프로젝트가 사람들의 문제를 해결해주기 때문에 사람들은 사용자가 되고 기여자가 될 것이라는 점을 기억하세요. 프로젝트의 메시지와 가치에 대해 생각할 때 사용자와 기여자의 관점으로 바라보세요.

예를 들어 @robb는 코드 예제를 사용해 그의 프로젝트 [Cartography](https://github.com/robb/Cartography)가 왜 유용한지 명확하게 알려줍니다.

![Cartography README](/assets/images/finding-users/cartography.jpg)

메시지 전달에 대해 더 알아보고 싶다면 사용자 페르소나 개발을 위한 Mozilla의 ["Personas and Pathways"](http://mozillascience.github.io/working-open-workshop/personas_pathways/)를 참조하세요.

## Help people find and follow your project

<aside markdown="1" class="pquote">
  You ideally need a single "home" URL that you can promote and point people to in relation to your project. You don't need to splash out on a fancy template or even a domain name, but your project needs a focal point.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

정보를 한 곳에 집중시켜 사람들이 여러분의 프로젝트를 찾고 기억하기 더 쉽게 만드세요.

**여러분의 작업을 홍보하기 위한 핸들을 정하세요.** 트위터 계정, GitHub URL, IRC 채널 등은 사람들을 여러분의 프로젝트에 끌어들이는 쉬운 방법입니다. 이런 바깥 연락망은 성장하는 프로젝트 커뮤니티가 모일 장소를 제공해 줍니다.

아직 프로젝트 계정이나 사이트 등을 만들고 싶지 않다면, 대신 여러분이 하는 모든 일에서 여러분 스스로의 트위터 혹은 GitHub 계정을 홍보하세요. 사람들이 여러분에게 연락하거나 여러분의 프로젝트에 관심을 가질 수 있게 할 것입니다. 모임이나 행사에서 발표를 한다면 약력이나 슬라이드에 꼭 연락처를 적어 두세요.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  A mistake I made in those early days (...) was not starting a Twitter account for the project. Twitter's a great way to keep people up to date about a project as well as constantly expose people to the project.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned”](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**프로젝트 웹사이트 작성을 고려하세요.** 깔끔한 문서와 튜토리얼을 담은 웹사이트는 여러분의 프로젝트를 더 친근하고 탐색하기 쉽게 만듭니다. 웹사이트가 있으면 프로젝트가 더 활성화되어 있다는 느낌을 주고, 이는 방문자들이 프로젝트를 더 편한 마음으로 사용할 수 있게 할 것입니다. 사람들에게 아이디어를 주기 위해 여러분의 프로젝트를 유용하게 사용할 수 있는 예시를 제공하세요.

Django의 공동 크리에이터인 [@adrianholovaty](https://news.ycombinator.com/item?id=7531689)는 웹사이트 운영이 "우리가 Django 개발 초반에 했던 일들 중 가장 잘한 일"이었다고 말했습니다.

여러분의 프로젝트가 GitHub에서 호스팅된다면 [GitHub Pages](https://pages.github.com/)를 이용해 쉽게 웹사이트를 만들 수 있습니다. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), [Middleman](https://middlemanapp.com/) 같은 포괄적 웹사이트의 훌륭한 [예시](https://github.com/showcases/github-pages-examples)를 참조하세요.

![Vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

이제 여러분은 프로젝트에 대한 메시지와 사람들이 프로젝트를 쉽게 찾아올 수 있는 길을 마련했습니다. 세상으로 나가서 사람들에게 널리 알리세요!

## Go where your project's audience is (online)

온라인에서의 활동은 이야기를 빠르게 퍼트리는 훌륭한 방법입니다. 온라인 채널을 이용하면 아주 넓은 층의 잠재 사용자 혹은 기여자와 닿을 수 있습니다.

기존의 온라인 커뮤니티나 플랫폼을 이용해 청중에게 다가가세요. 여러분의 오픈소스 프로젝트가 소프트웨어 프로젝트라면 [Stack Overflow](http://stackoverflow.com/), [Reddit](http://www.reddit.com), [Hacker News](https://news.ycombinator.com/), [Quora](https://www.quora.com/) 같은 곳에서 관심 있는 사람을 찾을 수 있을 것입니다. 여러분의 작품을 가장 유용하게 쓰거나 반가워할 것 같은 사람들이 모인 채널을 찾으세요.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Each program has very specific functions that only a fraction of users will find useful. Don't spam as many people as possible. Instead, target your efforts to communities that will benefit from knowing about your project.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects”](http://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

어떻게 여러분의 프로젝트를 공유할 수 있을지 더 알아봅시다.

* **관련된 오픈소스 프로젝트와 커뮤니티를 찾으세요.** 프로젝트를 직접 홍보할 필요가 없을 때도 있습니다. 예컨대 여러분의 프로젝트가 파이썬을 사용하는 데이터 사이언티스트에게 딱 맞는다면 파이썬 데이터 사이언티스트 커뮤니티를 찾아가세요. 그곳의 사람들이 여러분을 잘 알게 되면, 여러분의 프로젝트에 대해 이야기할 기회도 자연스럽게 늘어날 것입니다.
* **여러분의 프로젝트가 해결할 수 있는 문제를 겪고 있는 사람을 찾으세요.** 관련 포럼에서의 검색을 통해 프로젝트의 목표 사용자층을 찾고, 그들의 질문에 답해주며 적절한 때에 재치 있게 여러분의 프로젝트를 해결책으로서 제시하는 방법도 있습니다.
* **피드백을 요청하세요.** 관심과 흥미를 가질 만한 사람들에게 여러분과 여러분의 프로젝트를 소개하세요. 프로젝트를 어떤 사람들이 유용하게 사용할 수 있을지에 대한 여러분의 생각을 구체적으로 말하세요. 문장은 이런 식으로 끝내는 것이 좋습니다. "제 프로젝트가 X를 하려는 Y 여러분들에게 분명 큰 도움이 될 거라고 생각해요." 프로젝트를 홍보하기만 하지 말고 사람들의 피드백에 귀 기울이고 답변하세요.

사람들로부터 무언가를 받고자 한다면 그 전에 그들을 도와주는 데 집중하세요. 프로젝트를 온라인에서 홍보하는 것은 누구나 할 수 있는 쉬운 일이기 때문에 아주 많은 경쟁이 있는 셈입니다. 그 사이에서 눈에 띄려면 사람들에게 여러분이 무엇을 원하는가가 아닌 여러분이 어떤 사람인가를 알려야 합니다.

여러분의 노력에도 불구하고 아무도 관심을 가지지 않는다면, 너무 실망하지 마세요! 대부분의 프로젝트는 초기 단계에 수 개월부터 수 년의 시간을 필요로 합니다. 처음 시도에 반응을 얻지 못한다면, 다른 전략을 시도하거나 다른 사람의 프로젝트에 가치를 제공할 방법을 찾아보세요. 프로젝트를 홍보하고 본궤도에 올리는 데에는 충분한 시간과 노력이 필요합니다.

## Go where your project's audience is (offline)

![Public speaking](/assets/images/finding-users/public_speaking.jpg)

오프라인 행사는 새로운 프로젝트를 홍보하는 인기 있는 수단입니다. 오프라인 행사는 분야에서 활동 중인 사람들과 만나고 그들과 인간관계를 쌓을 절호의 기회입니다. 특히 개발자들과 친해지는 데 관심이 있다면 더욱 그렇습니다.

사람들 앞에서 [발표](http://speaking.io/)하는 것이 익숙하지 않다면 여러분의 프로젝트가 사용하는 언어나 시스템에 관련된 지역 모임을 찾는 것부터 시작하세요.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  I was pretty nervous about going to PyCon. I was giving a talk, I was only going to know a couple of people there, I was going for an entire week. (...) I shouldn't have worried, though. PyCon was phenomenally awesome! (...) Everyone was incredibly friendly and outgoing, so much that I rarely found time not to talk to people!
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon”](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

행사에서의 발표가 처음이라면 긴장되는 것은 당연한 일입니다! 청중들이 모인 이유는 여러분의 프로젝트에 대해 듣고 싶어서라는 사실을 기억하세요.

이야기를 풀어나가면서 청중들이 어떤 부분에 흥미를 느끼고 있는지, 그리고 어떤 부분에서 가치를 얻을 수 있을지에 집중하세요. 친절하고 상냥한 말투를 사용하세요. 미소 짓고, 호흡하고, 즐기면 됩니다.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  When you start writing your talk, no matter what your topic is, it can help if you see your talk as a story that you tell people.
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk”](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

준비가 되었다면 프로젝트 홍보를 위해 컨퍼런스에서 발표하는 것도 고려해 보세요. 컨퍼런스는 온 세상의 다양한 사람들을 만날 기회를 제공합니다.

여러분이 사용하는 언어와 시스템에 관한 컨퍼런스를 찾으세요. 발표 신청서를 제출하기 전에 컨퍼런스를 조사한 뒤, 발표 내용을 청중의 상황에 맞게 다듬어 신청이 받아들여질 가능성을 높이세요. 컨퍼런스의 발표자들에 대해 알아보면 전반적인 청중의 성향을 파악할 수 있습니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  I wrote very nicely to the JSConf people and begged them to give me a slot where I could present it at JSConf EU. (...) I was extremely scared, presenting this thing that I had been working on for six months. (...) The whole time I was just thinking, oh my God. What am I doing here?
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js” (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Build a reputation

지금까지 다루어진 전략에 더해서, 여러분의 프로젝트에 기여할 사람들을 초대하는 가장 좋은 방법은 바로 그들의 프로젝트에 기여하는 것입니다.

신입을 돕고, 자원을 공유하고, 다른사람들의 프로젝트에 사려 깊은 기여를 하는 것은 긍정적인 평판을 쌓는 데 도움이 됩니다. 오픈소스 커뮤니티에서 적극적으로 활동하는 회원이 되면 다른 회원들이 여러분이 하는 일에 대한 맥락을 얻게 되고, 여러분의 프로젝트에 관심을 갖고 프로젝트를 공유해 줄 가능성이 높아집니다. 타 오픈소스 프로젝트와의 관계가 발전하면 공식적인 파트너십으로 연결될 수도 있습니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  The only reason urllib3 is the most popular third-party Python library today is because it's part of requests.
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive”](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

어느 순간도 평판을 쌓기에는 너무 늦거나 이르지 않습니다. 이미 여러분의 프로젝트를 공개했더라도 사람들을 도울 방법을 항상 찾아 다니세요.

하룻밤 사이에 청중을 확보하는 비법 같은 것은 없습니다. 사람들의 신뢰와 존경심을 얻는 데에는 시간이 필요하고, 평판은 아무리 오래 관리해도 그 끝이 없습니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ariya?s=180" class="pquote-avatar" alt="avatar">
  PhantomJS was released for the first time in the beginning of 2011. (...) I spread the word in the usual ways: I tweeted about it, I wrote blog posts on things you could do with it, I mentioned it during various discussions in meetups. When it became more well known in 2014, I started giving presentations about it.
  <p markdown="1" class="pquote-credit">
— @ariya, ["Maintainer Stories”](https://github.com/open-source/stories/ariya)
  </p>
</aside>

## Keep at it!

사람들이 여러분의 프로젝트에 관심을 갖는 데 오랜 시간이 걸릴 수도 있지만 괜찮습니다! 유명한 프로젝트 중 몇몇은 지금의 경지에 다다르기 위해 몇 년이 들었습니다. 프로젝트가 갑자기 유명해지기를 바라는 대신 관계를 쌓는 데 집중하세요. 인내심을 가지고, 여러분의 노력에 고마워하는 사람들과 작업을 계속 공유하세요.
