---
lang: ja
title: オープンソースメトリクス
description: 成功の度合いを計測し続けることで、データをもとにしてあなたのオープンソースプロジェクトに関する意思決定を行おう。
class: metrics
order: 9
image: /assets/images/cards/metrics.png
related:
  - finding
  - best-practices
---

## なぜあらゆるものを計測するか？

データを賢く使うことで、オープンソースのメンテナーとしてより良い意思決定を行う助けとなります。

より多くの情報を得ることによって、下記が可能となります：

* ユーザーが新機能に対してどう反応しているかを理解する
* 新しいユーザーがどこから来ているのかを把握する
* 滅多にないユースケースや滅多に使われない機能を特定し、今後サポートするかどうかを決める
* プロジェクトの人気を定量化する
* プロジェクトがどのように使われているかを理解する
* スポンサーや補助金によって資金を獲得する

例えば、 [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Analytics.md) では、 Google Analytics を使うことでやることの優先順位付けの役に立つということに気づきました：

> Homebrew は無償で提供されており、ボランティアが空き時間で運営しています。その結果、 Homebrew ユーザーについて調査を行って将来の機能を設計する最善の方法を検討したり、現在の作業の優先順位付けを行うためのリソースが不足しています。匿名化されたユーザー解析を行うことによって、人々が Homebrew をいつ、どこで、どのように使っているかを知ることができ、修正や機能の優先順位付けができるようになっています。

人気を得ることだけが全てではありません。人々がオープンソースプロジェクトに参加する理由は様々です。メンテナーとしてのあなたのゴールが注目を集めることであったり、あなたのコードを共有すること、もしくは単に楽しみたいのであれば、メトリクスはあなたにとって重要ではないかもしれません。

もしあなたがプロジェクトをより深いレベルで _理解したいと思っている_ のであれば、以降を読んでプロジェクトの活動を分析する方法を学びましょう。

## 発見

他の人があなたのプロジェクトにコントリビュートしてくれるようになるには、彼らにあなたのプロジェクトの存在を知ってもらう必要があります。この質問を自問してみましょう: _人々はこのプロジェクトをみつけられているだろうか？_

![トラフィックグラフ](/assets/images/metrics/repo_traffic_graphs_tooltip.png)

もしプロジェクトを GitHub 上にホストしているのであれば、何人があなたのプロジェクトを訪れていて、どこから来たのかを[見ることが出来ます](https://help.github.com/articles/about-repository-graphs/#traffic)。プロジェクトのページで、 "Insights" をクリックし、 "Traffic" をクリックします。このページでは、下記を見ることが出来ます:
 
* **トータルページビュー:** プロジェクトが何回閲覧されたか

* **トータルユニークビジター:** プロジェクトが何人に閲覧されたか

* **参照しているサイト:** 訪問者がどこから来たか。この指標は、どこでプロジェクトに興味がある人に接触することができるかを把握したり、宣伝がうまくいっているかどうかを判断する助けとなります。

* **人気のあるコンテンツ:** 訪問者がプロジェクト上のどこを閲覧しているか。ページビューとユニークビジターをコンテンツごとに把握することが出来ます。

[GitHub のスター](https://help.github.com/articles/about-stars/)も、プロジェクトの人気を測る上での基準となります。 GitHub のスターは必ずしもプロジェクトのダウンロード数や利用数と関連していませんが、何人がプロジェクトの通知を受け取っているかを知ることが出来ます。

また、[特定の場所での見つけやすさ](https://opensource.com/business/16/6/pirate-metrics)もトラッキングしたいかもしれません：例えば、 Google PageRank 、プロジェクトのウェブサイトからの流入や他のオープンソースプロジェクトやウェブサイトからの流入などです。

## 使われ方

人々は、インターネットという荒野であなたのプロジェクトを見つけようとしているのです。理想的には、あなたのプロジェクトを見かけたらすぐに、使いたいと思って欲しいわけです。そこで、あなたが気になるであろう2つ目の質問はこれです： _人々はこのプロジェクトを使っているだろうか？_

もしプロジェクトを配布するのに npm や RubyGems.org のようなパッケージマネジャーを使っているのであれば、プロジェクトのダウンロード数をトラッキングできるかもしれません。

パッケージマネジャーごとに「ダウンロード」の定義は若干異なりますし、ダウンロードしたからといって必ずしもインストールしたり使ったりするわけではありません。しかし、比較のための基準にはなりえます。様々な有名なパッケージマネジャー間で利用統計をトラックする [Libraries.io](https://libraries.io/) を使ってみましょう。

もしプロジェクトを GitHub でホストしているのであれば、再度 "Traffic" ページを見てみましょう。そこでは [clone graph](https://github.com/blog/1873-clone-graphs) によって、あなたのプロジェクトが日毎に何度クローンされたか、トータルのクローン数とクローンを実行したユニークユーザー数を見ることが出来ます。

![Clone graph](/assets/images/metrics/clone_graph.png)

もし、プロジェクトを訪問してくれている人の数に比べて利用率が低いようであれば、考えられる理由は以下の2つのどちらかでしょう:

* 訪問してくれた人にユーザーになってもらうのに失敗している
* 間違った人々にアピールしている

例えば、あなたのプロジェクトが Hacker News のトップページに載った場合、トラフィックのスパイクが発生するでしょうが、コンバージョンレートは低下します。 Hacker News を見ている全員にリーチしてしまうからです。しかし、もしあなたのプロジェクトが Ruby を使っていて、 Ruby のカンファレンスで取り上げられたのであれば、ターゲットとしている人々にリーチできるのでより高いコンバージョンレートになる可能性が高くなります。

あなたのプロジェクトに興味を持った人がどこから来ているかを把握し、上記の2つの問題が起きていないかプロジェクトページでフィードバックを求めてみましょう。

人々があなたのプロジェクトを使っていることがわかったら、どのように使っているかを知りたくなるでしょう。あなたのプロジェクトをフォークして、機能を追加しているのでしょうか？彼らは科学プロジェクトのために使っているのでしょうか、それともビジネスで使っているのでしょうか？

## リテンション

あなたのプロジェクトを見つけて使っている人がいるということがわかりました。あなたが自問するであろう次の疑問はこれでしょう： _人々はプロジェクトにコントリビュートしているだろうか？_

コントリビューターについて考え始めるのに早すぎる事はありません。あなた以外の人々からの支援なしでは、プロジェクトが有名（沢山の人が使っている）になってもサポートされていない（必要なメンテナー作業を行うことが出来ない）という不健康な状況に陥るリスクがあります。

活動的だったコントリビューターも最終的には他に移ってしまうため、リテンションには[新しいコントリビューターの流入](http://blog.abigailcabunoc.com/increasing-developer-engagement-at-mozilla-science-learning-advocacy#contributor-pathways_2)も必要です。

下記に定期的にトラッキングした方が良いコミュニティメトリクスの例を挙げます：

* **コントリビューターのトータルの人数とコントリビューター毎のコミット数:** コントリビューターが何人いるか、そして誰がより活動的か。 GitHub では、 "Insights" -> "Contributors" から見ることが出来ます。今現在はこのグラフはリポジトリのデフォルトブランチにコミットをしたコントリビューターのみを計上しています。

![Contributor graph](/assets/images/metrics/repo_contributors_specific_graph.png)

* **初めてのコントリビューター、一時的なコントリビューター、常連のコントリビューター:** 新しいコントリビューターを獲得できているかどうかや、彼らが再度コントリビュートしてくれているかどうかをトラッキングします。（一時的なコントリビューターとは、コミット数が少ないコントリビューターのことです。それが1コミットだけの人なのか、5コミット以下の人なのかはあなた次第です）。新しいコントリビューターが来ないと、プロジェクトのコミュニティは停滞してしまいます。

* **オープンなイシューとオープンなプルリクエストの数:** もしこれらの数値が高すぎるようであれば、イシューのトリアージやコードレビューに手助けが必要かもしれません。

* **_オープンされた_ イシューと _オープンされた_ プルリクエストの数:** オープンされたイシューの数から、イシューをオープンするほどあなたのプロジェクトを気にかけている人がいるということがわかります。もし時間を経るに従ってその数が増えているのであれば、より多くの人がプロジェクトに興味を持ってくれているということを示しています。

* **コントリビュートの種類:** 例えば、コミット、タイポやバグの修正、イシューへのコメントなどです。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/arfon?s=180" class="pquote-avatar" alt="avatar">
  オープンソースというのはコードだけの話ではありません。成功するオープンソースプロジェクトでは、コードやドキュメントへのコントリビュートに加えて、それらの変更についての議論も行われているものです。
  <p markdown="1" class="pquote-credit">
— @arfon, ["The Shape of Open Source"](https://github.com/blog/2195-the-shape-of-open-source)
  </p>
</aside>

## メンテナーの活動

最後に、プロジェクトのメンテナーが受け取ったコントリビュートを処理することが出来ているかどうかを確かめましょう。自問すべき最後の質問はこれです： _私は（もしくは私達は）コミュニティに反応しているだろうか？_

反応のないメンテナーはオープンソースプロジェクトのボトルネックとなります。もし誰かがコントリビュートしようとしても、メンテナーから返事がなければ彼らはがっかりして去ってしまうでしょう。

[Mozilla の調査によると](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177)、メンテナーの反応の早さは繰り返しコントリビュートしてもらうための重大な要素です。

イシューに対してでもプルリクエストに対してでも、コントリビュートに対してあなた（もしくは別のメンテナー）が反応するのにかかった時間をトラッキングすることを検討しましょう。反応をするために必ずしもアクションを起こす必要はありません。一言こういうだけでも良いのです： _「提案ありがとうございます！来週確認します。」_

下記のようなコントリビュートのプロセスのステージごとの時間を計測することも出来ます：

* イシューがオープンである平均期間
* イシューがプルリクエストによってクローズされたかどうか
* 古くなったイシューがクローズされたかどうか
* プルリクエストをマージするまでの平均期間

## 人々について学ぶために📊を使いましょう

メトリクスを理解することで、活発で成長するオープンソースプロジェクトを作り上げる助けとなります。たとえ全ての指標をダッシュボードで可視化していなくても、プロジェクトを成功させるために必要な行動の種類に注目するために上述のフレームワークを使いましょう。
