---
lang: ja
title: リーダーシップと組織運営
description: 意思決定するためのルールを決めることで、オープンソースプロジェクトを成長させる助けとなります
class: leadership
order: 6
image: /assets/images/cards/leadership.png
related:
  - best-practices
  - metrics
---

## 成長中のプロジェクトの運営方法を理解しよう

あなたのプロジェクトは成長しており、人々が携わっていて、あなたは物事がこのまま進むように維持することに熱心でしょう。この段階では、あなたはどのようにして通常のコントリビューターをワークフローに組み込むのが良いか悩んでいるかもしれません。誰かにコミット権限を与えるかどうかであったり、コミュニティの議論をどのように収集させるのかであったり。もしこういった疑問があるのであれば、私達は答えを知っています。

## オープンソースプロジェクトで使われる公式の役割の例はなんですか？

多くのプロジェクトでは、コントリビューターの役割は似たようなものを使っています。

しかし、こういった役割が実際の所何を意味するのかは、完全にあなた次第です。下記にあなたが知っているであろう役割を挙げます：

* **メンテナー**
* **コントリビューター**
* **コミッター**

**幾つかのプロジェクトでは、「メンテナー」は** コミット権限を持っている唯一の人です。他のプロジェクトでは、単に README にメンテナーとして記載されている人であることもあります。

メンテナーはプロジェクトでコードを書いている人である必要はありません。プロジェクトの布教を熱心に行っている人でも良いですし、多くのドキュメントを書くことで他の人がプロジェクトにアクセスしやすくしている人でも良いのです。日常的に何をやっているのかにかかわらず、メンテナーはプロジェクトの方向性に責任を持っていると感じていて、またプロジェクトを改善するのに熱心である人でしょう。

**「コントリビューター」は誰でもなり得ます。** それは、イシューやプルリクエストにコメントを書いている人かもしれないし、プロジェクトに価値を与える（イシューを選別する、コードを書く、イベントを運営するなど）人かもしれないし、プルリクエストをマージしてもらった人（おそらくこれが最も狭義のコントリビューターの定義です）かもしれません。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  \[Node.js では、\] イシューにコメントした人やコードを書いた人は皆コミュニティのメンバーなのです。彼らに会えたということは、ユーザーからコントリビューターへの一線を越えたということを意味しています。
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Healthy Open Source"](https://medium.com/the-javascript-collection/healthy-open-source-967fa8be7951)
  </p>
</aside>

**「コミッター」という言葉は** コミットアクセスという特定の種類の責務を、他の種類のコントリビュートと区別するために使われるでしょう。

あなたの好きなようにプロジェクトの役割を定義できますが、より多くの種類のコントリビュートを奨励するためにより[広い定義を検討しましょう](../how-to-contribute/#コントリビュートするということが意味するもの)。プロジェクトに多大なコントリビュートをしている人に対しては、その人の技術スキルがどうであれ、その人のコントリビュートを公式に認めるために、リーダーの役割を使うことができます。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jacobian?s=180" class="pquote-avatar" alt="avatar">
  皆さんは私のことをDjangoの「発明者」と認識しているかもしれません...しかし、実際は私は作られてから1年後に採用された人間なのです。 (...) 皆さんは私のプログラミングスキルのおかげで成功したと思うかもしれません...しかし、私はせいぜい平均的なプログラマーなのです。
  <p markdown="1" class="pquote-credit">
— @jacobian, ["PyCon 2015 Keynote" (video)](https://www.youtube.com/watch?v=hIJdFxYlEKE#t=5m0s)
  </p>
</aside>

## どのようにしてリーダーシップの役割を明確にするか？

リーダーシップの役割を明確にすることで、人々に責任を持たせ、他のコミュニティメンバーが助けが必要な時に誰に聞くべきかが明確になります。

小さいプロジェクトでは、リーダーを任命することは単に README や CONTRIBUTORS ファイルに名前を追加するだけで済むこともあります。

大きなプロジェクトでは、ウェブサイトを持っているのであれば、チームページやプロジェクトリーダーのリストのページを作りましょう。例えば、 [Postgres](https://github.com/postgres/postgres/) では [チームのリストページ](https://www.postgresql.org/community/contributors/) に各コントリビューターの短いプロフィールを記載しています。

もしあなたのプロジェクトのコントリビューターが非常に活発なのであれば、メンテナーの「コアチーム」を作ったり、異なる問題領域ごと（例えば、セキュリティ、イシューの選別、コミュニティ運営）に責任を持つ分科会を持っているかもしれません。あなたが指名するのではなく、人々が自分の興味のある領域の役割に自律的にボランティアしてくれるように任せましょう。

<aside markdown="1" class="pquote">
  \[私達は\] コアチームに対して、幾つかの「サブチーム」で支えています。各サブチームはそれぞれ特定の領域にフォーカスしています。例えば、言語設計やライブラリなどです。 (...) 世界をまたがるコラボレーションと、プロジェクト全体として協力で一貫したビジョンを維持するために、各サブチームはコアチームのメンバーによってリードされています。
  <p markdown="1" class="pquote-credit">
— ["Rust Governance RFC"](https://github.com/rust-lang/rfcs/blob/master/text/1068-rust-governance.md)
  </p>
</aside>

リーダーシップチームは( IRC のような)専用のチャンネルを作りたいと思ったり、プロジェクトについて定期的に議論するために( Gitter 上や Google Hangout 上で)集まりたいと思うかもしれません。こういったミーティングでさえも公にする事で、他の人も議論を聞けるようにしましょう。例えば、 [Cucumber-ruby](https://github.com/cucumber/cucumber-ruby) では、 [毎週オフィスアワーを設けています](https://github.com/cucumber/cucumber-ruby/blob/master/CONTRIBUTING.md#talking-with-other-devs)。

一度リーダーシップの役割を確立したなら、どのようにして彼らにコンタクトを取れるかドキュメントにまとめることを忘れないようにしましょう。メンテナーにどのようにしたらなれるかであったりどのように分科会に参加するのかのプロセスを明確に確立し、 GOVERNANCE.md ファイルにそれを記載しましょう。

[Vossibility](https://github.com/icecrime/vossibility-stack) のようなツールは、プロジェクトに対するコントリビュートを誰がやっているのか（やっていないのか）を公にトラッキングするのに役立ちます。こういった情報をドキュメント化することで、メンテナーは非公開の場で意思決定を行う派閥を作っているとコミュニティから認識されることを避けることができます。

最後に、プロジェクトが GitHub 上にあるのであれば、プロジェクトを個人アカウントから Organization に移し、少なくとも一人の管理者をバックアップとして追加することを検討しましょう。 [GitHub Organizations](https://help.github.com/articles/creating-a-new-organization-account/) を使うことで、権限や複数のリポジトリを管理し、[所有権を共有することで](../building-community/#プロジェクトの所有権を共有しよう)プロジェクトの資産を守ることがやりやすくなります。

## いつ他の人にコミット権限を与えるべきだろうか？

コントリビュートをするすべての人にコミット権限を与えるべきだと考える人もいます。そうすることで、より多くの人にプロジェクトに対して責任を感じてもらうことができます。

その一方で、大きく複雑なプロジェクトでは、プロジェクトに対して熱心に献身している人のみにコミット権限を与えたいと思うかもしれません。唯一の正解はありません - あなたが最も良いと思うことをやりましょう。

もしプロジェクトが GitHub 上にあるのであれば、 [protected branches](https://help.github.com/articles/about-protected-branches/) を使うことで、どいうった状況で誰が特定のブランチに push できるのかを管理することができます。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/felixge?s=180" class="pquote-avatar" alt="avatar">
  誰かがプルリクエストを送ってきたときはいつでも、その人にプロジェクトへのコミット権限を与えましょう。はじめはそれが馬鹿げているように聞こえるかもしれませんが、この戦略によって GitHub の真の力を解き放つことができるようになります。 (...) 一度コミット権限をもらえば、人々はもはや自分のパッチがマージされるかどうか心配せずにすみます。こうすることで、彼らはより多くの仕事を成し遂げてくれるようになるのです。
  <p markdown="1" class="pquote-credit">
— @felixge, ["The Pull Request Hack"](https://felixge.de/2013/03/11/the-pull-request-hack.html)
  </p>
</aside>

## オープンソースプロジェクトによくある運営方法はどのようなものでしょうか？

オープンソースプロジェクトに関連して、3つのよく使われる運営方法があります。

* **BDFL:** BDFL は "Benevolent Dictator for Life（優しい終身の独裁者）" の略です。これは、一人の人間（大抵はプロジェクトを立ち上げた人）が、全てのプロジェクトの大きな決断に最終承認を出すやり方です。 [Python](https://github.com/python) は、古くからある例です。小さなプロジェクトではおそらく初めから BDFL を採用しているでしょう。なぜなら、メンテナーが一人か二人しかいないからです。企業が始めたプロジェクトも BDFL のカテゴリーに入るでしょう。

* **業績主義:** **(メモ: "業績主義"という言葉は、コミュニティによっては否定的な意味を持つかもしれなく、[複雑な社会的、政治的歴史](http://geekfeminism.wikia.com/wiki/Meritocracy)があります。)** 業績主義のもとでは、活動的なプロジェクトコントリビューター（「業績」を出した人）が、公式の意思決定の役割を与えられます。意思決定はたいてい投票によって行われます。業績主義のコンセプトは [Apache Foundation](https://www.apache.org/) が先鞭をつけました; [全ての Apache プロジェクト](https://www.apache.org/index.html#projects-list)は業績主義で運営されています。コントリビュートは、全て企業ではなく代表する個人によってのみ行われます。

* **自由主義的なコントリビュート:** 自由主義的なコントリビュートモデルでは、最も働いている人が最も影響力があると認められますが、これはこれまでのコントリビュートではなく現時点での仕事に基づきます。プロジェクトでの大きな意思決定は、純粋な投票ではなく合意の模索プロセス（大きな不満点について議論する）によって行われます。そして、可能な限りコミュニティ内の多くの知見を集めようと努力します。自由主義的なコントリビュートモデルを採用している有名なプロジェクトの例としては、 [Node.js](https://foundation.nodejs.org/) や [Rust](https://www.rust-lang.org/) があります。

どのモデルを使うべきでしょうか？それはあなた次第です！それぞれのモデルには利点と欠点があります。そして、はじめはこれらのモデルは全く異なるように見えるかもしれませんが、見かけ以上にこれらのモデルは共通点が多いのです。もしこれらのモデルのうちの1つを採用することに興味があるのであれば、これらのテンプレートを確認してみましょう：

* [BDFL モデルテンプレート](http://oss-watch.ac.uk/resources/benevolentdictatorgovernancemodel)
* [業績主義モデルテンプレート](http://oss-watch.ac.uk/resources/meritocraticgovernancemodel)
* [Node.js の自由主義的コントリビュートポリシー](https://medium.com/the-node-js-collection/healthy-open-source-967fa8be7951)

## プロジェクトを立ち上げる時に、運営ドキュメントは必要でしょうか？

プロジェクトの運営についてドキュメントを書くのに適切なタイミングはありませんが、コミュニティの力学が明らかになってから定義するほうがずっと簡単です。オープンソース運営における最善の（そして最も大変な）点は、コミュニティによって形作られているということです！

しかしながら、初期段階でドキュメントを書くことでは必ずプロジェクト運営に寄与するでしょう。なので、書けるものから書き始めましょう。例えば、どういった行動を期待するかを明確に定義したり、コントリビューターのプロセスはどうなっているかといったものを、プロジェクトの立ち上げ時点に書きましょう。

もしあなたがオープンソースプロジェクトを立ち上げようとしている企業に所属しているのであれば、立ち上げの前にプロジェクトを進めるにあたって何をコミュニティに期待し、どのように意思決定するのかを内部で議論しておくことは価値のあることです。特に、あなたの企業がプロジェクトにどのように関わるか（もしくはかかわらないか）に関して公に説明しておきたいと思うかもしれません。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/caabernathy?s=180" class="pquote-avatar" alt="avatar">
  Facebook では、社内で実際にこのプロジェクトの仕事をしている小さなチームを GitHub 上のプロジェクトの運営担当としています。例えば、 React は React 開発者によって運営されています。
  <p markdown="1" class="pquote-credit">
— @caabernathy, ["An inside look at open source at Facebook"](https://opensource.com/life/15/10/ato-interview-christine-abernathy-facebook)
  </p>
</aside>

## 企業の従業員がコントリビュートを提出したら何が起きますか？

成功したオープンソースプロジェクトは多くの人々や企業によって使われるようになります。そして、幾つかの企業では、プロジェクトが最終的な収益への流れに結びつくことになるかもしれません。例えば、プロジェクトのコードを商用のサービスの一部として使っているかもしれません。

プロジェクトが広く使われるようになるほど、そのプロジェクトに習熟した人たちの需要が高まります - あなた自身もそうかもしれません！そして、プロジェクトでやっている仕事で採用されることも時にはあるでしょう。

企業の活動も、普通の活動と同じであり、1つの開発リソースの源であると捉えることは重要です。当然、給与をもらって開発している人を特別扱いすべきではありません; それぞれのコントリビュートは技術的な功績によって評価されるべきです。しかしながら、企業活動に従事する事を苦痛に感じるべきではありませんし、特定の改善や機能について議論するときにはユースケースを主張することにも苦痛を感じるべきではありません。

「商用利用」は、「オープンソース」とは完全に両立可能です。「商用利用」は単にどこかでお金が絡んでいることを意味するに過ぎません - それはソフトウェアが商取引で使われているということで、プロジェクトが多く採用されるにつれてその可能性は増していきます。（オープンソースソフトウェアがオープンソースではない製品の一部として使われる時、プロダクト全体はそれでも「プロプライエタリ」ソフトウェアですが、オープンソースのように商用も非商用のどちらでも利用可能です。）

他の皆と同様に、お金を支払われて開発を行っている人もプロジェクト内の影響力を得るのは、コントリビュートの質や量によってです。明らかに、お金を支払われている開発者は支払われていない開発者よりも多くのことをできますが、それで良いのです：お金を得ているかどうかは、その人がどのくらいコントリビュートするかに影響を与える要素が多くある中の1つでしかありません。プロジェクト内の議論では、コントリビュートを行う上での外部要因ではなく、コントリビュート自体に集中し続けましょう。

## プロジェクトを運営するのに法人は必要ですか？

お金を扱うのでなければ、オープンソースプロジェクトの運営に法人は必要ありません。

例えば、商用ビジネスを立ち上げたいのであれば、（もし US で行うのであれば） C 株式会社や有限会社の立ち上げを考えているでしょう。あなたがオープンソースプロジェクトに関連した請負作業を行うだけであれば、あなたが単独で報酬を受け取るか、もしくは（ US で行うのであれば） LLC を設立することもできます。

あなたのオープンソースプロジェクトで寄付を受け取りたいのであれば、（例えば PayPal や Stripe を使うことで）寄付ボタンを設置することができます。ただし、非営利団体（ US の場合は 501c3 ）でない場合は課税控除の対象にはなりません。

多くのプロジェクトでは非営利団体を設立するという面倒を避けるために、代わりに非営利の財政スポンサーを見つけています。財政スポンサーは、寄付額の一定の割合を受け取ることと引き換えにあなたの代わりに寄付を受け取ります。 [Software Freedom Conservancy](https://sfconservancy.org/) や [Apache Foundation](https://www.apache.org/) 、 [Eclipse Foundation](https://eclipse.org/org/foundation/) 、 [Linux Foundation](https://www.linuxfoundation.org/projects) 、 [Open Collective](https://opencollective.com/opensource) は、オープンソースプロジェクトの財政スポンサーとして活動している団体の例です。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/piamancini?s=180" class="pquote-avatar" alt="avatar">
  私達のゴールは、コミュニティが自立して持続可能になるようなインフラを提供することで、コントリビューター、支援者、スポンサーの全員が利益を得ることができるような環境を作ることです。
  <p markdown="1" class="pquote-credit">
— @piamancini, ["Moving beyond the charity framework"](https://medium.com/open-collective/moving-beyond-the-charity-framework-b1191c33141#.vgsbj9um9)
  </p>
</aside>

もしあなたのプロジェクトが特定の言語やエコシステムと密接に関係しているのであれば、連携できるソフトウェア財団もあるかもしれません。例えば、 [Python Software Foundation](https://www.python.org/psf/) は [PyPI](https://pypi.org/) という Python のパッケージマネジャーをサポートしていますし、 [Node.js Foundation](https://foundation.nodejs.org/) は [Express.js](https://expressjs.com/) という Node ベースのフレームワークをサポートしています。
