---
lang: ja
title: オープンソースにコントリビュートする方法
description: オープンソースにコントリビュートしたいですか？このガイドではオープンソースへのコントリビュートの方法を、初めての人だけでなく熟練の方にも紹介します。
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## オープンソースにコントリビュートする理由は？

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  \[freenode\] で働くことで、その後の大学での勉強や実際の仕事をする上で役に立つたくさんのスキルを身につけることができました。オープンソースプロジェクトにコントリビュートすることは、プロジェクトを前進させると共に私自身への助けにもなりました！
  <p markdown="1" class="pquote-credit">
— @errietta, ["Why I love contributing to open source software"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

オープンソースにコントリビュートすることはやりがいがあり、あなたが思い描くどんなスキルに対しても、学習し、教え、経験を積むことができます。

なぜ人々はオープンソースにコントリビュートするのでしょう？理由は様々です！

### 既に持っているスキルを改善する

あなたが練習したいと思っていることが、コーディングであれ、UIデザインやグラフィックデザイン、文章を書くこと、組織を作ることであれ、オープンソースプロジェクトにはあなたのためのタスクがあります。

### 似たようなことに興味を持っている人に会う

暖かく迎えてくれるコミュニティを持ったオープンソースプロジェクトでは、人々が何年経っても戻って来続けます。多くの人がオープンソースに参加することによって生涯に渡る友好関係を築いています。たとえそれがカンファレンスでばったり会うという形であったり、夜遅くにブリトーについてチャットをしているという形であれ。

### メンターを見つけ互いに教えあう

同じプロジェクトで他の人と一緒に働くということは、あなたが仕事をやる方法を説明するだけでなく、他の人に助けを求める必要が出てきます。学習し、教えることは関わる人全てにとって充実した活動となります。

### あなたの評判（やキャリア）を育てるのに役立つ成果物を作り上げる

その定義からして、すべてのオープンソースはパブリックです。このことはあなたがやっていることをどこでも自由に紹介できる事例を得られるということを意味します。

### ピープルスキルを学ぶ

オープンソースは、人々の衝突を解消したり、チームを組織したり、仕事の優先順位付けをするなどといったリーダーシップやマネジメントスキルを実践する機会を提供してくれます。

### 変化を起こせるようになる助けとなる、たとえそれが小さな変化であったとしても

あなたは何もオープンソースに生涯に渡って常に参加し続ける必要があるわけではありません。ウェブサイトでタイポを見つけて、直してほしいと思ったことはありませんか？オープンソースプロジェクトでは、あなたがそれをできるのです。オープンソースによって、人々は人生や世界をどう経験するかが自分自身のものだと感じられることを助けてくれます。そしてその事自体が大きな喜びとなるのです。

## コントリビュートするということが意味するもの

オープンソースコントリビューターになりたてで自信が持てないと感じているかもしれません。どのようにして正しいプロジェクトを見つけるのでしょう？もしコーディングの仕方を知らないとしたらどうでしょう？もし何かが間違ってしまったらどうしましょう？

心配ありません！オープンソースプロジェクトに関わるにはあらゆる方法があります。そして、少しのコツがあればあなたの経験を最大限活かす事ができるでしょう。

### かならずしもコードを書く必要はありません

オープンソースへのコントリビュートについてのよくある勘違いとしては、あなたはコードを書く必要があるというものです。実際、それはしばしばプロジェクトの中で最も[無視されるか見落とされている部分](https://github.com/blog/2195-the-shape-of-open-source)です。この種のコントリビュートを行うことによってプロジェクトに対して _非常に大きな_ 助けとなります。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  私は CocoaPods での仕事で有名になってきましたが、多くの人は私が CocoaPods 自体に対する仕事をほとんどしていないということを知らないのです。このプロジェクトでの私の時間はほとんどがドキュメントを書いたり、ブランディングのしごとをすることに費やされているのです。
  <p markdown="1" class="pquote-credit">
— @orta, ["Moving to OSS by default"](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

たとえコードを書くことが好きであったとしても、他の種類のコントリビュートはプロジェクトに関わり、他のコミュニティメンバーに会う良いやり方です。このような関係を作ることはそのプロジェクトの他の部分に関わる人と仕事をする機会を与えてくれます。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/brettcannon?s=180" class="pquote-avatar" alt="avatar">
  私が初めて Python 開発チーム(別名 python-dev )と接触したのは、2002年6月17日に私のパッチを受け入れてもらうためにメーリングリストにメールをした時でした。私はすぐにオープンソースバグに遭遇し、グループのためにメールの要約を整理し始めることにしました。彼らは、私の各トピックについての質問に寛大に接してくれましたが、更に非常に重要だったのが、誰かが修正が必要であるなにかを指摘した時にすぐに気づくことができるようになったということでした。
  <p markdown="1" class="pquote-credit">
— @brettcannon, ["Maintainer Stories"](https://github.com/open-source/stories/brettcannon)
  </p>
</aside>

### イベントを計画するのが好きですか？

* [@fzamperin が NodeSchool でやったように](https://github.com/nodeschool/organizers/issues/406)ワークショップやミートアップを開催する
* (もしあるなら)プロジェクトのカンファレンスを企画する
* コミュニティメンバーが発表するのにちょうどよいカンファレンスを見つけるのを手伝う

### デザインをするのが好きですか？

* プロジェクトのユーザビリティを向上させるためにレイアウトを再構成する
* [Drupal で提案されているように](https://www.drupal.org/community-initiatives/drupal-core/usability)、プロジェクトのナビゲーションやメニューを再構成して改善するためにユーザーリサーチを実施する
* プロジェクトが一貫したビジュアルデザインを保てるようにスタイルガイドを作る
* [hapi.js のコントリビューターがやったように](https://github.com/hapijs/contrib/issues/68)、Tシャツや新しいロゴのデザインをする

### 文章を書くのが好きですか？

* プロジェクトのドキュメントを書いたり改善する
* プロジェクトがどのように使われているかの事例を選別する
* プロジェクトのニュースレターを始めたり、メーリングリストのハイライトを整理する
* [PyPA のコントリビューターがやったように](https://github.com/pypa/python-packaging-user-guide/issues/194)、プロジェクトのチュートリアルを書く
* プロジェクトのドキュメントを翻訳する

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  真面目な話、\[ドキュメント\]は非常に大事です。これまでの所、 Babel のドキュメントは素晴らしく、 Babel の最高の機能になっています。ただ、まだ作業が必要でものによっては文章を追加したほうが良い節があり、それをやってもらえると非常にありがたいです。
  <p markdown="1" class="pquote-credit">
— @kittens, ["Call for contributors"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### 整理するのが好きですか？

* 整理するために、重複しているイシューを紐づけたり、新しいイシューのラベルを提案する
* [@nzakas が ESLint でやったように](https://github.com/eslint/eslint/issues/6765)、オープンなイシューをくまなく調べ、古いものをクローズすることを提案する
* 議論を前進させるために、最近オープンされたイシューの内容を明確にする質問をする

### コードを書くのが好きですか？

* [@dianjin が Leaflet でやったように](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)、取り組むオープンなイシューを見つける
* 新しい機能を書く手伝いをできるかどうか聞いてみる
* プロジェクトのセットアップを自動化する
* ツールやテストの改善をする

### 人々を助けるのが好きですか？

* Stack Overflow ([この Postgres の例のように](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge))や Reddit でのプロジェクトに対する質問に答える
* オープンイシューでの質問に答える
* ディスカッションボードやコンバセーションチャネルでの会話の進行をする

### 他の人がコードを書くのを助けるのが好きですか？

* 他の人のコードをレビューする
* プロジェクトがどのように使われるのかについてチュートリアルを書く
* [@ereichert が Rust で @bronzdoc にやったように](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)、他のコントリビューターのメンターをやる

### 必ずしもソフトウェアプロジェクトで働く必要はありません

「オープンソース」はしばしばソフトウェアのことを指していますが、あなたはどんなものでもコラボレートできるのです。本やレシピ、リストや授業もオープンソースプロジェクトとして開発されているのです。

例えば:

* @sindresorhus は["素敵なもの"のリストを作っています](https://github.com/sindresorhus/awesome)
* @h5bp はフロントエンド開発者のための[面接での質問集](https://github.com/h5bp/Front-end-Developer-Interview-Questions)をまとめています
* @stuartlynn と @nicole-a-tesla は[ツノメドリについての愉快な事柄のコレクション](https://github.com/stuartlynn/puffin_facts)を作っています

たとえあなたがソフトウェアエンジニアだったとしても、ドキュメントを書くことはオープンソース活動を始めるにあたって良いスタートとなります。ときにはコードを書かないプロジェクトに関わること障壁が低く、コラボレーションのプロセスを通じて自身と経験を身につけることができます。

## 新しいプロジェクトに順応しよう

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  もしあなたがイシュートラッカーを見て、ごちゃごちゃしていると感じるのであれば、そう感じているのはあなただけではないはずです。こういったツールは多くの暗黙的な知識を必要としますが、人々は助けてくれますし、あなたから質問をすることもできるのです。
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["How to Contribute to Open Source"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

タイポの修正以上のものであればなんでも、オープンソースにコントリビュートするというのは知らない人たちのパーティに近づいていくようなものです。もしあなたがラマについて話し始めたとして、一方で彼らは金魚について深い議論をしていたら、おそらくあなたのことを少し奇妙な目で見るでしょう。

盲目的にあなた自身の提案をする前に、部屋の雰囲気を読み取る方法を学びましょう。そうすることによって、あなたのアイデアの存在に気づいてもらい聞き入れてもらうチャンスが増すでしょう。

### オープンソースプロジェクトの構造

それぞれのオープンソースコミュニティは異なります。

ある一つのオープンソースプロジェクトで長い時間を過ごしたということは、ある一つのオープンソースプロジェクトについて理解したということを意味します。異なるプロジェクトに移ると、使っている言葉や規範、コミュニケーションスタイルが全く異なることに気づくでしょう。

とはいえ、多くのオープンソースプロジェクトは似たような組織構造を持っています。異なるコミュニティの役割や全体のプロセスを理解することは新しいプロジェクトに早く順応するための助けになるでしょう。

典型的なオープンソースプロジェクトは下記のような種類の人々がいます:

* **オーサー:** そのプロジェクトを作った人(たち)もしくは組織
* **オーナー:** 組織やリポジトリに対して管理上の所有権を持っている人(たち)もしくは組織(かならずしも元のオーサーと同じとは限らない)
* **メンテナー:** ビジョンを推し進め、プロジェクトの組織的なマネジメントを行うコントリビューター(彼らはオーサーやオーナーであることもある)
* **コントリビューター:** プロジェクトに対して何かしらのコントリビュートをするすべての人
* **コミュニティメンバー:** プロジェクトを使っている人々。彼らは議論をしたり、プロジェクトの方向性に対して意見を表明したりする

より大きなプロジェクトでは、ツールの整備やコミュニティのモデレートやイベントの運営など異なるタスクに特化した分科会やワーキンググループがあるかもしれません。プロジェクトのウェブサイトの「チーム」についてのページや、リポジトリの運営に関するドキュメントをみて、こういった情報を見つけましょう。

プロジェクトにはドキュメントもあります。これらのファイルはたいていリポジトリのトップレベルに置かれています。

* **LICENSE:** その定義から、すべてのオープンソースプロジェクトは[オープンソースライセンス](https://choosealicense.com)を持っている必要があります。もしそのプロジェクトがライセンスを持っていないのであれば、それはオープンソースではありません。
* **README:** README はそのプロジェクトへの新しいコミュニティメンバーを迎えるための操作マニュアルです。そこではなぜそのプロジェクトが便利で、どのように始めるかの説明があります。
* **CONTRIBUTING:** README が人々がそのプロジェクトを _使う_ 手助けをする一方、 CONTRIBUTING ドキュメントは人々が _コントリビュートする_ 手助けをします。そこではどういった種類のコントリビュートが必要とされていて、そのプロセスがどうなっているかの説明があります。すべてのプロジェクトが CONTRIBUTING ファイルを持つわけではないですが、そのファイルがあることによって、そのプロジェクトがコントリビュートを歓迎していることの印になります。
* **CODE_OF_CONDUCT:** 行動規範は参加者の振る舞いに対する基本原則を設定し、友好的な環境を作る手助けをします。すべてのプロジェクトが CODE_OF_CONDUCT ファイルを持つわけではないですが、そのファイルがあることによって、そのプロジェクトがコントリビュートを歓迎していることの印になります。
* **その他のドキュメント:** それ以外にも、特に大きなプロジェクトではチュートリアル、ウォークスルー、運営方針などといったドキュメントがあることがあります。

最後に、オープンソースプロジェクトは議論を整理するために次のようなツールを使います。アーカイブを読み通すことで、そのコミュニティがどのように考え動いてきたかを把握することができるでしょう。

* **イシュートラッカー:** そのプロジェクトに関連するイシューを議論する場所
* **プルリクエスト:** 作業中の変更について議論し、レビューをする場所
* **ディスカッションフォーラムやメーリングリスト:** いくつかのプロジェクトではあるトピックについて会話 (例えば、バグの報告や機能要望の代わりに _「これはどうやって・・・すると良いのでしょう？」_ や _「・・・についてどう思いますか？」_ といったもの) をするのにこれらのチャネルを使うかもしれません。また、すべての会話をイシュートラッカー上で行うプロジェクトもあります。
* **同期的なチャットチャネル:** カジュアルな会話やコラボレーション、簡単なやりとりについては ( Slack や IRC のような) チャットチャネルを使うプロジェクトもあります。

## コントリビュートするプロジェクトを見つけよう

さてあなたはオープンソースプロジェクトがどのように働くのかを理解しました。次はコントリビュートするプロジェクトを見つける番です！

もしあなたがこれまでにオープンソースプロジェクトにコントリビュートしたことが一度もないのであれば、アメリカ大統領のジョン・F・ケネディのアドバイスを聞いてみましょう。彼はかつて、 _「あなたの国があなたのために何をしてくれるのかを問うのではなく、あなたが国のために何ができるかを問いなさい」_ と言いました。

オープンソースへのコントリビュートはあらゆる階層で、プロジェクトをまたいで行われています。あなたの最初のコントリビュートが具体的にどういったものであるかや、どのようなものなのかを考えすぎる必要はありません。

代わりにあなたが既に使っていたり使いたいと思っているプロジェクトについて考え始めましょう。活発にコントリビュートすることになるプロジェクトは、何度も戻ってきたいと思うようなものなのです。

そういったプロジェクトの中で、何かをよくできたり違ったものにできると考え始めたときはいつでも、あなたの直感に従って行動しましょう。

オープンソースは排他的なクラブではありません。あなたのような人々からなっているのです。「オープンソース」は世の中の問題が解決可能であると扱うための単なるきらびやかな名前でしかないのです。

README を読んで、壊れたリンクやタイポを見つけるかもしれません。もしくは、あなたは新しいユーザーで、何かが壊れていたり、ドキュメントに書かれているべきと考えるイシューがあるかもしれません。それを無視して先に進んだり、他の誰かに直してとお願いする代わりに、あなたが参加することで手助けができないかどうか確かめてみましょう。これがオープンソースというものなのです！

> オープンソースへの[ふとしたコントリビュートの28%](https://www.igor.pro.br/publica/papers/saner2016.pdf) がタイポの修正やフォーマットの修正や翻訳といったドキュメントに対するものなのです。

また、新しいプロジェクトを見つけてコントリビュートする手助けとして、次のようなリソースのうちの一つを使うこともできます:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](http://www.firsttimersonly.com/)
* [Your First PR](https://yourfirstpr.github.io/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](http://up-for-grabs.net/)
* [Contributor-ninja](https://contributor.ninja)

### コントリビュートする前のチェックリスト

コントリビュートしたいプロジェクトを見つけたら、そのプロジェクトがコントリビュートを受け入れる体制ができているかどうかを確かめるために簡単に調べてみましょう。さもないと、あなたの懸命な努力が全くの無反応で終わってしまうかもしれません。

次に、プロジェクトが新しいコントリビューターにとって良いかどうかを評価する簡単なチェックリストを記載しました。

**オープンソースの定義に適っているか**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  ライセンスがあるか？たいてい、リポジトリのルートにある LICENSE という名前のファイルがそれに当たります。
  </label>
</div>

**プロジェクトがコントリビュートを積極的に受け入れているか**

master ブランチのコミットアクティビティをみてみましょう。 GitHub ではリポジトリのホームページでこの情報を見ることができます。

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  最新のコミットはいつか？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  そのプロジェクトには何人のコントリビューターがいるか？
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  どのくらいの頻度でコミットしているか？ ( GitHub では、トップにある "Commits" をクリックすることでこれを見ることができます)
  </label>
</div>

次に、プロジェクトのイシューをみてみましょう。

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
  いくつのイシューがあるか？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
  メンテナーはイシューがオープンされたらすばやく反応しているか？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
  イシューでアクティブな議論は行われているか？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
  イシューは最近のものか？
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
  イシューがクローズされているか？ ( GitHub では、 Issues ページの "closed" タブでクローズされたイシューを見ることができます)
  </label>
</div>

次にプロジェクトのプルリクエストに対して同じことをしましょう。

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
  いくつのプルリクエストがあるか？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
  メンテナーはプルリクエストがオープンされたらすばやく反応しているか？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
  プルリクエストでアクティブな議論は行われているか？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
  プルリクエストは最近のものか？
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
  どのくらい最近プルリクエストがマージされたか？ ( GitHub では、プルリクエストページの "closed" タブをクリックすることでクローズされたプルリクエストを見ることができます)
  </label>
</div>

**プロジェクトは歓迎してくれるか**

友好的で歓迎してくれるプロジェクトは新しいコントリビューターを受け入れてくれる印です。

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
  メンテナーはイシューでの質問に助けとなるような回答をしているか？
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
  人々はイシューやディスカッションフォーラム、チャット(例えば IRC や Slack )で友好的か)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
  プルリクエストはレビューされているか？
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
  メンテナーはコントリビュートに対して感謝しているか？
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  長いスレッドを見つけたら常に、スレッドの中で遅れてやってくるコア開発者の返答を確認してみましょう。彼らは建設的にまとめて、丁寧な姿勢を保ちつつもスレッドを結論に仕向けるべく一歩を踏み出していますか？もし罵り合いが多くあるのであれば、それはエネルギーが開発に向けられる代わりに議論に使われている兆候です。
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## コントリビュートする方法

あなたは好きなプロジェクトを見つけ、コントリビュートをする準備ができています。ついに！次にあなたのコントリビュートを効果的に行う方法を紹介します。

### 効果的にコミュニケーションする

あなたが一度きりのコントリビューターであろうとコミュニティに参加しようとしているのであろうと、他の人と働くことはオープンソースで獲得するスキルの中で最も大事なものの一つです。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[新しいコントリビューターとして、\] イシューをクローズできるようになりたいのであれば、質問をする必要があるということにすぐに気づきました。私はコードベースをざっと読んで、一旦何が行われているのか感覚を掴んだら、さらなる方向について質問をしました。そして、ほら！必要だった関連する詳細を全て手に入れて、イシューを解決することができました。
  <p markdown="1" class="pquote-credit">
— @shubheksha, [A Beginner's Very Bumpy Journey Through The World of Open Source](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

イシューやプルリクエストをオープンする前に、あなたのアイデアが効果的に扱われる助けのために、これらのことを心のとどめておきましょう。

**コンテキストを与えましょう。** 他の人がすぐに把握する手助けをしましょう。もしあなたがエラーに遭遇しているのであれば、あなたが何をしようとしていて、どうやって再現させるのかを説明しましょう。もしあなたが新しいアイデアを提案しているのであれば、なぜそれがプロジェクトにとって（あなたにとってだけではなく！）便利だと思うのかを説明しましょう。

> 😇 _"Yを行った時にXが起きません"_
>
> 😢 _"Xが壊れています！直して下さい。"_

**まずは自分の手を動かしましょう。** 何かを知らないのは問題ないのですが、トライしたことは示しましょう。助けを求める前に、プロジェクトの README やドキュメント、イシュー（オープンなものもクローズされたものも）、メーリングリストや答えをインターネットで探したか確認しましょう。人々はあなたが学ぼうとしていることを示せば、それを評価してくれるでしょう。

> 😇 _"私は X を実装するやり方がわかりません。ヘルプドキュメントを見たのですが、それについての言及を見つけることができませんでした。"_
>
> 😢 _"わたしはどうやったら X ができますか？"_

**要求は短く直接的にしましょう。** メールを送るのと同じように、それぞれのコントリビュートは、それがいくらシンプルで役に立つものであっても、他の誰かのレビューを必要とします。多くのプロジェクトでは、人々が助けられる以上の数の要求が来ています。簡潔にしましょう。そうすれば、誰かが助けてくれるチャンスを増やすことができるでしょう。

> 😇 _" API チュートリアルを書こうと思っています。"_
>
> 😢 _"私は先日高速道路を走っていて、給油のため止まりました。すると、我々がやるべき素晴らしいアイデアが思い浮かんだのです。しかし、それを説明する前に・・・"_

**全てのコミュニケーションを公開の場でしましょう。** いくらやりたくなったとしても、機密情報（セキュリティイシューや重大な行動指針違反など）を共有するのでもない限り、メンテナーに非公開に接触するのはやめましょう。会話を公開の場で行い続ければ、あなたの会話からより多くの人が学び、利益を得ることができます。会話することはそれ自体がコントリビュートとなりうるのです。

> 😇 _(コメントで) "@メンテナー こんにちは！このプルリクエストはどうやって進めたら良いですか？"_
>
> 😢 _(メールで) "こんにちは、メールを送ってすみませんが、私のプルリクエストをレビューしていただけないかと思いまして。"_

**質問をするのは問題ありません（ただし、辛抱強く！）** 誰しもがある時点ではそのプロジェクトに慣れていなく、経験のあるコントリビューターでさえ新しいプロジェクトを見るときは最新情報が必要となります。同様に、古くからのメンテナーでさえ常にそのプロジェクトのあらゆる部分に詳しいわけではありません。あなたが彼らに望むような辛抱強さをあなたも彼らに対して示しましょう。

> 😇 _"このエラーについて調べてくれてありがとうございます。あなたの提案に従ってみました。こちらがその出力です。"_
>
> 😢 _"なぜ私の問題を解決できないのでしょう？これはあなたのプロジェクトじゃないんですか？"_

**コミュニティの決定を尊重しましょう。** あなたのアイデアはコミュニティの優先事項やビジョンとは異なっているかもしれません。彼らはフィードバックを提供したり、あなたのアイデアを採用しないと決定するかもしれません。あなたは議論したり妥協点を見出したりするべきですが、メンテナーはあなたよりも長い期間あなたのアイデアと付き合っていく必要があるのです。もしあなたが彼らの方向性に賛成出来ないのなら、あなたはいつでもあなた自身のフォークやあなた自身のプロジェクトを始めることができるのです。

> 😇 _"あなたが私のユースケースを支持できないのは残念ですが、あなたが説明してくれたようにそれはユーザーのうちの一部にしか影響しませんし、私も理由を理解できます。意見を聞いてくださりありがとうございます。"_
>
> 😢 _"なぜあなたは私のユースケースを支持しないのですか？これは受け入れられません！"_

**なにより常にポジティブでいましょう。** オープンソースは世界中のコラボレータによって成り立っています。言語や文化、地理、タイムゾーンをまたぐことでコンテキストが失われてしまいます。加えて、テキストコミュニケーションでは調子や雰囲気を伝えるのが難しいです。これらの会話では相手は前向きであると仮定しましょう。丁寧にアイデアを先送りしたり、さらなるコンテキストを聞いたり、あなたのポジションを更に明確にするのは良いことです。インターネットがあなたが見つけたときよりもよりよい場所であるように心がけましょう。

### コンテキストを集める

何かをする前に、あなたのアイデアが他の場所で既に議論されていないか確かめましょう。そのプロジェクトの README やイシュー（オープンなものもクローズされたものも）、メーリングリストやスタックオーバーフローにざっと目を通しましょう。全てに目を通すのに何時間もかける必要はありませんが、いくつかのキーワードで検索するので十分です。

もしあなたのアイデアが他で見つけられないのであれば、動き出す準備ができたことになります。そのプロジェクトが GitHub 上にあるのであれば、あなたはおそらくイシューやプルリクエストをオープンすることでコミュニケーションするでしょう。

* **イシュー** は会話や議論を始めるようなものです
* **プルリクエスト** は解決に向けて仕事を始めることです
* 確認や方法を聞く質問のような、**軽いコミュニケーションには** 、もしそのプロジェクトが使っているのであれば、スタックオーバーフロー、 IRC 、 Slack や他のチャットで質問してみましょう。

イシューやプルリクエストをオープンする前に、そのプロジェクトのコントリビュートの方法についてのドキュメント（大抵は CONTRIBUTING と呼ばれるファイルや README の中にあります）を確認し、なにか特定の情報を含める必要があるか確かめましょう。例えば、あなたはテンプレートを使ったり、テストを実行する必要があるかもしれません。

もしあなたが大きなコントリビュートをしたいのであれば、その仕事に取り掛かる前にイシューをオープンしましょう。受け入れられないかもしれない仕事に取り掛かる前に、暫くの間そのプロジェクトをウォッチし（ GitHub では、 ["Watch" をクリックすることで](https://help.github.com/articles/watching-repositories/) 全ての会話の通知を受け取ることができます)、コミュニティメンバーを知ることは役に立つでしょう。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  あなたが活発に使っている一つのプロジェクトを選び、 GitHub 上で"ウォッチ"し、全てのイシューやプルリクエストに目を通すことで<em>多くのことを</em>学ぶでしょう。
<p markdown="1" class="pquote-credit">
— @gaearon [on joining projects](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### イシューをオープンする

下記のような状況では大抵イシューをオープンすべきです：

* あなただけで解決できないエラーの報告
* 高レベルなトピックやアイデア（例えば、コミュニティやビジョンや方針）についての議論
* 新しい機能や他のプロジェクトへのアイデアの提案

イシュー上でのコミュニケーションのコツ：

* **あなたが取り組みたいオープンイシューを見つけたら、** そのイシュー上であなたがそれに取り掛かる事を人々に知らせるためにコメントしましょう。そうすることで、あなたの仕事と重複する可能性が減ります。
* **イシューがしばらく前にオープンされたのであれば、** それは他の場所で取り組まれていたり、既に解決されている可能性があります。なので、仕事に取り掛かる前に確認するコメントをしましょう。
* **もしあなたがイシューをオープンしたのに、あとになって自分で解決策を見つけたのであれば、** そのイシューで人々に知らせるためにコメントしましょう。そして、イシューをクローズしましょう。成果をドキュメントにするだけでもそのプロジェクトに対するコントリビュートとなります。

### プルリクエストをオープンする

下記のような状況では大抵プルリクエストをオープンすべきです：

* 明確な修正（例えばタイポや壊れたリンクや明らかなエラー）の提出
* 既に要求されているコントリビュートや既にイシュー上で議論された仕事を始める際

プルリクエストでは、仕事が完了している必要はありません。大抵の場合、早い段階でプルリクエストを開き、他の人があなたの進捗を確認したり、フィードバックを与えられるようにしたほうが望ましいです。タイトルに "WIP" (Work in Progress) とつけましょう。いつでもさらなるコミットを追加できます。

そのプロジェクトが GitHub 上にあるのであれば、下記がプルリクエストを提出する方法です：

* **[リポジトリをフォークし](https://guides.github.com/activities/forking/)** ローカルにクローンしましょう。あなたのローカルと元の "upstream" リポジトリを remote として追加することで紐づけましょう。 "upstream" からの変更を頻繁にプルすることで、プルリクエストを提出する時にマージコンフリクトが起きづらくなるように、最新に追いついているようにしましょう。（より詳細な手順は[こちら](https://help.github.com/articles/syncing-a-fork/)を確認して下さい)。
* あなたの変更のための**[ブランチを切りましょう](https://guides.github.com/introduction/flow/)**。
* プルリクエストの中で**あらゆる関連するイシュー** や関連するドキュメントを参照しましょう （例えば、 "Closes #37." のように)。
* もしあなたが HTML/CSS を変更するのであれば、**前後のスクリーンショットを含めましょう**。あなたのプルリクエストの本文に画像をドラッグアンドドロップしましょう。
* **あなたの変更をテストしましょう！** もし既存のテストがあるのであれば、あなたの変更に対してそのテストを実行したり、必要であれば新しいテストを作りましょう。既存のテストの有無にかかわらず、あなたの変更が既存のプロジェクトを壊さないことを確かめましょう。
* できる限り**そのプロジェクトのスタイルに従ってコントリビュートしましょう**。これによってインデントやセミコロン、コメントがあなた自身のリポジトリの使い方とは異なるかもしれないということを意味します。しかし、メンテナーがマージしやすくしたり、他の人が理解して将来もメンテナンスしやすいようにしましょう。

もしこれがあなたの初めてのプルリクエストであれば、 [Make a Pull Request](http://makeapullrequest.com/) という、 @kentcdodds が作成したビデオチュートリアルを確認しましょう。また、プルリクエストを作る練習を [First Contributions](https://github.com/Roshanjossey/first-contributions) という、 @Roshanjossey によって作成されたリポジトリで行うこともできます。

## コントリビュートを提出した後に起こること

やりました！おめでとう、あなたはオープンソースコントリビューターになりました。これからも多数のコントリビュートを行う第一歩になることを願っています。

コントリビュートを提出した後、下記のうちのどれかが起きるでしょう：

### 😭 返事をもらえない

あなたはコントリビュートを行う前に、[そのプロジェクトの活動の様子を調べていると思います](#コントリビュートする前のチェックリスト)。しかしながら、アクティブなプロジェクトだったとしても、あなたのコントリビュートに対して返事が無いことがおき得ます。

一週間以上返事がないようであれば、同じスレッドにて、誰かにレビューを丁寧にお願いするのは妥当でしょう。あなたのコントリビュートをレビューするのに適切な人の名前を知っているのであれば、そのスレッドにて@メンションを使うことができます。

その人に非公開の場で接触するのは**やめましょう**。オープンソースプロジェクトにとって、公開の場でコミュニケーションすることは必要不可欠であるということを思い出しましょう。

もしあなたが丁寧につついてもまだ誰も反応しないのであれば、ずっと誰も反応しない可能性があります。良い気分ではないでしょうが、落胆しないようにしましょう。それは誰に対しても起こることなのです！返事をもらえない理由はたくさんあり、それにはあなたがコントロールできない個人的な状況も含まれます。他のプロジェクトや他のコントリビュートの方法を探しましょう。いずれにしても、他のコミュニティメンバーが携わってくれて反応してくれるようになる前にコントリビュートをするのに大きな時間を投資しないほうが良いのです。

### 🚧 あなたのコントリビュートに対して変更を要求する人がいる

あなたのコントリビュートに対して変更を要求されるのはよくあることです。その要求はあなたのアイデア自体に対してのフィードバックであることもあれば、コードに対する変更であることもあります。

変更を要求する人が居たら、すぐに返事をしましょう。彼らはあなたのコントリビュートに対して時間をとってレビューしてくれたのです。プルリクエストを開いて居なくなってしまうのは良くないやり方です。もしあなたが変更の仕方を知らないのであれば、その問題を調査し、必要であれば助けを求めましょう。

もしあなたがその問題に対してそれ以上の時間をかけることができない（例えばその会話が何ヶ月にも渡り、あなたの状況が変わったなど）場合は、メンテナーにそれを伝え、返答ができない旨を伝えましょう。他の誰かが喜んで引き継いでくれるはずです。

### 👎 あなたのコントリビュートが受け入れられない

あなたのコントリビュートは最終的に受け入れられるかもしれないし、受け入れられないかもしれません。既に多大なコストを払っていないとよいのですが。もしなぜ受け入れられないかわからないのであれば、メンテナーにフィードバックや確認をするのは全くもって理にかなっています。しかし、究極的にはそれが彼らの決定であると尊重する必要があるでしょう。異議を唱えたり、敵意を示さないようにしましょう。もし彼らに賛成出来ないのであれば、あなたはいつでもフォークしてあなた自身のプロジェクトを始めることができるのです。

### 🎉 あなたのコントリビュートが受け入れられた

バンザイ！あなたは無事にオープンソースにコントリビュートできました！

## やりました！

初めてのオープンソースへのコントリビュートをしたのであれ、他のコントリビュートの方法を探しているのであれ、あなたがなにか行動を起こそうという気持ちになっていたら嬉しいです。たとえあなたのコントリビュートが受け入れられなかったとしても、メンテナーがあなたを助けるために労力を割いてくれたことに対して感謝を伝えるのを忘れないようにしましょう。オープンソースはあなたのような、イシュー、プルリクエスト、コメントや挨拶をするような、人々で成り立っているのです。
