---
lang: ja
title: 居心地の良いコミュニティを築こう
description: 人々があなたのプロジェクトを使ったり、コントリビュートしたり、人に伝えたくなるようなコミュニティを築きましょう
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## あなたのプロジェクトの成功のためのお膳立てをしよう

プロジェクトを立ち上げ、言葉を広め、人々は注目しています。素晴らしい！さて、彼らに定着してもらうにはどうしたら良いでしょうか？

居心地の良いコミュニティを作り上げることによって、プロジェクトの未来や評判に投資することができます。プロジェクトで初めてのコントリビュートが行われるようになってきたら、初期のコントリビューターにポジティブな経験を与え、再度プロジェクトを訪れるようにしましょう。

### 歓迎の気持ちを伝えよう

プロジェクトのコミュニティについて考える一つの方法として、 @MikeMcQuaid が [contributor funnel](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/) と呼ぶものを使ってみましょう:

![Contributor funnel](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

コミュニティを築く際、漏斗の一番上にいる人（潜在的なユーザー）が一番下（活動的なメンテナー）に向かってどのように理論的に進むのかを考えましょう。あなたのゴールは、コントリビューターが各段階で経験する障害を減らすことです。もし簡単に進めるようになれば、より多くのことをしたいと思うようになるでしょう。

まずはドキュメント化から始めましょう：

* **あなたのプロジェクトを使いやすくしよう** [親切な README](../starting-a-project/#readme-を書く) とわかりやすいコードの例によって、あなたのプロジェクトに着手した人が使い始めやすくなります。
* **コントリビュートの仕方をわかりやすく説明しよう**。その際、 [CONTRIBUTING ファイルを使い](../starting-a-project/#コントリビュートのガイドラインを書く)、イシューの状態を最新に保ちましょう。

[GitHub の 2017 Open Source Survey](http://opensourcesurvey.org/2017/) では、未完成であったり混乱するドキュメントはオープンソースプロジェクトのユーザーにとって最大の問題である事が示されています。良いドキュメントが人々をあなたのプロジェクトに招き入れます。結果として、イシューやプルリクエストを登録する人が出てきます。こういったやり取りを、漏斗の底に近づいてもらう機会として利用しましょう。
 
* **新しくプロジェクトに参加してくれた人に対して、興味を示してくれたことへの感謝の気持ちを伝えよう！** 一度ネガティブな経験をしただけで、人は戻ってきてくれなくなってしまいます。
* **すぐに返事を返すようにしよう。** 一ヶ月もの間イシューに返事をしなければ、おそらく彼らはあなたのプロジェクトのことを忘れ去ってしまうでしょう。
* **受け入れるコントリビュートの種類について心を広く持とう。** 多くのコントリビューターがバグレポートや小さな修正から始めます。プロジェクトへの[コントリビュートには多くのやり方](../how-to-contribute/#コントリビュートするということが意味するもの)があります。人々が望むやり方でコントリビュートできるように手助けしましょう。
* **受け入れられないコントリビュートがあった場合は、** そのアイデアに感謝を示しつつ、なぜプロジェクトのスコープから外れているのかを[説明しましょう](../best-practices/#ノーと言うやり方を学ぼう)。その際、関連するドキュメントも共有しましょう。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  オープンソースにコントリビュートすることは一部の人にとってはより簡単なことです。間違ったことをしたり、場違いな事をして叱られるのではないかという大きな恐怖があります。（中略）コントリビューターに対して、技術力をあまり必要としない（ドキュメントやウェブサイトのコンテンツのマークダウン等）コントリビュートができる場を提供することで、そういった心配を大きく減らすことができます。
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Growing a contributor base in modern open source"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

オープンソースのコントリビューターの大部分は「通りすがりのコントリビューター」です：彼らはプロジェクトへのコントリビュートを時々するだけの人々です。通りすがりのコントリビューターはあなたのプロジェクトに十分に理解する時間がないかもしれないため、彼らがコントリビュートしやすくするべきです。

他のコントリビューターを励ますことはあなた自身への投資にもなります。あなたの大ファンにワクワクする仕事をする裁量を与えることで、自分であらゆる仕事をやらないといけないというプレッシャーを減らすことができます。

### あらゆる事を記録しよう

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  これまでに（技術）イベントに参加して、知り合いが誰もおらず、周りは皆グループになって古くからの友人同士のように話しているといった経験をしたことはありませんか？（中略）オープンソースプロジェクトにコントリビュートをしたいと思っているのに、なぜ、またはどのようにそのプロジェクトが立ち上がったのかがわからないという状況を想像してみて下さい。
  <p markdown="1" class="pquote-credit">
— @janl, ["Sustainable Open Source"](https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

新しいプロジェクトを始めるときは、あなたのやっていることを秘密にしておきたいと感じるのは当然です。しかし、オープンソースプロジェクトはその過程を公開して記録することで成長していきます。

文書に記録することで、より多くの人がその過程の各ステップに参加することができます。それによって、必要だと思っていなかったことまでも助けてもらえるかもしれません。

文書に記録するというのは技術的なドキュメントに限った話ではありません。何かを書き留めておきたいという衝動を感じたり、プロジェクトについて非公式に議論するときはいつでも、それを公開できないか自問してみましょう。

プロジェクトのロードマップ、求めているコントリビュートの種類、コントリビュートがどのようにしてレビューされるか、ある決断をした理由といった情報の透明性を高めておきましょう。

もし複数のユーザーが同じ問題に遭遇しているのであれば、その解決策を README に書きましょう。

ミーティングに関しては、あなたのメモや学びを関連するイシューで公開することを検討しましょう。このレベルの情報の透明性によって得られるフィードバックにあなたは驚くかもしれません。

あらゆる事を記録するというのはあなた自身の作業についても当てはまります。プロジェクトにおいてなにか大きなアップデートに取り組んでいる場合、プルリクエストを作成し、作業中（ WIP ）という印をつけましょう。その方が、他の人がプロセスの早い段階から一緒に取り組んでいると感じることができます。

### すぐに反応しよう

[プロジェクトの存在を周知していく](../finding-users)につれて、人々からのフィードバックをもらうことになるでしょう。どのように動作しているのか質問があるかもしれないし、始めるにあたって助けを求めているかもしれません。

イシューが登録されたり、プルリクエストが提出されたり、プロジェクトについて質問を受けた場合はすぐに反応するようにしましょう。素早く返事をすれば、人々は会話に参加していると感じ、より熱心に参加してくれるでしょう。

たとえすぐにプルリクエストのレビューをできない場合であっても、その旨を素早く伝える事で繋がりを強めることができます。@tdreyno が [Middleman](https://github.com/middleman/middleman/pull/1466) のプルリクエストに対し、どのように返答しているかを見てみましょう：

![Middleman pull request](/assets/images/building-community/middleman_pr.png)

[Mozilla の調査によると](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177)、48時間以内にコードレビューをしてもらったコントリビューターは返答や再度コントリビュートを行う確率が非常に高いということがわかっています。 

Stack Overflow、Twitter、Reddit といったインターネットにおける他の場所でもあなたのプロジェクトについての会話が交わされることがあります。そのような場所からも通知が来るよう設定しておくことで、誰かがあなたのプロジェクトに言及したときに通知を受け取ることができます。

### コミュニティに集いの場を作ろう

コミュニティに集いの場を作るのには2つの理由があります。

1つ目はコミュニティメンバーのためです。人々が互いに知り合うのを助けましょう。共通の興味を持つ人々は、当然それについて会話する場を求めるでしょう。そして、そのコミュニケーションが公開されていてアクセスできるのであれば、誰でも過去のアーカイブを読むことで最新の情報に追いつき参加することができます。

2つ目の理由はあなたのためです。プロジェクトについて会話する公の場を作らなければ、あなたに直接コンタクトが来るようになるでしょう。初めは、「今回だけ」とプライベートメッセージで反応するのも十分簡単かもしれません。しかし時間が経つにつれ、特にあなたのプロジェクトが有名になると、あなたは疲れ切ってしまうでしょう。あなたのプロジェクトについて人々とプライベートにコミュニケーションしたいという衝動に抵抗しましょう。かわりに、プロジェクト用の公開チャンネルに誘導しましょう。

公の場でコミュニケーションすることは、あなたに直接メールを送ったり、ブログにコメントする代わりにイシューを開いてもらうように人々を誘導するのと同じ位簡単なことです。また、メーリングリストを設定したり、 Twitter アカウント、 Slack、 IRC チャンネルなどを作って、プロジェクトについての会話を可能にすることもできます。もしくは、それを全部やってもよいのです！

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) は、コミュニティメンバーを助けるために隔週でオフィスアワーを設定しています：

> Kops はコミュニティを支援しガイダンスを提供するために隔週で時間を設けています。Kops のメンテナーは、新しく参加した人との共同作業、プルリクエストの支援、新機能についての議論に時間を確保することに同意しています。

公の場でのコミュニケーションにも注意すべき例外があります：1) セキュリティに関するイシューや 2) 慎重に扱うべき行動規範への違反です。こういったイシューに関しては、内密に報告する手段を常に用意しておくべきです。あなた個人のメールを使いたくない場合は、専用のメールアドレスを確保しましょう。

## コミュニティを発展させよう

コミュニティは非常にパワフルです。このパワーは使い方によっては恵みにもなりえますし、災いにもなりえます。プロジェクトのコミュニティの発展にあたり、それが破壊的な力ではなく生産的な力にする方法があります。

### 悪い参加者を許容しない

どんな人気のあるプロジェクトにおいても、コミュニティの助けになるよりも害をなす人々を引き寄せてしまうことは避けられないでしょう。彼らは不要な議論をし始めたり、些末な機能に難癖をつけたり、他の人を脅したりするかもしれません。

こういった類の人々に対しては、ゼロ・トレランスポリシー（訳注：1990年代にアメリカで始まった教育方針の一つ。ポリシー違反には厳密に処分を行う）を適用することに最善を尽くしましょう。もし放置されてしまうと、有害な人々によって、コミュニティ内の人々は居心地が悪いと感じてしまうでしょう。コミュニティを去ってしまいさえするかもしれません。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/karissa?s=180" class="pquote-avatar" alt="avatar">
  実のところ、協力的なコミュニティを持つことが鍵となります。私は、同僚や親切なインターネット上の見知らぬ人、気さくな IRC チャンネルの助けが無ければ、この仕事を達成することはできなかったでしょう。（中略）そうでない状況に甘んじてはいけません。愚か者を甘んじて受け入れてはいけません。
  <p markdown="1" class="pquote-credit">
— @karissa, ["How to Run a FOSS Project"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

プロジェクトの些末な点について議論することが日常的になってしまうと、あなたを含むプロジェクトの人々が重要なタスクに集中することから気が逸れてしまいます。新たにあなたのプロジェクトにやってきた人もこういった議論を見て、参加したくないと思うかもしれません。

もしあなたのプロジェクトで有害な行動を見つけたら、公の場で指摘しましょう。温和ながらも断固たるトーンで、なぜその行動が受け入れられないのか説明しましょう。もし問題が続くようであれば、[彼らに立ち去るように言う](../code-of-conduct/#行動規範を遵守してもらおう)必要があるかもしれません。[行動規範](../code-of-conduct/)は、こういった会話を生産的にする助けになりえます。

### コントリビューターを出迎えよう

優れたドキュメントは、コミュニティが成長するにつれてより重要になります。あなたのプロジェクトに精通していない通りすがりのコントリビューターは、ドキュメントを読むことで必要とする周辺知識を得ることができます。

CONTRIBUTING ファイルに、新しいコントリビューターに始め方を明示しましょう。この説明のために専用のセクションを作成したいとさえ思うかもしれません。例えば [Django](https://github.com/django/django) は、新しいコントリビューターを迎えるためのランディングページを用意しています。

![Django new contributors page](/assets/images/building-community/django_new_contributors.png)

イシューのリストにおいて、バグに対してコントリビューターの種類に応じたラベル付けをしましょう：例えば、 [_"first timers only"_](https://kentcdodds.com/blog/first-timers-only) や _"good first issue"_ 、 _"documentation"_ といったものです。[こういったラベル](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14)によって、あなたのプロジェクトに詳しくない人がイシューをざっと目を通してコントリビュートを始める事が簡単になります。

最後に、あらゆるステップにおいて歓迎されていると人々に感じてもらえるようにドキュメントを活用しましょう。

プロジェクトを見たほとんどの人はあなたとやり取りすることはないでしょう。人々は恐れを感じたり、どのように始めたらよいかわからないといった理由で、コントリビュートをやめたかもしれません。そういった場合でも、ほんの少しでも彼らを歓迎する言葉があれば、彼らがイライラしてプロジェクトを去ってしまう事を防ぐことができます。

これは [Rubinius](https://github.com/rubinius/rubinius/) の[コントリビュートガイド](https://github.com/rubinius/rubinius/blob/master/.github/contributing.md)の書き出しの例です：

> まず最初に、Rubinius を使ってくれてありがとうとお伝えしたいと思います。このプロジェクトは愛の結晶であり、バグを見つけてくれたり、性能を向上させたり、ドキュメントを書くことを手伝ってくれる全てのユーザーに感謝しています。あらゆるコントリビュートには意味があるので、参加してくれることに感謝しています。そうは言っても、私達があなた達の問題に首尾よく取り組む事ができるように、いくつかのガイドラインに従うようお願いしたいと思います。

### プロジェクトの所有権を共有しよう

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  リーダーたちは異なる意見を持っていることでしょう。あらゆる健全なコミュニティはそうあるべきなのです！しかし、大きな声が人々を疲弊させることによって必ずしも勝つとは限らず、目立たない少数派の声も聞き入れられるように対策を講じる必要があります。
  <p markdown="1" class="pquote-credit">
— @@sagesharp, ["What makes a good community?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

人々は、自分にもプロジェクトの所有権があるという感覚を持つときに、コントリビュートすることにワクワクしてくれます。これはあなたが望まない方向にプロジェクトのビジョンを切り替えたり、望まないコントリビュートを受け入れるということではありません。しかし、他者を信用すればするほど、彼らはよりプロジェクトに留まってくれるようになるでしょう。

コミュニティの人々に所有権を共有する方法があるかどうか可能な限り検討しましょう。以下にいくつかアイデアを挙げます：

* **簡単な（致命的でない）バグを直すのを我慢しよう。** 代わりに、そのバグを新しいコントリビューターを募集したり、コントリビュートしたいと思っている人を指導したりするために活用しましょう。初めは不自然に感じるかもしれませんが、時間が経てばその投資の効果が表れるでしょう。例えば、 @michaeljoseph は以下の [Cookiecutter](https://github.com/audreyr/cookiecutter) のイシューに対して、彼自身で修正するのではなく、プルリクエストを送ってもらうよう求めています。

![Cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **CONTRIBUTORS ファイルや AUTHORS ファイルをプロジェクトに作ろう。** [Sinatra](https://github.com/sinatra/sinatra/blob/master/AUTHORS.md) が実施しているように、これらのファイルにプロジェクトにコントリビュートしてくれた人すべてをリストしましょう。

* かなり大きなコミュニティを既に獲得しているのであれば、コントリビューターへの感謝を伝える **ニュースレターを送ったり、ブログポストを書いたりしましょう。** Rust の [This Week in Rust](https://this-week-in-rust.org/) や Hoodie の [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) はどちらも良い事例です。

* **全てのコントリビューターにコミット権限を与えよう。** @felixge はこれによって人々が [パッチに磨きをかけることによりワクワクするようになる](https://felixge.de/2013/03/11/the-pull-request-hack.html)ことに気づき、更にしばらくの間取り組んでいなかったプロジェクトの新しいメンテナーを見つけることさえできたのです。

* もしプロジェクトが GitHub 上にあるのであれば、 **プロジェクトをあなた個人のアカウントから [Organization](https://help.github.com/articles/creating-a-new-organization-account/)** に移し、最低でも一人代わりの管理者を追加しましょう。 Organization によって外部の協力者と一緒にプロジェクト上での作業をしやすくなります。

実際のところ、[ほとんどのプロジェクトはたった](https://peerj.com/preprints/1233.pdf) 一人か二人のメンテナーしかおらず、彼らがほとんどの作業を行っています。プロジェクトやコミュニティが大きくなるほど、協力者を見つけるのがより簡単になります。

常に要求に応じてくれる人が見つかるとは限りませんが、そういったシグナルを出しておくことで、協力してくれる人が出てくるチャンスが増えます。そしてより早く始めると、より早く人々が助けてくれるでしょう。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  あなたがやりたいと思わないことを楽しんでやってくれるコントリビューターを募集する事が得策です。コーディングは好きだけどイシューに回答するのは好きではありませんか？それなら、コミュニティの中からそれを楽しんでくれる人を探し出して、その人にやってもらいましょう。
  <p markdown="1" class="pquote-credit">
— @gr2m, ["Welcoming Communities"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## 衝突を解消しよう

プロジェクトの初期段階では、大きな決定をするのは簡単です。もし何かをやりたいのであれば、行動あるのみです。

プロジェクトが有名になるにつれて、人々はあなたが下す決定に興味を持ち始めます。たとえ大きなコントリビューターのコミュニティがなかったとしても、たくさんのユーザーがいるのであれば、人々が決断について考えていたり、彼ら自身の問題を提起したりしていることに気づくでしょう。

ほとんどの場合、友好的で互いを尊重するコミュニティを作り上げ、プロセスを公開して記録してきているのであれば、コミュニティによって解決策を見つけることができるようになっているはずです。しかし、時々解決するのがやや難しい問題に遭遇することがあるでしょう。

### 親切さの基準を設けよう

コミュニティの人々が難しい問題に取り組んでいるときは、カッとなりやすくなるものです。人々は怒ったりイライラして、他の誰か、もしくはあなたに八つ当たりするかもしれません。

メンテナーとしてのあなたの仕事はこういった状況が悪化しないようにすることです。たとえあなたがそのトピックについて強い意見を持っていたとしても、争いに飛び込んであなたの意見を押し付けるのではなく、調停役やファシリテーターとして振る舞うようにしましょう。もし誰かが不親切であったり会話を独り占めしたりしている場合は、議論を市民的かつ生産的に保つために[即座に行動しましょう](../building-community/#悪い参加者を許容しない)。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  プロジェクトのメンテナーとして、コントリビューターに対して敬意を払うのは非常に重要です。彼らはあなたの言うことを非常に個人的に捉えることがよくあります。
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Be Cordial or Be on Your Way"](https://www.kennethreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

他の人々はあなたの指導を求めています。良い手本を示しましょう。がっかりしていたり、良い気分でなかったり、心配したりしている事を表明することもできますが、その場合も穏やかに行うようにしましょう。

常に冷静でいるのは簡単なことではありませんが、リーダーシップを示すことで、コミュニティの健全性を向上させることができます。インターネット上の人々はあなたに感謝することでしょう。

### README を憲法のように扱おう

README は[単なる手順書以上の存在です](../starting-a-project/#readme-を書く)。README はあなたのゴールやプロジェクトのビジョン、ロードマップについて書く場でもあるのです。もし人々がある特定の機能のメリットについて議論しすぎているのであれば、 それは README を見返してプロジェクトのより高レベルのビジョンについて会話することの助けとなるかもしれません。 README に注力することは、会話を個人から切り離し、生産的な議論を行うことに繋がります。

### 目的地ではなく、行程に焦点を当てよう

大きな決定を行う際に投票を用いるプロジェクトもあります。一見して賢明に見えますが、投票はお互いの心配事に耳を傾けたり対処したりすることよりも、「答え」を出す事に重きをおいてしまいます。

投票は政治的になり得ます。そうなると、コミュニティメンバーは互いのためになることをしたり、ある方法で投票することにプレッシャーを感じるようになります。また、コミュニティの[サイレントマジョリティ](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users)や投票が行われていることを知らないユーザーのように、全員が投票を行うわけでもありません。

とはいえ、時によっては決選投票が必要なこともあります。しかしできるだけ、合意を得ることよりも[「合意の模索」](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making)を重視しましょう。

合意を模索する過程において、コミュニティメンバーは十分出し尽くされたと感じるまで懸念点を議論します。小さな論点しか残っていない状況になってはじめて、コミュニティは前に進みます。「合意の模索」は、コミュニティが完璧な解にたどり着けないかもしれないことを受け入れます。そのかわりに、意見を聞き、議論をすることに重きをおくのです。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  Atom の Issue に投票システムが存在しない理由の一部は、 Atom チームはあらゆるケースにおいて投票システムを使うわけではないからです。時には、あまり支持されていなくても、正しいと感じることを選ぶ必要があります。（中略）私が提供し、実施すると固く約束するのは…、コミュニティの意見に耳を傾けることが私の仕事であるということです。
  <p markdown="1" class="pquote-credit">
— @lee-dohm on [Atom's decisionmaking process](https://discuss.atom.io/t/prioritize-issues-feature-requests-based-on-voting-system/27642/2)
  </p>
</aside>

たとえ合意の模索プロセスを採用していないとしても、プロジェクトメンテナーとして重要なことは、あなたが意見に耳を傾けていることを人々が知っているということです。人々に意見を受け止められていると感じさせ、彼らの心配を解決すると約束することは、慎重な対応が必要な状況を散らすための長い道のりのスタートとなります。そして、あなたの発言に行動が伴うようにするのです。

問題解決のために意思決定を急いではいけません。解決に向かう前に、皆の意見が聞き入れられ、全ての情報が公開されているようにしましょう。

### 議論を行動に集中し続けよう

議論は大事ですが、生産的な会話と生産的でない会話には違いがあります。

解決に向かっている限りは議論を奨励しましょう。もし、議論が明らかに停滞したり、論点がずれていたり、個人攻撃が始まったり、些細な点に固執したりすることが明らかになったら、それが議論を終えるときです。

こういった議論が続くことを許してしまうと、目前の問題に対しても良くないですし、コミュニティの健全性に対しても良くないです。こういった種類の議論が許されている、もしくは奨励されてすらいるというメッセージになってしまいますし、人々が今後問題を共有したり解決しようとする気持ちを削いでしまうことにも繋がります。

あなたや他者によって作られた全ての論点について、 _「この論点はどのように我々を解決に近づけるだろうか？」_ と考えてみましょう。

もし会話がもつれ始めたら、 _「次には何をするべきだろう？」_ と皆に問いかけ、議論の焦点をもとに戻りましょう。

もし会話が明らかにどこにも向かっていなく、取るべきアクションもないか、適切なアクションはすでに起こしたのであれば、理由とともにイシューを閉じましょう。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  強引にならずに議論を実利的なものに導いていくのはある種の技術です。単に無駄な時間を使わないよう忠告したり、建設的な内容がない限り書かないでほしいとお願いするだけではうまくいきません。 (中略) そうする代わりに、議論を進める条件を提案する必要があります：例えば指針を与えたり、あなたが望む結論に導くための道筋を提示したりといったことです。ただ、あなたが行動を指示しているように聞こえないよう気をつける必要があります。
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### 戦う場所を賢く選ぼう

コンテキストは重要です。誰が議論に参加していて、彼らがコミュニティの残りのメンバーを代表しているのかどうかを考えましょう。

コミュニティの皆がこの問題について不満を感じている、もしくは関係していますか？それとも、トラブルメーカーが一人いるだけでしょうか？常に声の大きいメンバーだけでなく、静かなコミュニティメンバーのことも考慮に入れる必要があります。

もしその問題がコミュニティの大部分の希望を表していないとしても、少数派の懸念を認める必要があるかもしれません。もしそれが明確な解決策がなく、繰り返し発生する問題なのであれば、そのトピックに関する過去の議論を参照し、そのスレッドを閉じましょう。

### コミュニティのタイブレーカーを見つけ出そう

良い対応と明確なコミュニケーションによって、大抵の問題は解決可能です。しかし、たとえ生産的な議論をしたとしても、どのように物事を進めるかについての意見の相違は発生する可能性があります。そういう場合は、タイブレーカーとなりうる個人やグループを見つけ出しましょう。

タイブレーカーはプロジェクトの主要なメンテナーかもしれませんし、投票によって決断する少人数のグループかもしれません。理想としては、タイブレーカーと GOVERNANCE ファイルにある関連するプロセスを、それを使わなければならない状況になる前に特定しておくことです。

タイブレーカーは最後の手段であるべきです。対立を呼ぶような問題はコミュニティが成長し、学習する良い機会です。こういった機会を受け入れ、可能なところではどこでも解決に向かうために協調的なプロセスを活用しましょう。

## コミュニティはオープンソースの❤️です

健全で栄えているコミュニティでは、オープンソースに毎週何百時間ものエネルギーを注ぎ込みます。多くのコントリビューターがオープンソース活動をする理由 - あるいはしない理由 - として、コミュニティの他の人を挙げます。そういったパワーを建設的に利用する方法を学習することで、オープンソース活動をしている人に対して忘れがたい経験を提供する事ができるでしょう。
