---
lang: ja
title: メンテナーの為のベストプラクティス
description: プロセスのドキュメント化やコミュニティの活用といったことを通じて、オープンソースメンテナーとしての日々をより楽にしましょう。
class: best-practices
order: 5
image: /assets/images/cards/best-practices.png
related:
  - metrics
  - leadership
---

## メンテナーになるということは何を意味するのか？

もし多くの人々に使われるオープンソースプロジェクトをメンテナンスしているのであれば、コーディングの時間が減り、イシューへの対応により多くの時間を割いているということに気づいているかもしれません。

プロジェクトの初期段階では、新しいアイデアを実験したり、やりたいと思ったことに基づいて意思決定しているでしょう。プロジェクトの人気が拡大していくことに伴い、ユーザーやコントリビューターと一緒に仕事をする時間がより多くなっていくことでしょう。

プロジェクトを運営するということは、コードを書く以上のことを必要とします。そのようなタスクは予想外のことが多いですが、成長しているプロジェクトにとって重要なことなのです。ここではプロセスのドキュメント化やコミュニティの活用といった、メンテナーとして過ごす日々を楽にする方法をいくつか集めてみました。

## プロセスをドキュメント化しよう

ドキュメント化はメンテナーとして出来ることのうち最も重要なことの一つです。

ドキュメント化はメンテナーの考えを明確にするだけではなく、他の人々にとってメンテナーが必要としていることや望んでいることを質問する前に理解する手助けとなります。

ドキュメントを書いておくことで、自分のスコープ外のことが起きたときにノーと言いやすくなります。また、人々が援助や手助けをしやすくなります。誰がドキュメントを読んだり、プロジェクトを使ったりしているかは誰にも分かりません。

たとえ完全な文章ではなく、箇条書きにしておくだけでも何も書かないより良いです。

ドキュメントを最新の状態に保つよう心がけましょう。もし常に最新を保つことが出来ないのであれば、古くなったドキュメントは削除するか、既に古くなっているということを明示することで、コントリビューターに対してそのドキュメントの更新が歓迎されることであることを伝えることが出来ます。

### プロジェクトのビジョンを書き留めよう

プロジェクトのゴールを書き留めることから始めましょう。README に追記するか、 VISION という名前の別のファイルを作りましょう。プロジェクトのロードマップなど、他に役立つ成果物があればそれらも公開しましょう。

明確でドキュメント化されたビジョンは、焦点が絞られた状態を保ち、他者からのコントリビュートによる「スコープの肥大化」を避ける助けとなります。

例えば @lord は、プロジェクトのビジョンを持つことでどのリクエストに時間を割くべきか判断しやすくなる、ということに気づきました。新しいメンテナーとして、彼は [Slate](https://github.com/lord/slate) への最初の機能要望を受け取ったときに、プロジェクトのスコープを固執しなかったことを後悔していました。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lord?s=180" class="pquote-avatar" alt="avatar">
  私はヘマをしたのです。私は完璧な解決策を見つける努力をしませんでした。中途半端な解決策の代わりに、「今は十分な時間がないのですが、長期的な nice-to-have リストに追加します」と言えたら良かったのです。
  <p markdown="1" class="pquote-credit">
— @lord, ["Tips for new open source maintainers"](https://lord.io/blog/2014/oss-tips/)
  </p>
</aside>

### 期待することを伝えよう

ルールを書き出すというのは神経をすり減らすこともあります。時折、他の人の行動を取り締まったり、楽しみを殺してしまっていると感じるかもしれません。

しかし、適切に明文化され、運用されれば、良いルールはメンテナーの力となります。メンテナーが望まないことに引きずり込まれるような状況を防いでくれるのです。

あなたのプロジェクトを訪れる人の殆どはあなた自身やあなたを取り巻く状況について何も知りません。あなたがこのプロジェクトで金銭を得ていると考えているかもしれません。特に彼らがあなたのプロジェクトを定期的に使い、依存している場合はなおさらです。多分、プロジェクトに多くの時間を費やしていた時もあったが、今は新しい仕事や家族で忙しい、ということもあったりするでしょう。

このようなことは全く問題ありません！他の人々が知ることができるようにすればよいのです。

プロジェクトを運営するのがパートタイムであったり、完全にボランティアで行っている場合、どのくらいの時間を使えるのか正直に打ち明けましょう。プロジェクトに必要であろう時間や、他の人があなたに使ってほしいと望む時間と、あなたが実際に使える時間は異なるからです。

下記に、明記しておく価値のある幾つかのルールをまとめます：

* コントリビュートがどのようにしてレビューされ、受け入れられるか（ _テストは必要か？イシューテンプレートを使うべきか？_ ）
* 受け入れる予定のコントリビュートの種類（ _コードの一部分に関してのみ手助けが必要か？_ ）
* リマインドをするのはいつが適切か（ _例えば、「メンテナーが7日以内に返答をします。もしそれを過ぎても返事がない場合は、スレッドで気軽にリマインドして下さい」_ ）
* どのくらいの時間をプロジェクトに使えるか（ _例えば、「我々はこのプロジェクトに週5時間しか使いません。」_ ）

[Jekyll](https://github.com/jekyll/jekyll/tree/master/docs) や [CocoaPods](https://github.com/CocoaPods/CocoaPods/wiki/Communication-&-Design-Rules) 、 [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Maintainers-Avoiding-Burnout.md) は、メンテナーとコントリビューターのための基本ルールを定めたプロジェクトの良い例です。
 
### コミュニケーションを公開しよう

あなたのやり取りをドキュメント化することも忘れないようにしましょう。可能な限りどこでも、プロジェクトについてのコミュニケーションを公開しましょう。機能要望やサポートリクエストについてプライベートにコンタクトしてくる人がいたら、彼らをメーリングリストやイシュートラッカーのようなパブリックなコミュニケーションチャネルに丁寧に誘導しましょう。

他のメンテナーと会ったり、プライベートに大きな決断をしたりした場合は、これらの会話を公の場にドキュメント化しましょう。たとえ、メモ書きを投稿するだけだとしてもです。

このようにして、コミュニティに参加した人は誰でも何年も所属している人と同程度の情報にアクセスできるようになるでしょう。

## ノーと言うやり方を学ぼう

ここまでで様々なものを明文化してきました。あらゆる人があなたのドキュメントを読んでくれるのが理想ですが、現実はドキュメントが存在することを伝える必要があるでしょう。

とはいえ、あらゆるものをドキュメント化する事は、ルールを遵守してもらう必要があるときに属人性を排除するのに役立ちます。

ノーと言うのは楽しいことではありません、しかし _「あなたのコントリビュートはこのプロジェクトの優先事項にはマッチしません。」_ という方が _「あなたのコントリビュートが好きではありません。」_ というよりも個人的でない印象になります。

メンテナーとして直面する様々な状況でノーを言う場面があります：プロジェクトのスコープに当てはまらない機能要望、議論を脱線させる人、他人のために不要な作業をすることなどです。

### 会話を友好的に保ちましょう

ノーと言うことを実践する上で最も重要な場所の一つが、イシューやプルリクエスト上です。プロジェクトのメンテナーとして、受け入れたくない提案を受けることは避けられないでしょう。

そのコントリビュートはプロジェクトのスコープを変更してしまうか、ビジョンにマッチしないのかもしれません。アイデアは良くても、実装が良くないのかもしれません。

その理由にかかわらず、あなたのプロジェクトの基準を満たさないコントリビュートをそつなく対処する事は可能です。

もし受け入れたくないコントリビュートを受け取った場合は、あなたの最初の反応はそれを無視するか見なかったことにすることでしょう。そのようなことは他の人の感情を傷つけ、さらにコミュニティの中にいる潜在的なコントリビューターのやる気まで削いでしまいます。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/krausefx?s=180" class="pquote-avatar" alt="avatar">
  大規模なオープンソースプロジェクトでサポートの対応をする際に大事なのは、イシューを動かし続けることです。イシューを停滞させないようにしましょう。もしあなたが iOS 開発者なのであれば、審査に時間がかかることがどれだけイライラするものかわかるでしょう。2年経ってから返事が返ってきて、 iOS の最新バージョンでやり直してくれと言われるかもしれないのです。
  <p markdown="1" class="pquote-credit">
— @KrauseFx, ["Scaling open source communities"](https://krausefx.com/blog/scaling-open-source-communities)
  </p>
</aside>

望ましくないコントリビュートをオープンのまま放置しないようにしましょう。放置すると罪悪感を感じたり親切になろうとしてしまいます。時間が経つにつれて、回答されていないイシューやプルリクエストによって、プロジェクトを進めることがストレスを伴い、恐怖を感じるものになってしまいます。

受け入れるつもりのないコントリビュートはすぐに閉じてしまうのが良いです。もし既に膨大なバックログで困っているのであれば、 @steveklabnik の[イシューを効率的にトリアージする方法](https://words.steveklabnik.com/how-to-be-an-open-source-gardener)が役に立つでしょう。

また、コントリビュートを無視することはコミュニティに悪い影響を与えます。プロジェクトにコントリビュートすることは威圧感があります。特に初めてのコントリビュートであればなおさらです。たとえ、そのコントリビュートを受け入れないとしても、その人に対して受け入れない旨と感謝の気持ちを伝えましょう。それは大きな賛辞となります！

もし、コントリビュートを受け入れたくないのであれば：

* 彼らのコントリビュートに**感謝しましょう**
* なぜプロジェクトのスコープに**マッチしないか説明しましょう**。そして、可能であれば、明確な改善提案をしましょう。親切に、しかし確固たる態度で行いましょう。
* もしあれば、**関連するドキュメントにリンクしましょう**。もし受け入れたくない内容が繰り返し提案されるようであれば、ドキュメントにその旨を追記して繰り返しの作業をなくしましょう。
* **リクエストをクローズしましょう**。

1 ~ 2文以上の返答は不要です。例えば、 [celery](https://github.com/celery/celery/) のユーザーが Windows 関連のエラーを報告してきたときに、 @berkerpeksag は[このように返答しました](https://github.com/celery/celery/issues/3383)：

![Celery screenshot](/assets/images/best-practices/celery.png)

ノーと言うのが恐ろしいと感じるのはあなただけではありません。あなたは一人ではないのです。 @jessfraz も[こう書いています](https://blog.jessfraz.com/post/the-art-of-closing/)：

> 私はこれまで Mesos や Kubernetes 、 Chromium といったオープンソースプロジェクトのメンテナーと話をしてきました。そして、彼ら全員が同意した事は、メンテナーとして最も難しいことの1つは、受け入れたくないパッチに対して「ノー」を言うことだ、という点です。

コントリビュートを受け入れたくないと思うことを罪に感じる必要はありません。オープンソースの第一のルールは、 @shykes [によると](https://twitter.com/solomonstre/status/715277134978113536)： _「ノーは一時的だが、イエスは永遠である」_ 。他の人の熱意に共感するのは良いことですが、コントリビュートを拒否することはその人自身を拒否することとは異なります。

最終的に、コントリビュートがあまり良くないものであれば、それを受け入れる義務はありません。人々がプロジェクトにコントリビュートしてくれたときには親切に、またきちんと返事をするようにしましょう。しかし、本当にプロジェクトのためになると思う変更のみを受け入れましょう。ノーと頻繁に言えば言うほど、それはより簡単になっていきます。約束します。

### 先回りしよう

まず第一に不要なコントリビュートの量を減らすには、コントリビュートガイドでコントリビュートを提案するプロセスとコントリビュートを受け入れるプロセスを説明しましょう。

もし品質の低いコントリビュートを多く受け取るようであれば、コントリビューターに事前に確認してもらうよう要求しましょう。例えば：

* イシューやプルリクエストのテンプレート/チェックリストを埋めてもらう
* プルリクエストを提出する前にイシューを開いてもらう

もしあなたのルールに従わない人がいたら、即座にイシューを閉じてドキュメントを共有しましょう。

はじめはこのやり方は親切ではないと感じるかもしれませんが、先回りしておくことは両者にとって良いことなのです。コントリビュートする人にとっては、受け入れられる見込みのないプルリクエストに何時間も費やす機会が減ります。そして、あなた自身の作業量もやりくりしやすくなります。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
  コントリビューターに対して CONTRIBUTING.md ファイルでどういった変更は受け入れられるのかを、作業を開始する前に知ることができるようになっているのが理想的です。
  <p markdown="1" class="pquote-credit">
— @MikeMcQuaid, ["Kindly Closing Pull Requests"](https://github.com/blog/2124-kindly-closing-pull-requests)
  </p>
</aside>

時には、ノーということで、潜在的なコントリビューターが怒ったり決定を批判したりするかもしれません。もしそれらの行動が敵対的であれば、[状況を沈静化するために行動を起こす](https://github.com/jonschlinkert/maintainers-guide-to-staying-positive#action-items)か、建設的に協調できないようであればコミュニティから抜けてもらいましょう。

### メンターシップを受け入れよう

プロジェクトの基準に満たないコントリビュートを定期的に提出する人がいるかもしれません。何度も拒絶を経験するのはお互いにとってイライラするものです。

もしその人がプロジェクトに対して情熱があるけれども上達が必要だとわかっている場合は、辛抱強くなりましょう。プロジェクトの期待する水準になぜ満たないのかをそれぞれの状況ごとに明確に説明しましょう。より簡単な、もしくはより明確なタスクを紹介しましょう。例えば、手始めに取り掛かるのにちょうど良いイシューに _"good first issue,"_ ラベルを付けるといったことです。もし時間があるのであれば、初めてのコントリビュートを通じて彼らのメンターとなることも検討しましょう。もしくは、コミュニティの中で喜んでメンターとなってくれそうな人を探しましょう。

## コミュニティを活用しよう

あらゆる事を一人で行う必要はありません。あなたのプロジェクトのコミュニティはそのためにあるのですから！たとえ現時点ではまだ活発なコントリビューターコミュニティが無かったとしても、たくさんのユーザーがいるのであれば、その人達に仕事をしてもらいましょう。

### 作業負荷を共有しよう

もし他の人に支援してもらいたいなら、まずはお願いして回る所からはじめましょう。

新しいコントリビューターが繰り返しコントリビュートを行っていることに気づいたら、より大きい責任を提供することで彼らの仕事を認めましょう。望むならどのようにリーダーの役割を担えるよう成長出来るのかについてもドキュメント化しましょう。

他の人に対して[プロジェクトの所有権を共有する](../building-community/#プロジェクトの所有権を共有しよう)よう推奨することはあなたの作業負荷を大いに減らすことに繋がります。 @lmccart が彼女のプロジェクトである [p5.js](https://github.com/processing/p5.js) で認識したように。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lmccart?s=180" class="pquote-avatar" alt="avatar">
  （コントリビューター向けのイベントの告知で）私は「誰でも参加可能です、優れたコーディングスキルも必要ありません。」と言い続けてきました。その後、（イベントに）多くの人が登録してくれた時に、今まで自分が言ってきたことは本当だろうか？と思い始めました。40人もの参加者が来てくれたため、彼ら一人ひとりを私がサポートすることは出来ませんでした。しかし、彼らは一致団結し、そしてうまくいきました。一人が状況を理解するとすぐに、近くの人に理解した内容を教えることができたのです。
  <p markdown="1" class="pquote-credit">
—  @lmccart, ["What Does "Open Source" Even Mean? p5.js Edition"](https://medium.com/@kenjagan/what-does-open-source-even-mean-p5-js-edition-98c02d354b39#.chnjlag7p)
  </p>
</aside>

もし、暫定的であれ恒久的であれ、あなたがプロジェクトから離れる必要があるのであれば、他の誰かに引き継ぎをお願いするのは少しも恥ずかしいことではありません。

もしプロジェクトの方向性に熱意を持っている人がいれば、その人にコミット権限を与えるか、公式にその人にプロジェクトの管理を引き渡しましょう。もしあなたのプロジェクトをフォークしている人がいて、フォーク先が活発にメンテナンスされているのであれば、あなたの元々のプロジェクトとフォーク先をリンクすることを検討しましょう。非常にたくさんの人々があなたのプロジェクトが生き続けて欲しいと望んでくれるのは素晴らしいことです！

@progrium が彼のプロジェクトである [Dokku](https://github.com/dokku/dokku) で[気づいたこととして](https://web.archive.org/web/20151204215958/https://progrium.com/blog/2015/12/04/leadership-guilt-and-pull-requests/)、プロジェクトのビジョンをドキュメントに明記しておくことで、たとえ彼がプロジェクトから退いてもプロジェクトのゴールが生き続けたというものがあります：

> 私は wiki に望むこととその理由を書きました。私にとって驚きだったのは、プロジェクトのメンテナーたちがその方向に向かい始めたことでした！私がやろうとしたことが実際に実現されたかって？常にそうだったわけではありません。しかし、それでも私が描いた理想像にプロジェクトが近づいていったのです。

### 他の人に彼らが必要な解決策を作ってもらおう

もし潜在的なコントリビューターがあなたのプロジェクトがやるべきことについて異なる意見を持っているのであれば、彼ら自身のフォークを作ることを推奨するのも一つの手です。

プロジェクトをフォークすることは必ずしも悪いことではありません。プロジェクトをコピーしてそれを修正できるということはオープンソースの最も素晴らしい点の1つです。コミュニティメンバーに対して彼ら自身のフォークを作ることを推奨することで、あなたのプロジェクトのビジョンと衝突することなく、メンバーの創造性を発揮するはけ口を作り出すことが出来ます。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/geerlingguy?s=180" class="pquote-avatar" alt="avatar">
  私は80%のユースケースを満たすように提供します。もしユニコーンの一人（訳注：残りの20％のユースケースが必要な人のこと）なのであれば、私の作品をフォークして下さい。私はそれによって傷つくことはありません。私のプロジェクトはほとんどが常に最もよくある問題を解決するためのものなのです; 更に深いことをやりたい場合のために、フォークしたり拡張しやすくするよう努めています。
  <p markdown="1" class="pquote-credit">
— @geerlingguy, ["Why I Close PRs"](https://www.jeffgeerling.com/blog/2016/why-i-close-prs-oss-project-maintainer-notes)
  </p>
</aside>

同じことが、あなたが構築する余裕の無い解決策を本当に望んでいるユーザーに対しても言えます。 API とカスタマイズのためのフックを提供することで、他の人が彼ら自身のニーズを、ソースコードを直接修正することなく実現する助けとなります。 @orta は CocoaPods 向けのプラグインを他の人に作ってもらうことで、「最も面白いアイデア」が出てきたと[言っています](https://artsy.github.io/blog/2016/07/03/handling-big-projects/)：

> プロジェクトが大きくなっていくにつれて、メンテナーが新しいコードを追加することに対して保守的になっていくのはほぼ避けようがない。「ノー」ということが上手になっていくだろうが、多くの人は理にかなったニーズを持っています。そこで代わりに、あなたのツールをプラットフォーム化することになるのです。

## ロボットを使おう

他の人に手伝ってもらえるタスクがたくさんあるのと同様に、人間がやる必要のないタスクも多数あります。ロボットは友達です。ロボットを使うことでメンテナーとして過ごす日々を楽にしましょう。

### コードの品質を向上させるためにテストやチェックを要求しよう

プロジェクトを自動化する最も重要な方法の1つは、テストを追加することです。

テストがあることで、コントリビューターは何一つ壊していない事を自信を持って確認することができます。また、あなたにとっても、コントリビュートをすばやくレビューし取り込みやすくなります。より早く反応すればするほど、コミュニティもより活発になるのです。

全てのコントリビュートに対してテストを自動的に実行するように設定し、またコントリビューターがローカルで簡単にテストを実行できるようにしておきましょう。コントリビュートが提出される前に全てのテストが成功している事を要求しましょう。こうすることで、全てのコントリビュートが提出される前に、最低限の品質基準を設けることができるようになります。 GitHub の [Required status checks](https://help.github.com/articles/about-required-status-checks/) 機能を使うことで、テストが成功していない変更はマージされないよう保証することができます。

テストを追加したら、 CONTRIBUTING ファイルでテストがどう実行されるかを説明しましょう。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/edunham?s=180" class="pquote-avatar" alt="avatar">
  私は人々が実装するあらゆるコードに対してテストが必要だと思っています。もしコードが完全に正しいのであれば、変更の必要はありませんが、 私達がコードを書くときは何かがおかしいときです、それは「クラッシュする」であったり「これこれの機能が足りない」といったようなケースです。どんな変更をしようとしているのであれ、テストは誤ってバグを入れ込んでしまう事を防ぐために非常に重要です。
  <p markdown="1" class="pquote-credit">
— @edunham, ["Rust's Community Automation"](https://edunham.net/2016/09/27/rust_s_community_automation.html)
  </p>
</aside>

### ツールを使って基本的なメンテナンス作業を自動化しよう

人気のあるプロジェクトをメンテナンスすることについての良いニュースとしては、他のメンテナーも似たような問題に直面し、そのための解決策を作っているということです。

メンテナンス作業の一部を自動化するために、[非常に幅広いツール](https://github.com/showcases/tools-for-open-source)があります。幾つか例を挙げましょう：

* [semantic-release](https://github.com/semantic-release/semantic-release) はリリースを自動化します
* [mention-bot](https://github.com/facebook/mention-bot) はプルリクエストのレビュアーになってくれる可能性のある人にメンションを送ります
* [Danger](https://github.com/danger/danger) はコードレビューを自動化します

バグ報告や他のよくあるコントリビュートに対しては、 GitHubに [イシューテンプレートとプルリクエストテンプレート](https://github.com/blog/2111-issue-and-pull-request-templates) という機能があります。これを使うことで、コミュニケーションを簡素化することができます。 @TalAter はイシューやプルリクエストのテンプレートを作成する助けとなるよう、 [Choose Your Own Adventure guide](https://www.talater.com/open-source-templates/#/) を作りました。

メール通知を管理する際、優先順位を設定するために[メールフィルター](https://github.com/blog/2203-email-updates-about-your-own-activity)を使うことができます。

更に発展させたいのであれば、スタイルガイドやリンターを使うことで、プロジェクトへのコントリビュートを標準化し、レビューや取り込みを簡単にできます。

しかし、あなたが設定した標準が複雑すぎると、コントリビュートへの障壁が高くなってしまいます。皆の作業を簡単に行うために十分なルールだけを追加するように気をつけましょう。

どのツールを使うべきかわからないのであれば、他の有名なプロジェクトがどのようにしているかを探してみましょう。特に、同じエコシステムのプロジェクトを見てみましょう。例えば、他の Node モジュールではコントリビュートプロセスをどのようにしているでしょうか？他のプロジェクトと似たようなツールや方法を使うことで、ターゲットとするコントリビューターがコントリビュートプロセスに親しみやすくなります。

## 活動停止しても良い

オープンソース活動はかつては喜びをもたらしてくれました。しかし今となっては辞めたいと感じていたり、うしろめたい気持ちになっているかもしれません。

おそらく、あなたは困惑しているか、プロジェクトについて考えるのが怖いと感じているかもしれません。その間にも、イシューやプルリクエストは積み上がっていくのです。

オープンソース活動において、燃え尽きてしまうことは特にメンテナーの間で現実に発生し、よく起きることなのです。メンテナーとしてあなた自身が幸福であることは、オープンソースプロジェクトが生き残る上で交渉の余地なく必要なことです。

言うまでもないことですが、休みを取りましょう！バケーションを取るのに、燃え尽きたと感じるまで待つ必要はないのです。 Python のコア開発者である @brettcannon は、14年間に及ぶ OSS ボランティア活動を経て、[1ヶ月の休みを取る](https://snarky.ca/why-i-took-october-off-from-oss-volunteering/)ことを決断しました。

他の仕事と同じように、休みを取ることでリフレッシュし、幸せを感じ、仕事に熱中できるのです。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielbachhuber?s=180" class="pquote-avatar" alt="avatar">
  WP-CLI をメンテナンスする中で、まずは自分自身を幸せにし、自分がどこまで関わるかの境界を明確にすることが必要であると気づきました。私が見つけた最も良いバランスは、私の通常の仕事時間の中で週に2 ~ 5時間を充てるというものです。このバランスで、私はプロジェクトに熱心に関わることができ、かつ仕事のようだと感じることもありません。取り掛かるイシューの優先順位付けをしているので、最も重要だと思うことで定期的に進捗を出すことができるのです。
  <p markdown="1" class="pquote-credit">
— @danielbachhuber, ["My condolences, you're now the maintainer of a popular open source project"](https://runcommand.io/2016/06/26/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/)
  </p>
</aside>

時には、皆があなたを必要としていると感じられて、オープンソース活動を休むのは難しいと感じることがあるかもしれません。あなたが退くことに対して、罪悪感を感じさせようとする人さえいるかもしれません。

プロジェクトから離れる間にユーザーやコミュニティをサポートしてくれる人を探すために最善を尽くしましょう。もし必要なサポートを見つけられなかったとしても、とにかく休みを取りましょう。不在のときはきちんとその旨を共有しましょう。そうすることで、あなたからの返答がないことで人々を困惑させることもありません。

休みを取ることはバケーションを取ることだけではありません。もし週末であったり、業務時間中にはオープンソース活動をやりたくないのであれば、他の人にその希望を共有しましょう。そうすることで、彼らはあなたを悩ませないようにしてくれるでしょう。

## まずはじめに自分を労ろう！

人気のあるプロジェクトをメンテナンスすることは、成長の初期ステージに必要なものとは異なるスキルが必要となります。しかし、それはなおも報われるものです。メンテナーとして、ごくわずかな人しか経験できないレベルのリーダーシップと個人スキルを実践することになります。常に簡単に対処できる訳ではありませんが、明確に線引をし、あなたが心地よく感じることだけを行うようにすることで、幸福でリフレッシュしていて、生産的な状態を維持する助けとなるのです。
