---
lang: id
title: Menemukan Pengguna untuk Proyek Anda
description: Membantu proyek open source Anda untuk berkembang dengan cara menyampaikannya ke pengguna yang senang dengan proyek Anda
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Menyebarkan kata

Tidak ada aturan yang menyebutkan bahwa Anda harus mempromosikan sebuah proyek open source ketika Anda merilisnya. Terdapat banyak alasan untuk bekerja pada open source yang tidak berkaitan dengan popularitas. Namun jika Anda berharap orang lain akan menemukan dan menggunakan proyek open source Anda, inilah saatnya untuk memberitahukan ke semua orang tentang hasil kerja keras Anda.

## Menentukan pesan Anda

Sebelum Anda memulai pekerjaan tentang mempromosikan proyek Anda, Anda harus bisa menjelaskan apa yang dilakukan oleh proyek Anda dan kenapa itu penting.

Apa yang membuat proyek Anda berbeda atau menarik? Mengapa Anda membuatnya? Menjawab pertanyaan-pertanyaan ini kepada diri sendiri akan membuat lebih mudah untuk bisa meyakinkan orang lain

Ingat bahwa orang-orang akan terlibat sebagai pengguna, dan kemudian kontributor, karena menyelesaikan sebuah masalah bagi mereka. Ketika Anda memikirkan tentang pesan dan nilai proyek Anda, cobalah untuk melihat dari sudut pandang apa yang _mereka_ inginkan.

Sebagai contoh, @robb menggunakan contoh kode program untuk menjelaskan kenapa proyeknya [Cartography](https://github.com/robb/Cartography), berguna:

![cartography readme](/assets/images/finding-users/cartography.jpg)

Untuk mendalami lebih dalam tentang penyampaian pesan, lihat panduan Mozilla ["Persona dan Jalur"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) untuk mengembangkan persona pengguna.

## Bantu orang lain menemukan dan mengikuti proyek Anda

<aside markdown="1" class="pquote">
  Idealnya Anda membutuhkan satu URL "awal" yang bisa Anda promosikan dan mengarahkan orang-orang sehubungan dengan proyek Anda. Anda tidak harus menggunakan template atau nama domain, tetapi proyek Anda membutuhkan sebuah titik fokus.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Bantu orang lain untuk mencari dan mengingat proyek Anda dengan mengarahkan mereka pada sebuah nama yang tunggal.

**Gunakan akun yang jelas untuk mempromosikan pekerjaan Anda.** Sebuah akun Twitter, URL GitHub, atau channel IRC merupakan cara mudah untuk menunjukkan kepada orang lain tentang proyek Anda. Akun-akun ini juga memberikan tempat untuk berdiskusi bagi komunitas proyek Anda yang senantiasa berkembang.

Jika Anda belum ingin membuat channel pada proyek Anda, promosikan akun Twitter atau GitHub pada segala pekerjaan Anda. Sebagai contoh, pastikan akun tersebut masuk pada biodata atau slide presentasi ketika Anda berbicara pada acara pertemuan. Dengan cara itu, orang lain tahu bagaimana menghubungi Anda atau mengikuti hasil pekerjaan Anda.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  Sebuah kesalahan yang saya lakukan di masa-masa awal (...) adalah dengan tidak membuat akun Twitter untuk proyek. Twitter merupakan cara yang baik untuk memberikan informasi terbaru kepada orang-orang sekaligus untuk menampilkan orang lain kepada proyek.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Pertimbangkan untuk membuat halaman web untuk proyek Anda.** Sebuah halaman web membuat proyek Anda terasa lebih bersahabat dan mudah untuk dieksplorasi, terutama jika dikombinasikan dengan dokumentasi dan tutorial yang jelas. Hal ini juga menjelaskan bahwa proyek Anda masih aktif, yang akan membuat pengguna Anda menjadi lebih nyaman dalam menggunakannya. Gunakan contoh untuk memberikan ide kepada orang lain tentang bagaimana menggunakan proyek Anda.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), co-creator dari Django, mengatakan bahwa halaman web merupakan _"salah satu hal terbaik yang kita lakukan dengan Django di masa-masa awal"_.

Jika proyek Anda berada di GitHub, Anda bisa menggunakan [GitHub Pages](https://pages.github.com/) untuk membuat halaman web dengan mudah. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), dan [Middleman](https://middlemanapp.com/) adalah [beberapa contoh](https://github.com/showcases/github-pages-examples) dari halaman web yang komprehensif.

![vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

Ketika Anda telah memiliki pesan untuk proyek Anda dan cara mudah bagi orang lain untuk menemukan proyek Anda, sekarang bicaralah ke pengguna Anda!

## Ketika pengguna proyek Anda (online)

Kegiatan outreach online merupakan cara yang bagus untuk berbagi dan menyebarkan informasi dengan cepat. Dengan menggunakan chanel online, Anda memiliki potensi untuk menjangkau jumlah pengguna yang sangat besar.

Ambil keuntungan dari komunitas dan platform online yang sudah ada untuk menjangkau pengguna Anda. Jika proyek open source Anda adalah proyek perangkat lunak, Anda mungkin bisa menjangkau proyek Anda melalui [Stack Overflow](https://stackoverflow.com/), [reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/), atau [Quora](https://www.quora.com/). Temukan chanel yang Anda pikir orang-orang akan mendapatkan keuntungan dari pekerjaan Anda.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Setiap program memiliki fungsi yang spesifik yang dianggap penting bagi sebagian kecil pengguna. Jangan melakukan spam kepada banyak orang. Tentukan target Anda pada komunitas yang mendapatkan keuntungan dengan mengetahui proyek Anda.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Amati jika Anda bisa menemukan cara untuk berbagi informasi tentang proyek Anda pada cara-cara yang relevan:

* **Berkenalan dengan proyek dan komunitas open source yang relevan.** Seringkali, Anda tidak harus secara langsung mempromosikan proyek Anda. Jika proyek Anda sesuai untuk pengolah data yang menggunakan Python, berkenalanlah dengan komunitas pengolah data Python. Dengan semakin banyak orang yang mengenal Anda, kesempatan akan hadir untuk membicarakan hasil pekerjaan Anda.
* **Temukan orang yang memiliki masalah yang diselesaikan dengan proyek Anda.** Cari melalui forum tentang orang-orang yang menjadi target pengguna proyek Anda. Jawab pertanyaan mereka dan carilah kesempatan untuk menawarkan proyek Anda sebagai solusinya.
* **Minta masukan.** Perkenalkan diri Anda dan pekerjaan Anda kepada pengguna yang relevan. Jelaskan secara spesifik tentang siapa saja yang Anda anggap akan mendapatkan keuntungan dari proyek Anda. Cobalah untuk mengakhiri kalimat : _"Saya pikir proyek saya akan sangat membantu X, yang sedang mencoba melakukan Y_". Dengarkan dan berikan respon terhadap masukan orang lain dibandingkan terus menerus mempromosikan hasil pekerjaan Anda.

Secara umum, berfokuslah pada membantu orang lain sebelum meminta. Karena sangatlah mudah bagi setiap orang untuk mempromosikan proyek, sehingga akan terjadi banyak suara-suara yang masuk. Berikan orang lain tentang konteks tentang diri Anda, bukan saja yang Anda inginkan agar Anda bisa berbeda dari yang lain.

Jika tidak ada yang menanggapi atau merespon, jangan kecewa! Rilis proyek awal biasanya merupakan proses yang bersifat iteratif yang bisa memakan waktu berbulan-bulan atau bahkan bertahun-tahun. Jika Anda tidak mendapatkan respon untuk pertama kali, cobalah taktik yang berbeda, atau cari cara lain untuk menambahkan nilai bagi hasil pekerjaan orang lain terlebih dahulu. Hal ini memerlukan waktu dan dedikasi.

## Ketika pengguna proyek Anda (offline)

![public speaking](/assets/images/finding-users/public_speaking.jpg)

Kegiatan _offline_ adalah cara yang populer untuk mempromosikan proyek baru. Kegiatan ini merupakan cara yang baik untuk menjangkau pengguna yang sibuk dan membangun koneksi yang lebih personal, terutama jika Anda tertarik untuk menjangkau para pengembang.

Jika Anda termasuk [awam pada komunikasi publik](https://speaking.io/), mulailah dengan mencari acara pertemuan lokal yang berhubungan dengan bahasa atau ekosistem dari proyek Anda.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  Saya cukup gugup ketika hendak menghadiri PyCon. Saya memberikan ceramah, hanya kenal beberapa orang, dan acara berlangsung selama satu minggu penuh. (...) Tetapi saya tidak perlu khawatir. PyCon sudah fenomenal! (...) Semua orang sangat ramah dan aktif, bahkan sangat jarang saya mendapati waktu tidak berbicara dengan orang-orang!
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Jika Anda belum pernah berbicara pada acara pertemuan sebelumnya, sangatlah normal untuk cemas! Ingatlah bahwa pengguna Anda hadir karena mereka dengan tulus hendak mendengarkan tentang pekerjaan Anda.

Ketika Anda mulai menuliskan presentasi Anda, fokus pada apa yang akan dianggap menarik oleh pengguna Anda. Gunakan bahasa yang ramah dan mudah dipahami. Senyum, ambil nafas, dan bersenang-senanglah.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  Ketika Anda mulai menuliskan isi presentasi Anda, tidak perduli topiknya, hal itu bisa membantu jika Anda melihatnya seperti menceritakan sebuah cerita kepada orang lain.
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Ketika Anda sudah merasa siap, pertimbangkan untuk berbicara pada level konferensi untuk mempromosikan proyek Anda. Acara konferensi bisa membantu Anda menjangkau lebih banyak orang, seringkali dari berbagai penjuru dunia.

Carilah konferensi yang sesuai dengan bahasa atau ekosistem Anda. Sebelum Anda mengumpulkan presentasi Anda, pelajari konferensi sebelumnya untuk menyesuaikan presentasi Anda dengan pengunjung dan meningkatkan peluang Anda untuk diterima. Anda seringkali bisa melihat pengunjung konferensi dengan melihat para pembicaranya.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  Saya menuliskan pada orang-orang JSConf dan meminta mereka untuk memberikan saya satu kesempatan dimana saya bisa mempresentasikannya pada JSConf EU. (...) Saya sangatlah takut, mempresentasikan sesuatu yang telah saya persiapkan selama enam bulan. (...) Selama acara saya hanya berpikir, ya Tuhan. Apa yang saya lakukan disini?
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Membangun sebuah reputasi

Selain strategi yang dijelaskan diatas, cara terbaik untuk mengundang orang lain untuk berbagi dan berkontribusi pada proyek Anda adalah untuk berbagi dan berkontribusi pada proyek mereka.

Membantu pengguna baru, berbagai sumber daya, dan membuat kontribusi yang berguna pada pekerjaan orang lain akan membantu Anda membangun reputasi yang positif. Lalu orang-orang tersebut akan memiliki konteks untuk pekerjaan Anda dan akan lebih memperhatikan dan mempromosikan apa yang Anda kerjakan.

Seringkali, hubungan ini bisa mengarah pada hubungan yang resmi dengan ekosistem yang lebih luas.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  Satu-satunya alasan kenapa urllib3 adalah pustaka Python pihak ketiga yang paling terkenal adalah karena merupakan bagian dari requests.
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Tidak pernah terlalu cepat, atau terlambat untuk membangun reputasi Anda. Meskipun Anda baru saja merilis proyek Anda, selalu carilah cara untuk membantu orang lain.

Tidak ada solusi cepat untuk membangun pengguna. Mendapatkan kepercayaan dan penghargaan membutuhkan waktu, dan proses membangun reputasi tidak pernah selesai.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ariya?s=180" class="pquote-avatar" alt="avatar">
  PhantomJS dirilis pertama kalinya di awal 2011. (...) Saya menyebarkan dengan cara yang sederhana: Saya menuliskan tweet, saya menuliskan di blog tentang apa yang bisa Anda lakukan, saya menjelaskannya pada berbagai acara pertemuan. Ketika proyek ini mulai dikenal pada 2014, Saya mulai memberikan presentasi tentang proyek ini.
  <p markdown="1" class="pquote-credit">
— @ariya, ["Maintainer Stories"](https://github.com/open-source/stories/ariya)
  </p>
</aside>

## Teruslah Berjuang!

Seringkali membutuhkan waktu yang sangat lama sebelum orang lain mulai memperhatikan proyek open source Anda. Tidak masalah! Sebagian dari proyek open source yang terkenal saat ini membutuhkan waktu bertahun-tahun untuk mencapai aktivitas yang tinggi seperti saat ini. Fokus pada membangun relasi dibandingkan mencari jalan pintas.Bersabarlah dan terus berbagi pekerjaan Anda dengan mereka yang menghargainya.
