---
lang: hu
title: A projekt felhasználók megtalálása
description: Segítsd a projekted fejlődését azzal, hogy elégedett felhasználókat találsz.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Az ige terjesztése

Nincs olyan szabály, ami kimondja, hogy egy nyílt forráskódú projektet ismertté kell tenni az induláskor. Számos valós ok lehet arra, hogy olyan nyílt forráskódú munkát végezz, amelynek semmi köze a népszerűséghez. Ahelyett, hogy abban reménykednél, hogy mások majd megtalálják és felhasználják a nyílt forráskódú projektedet, kezdd el megismertetni a világot a kemény munkád eredményével!

## Fogalmazd meg az üzenetet

Mielőtt elindítanád a projekted népszerűsítési munkáját, meg kell tudnod fogalmazni, hogy az mit csinál, és miért fontos.

Mitől más, mint a többi, vagy miért különleges a projekt? Miért hoztad létre? Ha megválaszolod ezeket a kérdéseket, segít kommunikálni a projekt lényegét.

Ne feledd, hogy az emberek először _felhasználóként_ vesznek részt, majd idővel _résztvevőkké_ válnak, mert a projekt megold számukra egy problémát. Amikor a projekt üzenetéről és értékéről gondolkodsz, próbáld objektíven, a _felhasználók és résztvevők_ szemszögéből nézni ezeket.

Például, @robb példa programkódokat használt a projektje népszerűsítésére, [Cartography](https://github.com/robb/Cartography), hogy bizonyítsa mennyire hasznos:

![Cartography README](/assets/images/finding-users/cartography.jpg)

Kicsit mélyebb üzenetért, nézd meg a Mozilla ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) felhasználói személyiség fejlesztéséről szóló útmutatóját.

## Segítsd az embereket abban, hogy megtalálják és kövessék a projektedet

<aside markdown="1" class="pquote">
  Ideális esetben egyetlen URL-címre van szükség, amelyet a projekthez kapcsolódóan népszerűsíthetsz és ahová az embereket irányíthatod. Nem kell egy kifinomult weboldal de még domain név sem, ugyanakkor a projektnek szüksége van egy központi helyre.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Segíts az embereknek megjegyezni a projektedet azáltal, hogy egyetlen pontra, helyre irányítod őket.

**Legyen egyértelmű, hogy hol népszerűsíted a munkád.** Ez lehet Twitter vagy IRC csatorna, vagy GitHub URL, amely könnyen elérhető mindenkinek. Ezek a helyek a projekt növekvő közösségének is helyet biztosítanak.

Ha még nem szeretnél projekthez köthető kommunikációs csatornákat kiépíteni, akkor a saját Twitter vagy GitHub helyeiden is meg tudod azt tenni. A Twitter vagy GitHub azonosító alapján a felhasználók tudni fogják hogyan érjenek el téged és a projektet. Ha eseményen vagy szakmai találkozókon adsz elő, akkor bizonyosodj meg róla, hogy ezeket a elérhetőségeket feltüntetted az előadásodban. 

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  Akkoriban vétettem egy hibát azzal, hogy nem indítottam Twitter csatornát a projektnek. A Twitter nagyszerű hely arra, hogy az emberek megismerjék a projektet és naprakész információjuk legyen a változásokról, eseményekről.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Fontold meg webhely létrehozását a projektedhez.** A weboldal barátságosabbá teszi a projektet és könnyebbé teszi a keresést, főleg ha ez áttekinthető dokumentációval és útmutatókkal párosul. Egy weboldal azt sugallja, hogy a projekt aktív, így az emberek bátrabban fogják használni. Mutass példákat arra, hogy a felhasználók hogyan tudják használni a munkádat.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), a Django társalapítója mondta egyszer a weboldalról, hogy _"messze a legjobb dolog volt, amit csinálhattunk a Django indulásakor"_.

Ha a projekted a GitHub-on van, akkor használhatod a [GitHub Pages](https://pages.github.com/) funkciót arra, hogy a weboldalt könnyedén létrehozd. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), és [Middleman](https://middlemanapp.com/) [és még számos példa](https://github.com/showcases/github-pages-examples) a nagyszerű, áttekinthető weboldalakra.

![Vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

Most, hogy van a projektednek üzenete és van egy könnyű módja annak, hogy az emberek megtalálják a projektedet, vágjunk bele, és beszéljünk az emberekkel.

## Ott kell lenni, ahol a hallgatóság van (online)

Az online tájékoztatás nagyszerű módja annak, hogy gyorsan megoszthasd és terjeszd az információt. Az online csatornák használatával lehetőséged van nagyon széles közönség elérésére.

Használd ki a meglévő online közösségeket és platformokat, hogy elérd a saját közönségedet. Ha a nyílt forráskódú projekted szoftver projekt, akkor közönségedet megtalálhatod a [StackOverflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/), vagy [Quora](https://www.quora.com/) oldalakon. Találd meg azokat a csatornákat, ahol olyan emberek vannak, akik a legtöbbet profitálhatnak a munkádból, vagy a leginkább kíváncsiak lehetnek rá.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Minden programnak vannak olyan speciális funkciói, amelyet a felhasználóknak csak egy része talál hasznosnak. Nem kell minden embert elérni, akiket nem érdekel ez. Inkább célozz meg olyan közösségeket, amelyeknek előnyére válik a te projekted.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Nézzük, hogyan lehet megtalálni a lényeges helyeket, ahol megoszthatod a projekted:

* **Ismerd meg a kapcsolódó nyílt forráskódú projekteket és közösségeket.** Néha nem kell közvetlenül hirdetni a projekted. Ha a projekt tökéletes a Python-t használó adathalmaz kutatók számára, ismerkedj meg a Python adatkutató közösséggel. Amint az emberek megismernek, természetes lehetőség adódik a beszélgetésre és arra, hogy megoszd velük a munkád eredményét.
* **Találd meg azokat az embereket, akiknek a problémájára megoldást kínál a projekted.** Nézd át a kapcsolódó fórumokat, hogy megtaláld azokat az embereket, akik a projekted közönségét alkothatják. Válaszold meg a kérdéseiket és ha lehetséges, tapintatosan ajánld fel a projektedet megoldásként.
* **Kérj visszajelzést.** Mutasd be magadat és a munkádat egy olyan közösségnek, amelyik érdekesnek találhatja azt. Legyél konkrét abban, hogy szerinted kinek hasznos a projekted. Próbáld így befejezni a mondatod: _"Úgy gondolom, hogy a projektem tényleg nagyon hasznos X csoportnak, akik az Y problémát akarják megoldani_". Hallgasd meg és válaszolj mások észrevételére, ne csak bemutató előadás legyen a projektedről.

Általánosságban: fókuszálj mások megsegítésére mielőtt bármit is kérsz. Mivel bárki képes online egy projektet bemutatni, ezért sok lesz a zaj. Ahhoz, hogy kitűnj a tömegből, az embereknek meg kell érteniük, hogy ki is vagy és nem csak azt, hogy mit akarsz.

Ha senki sem figyel fel vagy válaszol az első kísérletedre, ne add fel! A legtöbb projekt iteratív folyamat, amely hónapokig vagy akár évekig tart. Ha elsőre nem kapsz visszajelzést, akkor próbálj más taktikát vagy keress olyan lehetőséget, hogy mások munkájához hozzájárulj valami hasznossal. A projekt hírének megalapozása és elindítása időt és kitartást igényel.

## Ott kell lenni, ahol a hallgatóság van (off-line)

![Előadás](/assets/images/finding-users/public_speaking.jpg)

A projektek népszerűsítésének gyakori módja, ha egy off-line eseményen mutatod be őket. Ez nagyszerű módja annak, hogy elérjed az elkötelezett közönséget, és mélyebb emberi kapcsolatokat építs ki különösen, ha érdekelt vagy a fejlesztők elérésében.

Ha teljesen [új vagy az előadásban](https://speaking.io/), keress egy helyi szakmai találkozót (meetup) amely kapcsolódik a projekted témájához vagy programnyelvéhez.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  Nagyon feszült voltam, amikor a PyCon rendezvényre készültem. Előadást kellett tartanom, miközben alig ismertem ott pár embert, és ezt egy egész héten keresztül. (...) Nem kellett volna aggódnom. A PyCon fantasztikus volt! (...) Mindenki hihetetlenül barátságos és nyitott volt, annyira, hogy ritkán találtam időt arra, hogy ne beszélgessek az emberekkel!
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Ha még soha nem beszéltél egy eseményen, teljesen normális, hogy feszültnek érzed magad. Ne feledd, hogy a közönség azért van ott, mert valóban szeretne hallani a munkádról.

A beszéd írásakor összpontosíts arra, amit szerinted a közönség érdekesnek talál és mutasd meg az értéket a munkádban. Barátságos, elfogadható nyelvezetet használj. Mosolyogj, lélegezz és érezd jól magad!

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  Amikor az előadásodat készíted, segíthet – függetlenül a témától –, ha úgy tekintesz rá, mint egy történetre, amit elmesélsz a hallgatóságnak.
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Amikor késznek érzed magad, gondolkozz el, hogy hol, milyen konferenciákon tudnád bemutatni a projektedet. A konferenciák segítenek abban, hogy több embert elérj, gyakran a világ minden részéről.

Keress olyan konferenciát, amely erősen kapcsolódik a te fejlesztési nyelvedhez, ökoszisztémádhoz. Mielőtt az előadásoddal jelentkezel, nézz utána a konferenciának, és szabd kicsit hozzá az előadásodat, ezzel növelve az esélyét, hogy elfogadják az anyagodat. Gyakran a többi előadó alapján is fel tudod mérni, hogy milyen az adott konferencia közönsége.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  Nagyon kedves levelet írtam a JSConf szervezőknek, amelyben könyörögtem nekik, hogy adjanak nekem egy lehetőséget, hogy előadhassak a JSConf EU-n. (...) Nagyon rémült voltam előadni azt, amin 6 hónapig dolgoztam. (...) Egész idő alatt csak arra gondoltam, "Ó Istenem, mit keresek én itt?"
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Alapozd meg a hírnevet

A fent vázolt stratégiák mellett a legjobb módja annak, hogy részvételre buzdítsd az embereket a projektedre az, hogy te is részt veszel az ő projektjeikben.

Új résztvevők segítése, információ megosztása és átgondolt részvétel mások projektjeiben segít, hogy pozitív kép alakuljon ki rólad. Aktív nyílt forráskódú közösségi tagként az emberek felfigyelnek rád és könnyebben befogadják a projektedet. A más projektekkel kialakított kapcsolat akár hivatalos partnerséghez is vezethet.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  Az egyetlen oka annak, hogy az urllib3 a legnépszerűbb független Python csomag ma az, hogy a requests csomag részévé vált.
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Soha sincs túl késő vagy túl korán a hírnév építéséhez. Még ha el is indítottad a saját projektedet, folyamatosan keresd a lehetőséget arra, hogy másoknak segíts.

Nem létezik olyan módszer, amivel hirtelen közönséget és hírnevet tudsz szerezni. A bizalom és tisztelet megszerzéséhez idő kell, és a hírnév építése sohasem érhet véget.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ariya?s=180" class="pquote-avatar" alt="avatar">
  A PhantomJS 2011 elején jelent meg először. (...) A hírét a szokásos módon terjesztettem: Twitter-en írtam róla, írtam Blog-ot arról hogyan és mire jó, és számos szakmai összejövetelen beszélgettem róla. 2014-re, mikorra ismertté vált, elkezdtem önálló előadásokat is tartani.
  <p markdown="1" class="pquote-credit">
— @ariya, ["Maintainer Stories"](https://github.com/open-source/stories/ariya)
  </p>
</aside>

## Tarts ki!

Lehet, hogy sokáig fog tartani, mire az emberek felfigyelnek a projektedre, de ezzel nincs semmi probléma! Számos olyan projektnek, amely ma a leghíresebbek között van, évekig tartott, mire elérte a jelenlegi ismertségét és aktivitását. A lényeg a kapcsolatépítésen legyen, ne abban reménykedj, hogy egyszer magától fog növekedni a hírneve. Légy türelmes, és működj együtt azokkal, akik értékelik a munkádat.
