---
lang: es
title: Construyendo Comunidades de Bienvenida
description: Construyendo una comunidad que anime a al gente a usar, contribuir y educar con su proyecto
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Configurando tu proyecto para el &eacute;xito

Acabas de lanzar tu proyecto, est&aacute;s pasando la voz, y la gente lo est&aacute; siguiendo. ¡Genial! Ahora, ¿c&oacute;mo haces que se queden?

Una comunidad de bienvenida es una inversi&oacute;n a futuro a tu proyecto y a tu reputaci&oacute;n. Si tu proyecto est&aacute; reci&eacute;n comenzando a ver sus primeras contribuciones, comienza por dar a los primeros colaboradores una experiencia positiva, y facil&iacute;tales continuar regresando.

### Haz que la gente se sienta bienvenida

Una manera de pensar acerca de la comunidad del proyecto es a trav&eacute;s de lo que @MikeMcQuaid llama [contributor funnel](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/):

![contributor funnel](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

A medida que construyes tu comunidad, considera c&oacute;mo &aacute;lguien que se encuentra en la parte superior del embudo (un usuario potencial) puede te&oacute;ricamente hacer su camino hacia abajo (un mantenedor activo). Tu objetivo es reducir la fricci&oacute;n en cada etapa de la experiencia del colaborador. Cuando las personas  obtienen victorias f&aacute;ciles, se sentir&aacute;n incentivadas a hacer m&aacute;s.

Comienza con tu documentaci&oacute;n:

* **Hazlo sencillo para quienes tienen que utilizar el proyecto.** [Un documento README amigable](../starting-a-project/#escribiendo-un-readme) y c&oacute;digos de ejemplo claros har&aacute;n m&aacute;s f&aacute;cil el comienzo para cualquiera que aterrice en tu proyecto.
* **Explica claramente c&oacute;mo contribuir**, utilizando [un archivo CONTRIBUTING](../starting-a-project/#escribiendo-las-pautas-para-contribuir) y manteniendo tus problemas al d&iacute;a.

Una buena documentaci&oacute;n invita a las personas a interactuar con tu proyecto. Eventualmente, &aacute;lguien abrir&aacute; un problema o un pull request.

* **¡Cuando &aacute;lguien nuevo aterrice en tu proyecto, agrad&eacute;cele por su inter&eacute;s!** Es suficiente una sola experiencia negativa para que &aacute;lguien no quiera regresar.
* **Comp&oacute;rtate de manera sensible.** Si no respondes a sus problemas por un mes, lo m&aacute;s probable es que ya se hayan olvidado de tu proyecto.
* **Tener la mente abierta acerca de los tipos de contribuciones que aceptar&aacute;.** Muchos colaboradores comienzan reportando un error o con un arreglo peque&ntilde;o. Hay [muchas maneras de contribuir](../how-to-contribute/#qué-significa-contribuir) con un proyecto. Permite que las personas ayuden de la manera que ellos quieran ayudar.
* **Si existe alguna contribuci&oacute;n con la que est&aacute;s en desacuerdo,** agrad&eacute;cele por su idea y [expl&iacute;cale porqu&eacute;](../best-practices/#aprendiendo-a-decir-no) no encaja en la incumbencia del proyecto, enlazando con documentaci&oacute;n relevante si la tienes.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  Contribuir con c&oacute;digo abierto es m&aacute;s f&aacute;cil para algunos que para otros. Hay mucho miedo de recibir un alarido por no haber hecho algo bien o simplemente por no encajar. (...) Al dar a los colaboradores un lugar para contribuir con aspectos de muy baja competencia t&eacute;cnica (documentaci&oacute;n, reducci&oacute;n del contenido web, etc) puedes ayudar a reducir esas preocupaciones significat&iacute;vamente.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Growing a contributor base in modern open source"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

La mayor&iacute;a de los colaboradores con el c&oacute;digo abierto son "colaboradores casuales": personas que contribuyen con un proyecto solo ocasionalmente. Un colaborador casual probablemente no disponga del tiempo para dedicarse a tiempo completo a tu proyecto, por lo que tu trabajo es el de hacer que sea m&aacute;s sencillo para ellos contribuir.

Animar a otros colaboradores es tambi&eacute;n invertir en t&iacute; mismo . Cuando brinda poder a sus m&aacute;s grandes seguidores paraa continuar con el trabajo que los mantiene entusiasmados, hay menos presi&oacute;n que si lo hicieras tu mismo.

### Documenta todo

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  ¿Alguna vez viste un evento (t&eacute;cnico) en donde no conozcas a nadie, pero todos los dem&aacute;s parece que se encuentran en grupos y conversan como viejos amigos? (...) Ahora imag&iacute;nate queriendo contribuir con un proyecto de c&oacute;digo abierto, pero no distingues porqu&eacute; o c&oacute;mo esto est&aacute; sucediendo.
  <p markdown="1" class="pquote-credit">
— @janl, ["C&oacute;digo abierto sostenible"](https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Cuando comienzas un proyecto, mantener tu trabajo en privado puede sentirse natural. Pero los proyectos de c&oacute;digo abierto avanzan mucho m&aacute;s cuando procesas tu documento en p&uacute;blico.

Cuando escribes las cosas, m&aacute;s personas pueden participar en cada paso del camino. Puedes necesitar ayuda o algo que todav&iacute;a no sabes que necesitas.

Escribir las cosas significa mucho m&aacute;s que documentaci&oacute;n t&eacute;cnica. Cada vez que sientas la necesidad de escribir algo o de discutir tu proyecto de manera privada, preg&uacute;ntate si puedes hacerlo p&uacute;blicamente.

Mantente transparente acerca de la hoja de ruta de tu proyecto, los tipos de contribuciones que est&aacute;s buscando, c&oacute;mo se revisa el trabajo de quienes contribuyan o porqu&eacute; tomas determinadas decisiones.

Si ves que varios usuarios est&aacute;n trabajando en el mismo problema, documenta sus respuestas en el README.

Para las reuniones, considera publicar tus notas o carteles en un asunto relevante. La retroalimentaci&oacute;n que obtendr&aacute;s de este nivel de transparencia te sorprender&aacute;

Documentar todo tambi&eacute;n se aplica al trabajo que tu haces. Si est&aacute;s trabajando en una actualizaci&oacute;n sustancial de tu proyecto, ponlo en un pull request y m&aacute;rcalo como trabajo en proceso (WIP, work in progress por sus siglas en ingl&eacute;s). De esa manera, otras personas se pueden sentir involucradas en el proceso desde temprano

### Comp&oacute;rtate de manera sensible

A medida que [promocionas tu proyecto](../finding-users),las personas te har&aacute;n llegar sus comentarios. Pueden tener preguntas acerca de c&oacute;mo funcionan las cosas, o necesitar ayuda para comenzar

Trata de responder cuando &aacute;lguien presenta un problema, env&iacute;a un pull request o realiza una pregunta acerca de tu proyecto. Cuando respondes r&aacute;pidamente, logras que las personas se sientan parte del di&aacute;logo, y estar&aacute;n m&aacute;s entusiasmadas de participar.

Incluso si no puedes revisar su solicitud inmediatamente, con solo agradecer su temprana ayuda incrementar&aacute; su compromiso. As&iacute; es como @tdreyno respondi&oacute; a un pull request en [Middleman](https://github.com/middleman/middleman/pull/1466):

![middleman pull request](/assets/images/building-community/middleman_pr.png)

Un [estudio de Mozilla](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) encontr&oacute; que los colaboradores que reciben una revisi&oacute;n de su c&oacute;digo dentro de las 48 horas tienen una significativa mayor tasa de retornar y de repetir alguna contribuci&oacute;n.

Las conversaciones acerca de tu proyecto pueden tambi&eacute;n ocurrir en otros lugares a lo largo de la internet, como en Stack Overflow, Twitter o reddit. Puedes configurar tus notificaciones en cualquiera de esos tres lugares de manera de ser alertado cuando &aacute;lguien mencione tu proyecto.

### Brinda a tu comunidad un lugar para congregarse

Existen dos razones para brindar a tu comunidad un lugar para congregarse.

La primera raz&oacute;n es para ellos. Ayuda a las personas a conocerse. Las personas con intereses comunes querr&aacute;n inevitablemente  un lugar para hablar de ello. Y cuando la comunicaci&oacute;n es p&uacute;blica y accesible, cualquiera puede leer los archivos pasados para ponerse al d&iacute;a y participar.

La segunda raz&oacute;n es para t&iacute;. Si no brindas a las personas un lugar p&uacute;blico para conversar acerca de tu proyecto, probablemente te contactar&aacute;n directamente. Al comienzo puede no parecer demasiado responder a mensajes privados "s&oacute;lo por &eacute;sta vez". Pero con el tiempo, especialmente si tu proyecto se hace conocido, te sentir&aacute;s agotado. Evita la tentaci&oacute;n de comunicarte con las personas acerca de tu proyecto en privado. En su lugar, dir&iacute;gelos al canal p&uacute;blico designado.

La comunicaci&oacute;n p&uacute;blica puede ser tan simple como dirigir a las personas a abrir un tema en lugar de enviarle un correo electr&oacute;nico a usted directamente o comentar en su blog. Podr&iacute;as incluso configurar una lista de correos electr&oacute;nicos, o crear una cuenta en Twitter, Slack o un canal IRC para que las personas puedan comentar sobre tu proyecto. ¡O prueba todo lo anterior!

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) tiene tiempo reservado de las horas de oficina para ayudar a los miembros de la comunidad cada dos semanas :

> Kops tambi&eacute;n tiene tiempo reservado cada dos semanas para ofrecer ayuda y gu&iacute;a a la comunidad. Los mantenedores de Kops han acordado reservar tiempo dedicado espec&iacute;ficamente a trabajar con los reci&eacute;n llegados, ayudando con PRs y discutiendo nuevas caracter&iacute;sticas.

Las excepciones notables a la comunicaci&oacute;n p&uacute;blica son: 1) cuestiones de seguridad y 2) infracciones sensibles al c&oacute;digo de conducta. Siempre deber&iacute;as encontrar la manera para que las personas reporten estos aspectos de manera privada. Si no quieres utilizar tu correo electr&oacute;nico privado, configura una cuenta de correo electr&oacute;nico dedicada.

## Haciendo crecer tu comunidad

Las comunidades son extremadamente poderosas. Ese poder puede ser una bendici&oacute;n o una maldici&oacute;ni, dependiendo de c&oacute;mo lo maneje. A medida que la comunidad de tu proyecto crece, existen maneras para ayudar a que se convierta en una fuerza de construcci&oacute;n, no de destrucci&oacute;n.

### No toleres a los malos actores

Cualquier proyecto popular inevitablemente atraer&aacute; a personas que perjudican a tu comunidad, en lugar de ayudarla. Pueden comenzar discusiones innecesarias, discutir sobre rasgos triviales o burlarse de otros.

Haz todo lo posible para adoptar una pol&iacute;tica de tolerancia cero hacia este tipo de personas. Si no se controla, las personas negativas har&aacute;n que otras personas de tu comunidad se sientan inc&oacute;modas. Incluso pueden irse.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  La verdad es que tener una comunidad de apoyo es clave. Nunca hubiera sido capaz de realizar este trabajo sin la ayuda de mis colegas, los extra&ntilde;os de internet que fueron amigables y los canales IRC de conversaci&oacute;n. (...) No te conformes con menos. No te conformes con los idiotas.
  <p markdown="1" class="pquote-credit">
— @okdistribute, ["How to Run a FOSS Project"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Los debates regulares sobre aspectos triviales de tu proyecto distrae a otros, incluy&eacute;ndote tambi&eacute;n a t&iacute;, de enfocarte en tareas importantes. Las nuevas personas que llegan a tu proyecto pueden ver estas conversaciones y pueden &oacute; no querer participar.

Cuando ves que ocurrre alg&uacute;n comportamiento negativo, haz la observaci&oacute;n correspondiente de manera p&uacute;blica. Expl&iacute;cale, en un tono amable, porqu&eacute; dicho comportamiento no es aceptable. Si el problema persiste, puedes necesitar [solicitarle que se retire](../code-of-conduct/#aplicando-tu-código-de-conducta). Tu [c&oacute;digo de conducta](../code-of-conduct/) puede ser una gu&iacute;a constructiva para estas conversaciones.

### Re&uacute;nete con los colaboradores donde ellos est&aacute;n

La buena documentaci&oacute;n solo se vuelve importante a medida que tu comunidad crece. Los colaboradores casuales, quienes no estar&iacute;an familiarizados con tu proyecto de otra manera, leen tu documentaci&oacute;n para entender r&aacute;pidamente el contexto de lo que necesitas.

En tu archivo CONTRIBUTING, indica de manera expl&iacute;cita a los nuevos colaboradores c&oacute;mo pueden comenzar. Tal vez quieras dedicar incluso una secci&oacute;n para tal prop&oacute;sito. [Django](https://github.com/django/django), por ejemplo, tiene una p&aacute;gina especial para dar la bienvenida a los nuevos colaboradores.

![django new contributors page](/assets/images/building-community/django_new_contributors.png)

En tu cola de asuntos, etiqueta errores que son convenientes para diferentes tipos de colaboradores: por ejemplo, [_"solo principiantes"_](https://kentcdodds.com/blog/first-timers-only), "conveniente para quienes resuelven su primer bug", o "documentaci&oacute;n". [Estas etiquetas](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) hacen que sea m&aacute;s f&aacute;cil buscar problemas a resolver para alguien nuevo en el proyecto y as&iacute; poder comenzar.

Finalmente, utiliza tu documentaci&oacute;n para hacer que las personas se sientan bienvenidas en cada etapa del camino.

Nunca vas a interactuar con la mayor&iacute;a de las personas que se acercan a tu proyecto. Puede haber colaboradores que no recibiste porque &aacute;lguien se sinti&oacute; intimidado o no supo c&oacute;mo comenzar. Incluso algunas palabras amables pueden evitar que esas personas abandonen tu proyecto por verse frustradas

Por ejemplo, as&iacute; es como [Rubinius](https://github.com/rubinius/rubinius/) comienza su  [gu&iacute;a de contribuciones](https://github.com/rubinius/rubinius/blob/master/.github/contributing.md):/

> Queremos comenzar agradeciendo por utilizar Rubinius. Este proyecto es un trabajo de amor, y apreciamos a todos los usuarios que detectan errores, hacen mejoras al rendimiento, y ayudan con su documentaci&oacute;n. Cada contribuci&oacute;n es significativa, as&iacute; que gracias por participar. Dicho esto, aqu&iacute; dejamos algunas pautas que pedimos que sigan para que podamos abordar con &eacute;xito su problema.

### Comparte la propiedad de tu proyecto

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
 Los l&iacute;deres tendr&aacute;n diferentes opiniones, como deber&iacute;a ocurrir en todas las comunidades saludables. De todos modos, necesitas tomar algunas medidas para asegurar que las voces m&aacute;s potentes no ganen siempre por haber cansado a los dem&aacute;s, y que tambi&eacute;n se escuchen las voces menos potentes y minoritarias.

  <p markdown="1" class="pquote-credit">
— @sagesharp, ["What makes a good community?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Las personas se entusiasman por contribuir con proyectos cuando perciben un sentido de pertenencia. Eso no significa que tengas que cambiar la visi&oacute;n de tu proyecto o aceptar contribuciones que no quieres. Pero cuanto m&aacute;s cr&eacute;dito les des a los otros, m&aacute;s se quedar&aacute;n.

Observa si puedes encontrar maneras de compartir la propiedad de tu comunidad tanto como te sea posible. Aqu&iacute; hay algunas ideas:

* **Evita corregir errores sencillos (no cr&iacute;ticos).** En su lugar, utilizalos como oportunidades para reclutar nuevos colaboradores, o mentorear a &aacute;lguien que quiere contribuir. Puede parecer antinatural al principio, pero tu inversi&oacute;n se ver&aacute; compensada en el tiempo. Por ejemplo,  @michaeljoseph le pidi&oacute; a un colaborador que enviara un pull request de un problema detallado a continuaci&oacute;n [Cookiecutter](https://github.com/audreyr/cookiecutter) en lugar de arreglarlo &eacute;l mismo.

![cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Inicia un archivo de COLABORADORES o AUTORES en tu proyecto** que liste a todos los que colaboraron con tu proyecto, como lo hace [Sinatra](https://github.com/sinatra/sinatra/blob/master/AUTHORS.md).

* Si tienes una comunidad considerable, **env&iacute;a un bolet&iacute;n o escribe un post en un blog** agradeciendo a los colaboradores. Rust's [This Week in Rust](https://this-week-in-rust.org/) y Hoodie's [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) son dos buenos ejemplos.

* **Da a cada colaborador permiso para hacer commit.** @felixge encontr&oacute; con esto que las personas [se entusiasmaran por pulir sus parches](https://felixge.de/2013/03/11/the-pull-request-hack.html), e incluso encontr&oacute; nuevas personas para mantener proyectos en los que no hab&iacute;a trabajado hace tiempo.


* Si tu proyecto est&aacute; alojado en GitHub, **mueve tu proyecto desde tu cuenta personal hacia una [Organizaci&oacute;n](https://help.github.com/articles/creating-a-new-organization-account/)** y agrega al menos un administrador de respaldo. Las Organizaciones hacen que sea m&aacute;s f&aacute;cil trabajar en proyectos con colaboradores externos.

La realidad es que [la mayor&iacute;a de los proyectos solo tienen](https://peerj.com/preprints/1233.pdf) una o dos personas que lo mantengan y que hacen la mayor&iacute;a del trabajo. Mientras m&aacute;s grande sea tu proyecto, y mientras m&aacute;s grande sea tu comunidad, m&aacute;s f&aacute;cil es encontrar ayuda.

Aunque no siempre encuentres quien responda tu pedido, poner una se&ntilde;al por fuera incrementa las probabilidades de que otras personas se presenten. Y mientras m&aacute;s temprano comiences, m&aacute;s pronto las personas podr&aacute;n ayudar.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  \[Est&aacute; entre\] tus mayores intereses se encuentra reclutar colaboradores que disfruten y que sean capaces de hacer las cosas que tu no puedes. ¿Te gusta escribir c&oacute;digo, pero no responder a los problemas? Entonces identifica aquellos individuos en tu comunidad que lo hacen y permiteles hacer lo suyo.

  <p markdown="1" class="pquote-credit">
— @gr2m, ["Welcoming Communities"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Resolviendo conflictos

En las primeras etapas de tu proyecto, es bastante f&aacute;cil tomar decisiones importantes. Cuando quieres hacer algo, simplemente lo haces.

A medida que tu proyecto se hace m&aacute;s conocido, m&aacute;s personas tendr&aacute;n inter&eacute;s en las decisiones que tomes. Incluso si no tienes una gran comunidad de colaboradores, si tu proyecto tiene muchos usuarios, encontrar&aacute;s personas que pesan en las decisiones o plantean cuestiones propias.

En su mayor parte, si has cultivado una comunidad amistosa y que se maneja con respeto y has documentado tu proceso de manera abierta, tu propia comunidad deber&iacute;a tener la habilidad para encontrar una soluci&oacute;n. Pero algunas veces te encontrar&aacute;s con problemas un poco m&aacute;s dif&iacute;ciles de abordar.

### Fijando la vara para la amabilidad

Cuando tu comunidad se encuentre lidiando con una cuesti&oacute;n dif&iacute;cil, los &aacute;nimos pueden subir. Las personas pueden enojarse o verse frustradas y tomar las cr&iacute;ticas como algo personal, incluso provenientes de t&iacute;.

Tu trabajo como encargado es evitar que estas situaciones escalen. Incluso si tienes una fuerte opini&oacute;n sobre un tema, trata de mantener una posici&oacute;n de moderador o de facilitador, en lugar de ir a la lucha y empujar tus propios puntos de vista. Si &aacute;lguien est&aacute; comport&aacute;ndose de manera poco educada o monopolizando la conversaci&oacute;n, [act&uacute;a inmediatamente](../building-community/#no-toleres-a-los-malos-actores) para mantener una discusi&oacute;n civilizada y productiva.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  Como responsable de un proyecto, es extremadamente importante ser respetuoso con los colaboradores. A menudo toman lo que les dices de manera personal.
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Be Cordial or Be on Your Way"](https://www.kennethreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

Otras personas te mirar&aacute;n como un gu&iacute;a. Da un buen ejemplo. Todav&iacute;a puedes expresar desacuerdo, tristeza o preocupaci&oacute;n, pero de manera calmada.

Mantener la calma no es f&aacute;cil, pero demostrar liderazgo mejora la salud de tu comunidad. Internet te agradece.

### Trata a tu README como una constituci&oacute;n

Tu README es [m&aacute;s que un conjunto de instrucciones](../starting-a-project/#escribiendo-un-readme). Tambi&eacute;n es un lugar para hablar acerca de tus objetivos, visi&oacute;n del producto, y un mapa de ruta. Si las personas est&aacute;n muy centradas en debatir el m&eacute;rito de un aspecto en particular, puede revisar el README y conversar de una visi&oacute;n m&aacute;s alta de tu proyecto. Centrarse en el README tambi&eacute;n despersonaliza la conversaci&oacute;n, para tener una discusi&oacute;n m&aacute;s constructiva.

### Enf&oacute;cate en el viaje, no en el destino

Algunos proyectos utilizan un proceso de votaci&oacute;n para tomar decisiones importantes. Si bien parece sensato a primera vista, la votaci&oacute;n pone hincapi&eacute; en una "respuesta", m&aacute;s que en escuchar y tratar las preocupaciones de cada uno.

La votaci&oacute;n se puede volver pol&iacute;tica, cuando los miembros de la comunidad se sienten presionados para hacerse favores entre ellos o a votar de determinada manera. No todos votan, si existe una [mayor&iacute;a silenciosa](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) en tu comunidad, o existen usuarios que no se enteraron que se estaba llevando a cabo una votaci&oacute;n.

Algunas veces, la votaci&oacute;n se vuelve un desempate necesario. La mayoría de las veces, sin embargo, pone &eacute;nfasis en la ["b&uacute;squeda de concenso"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making) m&aacute;s que en concensuar.

Bajo un proceso de b&uacute;squeda de concenso, los miembros de la comunidad discuten las principales preocupaciones hasta que sienten que fueron escuchadas adecuadamente. Cuando solo quedan preocupaciones menores, la comunidad avanza. La "B&uacute;squeda de Concenso" reconoce que una comunidad puede no ser capaz de alcanzar una respuesta perfecta. En su lugar prioriza el escuchar y la discusi&oacute;n.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  Parte de la raz&oacute;n por la que la votaci&oacute;n no existe para Cuestiones At&oacute;micas es porque un Grupo At&oacute;mico no llevar&aacute; adelante un sistema de votac&iacute;on en todos los casos. Algunas veces tenemos que elegir lo que nos parece correcto incluso aunque no sea popular. (...) Lo que puedo ofrecer y prometo hacer... es escuchar a la comunidad.
  <p markdown="1" class="pquote-credit">
— @lee-dohm on [Atom's decisionmaking process](https://discuss.atom.io/t/prioritize-issues-feature-requests-based-on-voting-system/27642/2)
  </p>
</aside>

Incluso si no adopta un proceso de b&uacute;squeda de concenso, como responsable del proyecto, es importante que las personas sepan que est&aacute;s escuchando. Hacer que las personas se sientan escuchadas y comprometerte a resolver sus preocupaciones, facilita gran parte del camino para resolver situaciones delicadas. Luego, contin&uacute;a tus palabras con acciones.

No te apresures a tomar una decisi&oacute;n por el bien de tener una soluci&oacute;n. Aseg&uacute;rate de que todos se sientan escuchados y que toda la informaci&oacute;n se ha hecho p&uacute;blica antes de avanzar hacia una soluci&oacute;n.

### Mant&eacute;n la conversaci&oacute;n centrada en la acci&oacute;n

La discusi&oacute;n es importante, pero hay una diferencia entre conversaciones productivas e improductivas.

Fomenta la discusi&oacute;n siempre y cuando se mueva hacia una soluci&oacute;n. Si est&aacute; claro que la conversaci&oacute;n se est&aacute; extinguiendo o y&eacute;ndose por las ramas, que las cosas se est&aacute;n haciendo personales o que est&aacute;n discutiendo sobre detalles menores, es tiempo de cerrarla.

Permitir que contin&uacute;en estas conversaciones no solo es malo para un tema en cuesti&oacute;n, sino tambi&eacute;n para la salud de la comunidad. Esto env&iacute;a el mensaje que este tipo de conversaciones est&aacute;n permitidas e incluso fomentadas, y puede desalentar a las personas a plantear o resolver problemas futuros.

Con cada aspecto que hayas hecho o que hayan hecho otros, preg&uacute;ntate, _"¿C&oacute;mo nos acerca &eacute;sto a una soluci&oacute;n?"_

Si la conversaci&oacute;n comienza a desenredarse, pregunta al grupo, _"¿Qu&eacute; pasos deber&iacute;amos tomar?"_ para reorientar la conversaci&oacute;n.

Si la conversaci&oacute;n claramente no va a ning&uacute;n lado, no existen acciones claras para tomar, o las acciones correctas ya se llevaron adelante, cierra el tema y explica porqu&eacute; lo cerraste.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Guiar un t&oacute;pico hacia algo &uacute;til sin ser agresivo es un arte. No funcionar&aacute; simplemente con llamar la atenci&oacute;n a las personas para impedir que contin&uacute;en perdiendo tiempo, ni pedirles que no publiquen a menos que tengan algo constructivo que decir. (...) En su lugar, debes sugerir condiciones para continuar progresando: brinda a las personas una ruta, un camino a seguir que los lleve al resultado que quieres, pero sin aparentar que les est&aacute;s dictando una conducta.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### Elige tus batallas sabiamente

El contexto es importante. Considera qui&eacute;n est&aacute; involucrado en una discusi&oacute;n y c&oacute;mo representa &eacute;sta al resto de la comunidad.

¿Est&aacute;n todos en la comunidad molestos, o incluso involucrados en un problema? ¿O es un provocador solitario? No te olvides de considerar a los miembros silenciosos de la comunidad, no solo a las voces activas.

Si el problema no representa las necesidades m&aacute;s amplias de tu comunidad, tal vez solo necesites agradecer las preocupaciones de algunas personas. Si se trata de un problema recurrente sin una soluci&oacute;n clara, dirige el foco a discusiones previas y cierra el hilo de discusi&oacute;n.

### Identifica a un decisor de la comunidad

Con una buena actitud y una clara comunicaci&oacute;n, es posible resolver la mayor&iacute;a de las situaciones dif&iacute;ciles. Sin embargo, incluso en una discusi&oacute;n productiva, simplemente pueden haber diferencias de opini&oacute;n sobre c&oacute;mo proceder. En esos casos, identifica un individuo o un grupo de personas que puedan actuar como decisivas.

Un decisor puede ser un responsable primario del proyecto, o podr&iacute;a ser un peque&ntilde;o grupo de personas que toman una decisi&oacute;n en base a votaci&oacute;n. Idealmente, habr&aacute;s identificado un decisor y el proceso asociado en un archivo llamado GOVERNANCE antes de que necesites utilizarlo.

Tu decisor deber&iacute;a ser tu &uacute;ltimo recurso. Los temas que dividen son una oportunidad de crecer y aprender para tu comunidad. Aprovecha esas oportunidades y utiliza un proceso colaborativo para moverte hacia una soluci&oacute;n cada vez que sea posible.

## La comunidad es el ❤️ del c&oacute;digo abierto

Las comunidades sanas y pr&oacute;speras alimentan las miles de horas que se producen cada semana de c&oacute;digo abierto. Muchos colaboradores se&ntilde;alan a otras personas como la raz&oacute;n para trabajar -o para no trabajar- en c&oacute;digo abierto. Al aprender a aprovechar ese poder de manera constructiva, ayudar&aacute;s a que &aacute;lguien tenga una inolvidable experiencia con el c&oacute;digo abierto.
