---
lang: de
title: Für Open-Source-Arbeit bezahlt werden
description: Verstetigen Sie Ihre Open-Source-Arbeit, indem Sie finanzielle Unterstützung für Ihre Zeit oder Ihr Projekt erhalten.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Warum manche Menschen finanzielle Unterstützung suchen

Ein Großteil der Open-Source-Arbeit wird ehrenamtlich geleistet, z.B. wenn jemand in einem Projekt, das er benutzt, auf einen Fehler stößt und eine schnelle Lösung vorschlägt. Außerdem basteln viele Leute einfach in ihrer Freizeit an einem Open-Source-Projekt.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">

  Ich war auf der Suche nach einem Hobby-Programmierprojekt, mit dem ich mich während der Weihnachtswoche beschäftigen konnte. (...) Ich hatte einen Heimcomputer und nicht viel anderes an der Hand und entschied mich, einen Interpreter für die neue Skriptsprache zu schreiben, über die ich in letzter Zeit nachgedacht hatte. (...) Ich wählte Python als Arbeitstitel.

  _I was looking for a "hobby" programming project that would keep me occupied during the week around Christmas. (...) I had a home computer, and not much else on my hands. I decided to write an interpreter for the new scripting language I had been thinking about lately. (...) I chose Python as a working title._

  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Es gibt viele Gründe, warum eine Person _nicht_ für ihre Open-Source-Arbeit bezahlt werden möchte.

* **Sie haben vielleicht schon einen Vollzeitjob, den sie lieben,** und der ihnen ermöglicht, in ihrer Freizeit einen Beitrag zu Open-Source-Software zu leisten.
* **Sie mögen Open Source als Hobby,** oder als kreative Flucht und wollen sich finanziell nicht verpflichtet fühlen, an ihren Projekten arbeiten zu müssen.
* **Sie ziehen andere Vorteile aus ihren Open-Source-Beiträgen,** wie z.B. den Aufbau ihres Rufs oder Portfolios, das Erlernen neuer Fertigkeiten oder das Gefühl, in einer Gemeinschaft eingebettet zu sein.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">

  Finanzielle Zuwendungen bringen für manche ein Verantwortungsgefühl mit sich. (...) Es ist wichtig für uns, in der global vernetzten, schnelllebigen Welt, in der wir leben, sagen zu können: "Nicht jetzt. Ich mache lieber etwas ganz anderes."

  _Financial donations do add a feeling of responsibility, for some. (...) It's important for us, in the globally connected, fast-paced world we live in, to be able to say "not now, I feel like doing something completely different"._

  <p markdown="1" class="pquote-credit">
— @alloy, ["Why We Don't Accept Donations"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Für andere kann eine Bezahlung die einzige Möglichkeit sein, sich an Open Source zu beteiligen. Sei es, weil das Projekt ständige oder zeitintensive Mitarbeit erfordert, oder seien es persönliche Gründe.

Populäre Projekte aufrecht zu erhalten, kann eine große Verantwortung sein, die 10 oder 20 Stunden pro Woche in Anspruch nimmt, statt nur ein paar Stunden pro Monat.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">

  Fragen Sie irgendeine\*n Open-Source-Projektbetreuer\*in, und sie oder er wird Ihnen sagen, wie viel Arbeit im Management eines Projekts steckt. Sie haben Kunden. Sie beheben Probleme für sie. Sie erschaffen neue Funktionen. Das alles wird zu einem echten Zeitaufwand.

  _Ask any open source project maintainer, and they will tell you about the reality of the amount of work that goes into managing a project. You have clients. You are fixing issues for them. You are creating new features. This becomes a real demand on your time._

  <p markdown="1" class="pquote-credit">
— @ashedryden, ["The Ethics of Unpaid Labor and the OSS Community"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Bezahlte Arbeit ermöglicht Leuten aus verschiedenen Lebenssituationen heraus, sinnvolle Beiträge zu leisten. Manche Menschen können es sich eben nicht leisten, unbezahlte Zeit für Open-Source-Projekte aufzuwenden, z.B. weil ihre finanzielle Situation, Schulden, Familien- oder anderen Betreuungspflichten dies nicht zulassen. Das heißt, die möglichen Beiträge von talentierten Menschen, die es sich ehrenamtliche Arbeitszeit nicht leisten können, würden nie das Licht der Welt erblicken. Dies hat ethische Implikationen, wie @ashedryden [beschreibt](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), da die Beiträge, die das Licht der Welt erblicken, eher zu Gunsten derjenigen tendieren, die bereits Vorteile im Leben haben. Und sie diese aufgrund ihrer freiwilligen Beiträge weiter ausbauen können, während Andere, die nicht zu freiwilligem Engagement in der Lage sind, auch daraus keine Vorteile ziehen können. Dies wiederum verstärkt den derzeitigen Mangel an Vielfalt in der Open-Source-Welt.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">

  OSS bringt massive Vorteile für die Technologieindustrie, was wiederum Vorteile für alle Branchen bedeutet. (...) Solange jedoch die einzigen Leute, die sich darauf konzentrieren können, die Glücklichen und die Besessenen sind, dann gibt es ein riesiges ungenutztes Potenzial.

  _OSS yields massive benefits to the technology industry, which, in turn, means benefits to all industries. (...) However, if the only people who can focus on it are the lucky and the obsessed, then there's a huge untapped potential._

  <p markdown="1" class="pquote-credit">
— @isaacs, ["Money and Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Wenn Sie auf der Suche nach finanzieller Unterstützung sind, gibt es zwei Möglichkeiten: Sie können Ihre eigene Arbeitszeit finanzieren, oder Sie können eine organisatorische Finanzierung für das Projekt finden.

## Die eigene Arbeitszeit finanzieren

Heutzutage werden viele Leute für Open-Source in Teil- oder Vollzeit bezahlt. Der häufigste Weg dahin ist, mit Ihrem Arbeitgeber darüber zu sprechen.

Es ist einfacher, sich für Open-Source-Arbeiten zu entscheiden, wenn Ihr Arbeitgeber das Projekt tatsächlich nutzt. Wenn nicht, werden Sie kreativ: Vielleicht nutzt Ihr Arbeitgeber nicht das Projekt, aber Python, und die Pflege eines beliebten Python-Projekts hilft dabei, neue Python-Entwickler\*innen anzuziehen. Vielleicht sieht Ihr Arbeitgeber dadurch generell entwicklerfreundlicher aus.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/hzoo?s=180" class="pquote-avatar" alt="avatar">

  Wie viele Andere auch, kämpfte ich mit der Last, ein Open-Source-Projekt aufrechtzuerhalten. Als ich mit Open Source anfing, blieb ich lange auf Arbeit, um daran zu arbeiten, oder fing nach dem Feierabend direkt wieder an. (...) Mit meinem Chef besprach ich diese mir im Weg stehenden Probleme, aber weil wir Babel selbst nutzten, entwickelten wir Ideen, um die Open-Source-Aufgaben zu integrieren.

  _Like many in open source, I was struggling with the burden of maintaining a project. When I first started doing open source, I used to just stay late to work on it or right when I got home. (...) I was able to discuss with my boss the issues I was facing and we came up with ideas on how we could incorporate open source tasks given our own use of Babel._

  <p markdown="1" class="pquote-credit">
— @hzoo, ["Maintainer Stories"](https://github.com/open-source/stories/hzoo)
  </p>
</aside>

Wenn Sie kein existierendes Open-Source-Projekt haben, an dem Sie gerne arbeiten würden, sondern lieber Ihre aktuellen Arbeitsergebnisse quell-offen hätten, sollten Sie Ihren Arbeitgeber bitten, einen Teil seiner internen Software zu öffnen.

Viele Unternehmen entwickeln Open-Source-Programme, um ihre Marke aufzubauen und Talente zu rekrutieren.

@hueniverse z.B., fand heraus, dass es finanzielle Gründe gab, die [Investition von Walmart in Open Source zu rechtfertigten.](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). Und @jamesgpearce fand heraus, dass Facebooks Open-Source-Program [den Unterschied in der Personalakquise](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) machte:

> Es ist eng mit unserer Hackerkultur und der Wahrnehmung unseres Unternehmens verbunden. Wir fragten unsere Angestellten: "Kanntet ihr das Open-Source-Programm von Facebook?". Zwei Drittel sagten "Ja". Die Hälfte sagte, dass das Programm positiv zu ihrer Entscheidung beigetragen hat, für uns zu arbeiten. Das sind keine marginalen Zahlen, und ein sich hoffentlich fortsetzender Trend.
>
> It is closely aligned with our hacker culture, and how our organization was perceived. We asked our employees, "Were you aware of the open source software program at Facebook?". Two-thirds said "Yes". One-half said that the program positively contributed to their decision to work for us. These are not marginal numbers, and I hope, a trend that continues.

Wenn Ihr Unternehmen diesen Weg einschlägt, ist es wichtig, die Grenzen zwischen Gemeinschafts- und Unternehmenstätigkeit klar zu halten, denn Open Source erhält sich letztlich durch Beiträge von Menschen auf der ganzen Welt. Und das ist größer als jedes einzelne Unternehmen oder jeder einzelne Standort.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">

  Die Arbeit an Open Source ist eine seltene und wunderbare Gelegenheit, aber Sie sollten dabei nicht auf Ihre Leidenschaft verzichten müssen. Denn die sollte der Grund für Ihre Bezahlung durch ein Unternehmen sein.

  _Getting paid to work on open source is a rare and wonderful opportunity, but you should not have to give up your passion in the process. Your passion should be why companies want to pay you._

  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Wenn Sie Ihren derzeitigen Arbeitgeber nicht davon überzeugen können, Open-Source-Arbeit zu priorisieren, sollten Sie sich überlegen, einen neuen Arbeitgeber zu finden, der Mitarbeit an Open Source fördert. Zum Beispiel:

* Manche Firmen, wie [Netflix](https://netflix.github.io/) oder [PayPal](https://paypal.github.io/), zeigen ihr Open-Source-Engagement auf ihren Webseiten
* [Zalando](https://opensource.zalando.com) veröffentlicht seine [Open-Source-Beitragsrichtlinie](https://opensource.zalando.com/docs/using/contributing/) für Angestellte

Aus einer großen Firma stammende Projekte, wie z.B. [Go](https://github.com/golang) oder [React](https://github.com/facebook/react), stellen vermutlich auch weiterhin Leute für Open-Source-Arbeit an.

Außerdem können Sie versuchen, abhängig von Ihren persönlichen Umständen, selbstständig Geld zu sammeln, um Ihre Open-Source-Arbeit zu finanzieren, zum Beispiel:

* @gaearon finanzierte seine Arbeit an [Redux](https://github.com/reactjs/redux) mittels einer [Patreon-Crowdfunding-Kampagne](https://redux.js.org/)
* @andrewgodwin finanzierte Arbeit an Djangos Schemamigrations [mittels einer Kickstarter-Kampagne](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

## Geldquellen für Ihr Projekt auftun

Abgesehen von Vereinbarungen für einzelne Projektteilnehmer\*innen, sammeln Projekte manchmal Geld von Unternehmen, Einzelpersonen oder anderen ein, um die laufende Arbeit zu finanzieren.

Geld von einer Organisation kann verwendet werden, aktuelle Projektteilnehmer\*innen zu bezahlen, die Kosten für den Betrieb des Projekts zu decken (z.B. Hosting-Gebühren) oder in neue Funktionen oder Ideen zu investieren.

Da Open Source populärer wird, ist die Finanzierung von Projekten immer noch experimentell, aber es gibt einige allgemeine Optionen.

### Geld mittels Crowdfunding-Kampagnen oder Sponsoren einsammeln

Sponsoren lassen sich einfacher finden, wenn Sie bereits ein starkes Publikum oder einen guten Ruf haben, oder Ihr Projekt sehr beliebt ist.

Hier einige Beispiele für gesponsorte Projekte:

* **[webpack](https://github.com/webpack)** sammelt Geld von Firmen und Einzelpersonen [mittels OpenCollective](https://opencollective.com/webpack)
* **[Vue](https://github.com/vuejs/vue)** wird [mittels Patreon finanziert](https://github.com/open-source/stories/yyx990803)
* **[Ruby Together](https://rubytogether.org/),** eine nicht-Gewinn-orientierte Organisation zahlt für die Arbeit an [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), und anderen Ruby-Infrastrukturprojekten

### Eine Einnahmequelle schaffen

Abhängig von Ihrem Projekt können Sie kommerziellen Support, gehostete Optionen oder zusätzliche Funktionen in Rechnung stellen. Wie beispielsweise:

* **[Sidekiq](https://github.com/mperham/sidekiq)** bietet Bezahlversionen mit zusätzlichem Support
* **[Travis CI](https://github.com/travis-ci)** bietet Bezahlversionen ihres Dienstes
* **[Ghost](https://github.com/TryGhost/Ghost)** ist ein Non-Profit mit Bezahldiensten

Einige populäre Projekte, wie z.B. [npm](https://github.com/npm/npm) und [Docker](https://github.com/docker/docker), sammeln sogar Wagniskapital ein, um ihr Wachstum zu unterstützen.

### Fördermittel beantragen

Einige Softwarestiftungen und Unternehmen bieten Zuschüsse für Open-Source-Arbeiten an. Manchmal können Zuschüsse an Einzelpersonen ausgezahlt werden, ohne eine juristische Person für das Projekt zu gründen.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** erhielt eine Förderung des [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/)
* Arbeiten an **[OpenMRS](https://github.com/openmrs)** wurden von [Stripes Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees) gefördert
* **[Libraries.io](https://github.com/librariesio)** erhielt Fördermittel der [Sloan Foundation](https://sloan.org/programs/digital-technology)
* Die **[Python Software Foundation](https://www.python.org/psf/grants/)** fördert Python-relvante Arbeiten

Weitere, detaillierter erklärte Möglichkeiten, um für Open-Source-Arbeit bezahlt zu werden, finden Sie in [der Anleitung "Lemonade Stand"](https://github.com/nayafia/lemonade-stand) von @nayafia. Die verschiedenen Finanzierungsarten erfordern unterschiedliche Fähigkeiten, die Sie Ihren Stärken entsprechend in Erwägung ziehen sollten.

## Eine Argumentationslinie für finanzielle Unterstützung aufbauen

Egal ob Ihr Projekt eine neue Idee umsetzt, oder schon seit Jahren besteht: Sie sollten sich Gedanken über passende Finanzierung machen, Geldquellen identifizieren, und diesen ein überzeugendes Argument liefern können.

Egal, ob Sie für Ihre eigene Zeit oder für ein Projekt Geld sammeln möchten, Sie sollten in der Lage sein, die folgenden Fragen zu beantworten.

### Einfluss

Warum ist dieses Projekt nützlich? Warum gefällt es Ihren (potenziellen) Nutzer\*innen so gut? Wo wird es in fünf Jahren sein?

### Wichtigkeit

Versuchen Sie Beweise für die Wichtigkeit Ihres Projektes zu sammeln: Metriken, Anekdoten oder Referenzen. Gibt es Unternehmen oder bemerkenswerte Personen, die Ihr Projekt gerade nutzen? Falls nicht, hat es jemand Bekanntes empfohlen?

### Nutzen für die Geldgeber

Geldgeber (sei es Ihr\*e Arbeitgeber\*in oder eine Förderstiftung) werden von vielen Anderen angesprochen: Warum sollte gerade Ihr Projekt unterstützt werden? Wie profitiert der Geldgeber selbst davon?

### Nutzung der Gelder

Was genau werden Sie mit der vorgeschlagenen Finanzierung erreichen? Konzentrieren Sie sich auf Projektmeilensteine oder -ergebnisse, anstatt ein Gehalt zu zahlen.

### Wie empfangen Sie das Geld

Hat der Geldgeber irgendwelche Anforderungen an die Auszahlung? Müssen Sie beispielsweise eine gemeinnützige Organisation sein, oder einen gemeinnützigen finanziellen Sponsor haben? Oder werden die Mittel an eine\*n einzelne\*n Auftragnehmer\*in anstatt an eine Organisation vergeben? Diese Anforderungen variieren zwischen den Geldgebern, also sollten Sie dies im Vorhinein in Erfahrung bringen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">

  Seit Jahren sind wir die führende Ressource für Webseiten-freundliche Icons; Mit einer Community von über 20 Millionen Menschen und auf über 70 Millionen Websites, einschließlich Whitehouse.gov. (...) Version 4 wurde vor drei Jahren veröffentlicht. Seitdem hat sich die Web-Technologie stark verändert, und offen gesagt: Font Awesome ist ein wenig abgestanden. (...) Deshalb führen wir Font Awesome 5 ein. Wir modernisieren und überarbeiten das CSS und entwerfen jedes Icon komplett neu. Damit erreichen wir ein besseres Design, bessere Konsistenz und bessere Lesbarkeit.

  _For years, we've been the leading resource of website friendly icons, with a community of over 20 million people and been featured on over 70 million websites, including Whitehouse.gov. (...) Version 4 was three years ago. Web tech's changed a lot since then, and frankly, Font Awesome's gotten a bit stale. (...) That's why we're introducing Font Awesome 5. We're modernizing and rewriting the CSS and redesigning every icon from top to bottom. We're talking better design, better consistency, and better readability._

  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Experimentieren und nicht aufgeben

Es ist nicht einfach, Geld zu sammeln. Egal ob Sie ein Open-Source-Projekt, einen gemeinnützigen Verein oder ein Software-Startup betreiben. In den meisten Fällen müssen Sie kreativ werden. Identifizieren Sie den Modus der Bezahlung, stellen Sie Recherchen an und versetzen Sie sich selbst in die Rolle der Geldgeber\*innen. Dies wird Ihnen beim Finden eines überzeugenden Argumentes für die Finanzierung helfen.
