---
lang: de
title: Finden Sie Nutzer*innen für Ihr Projekt
description: Ziehen Sie Ihr Open-Source-Projekt groß, indem Sie es in die Hände zufriedener Anwender*innen legen.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Tue Gutes und rede darüber!

Es gibt keine Regel, die besagt, dass man den Start eines Open-Source-Projektes verkünden _muss_. Viele erfüllende Beweggründe für Open-Source-Arbeit haben nichts mit Popularität zu tun. Aber anstatt _zu hoffen_, dass Ihr Open-Source-Projekt gefunden und genutzt wird, sollten Sie über Ihre harte Arbeit reden.

## Klären Sie Ihre Botschaft

Bevor Sie mit der eigentlichen Arbeit an einem Projekt beginnen, sollten Sie (er)klären, was es tut und warum es wichtig ist.

Was macht Ihr Projekt anders oder interessant und warum haben Sie es begonnen? Die Beantwortung dieser Fragen hilft Ihnen dabei, die Bedeutung Ihres Projekts zu kommunizieren.

Denken Sie daran, dass Menschen sich als Nutzer\*innen engagieren und letztendlich zu Mitwirkenden werden, weil Ihr Projekt ein Problem für sie löst. Wenn Sie über die Botschaft und den Wert Ihres Projekts nachdenken, versuchen Sie durch die Brille der _Benutzer\*innen und Mitwirkenden_ zu blicken. Was könnten jene sich wünschen?

Code-Beispiele wie @robb sie verwendet, können klar kommunizieren, warum sein Projekt "[Cartography](https://github.com/robb/Cartography)" nützlich ist:

![Cartography README](/assets/images/finding-users/cartography.jpg)

Tiefere Einblicke in das Thema "Botschaften", finden Sie in Mozillas ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/)-Übung zur Entwicklung von Personas.

## Helfen Sie Menschen dabei, Ihr Projekt zu finden und zu beobachten

<aside markdown="1" class="pquote">

  Am besten nutzen Sie eine einzige "Heimat"-Adresse im Internet, auf die Sie im Zusammenhang mit Ihrem Projekt aufmerksam machen können und auf die Sie Interessenten verweisen. Sie müssen kein großes Geld für ausgefallene Vorlagen oder gar einen Domainnamen hinblättern, aber Ihr Projekt braucht eine zentrale Anlaufstelle.

  _You ideally need a single "home" URL that you can promote and point people to in relation to your project. You don't need to splash out on a fancy template or even a domain name, but your project needs a focal point._

  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Helfen Sie Leuten dabei, Ihr Projekt zu finden und es sich zu merken, indem Sie sie auf einen einzigen Namensraum verweisen.

**Preisen Sie Ihre Arbeit an unter _einem_ Nutzernamen an.** Twitter-Name, GitHub-URL oder IRC-Kanal sind einfache Möglichkeiten, Leute auf Ihr Projekt aufmerksam zu machen. Diese "Marktstände" bieten auch der wachsenden Gemeinschaft Ihres Projekts einen Ort, an dem sie sich treffen können.

Wenn Sie noch keine "Marktstände" für Ihr Projekt einrichten möchten, bewerben Sie immer Ihren eigenen Twitter- oder GitHub-Namen. Werben Sie für Ihren Twitter- oder GitHub-Namen, damit die Leute wissen, wie Sie zu erreichen sind oder wo Ihre Arbeit beobachtet werden kann. Wenn Sie bei einem Meeting oder einer Veranstaltung sprechen, stellen Sie sicher, dass Sie Ihre Kontaktinformationen erwähnen oder in Ihren Folien nennen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">

  Ein Fehler der frühen Tage (...) war, dass ich kein Twitter-Konto für das Projekt einrichtete. Twitter ist eine großartige Möglichkeit, die Leute auf dem Laufenden zu halten und sie ständig mit dem Projekt in Kontakt zu bringen.

  _A mistake I made in those early days (...) was not starting a Twitter account for the project. Twitter's a great way to keep people up to date about a project as well as constantly expose people to the project._

  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Ziehen Sie eine Website für Ihr Projekt in Betracht.** Eine Website macht Ihr Projekt freundlicher und einfacher zu navigieren. Vor allem, wenn die Seite klare Dokumentation und Tutorials enthält. Außerdem zeigt eine Website auch, dass Ihr Projekt aktiv ist, was wiederum Ihrem Publikum Vertrauen in den Nutzen Ihres Projektes gibt.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689) (Mitbegründer von Django) sagte, dass eine Website _"mit Abstand das Beste, das wir in der Frühphase von Django gemacht haben"_.

Wenn Ihr Projekt auf GitHub gehostet ist, können Sie mithilfe der [Pages-Funktion](https://pages.github.com/) einfach eine Webseite erstellen. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), und [Middleman](https://middlemanapp.com/) sind [einige Beispiele](https://github.com/showcases/github-pages-examples) für exzellente, reichhaltige Seiten.

![Vagrant-Haupseite](/assets/images/finding-users/vagrant_homepage.png)

Nun, da Sie die Botschaft Ihres Projekt klargestellt haben, und seine einfache Auffindbarkeit gewährleistet haben, lassen Sie uns rausgehen und mit Ihrem Publikum sprechen!

## Gehen Sie auf die Zielgruppe Ihres Projekts zu (online)

Internetkommunikation ist ein großartiger Weg, um die Botschaft Ihres Projektes schnell zu verbreiten und verteilen zu lassen: Online-Kanälen bieten das Potenzial, ein sehr breites Publikum zu erreichen.

Nutzen Sie die Vorteile bestehender Online-Communities und -Plattformen, um Ihr Publikum zu erreichen. Wenn es sich bei Ihrem Open Source Projekt um ein Softwareprojekt handelt, erreichen Sie Ihr Publikum wahrscheinlich auf [Stack Overflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/), oder [Quora](https://www.quora.com/). Finden Sie die Kanäle, von denen Sie denken, dass die Menschen am meisten von Ihrer Arbeit profitieren werden, oder sich begeistern lassen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">

  Jedes Programm verfügt über sehr spezifische Funktionen, die nur ein Bruchteil der Benutzer für nützlich hält: Spammen Sie nicht so viele Leute wie möglich zu, sondern richten Sie Ihre Bemühungen auf Gemeinschaften, die vom Kennenlernen Ihres Projekts profitieren.

  _Each program has very specific functions that only a fraction of users will find useful. Don't spam as many people as possible. Instead, target your efforts to communities that will benefit from knowing about your project._

  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](http://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Finden Sie Wege, um Ihr Projekt auf relevante Art und Weise mit anderen zu teilen:

* **Lernen Sie relevante Open Source Projekte und Communities kennen.** Manchmal müssen Sie nicht direkt für Ihr Projekt werben. Wenn Ihr Projekt perfekt für Datenwissenschaftler geeignet ist, die Python nutzen, lernen Sie die Python Data Science Community kennen. Wenn die Leute Sie kennenlernen, ergeben sich natürliche Gelegenheiten, über Ihre Arbeit zu sprechen und sie mit anderen zu teilen.
* **Finden Sie Personen, die mit dem Problem konfrontiert sind, das Ihr Projekt löst.** Suchen Sie in verwandten Foren nach Personen, die in die Zielgruppe Ihres Projekts fallen, beantworten Sie deren Fragen und finden Sie einen taktvollen Weg, um Ihr Projekt als Lösung vorzuschlagen.
* **Bitten Sie um Feedback.** Stellen Sie sich und Ihre Arbeit einem Publikum vor, das Sie für relevant und interessant hält, und geben Sie an, wer Ihrer Meinung nach von Ihrem Projekt profitieren könnte. Versuchen Sie, diesen Satz zu vervollständigen: _"Ich denke, dass mein Projekt wirklich den X helfen würde, die versuchen, Y zu tun."_. Hören Sie zu und reagieren Sie auf das Feedback anderer, anstatt einfach nur Ihre Arbeit anzupreisen.

Generell gilt: Konzentrieren Sie sich darauf, anderen zu helfen, bevor Sie um Gegenleistungen bitten. Da jeder leicht ein Projekt online bewerben kann, wird es eine Menge Rauschen geben: Um sich von der Masse abzuheben, machen Sie den Leuten Ihren persönlichen Kontext klar, und nicht nur Ihre Wünsche.

Wenn niemand auf Ihre anfängliche Kommunikation achtet oder darauf reagiert, lassen Sie sich nicht entmutigen! Die meisten Projektstarts sind ein iterativer Prozess, der Monate oder Jahre dauern kann. Wenn Sie beim ersten Mal keine Antwort erhalten, versuchen Sie es mit einer anderen Taktik oder suchen Sie nach Wegen, wie Sie die Arbeit anderer zuerst aufwerten können. Ein Projekt zu starten und zu bewerben, erfordert Zeit und Engagement.

## Gehen Sie auf die Zielgruppe Ihres Projekts zu (offline)

![Öffentliches Reden](/assets/images/finding-users/public_speaking.jpg)

Offline-Veranstaltungen helfen Ihnen dabei, neue Projekte beim Publikum bekannt zu machen und engagierte Leute zu erreichen. Insbesondere können Sie mit Entwickler\*innen direkt in Kontakt treten und Interesse an Ihrem Projekt wecken.

Wenn Sie gerade erst anfangen, [Vorträge zu halten](http://speaking.io/), tun Sie das am besten auf einem lokalen Treffen ("Meetup"), bei dem es um die Sprache oder die Programmierumgebung geht, in der Ihr Projekt angesiedelt ist.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">

  Ich war ziemlich nervös, als ich zur PyCon ging. Ich hielt einen Vortrag; Ich wollte nur ein paar Leute dort kennenlernen; Ich wollte eine ganze Woche lang hingehen. (...) Ich hätte mir aber keine Sorgen machen müssen. (...) PyCon war phänomenal grandios! Alle waren unglaublich freundlich und kontaktfreudig, so sehr, dass ich selten Zeit fand, nicht mit Leuten zu reden!

  _I was pretty nervous about going to PyCon. I was giving a talk, I was only going to know a couple of people there, I was going for an entire week. (...) I shouldn't have worried, though. PyCon was phenomenally awesome! (...) Everyone was incredibly friendly and outgoing, so much that I rarely found time not to talk to people!_

  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Wenn Sie noch nie auf einer Veranstaltung gesprochen haben, sind Gefühle der Nervosität völlig normal: Denken Sie daran, dass Ihr Publikum da ist, weil es wirklich von Ihrer Arbeit hören möchte.

Während Sie Ihren Vortrag ausarbeiten, konzentrieren Sie sich auf das für Ihr Publikum Interessante, das ihm einen Mehrwert bietet. Gestalten Sie Ihren Vortrag in einem freundlichen, zugänglichen Tonfall. Lächeln, atmen und Spaß haben.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">

  Wenn Du anfängst, Deinen Vortrag zu schreiben (Gleich über welches Thema!) kann es helfen, ihn als eine Geschichte anzusehen, die Du den Leuten erzählst.

  _When you start writing your talk, no matter what your topic is, it can help if you see your talk as a story that you tell people._

  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Wenn Sie sich gut vorbereitet fühlen, sollten Sie sich überlegen, mit einem Konferenzvortrag für Ihr Projekt zu werben. Das kann Ihnen helfen, mehr Menschen zu erreichen; Manchmal aus der ganzen Welt.

Suchen Sie nach Konferenzen, die speziell auf Ihre Sprache oder Ihre Programmierumgebung zugeschnitten sind. Bevor Sie Ihren Vortrag einreichen, recherchieren Sie die Konferenz, um Ihren Vortrag auf die Teilnehmer\*innen zuzuschneiden und Ihre Chancen zu erhöhen, auf der Konferenz als Redner\*in akzeptiert zu werden. Sie können oft ein Gefühl für Ihr Publikum bekommen, wenn Sie frühere Redner\*innen der Konferenz recherchieren.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">

  Ich schrieb sehr nett an die JSConf-Leute und flehte sie an, mir einen Platz zu geben, sodass ich auf der JSConf EU präsentieren könnte. (...) Ich hatte große Angst, dieses Ding, an dem ich sechs Monate lang gearbeitet hatte, vorzustellen. (...) Die ganze Zeit dachte ich nur, oh mein Gott, was mache ich hier?

  _I wrote very nicely to the JSConf people and begged them to give me a slot where I could present it at JSConf EU. (...) I was extremely scared, presenting this thing that I had been working on for six months. (...) The whole time I was just thinking, oh my God. What am I doing here?_

  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Reputation aufbauen

Zusätzlich zu den oben skizzierten Strategien ist der beste Weg, Menschen für Beiträge in Ihrem Projekt zu gewinnen, deren Projekte zu teilen und zu unterstützen.

Wenn Sie Neuankömmlingen helfen, Ressourcen gemeinsam nutzen und durchdachte Beiträge zu anderen Projekten leisten, können Sie einen guten Ruf aufbauen. Ein aktives Mitglied in der Open-Source-Gemeinschaft zu sein, hilft Leuten dabei, den Kontext Ihrer Arbeit zu verstehen. Es wird zudem wahrscheinlicher, dass Leute Ihr Projekt aufmerksam verfolgen und teilen. Die Entwicklungsbeziehungen zu anderen Open-Source-Projekten können sogar zu offiziellen Kooperationen führen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">

  Urllib3 ist nur darum die populärste Python-Bibliothek eines Drittanbieters, weil ihr Einbau mittels so vieler Pull Requests vorgeschlagen wird.

  _The only reason urllib3 is the most popular third-party Python library today is because it's part of requests._

  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Es ist nie zu früh oder zu spät, um mit dem Aufbau eines guten Rufs zu beginnen. Auch wenn Sie bereits ein eigenes Projekt gestartet haben, suchen Sie weiterhin nach Möglichkeiten, anderen zu helfen.

Ein Publikum aufzubauen, schafft man nicht über Nacht. Das Vertrauens und den Respekt anderer zu gewinnen, nimmt Zeit in Anspruch, und der Aufbau Ihres Rufes endet nie.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ariya?s=180" class="pquote-avatar" alt="avatar">

  PhantomJS wurde Anfang 2011 zum ersten Mal veröffentlicht. (...) Ich verkündete dies auf die übliche Art und Weise: Ich twitterte darüber, ich schrieb Blog-Posts über Dinge, die man damit machen könnte, ich erwähnte es in verschiedenen Diskussionen in Meetups. Als es 2014 bekannter wurde, fing ich an, Vorträge darüber zu halten.

  _PhantomJS was released for the first time in the beginning of 2011. (...) I spread the word in the usual ways: I tweeted about it, I wrote blog posts on things you could do with it, I mentioned it during various discussions in meetups. When it became more well known in 2014, I started giving presentations about it._

  <p markdown="1" class="pquote-credit">
— @ariya, ["Maintainer Stories"](https://github.com/open-source/stories/ariya)
  </p>
</aside>

## Weitermachen!

Es kann lange dauern, bis Leute Ihr Open-Source-Projekt bemerken. Das ist in Ordnung! Einige der populärsten Projekte erreichten erst nach Jahren ein hohes Aktivitätsniveau. Konzentrieren Sie sich darauf, Kontakte aufzubauen, anstatt zu hoffen, dass Ihr Projekt spontan an Popularität gewinnt. Seien Sie geduldig und teilen Sie Ihre Arbeit mit denen, die sie zu schätzen wissen.
