---
lang: de
title: Offenherzige Gemeinschaften aufbauen
description: Bauen Sie eine Community auf, die Menschen ermutigt, Ihr Projekt zu nutzen, zu unterstützen und weiter zu verbreiten.
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Ihr Projekt zum Erfolg führen

Ihr gerade gestartetes Projekt wird schon verbreitet und Leute schauen vorbei? Fantastisch! Wie überzeugen Sie sie, da zu bleiben?

Eine einladende, offenherzige Gemeinschaft ist eine Investition in die Zukunft und in den Ruf Ihres Projekts. Wenn Ihr Projekt gerade erst die initialen Kontributionen erfährt, fangen Sie damit an, den frühen Kontributor\*innen eine positive Erfahrung zu bereiten, und machen Sie es ihnen leicht, wiederzukommen.

### Geben Sie Leuten das Gefühl, willkommen zu sein

Die Community Ihres Projekts kann nach @MikeMcQuaid als "Kontributorentrichter" ([contributor funnel](https://speakerdeck.com/mikemcquaid/the-open-source-contributor-funnel)) aufgefasst werden:

![Contributor funnel](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

Während Sie Ihre Community aufbauen, überlegen Sie sich, wie jemand am Eingang des Trichters (potenzielle\*r Benutzer\*in) theoretisch den Weg nach unten finden könnte (aktiver\* Mitstreiter\*in). Ihr Ziel ist es, jede Phase des Mithelfens möglichst reibungslos zu gestalten. Denn wenn die Leute "leichte Beute" machen können, ermutigt sie dies zu weiteren Beiträgen.

Beginnen Sie mit der Dokumentation:

* **Helfen Sie beim Einstieg in ihr Projekt.** [Eine freundliche README](../starting-a-project/#eine-readme-schreiben) und anschauliche Codebeispiele erleichtern Allen, die auf Ihr Projekt stoßen, den Einstieg.
* **Erklären Sie in klaren Worten, wie Leute beitragen sollen**, bspw. in [einer CONTRIBUTING-Datei](../starting-a-project/#ihre-beitragsrichtlinien-aufschreiben), und indem Sie die Issues stets aktuell halten.
* **Good first issues**: Um neuen Mitwirkenden den Einstieg zu erleichtern, sollten Sie [für Anfänger\*innen* geeignete Issues explizit kenntlich machen (Englisch)](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). GitHub weist auf solche Issues vermehrt hin, sodass beitragswillige Neulinge zu nützlicher Mitarbeit ermuntert werden, ohne sich erst durch vermutlich zu schwere Issues durchkämpfen zu müssen.

[GitHubs 2017er Open-Source-Umfrage](http://opensourcesurvey.org/2017/) zeigte, dass unvollständige oder verwirrende Dokumentation das größte Problem für Open-Source-Anwender\*innen ist. Eine gute Dokumentation lädt zur Interaktion mit Ihrem Projekt ein. Wenn jemand ein Issue oder Pull Request erstellt, bietet sich für Sie die Möglichkeit, diese Person durch den Trichter zu bugsieren.

* **Wenn Leute neu zu Ihrem Projekt hinzustoßen, danken Sie ihnen für ihr Interesse!** Ansonsten braucht es nur eine negative Erfahrung, um jemanden nachhaltig abzuschrecken.
* **Antworten Sie schnell.** Wenn Sie einen Monat lang nicht auf jemandes Issue reagieren, ist es wahrscheinlich, dass diese Person Ihr Projekt bereits vergessen hat.
* **Nehmen Sie verschiedener Beitragsarten an.** Viele Mitwirkende beginnen mit einem Fehlerbericht oder einer kleinen Korrektur: Es gibt [viele Möglichkeiten, einen Beitrag zu leisten](../how-to-contribute/#was-einen-beitrag-leisten-bedeutet) zu einem Projekt. Lassen Sie Leute so helfen, wie diese es möchten.
* **Wenn es einen Beitrag gibt, mit dem Sie nicht einverstanden sind,** bedanken Sie sich trotzdem, aber [erklären warum](../best-practices/#lernen-nein-zu-sagen) die Idee nicht in den Projektrahmen passt. Verlinken Sie auf relevante Dokumentation, wenn vorhanden.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">

  Zu Open Source beizutragen ist für Manche einfacher als für andere. Manche haben Angst, angeschrien zu werden, weil sie etwas nicht richtig machen könnten oder einfach nicht hineinpassen. (...) Indem man den Mitwirkenden die Möglichkeiten gibt, auch mit sehr geringen technischen Kenntnissen (Dokumentation, Abschriften von Webinhalten, etc.) beitragen zu können, kann man diese Bedenken stark reduzieren.

  Contributing to open source is easier for some than others. There's a lot of fear of being yelled at for not doing something right or just not fitting in. (...) By giving contributors a place to contribute with very low technical proficiency (documentation, web content markdown, etc) you can greatly reduce those concerns.

  <p markdown="1" class="pquote-credit">
— @mikeal, ["Growing a contributor base in modern open source"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

Die Mehrheit der Open-Source-Mitwirkenden sind "Gelegenheitsmitwirkende": Personen, die nur gelegentlich an einem Projekt mitarbeiten. Möglicherweise haben sie nicht die Zeit, sich mit Ihrem Projekt vertraut zu machen. Daher ist es Ihre Aufgabe, es Leuten leicht zu machen, einen Beitrag zu leisten.

Andere zur Mitarbeit zu ermutigen, ist auch eine Investition in sich selbst: Wenn Sie Ihre größten Fans dazu befähigen, mit an etwas zu arbeiten, das sie begeistert, stehen Sie unter weniger Druck, alles selbst zu erledigen.

### Dokumentieren Sie alles

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">

  Waren Sie schon einmal auf einer (Technik-)Veranstaltung, auf der Sie niemanden kannten, aber alle anderen schienen in Gruppen zu stehen und wie alte Freunde zu plaudern? (...) Jetzt stellen Sie sich vor, Sie wollen zu einem Open-Source-Projekt beitragen, aber Sie sehen nicht, warum oder wie das passiert.

  _Have you ever been to a (tech-) event where you didn't know anyone, but everyone else seemed to stand in groups and chat like old friends? (...) Now imagine you want to contribute to an open source project, but you don't see why or how this is happening._

  <p markdown="1" class="pquote-credit">
— @janl, ["Sustainable Open Source"](https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Wenn Sie ein neues Projekt starten, mag es sich normal anfühlen, Ihre Arbeit privat zu halten. Aber Open-Source-Projekte gedeihen, wenn Sie Ihren Prozess öffentlich dokumentieren.

Wenn Sie Dinge aufschreiben, können mehr Leute an jedem Schritt des Weges teilnehmen. Vielleicht bekommen Sie Hilfe zu etwas, von dem Sie nicht einmal wussten, dass Sie es brauchen.

Dinge aufzuschreiben, ist mehr als nur technische Dokumentation. Wenn Sie den Drang verspüren, etwas aufzuschreiben oder Ihr Projekt privat zu diskutieren, fragen Sie sich, ob Sie es nicht doch öffentlich machen können.

Seien Sie transparent was die Roadmap Ihres Projekts angeht, die Arten von Beiträgen, nach denen Sie suchen, wie Beiträge überprüft werden, oder warum Sie bisherige Entscheidungen so getroffen haben.

Wenn Sie feststellen, dass mehrere Benutzer\*innen auf das gleiche Problem stoßen, dokumentieren Sie die Antworten in der README.

Ziehen Sie in Betracht, Besprechungsnotizen oder Schlussfolgerungen zu veröffentlichen. Die Rückmeldungen, die Sie aufgrund dieser Transparenz erhalten, könnten Sie überraschen.

Alles zu dokumentieren, gilt auch für Ihre Arbeit. Wenn Sie an einem umfangreichen Update Ihres Projekts arbeiten, erstellen Sie früh einen Pull Request und kennzeichnen Sie ihn als "Work in Progress" (WIP). So fühlen sich andere Personen frühzeitig in den Prozess eingebunden.

### Antworten Sie schnell

Wenn Sie [für Ihr Projekt werben](../finding-users), werden Leute Ihnen Rückmeldungen geben. Vielleicht in Form von Fragen, wie etwas in Ihrem Projekt funktioniert, oder sie brauchen Starthilfe bei der Benutzung.

Versuchen Sie, schnell zu reagieren, wenn jemand ein Issue oder Pull Request einreicht, oder eine Frage zu Ihrem Projekt stellt. Eine schnell Antwort gibt den Leuten das Gefühl, an einem Dialog teilzunehmen, und das kann ermutigend wirken, weiter mitzuhelfen.

Auch wenn Sie die Anfrage nicht sofort inhaltlich prüfen können, hilft die frühzeitige Bestätigung, das Engagement zu erhöhen. Ein Beispiel: @tdreyno reagiert auf einen Pull Request an [Middleman](https://github.com/middleman/middleman/pull/1466):

![Pull Request an Middleman](/assets/images/building-community/middleman_pr.png)

[Eine Mozilla-Studie fand heraus, dass](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) Kontributor\*innen, deren Codebeitrag innerhalb von 48 Stunden überprüft wurde, deutlich häufiger nochmal mithalfen.

Ihr Projekt kann an allen möglichen Stellen des Internets besprochen werden, wie z.B. auf Stack Overflow, Twitter oder Reddit. Dort können Sie Benachrichtigungen einrichten, um über Erwähnungen Ihres Projektes informiert zu werden.

### Geben Sie Ihrer Gemeinschaft einen Ort, an dem sie sich versammeln kann.

Es gibt zwei Gründe, Ihrer Gemeinschaft einen Ort der Begegnung zu geben.

Der erste Grund ist, Menschen mit gemeinsamen Interessen zu helfen, sich kennenzulernen. Menschen mit gemeinsamen Interessen wollen sich zwangsläufig treffen können, um über diese zu reden. Wenn die Kommunikation öffentlich und zugänglich ist, kann jede\*r die Archive lesen, um sich auf den neuesten Stand zu bringen und sich daran zu beteiligen.

Der zweite Grund nützt Ihnen selbst: Wenn Sie den Leuten _keinen_ öffentlichen Ort geben, um über Ihr Projekt zu sprechen, werden sie wahrscheinlich direkt mit Ihnen in Verbindung treten. Am Anfang mag es einfach erscheinen, hin und wieder mal auf private Nachrichten zu antworten, aber mit der Zeit, besonders wenn Ihr Projekt populär wird, werden Sie sich erschöpft fühlen und der Versuchung widerstehen, mit Leuten über Ihr Projekt privat zu kommunizieren, anstatt sie an einen bestimmten öffentlichen Kanal zu verweisen.

Öffentliche Kommunikation kann ganz einfach sein: Bitten Sie Leute, ein Issue zu öffnen, anstatt Ihnen direkt eine E-Mail zu schreiben oder in Ihr Blog zu kommentieren. Sie können für Leute, die über Ihr Projekt sprechen möchten, auch eine Mailingliste einrichten oder einen Twitter-Account, einen Slack- oder IRC-Kanal. Oder all dies gleichzeitig ausprobieren!

[Kubernetes' Kops](https://github.com/kubernetes/kops#getting-involved) legt alle zwei Wochen Bürozeiten fest, um den Mitgliedern der Gemeinschaft zu helfen:

> Die Kops-Betreuer\*innen haben sich bereit erklärt, Zeit einzuplanen für die Arbeit mit Neuankömmlingen, die Unterstützung von Pull Requests, sowie für die Diskussion über neue Funktionen.
>
> Kops also has time set aside every other week to offer help and guidance to the community. Kops maintainers have agreed to set aside time specifically dedicated to working with newcomers, helping with PRs, and discussing new features.

Wichtige Ausnahmen von öffentlicher Kommunikation sind: 1) Sicherheitsprobleme und 2) Verstöße gegen den Verhaltenskodex; Sie sollten immer eine Möglichkeit anbieten, solche Probleme privat zu melden. Wenn Sie Ihre persönliche E-Mail-Adresse dafür nicht verwenden möchten, richten Sie eine dedizierte Adresse ein.

## Ihre Nutzergemeinschaft vergrößern

Eine Gemeinschaft kann sehr kraftvoll sein. Dies kann zu Segen und Fluch werden, je nach Art der Nutzung. Wenn die Projektgemeinschaft wächst, gibt es Möglichkeiten, ihr zu einer konstruktiven Kraft zu verhelfen, anstatt zu einer destruktiven.

### Dulden Sie keine destruktiven Akteure

Jedes populäre Projekt wird unweigerlich Menschen anziehen, die Ihrer Gemeinschaft mehr schaden als helfen. Beispielsweise indem Sie können unnötige Debatten starten, über triviale Dinge streiten oder andere schikanieren.

Tun Sie Ihr Bestes, um eine Null-Toleranz-Politik gegenüber solchen Leuten zu verfolgen. Denn wenn obiges Verhalten unsanktioniert bleibt, werden andere Kontributor\*innen sich genervt fühlen und evtl. sogar Ihr Projekt verlassen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">

  Es ist wahrlich wichtig, eine unterstützende Gemeinschaft zu haben. Ohne die Hilfe meiner Kollegen\*innen, freundlicher Fremder aus dem Internet und gesprächiger IRC-Kanäle wäre ich nie in der Lage, diese Arbeit zu tun. (...) Geben Sie sich nicht mit weniger zufrieden. Geben Sie sich nicht mit Arschlöchern zufrieden.

  _The truth is that having a supportive community is key. I'd never be able to do this work without the help of my colleagues, friendly internet strangers, and chatty IRC channels. (...) Don't settle for less. Don't settle for assholes._

  <p markdown="1" class="pquote-credit">
— @okdistribute, ["How to Run a FOSS Project"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Regelmäßige Debatten über triviale Aspekte Ihres Projekts lenken alle davon ab, sich auf wichtige Aufgaben zu konzentrieren. Neue Leute, die zu Ihrem Projekt kommen, können diese Gespräche sehen und wollen nicht teilnehmen.

Wenn Sie ein destruktives Verhalten in Ihrem Projekt beobachten, sprechen Sie es öffentlich an. Erklären Sie freundlich aber bestimmt, warum so etwas nicht akzeptabel ist. Wenn das Problem weiterbesteht, müssen Sie die [Verursacher\*innen bitten, das Projekt zu verlassen](../code-of-conduct/#ihre-verantwortung-als-maintainerin), Ihr [Verhaltenskodex](../code-of-conduct/) kann eine konstruktive Anleitung für solche Gespräche sein.

### Holen Sie Mitwirkende dort ab, wo sie sich stehen

Eine gute Dokumentation wird nur immer wichtiger, je mehr Ihre Community wächst. Gelegenheitskontributor\*innen, die mit Ihrem Projekt nicht vertraut sind, lesen Ihre Dokumentation, um schnell den nötigen Überblick zu bekommen.

Geben Sie in Ihrer CONTRIBUTING-Datei explizit an, wie sie anfangen sollen. Vielleicht möchten Sie sogar eine eigene Sektion für diesen Zweck einrichten: [Django](https://github.com/django/django) zum Beispiel, hat eine spezielle Startseite, die neue Mitwirkende willkommen heißt.

![Djangos Startseite für neue Mitwirkende](/assets/images/building-community/django_new_contributors.png)

Die Liste der Issues sollte durchsortiert sein, Bugs z.B. als solche markiert, sowie Issues auch für unterschiedliche potentielle Kontributor\*innen: z.B. [_"first timers only"_](https://kentcdodds.com/blog/first-timers-only), _"good first issue"_, oder _"documentation"_. [Solche  "Labels"](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) vereinfachen es Neuankömmlingen, sich in Ihrem Projekt zurechtzufinden und mit der Lösung eines Problems zu beginnen.

Nicht zuletzt sollten Sie die Dokumentation nutzen, um Leute mit offenen Armen zu empfangen und ihnen Schritt-für-Schritt zu helfen.

Sie werden mit den meisten Leuten, die auf Ihr Projekt stoßen nie interagieren. Ihnen könnten Beiträge entgehen, weil jemand sich eingeschüchtert fühlte, oder nicht herausfand, was es denn zu tun gab. Schon ein paar freundliche Worte können verhindern, dass jemand einfach weiter zieht.

Zum Beispiel: [Rubinius](https://github.com/rubinius/rubinius/) beginnt [den Kontributionsratgeber](https://github.com/rubinius/rubinius/blob/master/.github/contributing.md) mit:

> Zum Einstieg möchten wir Dir erstmal unseren Dank aussprechen, dass Du Rubinius nutzt. Dieses Projekt wurde mit viel Liebe aufgebaut und wir schätzen alle Benutzer\*innen, die Fehler aufspüren, Geschwindigkeitsverbesserungen vornehmen und bei der Dokumentation helfen. Jeder Beitrag bedeutet uns etwas, also vielen Dank für Ihre Teilnahme! Wir bitten Sie jedoch, einige Richtlinien zu befolgen, damit wir Ihr Issue erfolgreich bearbeiten können.
>
> We want to start off by saying thank you for using Rubinius. This project is a labor of love, and we appreciate all of the users that catch bugs, make performance improvements, and help with documentation. Every contribution is meaningful, so thank you for participating. That being said, here are a few guidelines that we ask you to follow so we can successfully address your issue.

### Teilen Sie die Eigentümerschaft an Ihrem Projekt

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">

  Ihre Projektverantwortlichen werden unterschiedliche Meinungen haben, wie es in allen gesunden Gemeinschaften üblich sein sollte. Sie müssen jedoch dafür sorgen, dass nicht immer die lauteste Stimme gewinnt, weil sie andere Leute ermüdet, und dass weniger prominente Stimmen und Minderheitsmeinungen ebenfalls zu hören sind.

  _Your leaders will have different opinions, as all healthy communities should! However, you need to take steps to ensure the loudest voice doesn't always win by tiring people out, and that less prominent and minority voices are heard._

  <p markdown="1" class="pquote-credit">
— @sagesharp, ["What makes a good community?"](http://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Leute sind begeistert davon, an Projekten mitzuwirken, wenn sie ein Gefühl für Verantwortung bekommen. Das bedeutet nicht, dass Sie Ihre Projektvision umdrehen müssen, oder Beiträge annehmen, die Sie nicht wollen. Je mehr Anerkennung Sie anderen Menschen jedoch zollen, desto eher werden diese bei Ihrem Projekt bleiben.

Schauen Sie, ob Sie Wege finden können, Verantwortlichkeiten so weit wie möglich mit Ihren Projektteilnehmer\*innen zu teilen:

* **Lassen Sie einfache (unkritische) Bugs unangetastet.** Nutzen Sie diese stattdessen als Gelegenheit, neue Mitwirkende zu rekrutieren, oder helfen Sie einem hilfsbereiten Neuling, den Prozess eines Bug-Fixes zu durchlaufen. Es mag zunächst unnatürlich erscheinen, aber Ihre Investition wird sich im Laufe der Zeit auszahlen. @michaeljoseph hat zum Beispiel einen Mitwirkenden gebeten, einen Pull Request zu einem der folgenden Probleme in [Cookiecutter](https://github.com/audreyr/cookiecutter) zu stellen, anstatt es selbst zu beheben.

![Cookiecutter-Issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Führen Sie eine CONTRIBUTORS- oder AUTHORS-Datei in Ihrem Projekt**, die alle Leute aufzählt, die einen Beitrag geleistet haben, wie z.B. bei [Sinatra](https://github.com/sinatra/sinatra/blob/master/AUTHORS.md).

* Wenn Sie schon eine etwas größere Gemeinschaft versammelt haben, **senden Sie eine Rundmail oder schreiben ins Blog**, dass Sie Kontributor\*innen danken. Rusts [This Week in Rust](https://this-week-in-rust.org/) und Hoodies [Shoutout-Grüße](http://hood.ie/blog/shoutouts-week-24.html) sind zwei gute Beispiele dafür.

* **Geben Sie allen Kontributor\*innen Schreibzugriff.** @felixge fand heraus, dass dies Leute [zu mehr Feinschliff ihrer Beiträge anspornt](https://felixge.de/2013/03/11/the-pull-request-hack.html), und gewann sogar neue Maintainer\*innen für Projekte, an denen er selbst schon eine Weile nicht mehr arbeitete.

* Wenn Ihr Projekt auf GitHub liegt, **verschieben Sie es von Ihrem Privat-Konto in das einer [Organisation](https://help.github.com/articles/creating-a-new-organization-account/)** und fügen Sie zur Sicherheit mindestens eine\*n weitere\*n Administrator\*in hinzu. Organisationen machen die Zusammenarbeit mit externen Mithelfenden einfacher.

Realistischerweise haben [die meisten Projekte](https://peerj.com/preprints/1233.pdf) nur einen oder zwei Verantwortliche, welche die meiste Arbeit erledigen. Ja größer Ihr Projekt, und je größer seine Nutzer\*innengemeinschaft, desteo einfacher wird es sein, Hilfe zu finden.

Während Sie vielleicht nicht immer Leute finden, die einem Aufruf folgen, erhöht so ein Signals doch die Wahrscheinlichkeit, dass Andere mitmachen. Je früher Sie damit anfangen, desto eher können die Leute helfen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">

  \[Es liegt in Deinem Interesse\], Mitwirkende zu rekrutieren, die Spaß daran haben und fähig sind, die Aufgaben zu erledigen, die Du nicht schaffst. Wenn Sie gerne programmieren, aber keine Issues beantworten möchten, dann identifizieren Sie die Personen in Ihrem Projekt, die es möchte, und lassen Sie sie einfach machen.

  _\[It's in your\] best interest to recruit contributors who enjoy and who are capable of doing the things that you are not. Do you enjoy coding, but not answering issues? Then identify those individuals in your community who do and let them have it._

  <p markdown="1" class="pquote-credit">
— @gr2m, ["Welcoming Communities"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Konflikte beilegen

In der Anfangsphase Ihres Projekts ist es einfach, wichtige Entscheidungen zu treffen: Wenn Sie etwas tun wollen, dann tun Sie es einfach.

Je beliebter Ihr Projekt wird, desto mehr Menschen werden sich für von Ihnen getroffene Entscheidungen interessieren. Selbst wenn Sie keine große Gemeinschaft von Mitwirkenden haben: Wenn Ihr Projekt viele Benutzer\*innen hat, werden darunter Leute sein, die sich über Entscheidungen auslassen oder ihre eigenen Themen ansprechen.

Wenn Sie eine freundliche, respektvolle Gemeinschaft gepflegt und Ihre Prozesse offen dokumentiert haben, sollten Alle zur Lösungsfindung in der Lage sein. Aber manchmal stoßen Sie auf ein Problem, das etwas schwieriger zu lösen ist.

### Setzen Sie die Messlatte für Freundlichkeit

Wenn sich Ihre Gemeinschaft mit einem schwierigen Thema auseinandersetzt, können sich Gemüter schnell mal erhitzen. Menschen können wütend oder frustriert werden und es an Anderen oder an Ihnen auslassen.

Ihre Aufgabe als Maintainer\*in ist es, solche Situationen vor einer Eskalation zu bewahren. Selbst wenn Sie eine klare eigene Meinung zu diesem Thema haben, versuchen Sie, die moderierende Position einzunehmen, anstatt sich in den Kampf zu stürzen und Ihre Ansichten durchzusetzen. Wenn jemand unfreundlich wird oder das Gespräch an sich reißt, [handeln Sie sofort](../building-community/#dulden-sie-keine-destruktiven-akteure), um die Diskussionen zivil und produktiv zu halten.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">

  Als Projektbetreuer\*in ist es äußerst wichtig, dass Sie Ihren Mitwirkenden gegenüber respektvoll sind, denn sie nehmen das, was Sie sagen, oft sehr persönlich.

  _As a project maintainer, it's extremely important to be respectful to your contributors. They often take what you say very personally._

  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Be Cordial or Be on Your Way"](https://www.kennethreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

Andere Leute erwarten von Ihnen, ein gutes Beispiel abzugeben. Sie können immer noch Enttäuschung, Unzufriedenheit oder Besorgnis ausdrücken, aber tun Sie dies auf eine ruhige Art und Weise.

Es ist nicht einfach, einen kühlen Kopf zu bewahren, aber Führung zu zeigen, verbessert die Gesundheit der Gemeinschaft. Das Internet wird es Ihnen danken!

### Nutzen Sie die README als Verfassung

Ihre README-Datei ist [mehr als nur eine Anleitung](../starting-a-project/#eine-readme-schreiben). Sie ist auch das Dokument, das Ihre Ziele, Ihre Produktvision und Ihre Roadmap aufzeigt. Wenn die Leute sich zu sehr darauf konzentrieren, über die Vorzüge einer bestimmten Funktion zu diskutieren, kann es helfen, Ihre README zu überprüfen und das überragende Ziel Ihres Projekts anzusprechen. Der Verweis auf Ihre README entpersönlicht eine Diskussion auch, sodass Sie wieder konstruktiver geführt werden kann.

### Der Weg ist das Ziel

Einige Projekte nutzen einen Abstimmungsprozess, um wichtige Entscheidungen zu treffen. Auf den ersten Blick ist es sinnvoll, so eine Antwort zu finden, anstatt sich gegenseitig zuzuhören und auf die Sichtweisen Anderer einzugehen.

Abstimmungen können aber politisch werden, wenn sich die Community-Mitglieder unter Druck gesetzt fühlen, sich gegenseitig einen Gefallen zu tun oder auf eine bestimmte Wahl zu treffen. Außerdem stimmt nicht jede\*r mit ab, z.B. weil es ein [stille Mehrheit](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) in Ihrer Gemeinschaft geben könnte, oder neue Benutzer\*innen einfach nicht wussten, dass eine Abstimmung stattfindet.

Manchmal ist eine Abstimmung notwendig, um ein Patt aufzulösen. Aber soviel Sie können, betonen Sie die [Konsensfindung](https://de.wikipedia.org/wiki/Konsensprinzip) statt des Konsenses an sich.

Im Rahmen der Konsensfindungsprozesses diskutieren die Mitglieder der Gemeinschaft wichtige Anliegen, bis sie das Gefühl haben, angemessen gehört worden zu sein, und wenn nur noch geringe Bedenken bestehen, kommt die Gemeinschaft voran. Die Konsensfindung erkennt an, dass eine Gemeinschaft möglicherweise keine perfekte Antwort finden kann. Stattdessen priorisiert sie das Zuhören und die Diskussion.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">

  Für Atom-Issues gibt es kein Abstimmungssystem, weil z.B. das Atom-Team nicht in allen Fällen einem Abstimmungssystem folgen würde. Manchmal müssen wir uns für etwas entscheiden, das wir für richtig halten, auch wenn es unbeliebt ist. (...) Was ich anbieten und versprechen kann: Es ist meine Aufgabe, der Community zuzuhören.

  _Part of the reason why a voting system doesn't exist for Atom Issues is because the Atom team isn't going to follow a voting system in all cases. Sometimes we have to choose what we feel is right even if it is unpopular. (...) What I can offer and pledge to do (...) is that it is my job to listen to the community._

  <p markdown="1" class="pquote-credit">
— @lee-dohm on [Atom's decisionmaking process](https://discuss.atom.io/t/prioritize-issues-feature-requests-based-on-voting-system/27642/2)
  </p>
</aside>

Auch wenn Sie als Projektbetreuer\*in keine Konsensfindung betreiben möchten, ist es wichtig, dass die Leute ein offenes Ohr bei Ihnen finden. Anderen zuzuhören, und sich für die Lösung ihrer Probleme einzusetzen, hilft beim Entschärfen sensibler Situationen sehr. Lassen Sie Ihren Worten aber auch Taten folgen.

Überstürzen Sie Entscheidungen nicht, nur um eine Lösung herbeizuführen. Stellen Sie sicher, dass jede\*r sich gehört fühlt und dass alle Informationen öffentlich gemacht wurden, bevor Sie sich auf eine Entscheidung zubewegen.

### Halten Sie Diskussionen fokussiert auf Aktionen

Diskussionen sind wichtig, aber es gibt einen Unterschied zwischen produktiven und unproduktiven Gesprächen.

Fördern Sie Diskussionen, die sich aktiv auf eine Lösung zubewegen: Wenn klar ist, dass Dinge zerredet werden, oder die Konversation vom Thema abweicht, persönliche Anfeindungen passieren, oder die Leute sich über kleine Details streiten, ist es Zeit für eine Beendigung der Diskussion.

Die Fortsetzung solcher Diskussionen ist nicht nur schlecht für das jeweilige Thema, sondern auch für die Gesundheit Ihrer Gemeinschaft. Die Botschaft zu vermitteln, dass unproduktive Diskussionen erlaubt oder sogar gefördert werden, könnte Leute zukünftig davon abgehalten werden, Probleme anzusprechen oder zu lösen.

Bei jedem Diskussionsbeitrag ihrerseits, oder von Anderen, sollten Sie sich fragen _"Wie bringt uns dies einer Lösung näher?"_

Falls die Diskussion abdriftet, fragen Sie die Teilnehmer\*innen: _"Welche Schritte sollten wir als nächstes gehen?"_ um sie wieder zu fokussieren.

Wenn eine Diskussion offensichtlich nirgendwo hinführt, es keine klaren Maßnahmen zu ergreifen gibt, oder schon welche ergriffen wurden, schließen Sie das Issue und erklären Sie, warum Sie es geschlossen haben.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">

  Eine Diskussion unaufdringlich zu einem nützlichen Ziel zu führen, ist eine Kunst. Es wird nicht funktionieren, Menschen einfach zu ermahnen, Ihre Zeit nicht mehr zu verschwenden, oder sie zu bitten, nicht zu posten, wenn sie nichts Konstruktives zu sagen haben. (...) Stattdessen müssen Sie Bedingungen für weitere Fortschritte vorschlagen: Zeigen Sie den Menschen einen Weg auf, der zu den Ergebnissen führt, die Sie wollen, aber ohne zu diktieren, wie Sie sich verhalten.

  _Guiding a thread toward usefulness without being pushy is an art. It won't work to simply admonish people to stop wasting their time, or to ask them not to post unless they have something constructive to say. (...) Instead, you have to suggest conditions for further progress: give people a route, a path to follow that leads to the results you want, yet without sounding like you're dictating conduct._

  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### Wählen Sie Auseinandersetzungen mit Bedacht

Der Kontext ist wichtig: Überlegen Sie, wer an der Diskussion beteiligt ist und wie die Diskutanten den Rest der Gemeinschaft repräsentieren.

Ist jeder in der Community verärgert oder gar mit diesem Thema beschäftigt? Oder ist er ein\*e einzelner Unruhestifter\*in? Berücksichtigen Sie nicht nur die Aktiven, sondern vergessen Sie Ihre stillen Community-Mitglieder nicht.

Wenn das Thema nicht die breiteren Bedürfnisse Ihrer Gemeinschaft widerspiegelt, müssen Sie vielleicht nur die Sorgen einiger Weniger anerkennen. Wenn es sich um ein wiederkehrendes Problem ohne klare Lösung handelt, weisen Sie sie auf frühere Diskussionen hin und schließen Sie das Issue.

### Identifizieren Sie einen Community-Tiebreaker

Mit einer positiven Herangehensweise und klarer Kommunikation sind die schwierigsten Situationen lösbar. Aber auch in einem produktiven Gespräch kann es einfach zu Meinungsverschiedenheiten kommen. Identifizieren Sie dann eine Person oder Gruppe, die quasi als Schiedsrichter\*in fungieren kann.

Ein\*e solche\*r Schiedsrichter\*in kann die oder der Hauptverantwortliche für das Projekt sein, oder eine kleine Gruppe von Leuten, die über eine Entscheidung abstimmen. Idealerweise haben Sie einen Tiebreaker und den damit verbundenen Prozess in einer GOVERNANCE-Datei identifiziert, bevor Sie diese verwenden müssen.

Ihr\*e Schiedsrichter\*in sollte der letzte Ausweg sein, denn zunächst entzweiend wirkende Probleme sind eine Chance für Ihre Gemeinschaft, zu wachsen und zu lernen. Nutzen Sie diese Möglichkeiten, um in einem gemeinsamen Prozess zu einer Lösung zu kommen, wo immer dies möglich ist.

## Das ❤️ von Open-Source sind Gemeinschaften

Gesunde, blühende Gemeinschaften sorgen für den Antrieb für Tausende von Stunden, die jede Woche in Open-Source gesteckt werden. Viele Mitwirkende verweisen auf andere Menschen als Grund dafür, an Open-Source zu arbeiten (oder eben nicht). Indem Sie lernen, diese Kraft konstruktiv zu nutzen, werden Sie jemandem da draußen helfen, ein unvergessliches Open-Source-Erlebnis zu haben.
