---
lang: zh-tw
title: 找尋專案的使用者
description: 透過使用者的心得來幫助你的開源專案成長。
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## 四處傳播

沒有規定說應該怎麼去倡導剛創建的開源專案。但沒有任何理由說必須默默無聞的在開源專案上工作。相反，如果你向有更多的人發現和使用你的開源專案，你就應該讓所有人知道你所努力的成果！

## 發出自己的聲音

在你開始推廣你的專案之前，你應該能夠解釋你的專案是做什麼的，爲什麼大家需要他?

是什麼讓你的專案變得不同或者有趣，在自己心中問這些問題會讓你更容易說服別人。

牢記一件事情，別人之所以使用你的專案，甚至是爲你的專案做貢獻，是因爲你的專案解決了他們的問題。所以你要找出他們需要什麼，然後把他當成你專案的賣點或者說價值所在。

舉個例子，[@robb](https://github.com/robb)用代碼實例來清晰的闡述爲什麼他的專案[Cartography](https://github.com/robb/Cartography)是有用的。

![cartography readme](/assets/images/finding-users/cartography.jpg)

如果你想深入瞭解如何挖掘專案的"賣點"，看一下Mozilla的["Personas and Pathways"](http://mozillascience.github.io/working-open-workshop/personas_pathways/)，練習如何建立用戶的形象。

## 幫助人們找到並關注你的專案

<aside markdown="1" class="pquote">
  你最好有一個唯一的"主頁"鏈接用來推廣，引導人們關注你的專案。你不需要找一個炫酷的模板或者域名，但是你的專案確實需要一個入口。
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

通過引導他們到一個唯一的地址來幫助人們發現和記住你的專案。

**要有一個推廣的主陣地。**一個Twitter賬號，Github鏈接，或者IRC頻道是引導人們查看你們專案的一個簡單的方式。這些方式也給你日益增長的社群一個討論的好地方。

如果你目前還不想給你的專案搞這麼多亂七八糟的東西，而且還要在有機會的時候推廣你的Twitter帳號和Github帳號。舉個例子，如果你某一個討論會或者活動上發言要保證在你的簡歷或者幻燈片上包含這些資訊。只有這樣人們才會知道怎麼找到你或者關注你的工作。

<aside markdown="1" class="pquote">
  <img src="https://avatars2.githubusercontent.com/u/131416?v=3&s=400" class="pquote-avatar" alt="avatar">
  我之前犯過的一個錯誤就是沒有給專案開一個Twitter帳號。Twitter是一個讓人們知曉專案進展的好渠道，也可以讓人們持續的接觸到你的專案。
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**考慮給你的專案做一個網站**一個網站可以讓你的專案更加友好，而且更加容易瀏覽，更重要的是附上清晰的文檔和教程。這也是象徵著你的專案還是活躍的，這會讓你的用戶使用你專案的時候感覺更放心。可以用一些例子告訴人們如何使用的專案。

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), Django的協作者說，我們給Django做的網站可以說是"在早期開發Django的時候做的最好的一件事情了"。

如果你的專案是託管在GitHub上的，你可以用[GitHub Pages](https://pages.github.com/)簡單的創建一個網站。[Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), and [Middleman](https://middlemanapp.com/) 是一些優秀的內容詳盡的網站的[例子](https://github.com/showcases/github-pages-examples)

![vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

現在你的專案有了"賣點"，和讓人們很容易發現你專案的渠道，接下來我們談談如何和你的用戶交流吧！

## 到你專案的受眾在的地方去（線上）

網上拓展是分享和快速宣傳專案的一個好方法。藉助一些網上的渠道，你有可能找到一大批受眾。

利用既有的線上社群和平臺去找你的受眾。如果你的開源專案是一個軟件專案，你可能會在[Stack Overflow](http://stackoverflow.com/), [reddit](http://www.reddit.com), [Hacker News](https://news.ycombinator.com/), 或者[Quora](https://www.quora.com/)。找到你覺得人們會最有可能從你的專案中受益或者對你專案感興趣的渠道。

<aside markdown="1" class="pquote">
  <img src="https://avatars1.githubusercontent.com/u/169328?v=3&s=400" class="pquote-avatar" alt="avatar">
  每個程序都會有那麼一些方法只有一部分人才會用到，所以不要想著去打擾每一個人，把你的力氣用在可能會從你專案受益的社群就好。
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](http://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

來看看下面的一些方法吧，也許推廣你的專案的時候用得著。

* **快找找有沒有相關的開源專案和社群。**有時候，你不需要直接的推廣你的專案。如果你的專案對使用Python的數據科學家來說是無可挑剔的，那麼就去找Python數據科學的社群。等他們知道你的專案之後，很自然的就會談論然後分享你的工作成果。
* **如果你專案嘗試解決某些問題，那麼找到會遇到這些問題的人。**想象你的專案受眾會在哪些論壇，然後搜索這些論壇，回答他們的問題，然後找一個合適的實際，向他們建議使用你的專案來作爲一種解決方案。
* **尋求反饋。**給一個可能會用到你專案的人介紹你自己和你做的工作。對哪些人會從你的專案受益要很明確。嘗試完善一下下面這句話："我覺得我的專案能夠幫助A，那些嘗試做B的人"。聽取和回覆別人的反饋，而不是簡單的推廣。

一般來說，在你索取什麼回報之前先把精力放在幫助別人上。因爲在網上推廣一個專案對任何人都是一個不難的事情，所以有很多人和坐著一樣的事。告訴人們你是誰，而不是你想要什麼，這樣才能從眾多推廣者中脫穎而出。

如果沒有人對你的推廣感興趣，不要灰心！大部分的專案的開展都是一個要花費數月和數年的反覆過程。如果你第一次沒收到反應，嘗試換一種策略，或者找辦法給別人的專案做做貢獻。這都是些需要時間和奉獻精神的事情。

## 到你專案受眾在的地方去（線下）

![public speaking](/assets/images/finding-users/public_speaking.jpg)

線下活動是一個推廣專案流行的方式。這是一個接觸某個忠實聽眾和建立深層次的聯繫的好方式，特別是如果你對到場的開發者感興趣的話。

如果你還是個[公中演講的新手](http://speaking.io/)，從尋找一個和你專案使用的語言或者生態系統相關的當地的聚會開始吧。

<aside markdown="1" class="pquote">
  <img src="https://avatars0.githubusercontent.com/u/83444?v=3&s=460" class="pquote-avatar" alt="avatar">
  我去Pycon的時候非常緊張。我要發表一個演講，在那兒我就認識幾個人，還在那兒呆了整個周。但是其實我不應該焦慮的。Pycon真是太他媽吊了！每個人都是超級友好外向，以至於我沒有找到時間和人們講話。
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

如果你從來沒在公共場合講過話，感覺緊張那就太正常啦！記住你的聽眾就在哪兒，因爲他們都是真正的想聽你介紹你的專案。

當你在寫你的演講稿的時候，把重點放在你的聽眾會感興趣而且能獲取價值的事情上。保證你的語言要友好和和藹可親。笑一笑，深呼吸，幽默一點兒。

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  當你開始寫你的演講稿的時候，不管你的主題是什麼，如果你能把你的演講當成是給別人講故事的話，效果會更更好。
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

等你準備好了，考慮一下在某個會議上發言的時候推廣你的專案研討會可以幫助你接觸更多人，有時候是來自全世界各地的人。

<aside markdown="1" class="pquote">
  <img src="https://avatars2.githubusercontent.com/u/80?v=3&s=460" class="pquote-avatar" alt="avatar">
  我非常認真的給JSConf的人寫了一封信，然後求他們給我一點時間讓我JSConf上展示我的專案。同時我又非常擔心，這個專案我做了六個月，要是大家不認可怎麼辦。那時候我就一直在想，我的天，我他媽在這裏是幹嗎？
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## 贏得口碑

除了上面提到的策略之外，邀請人們分享和支持你的專案的最好辦法就是分享和支持他們的專案。

幫助新手，分享資源，給別人的專案認真的做貢獻會幫助你建立起良好的聲譽。然後他們就很有可能知道你的專案而且更有可能關注和分享你在做的事情。

有時候，這些關係還會進一步發展成更廣闊的生態系統中的官方合作伙伴（意思即使你有可能成爲那些有名社群的成員）

<aside markdown="1" class="pquote">
  <img src="https://avatars2.githubusercontent.com/u/6292?v=3&s=400" class="pquote-avatar" alt="avatar">
  urllib3之所以成為最流行的Python第三方庫的唯一原因就是大家都需要他。
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov)
  </p>
</aside>

種一棵樹最好的時候是十年前，其次是現在。所以何時開始建立你的聲望都不晚。即使是你早就已經建立了自己的專案，還是要繼續找辦法幫助別人。

建立用戶群沒有一蹴而就的方法。獲取別人的新人和尊重需要時間，同樣，建立聲望的過程也永遠不會停止。

<aside markdown="1" class="pquote">
  <img src="https://avatars1.githubusercontent.com/u/7288?v=3&s=460" class="pquote-avatar" alt="avatar">
  PhantomJS公開第一個版本的時候實在2011年初。我也就是用一些常規的方法來推廣：發Twitter，寫博客告訴別人可以用它來做什麼，在各種各樣的聚會上我都提到過它。當2014年他已經廣爲人知的時候。我才開始做關於它的演講。
  <p markdown="1" class="pquote-credit">
— @ariya, ["Maintainer Stories"](https://github.com/open-source/stories/ariya)
  </p>
</aside>

## 保持精進

有時候，讓人麼注意你的開源專案會花費很多時間。但是沒關係！現在很多流行的專案也都是花了很多年才有今天的活躍度。把重點放在建立聲望上而不是企圖一夜成名。耐心一點，一如既往的和那些可能會從中受益的人們分享你的專案。
