---
lang: zh-tw
title: 建立一套行為準則
description: 為了促進社羣朝健康且有建設性的方向發展，必須設立一個共同遵守的行為守則。
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## 我爲什麼需要行爲守則

行爲守則是一份確立專案參與者行爲規範的文件。採用和執行行爲守則可以幫助你們的社群營造積極的氛圍。

行爲守則不僅幫助保護你們的參與者，同時還有你們自己。如果你們維護一個專案，隨着時間的推移，可能會發現其他參與者懶散的態度會讓你們疲憊或對工作不滿意。

一份行爲守則可以幫助你們促進健康，有建設性的社群行爲。積極主動減少你們或其他人在你們的專案中變得疲勞的可能性，並幫助你們在有人做出你們不同意的事情時採取行動。

## 建立行爲守則

儘可能早地建立行爲守則，當你們第一次創建專案的時候。

此外，說出你們的要求。行爲守則的描述遵循如下幾點：

* 行爲守則在哪裏有效 _(只在issues以及pull requests，或者社群活動？)_
* 行爲守則適用於誰 _(社群成員以及維護者，那贊助商呢？)_
* 如果有人違反了行爲守則會怎樣？
* 大家如何舉報違規

無論你們在哪裏，請使用已有的行爲守則。[貢獻者盟約](http://contributor-covenant.org/)是一個被超過40，000個開源專案（包括Kubernetes, Rails和Swift）所使用的行爲守則。

[Django行爲守則](https://www.djangoproject.com/conduct/)和[Citizen行爲守則](http://citizencodeofconduct.org/)都是非常好的行爲守則。

請將CODE_OF_CONDUCT文件放在你們專案的根目錄，並在README中附上其鏈接，這樣對你們的社群是可見的。

## 決定你們如何執行行爲守則

<aside markdown="1" class="pquote">
  一份行爲守則沒有（或者不能）執行會比沒有行爲守則更糟糕。它釋放這樣一個資訊：行爲守則或者尊重在你們的社群並不重要。
  <p markdown="1" class="pquote-credit">
— [Ada Initiative](https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community/)
  </p>
</aside>

你們應該解釋如何執行行爲守則在違規發生**之前**。有幾點理由說明爲什麼這麼做：

* 必要的時候，它表示你們處事認真謹慎。

* 你們的社群會因爲投訴確實可以得到回覆而更加放心。

* 如果他們發現自己因爲違規而被調查時，你們能確保社群的審查流程是公平透明的。

你們可以給大家一個私有的渠道（如email地址）以便大家報告違規行爲以及解釋誰收到了這一的報告。它可以是維護者，一組維護者或行爲守則工作組。

請不要忘記了有人可能想要報告某些人違規接受了這些報告。在這樣的情況下，也給他們舉報那些人的機會。例如，@ctb和@mr-c [在他們的專案上解釋](https://github.com/dib-lab/khmer/blob/master/CODE_OF_CONDUCT.rst)， [khmer](https://github.com/dib-lab/khmer)：

> 對於濫用現象，擾亂或者其他不可接受的行爲都可以向**khmer-project@idyll.org**（僅由C. Titus Brown和Michael R. Crusoe處理）發送郵件。要報告涉及其中任何一個的問題，請電郵**Judi Brown Clarke，Ph.D.** BEACON行動進化研究中心的多元化主任，NSF科學技術中心。

爲了獲得靈感，可以查閱Django的[執行手冊](https://www.djangoproject.com/conduct/enforcement-manual/)（你們是否需要如此詳細的手冊，這取決於你們的專案）。

## 執行你們的行爲守則

有時，儘管你們盡了最大的努力，仍然會有人違反守則。當這樣的情況發生時，有幾種方法來解決消極或有害的行爲。

### 蒐集有關違規的資訊

認真對待社群中每個成員的想法。如果你們收到有人違規的報告，請認真對待並調查此事，即使它不符合你們自己的經驗。這樣做可以向你們的社群表面，你們珍視他們的觀點和信任他們的判斷。

有的社群成員可能是讓大家一直不舒服的慣犯，或者他們只是說了或做了一次。這都需要依據實際情況進行處理。

在你們做出迴應之前，請認真思考發生了什麼事。通過閱讀他們過去的評論和對話可以更好地理解他們爲什麼要那樣做。儘量收集其他人對他們行爲的看法。

<aside markdown="1" class="pquote">
  不要陷入爭論。在你們處理完手頭上的事情之前，不要側重於處理別人的行爲。專注於你們需要什麼。
  <p markdown="1" class="pquote-credit">
— Stephanie Zvan, ["So You've Got Yourself a Policy. Now What?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### 採取適當的行動

當蒐集和處理足夠的資訊後，你們需要決定做什麼。當你們在考慮下一步的時候，請牢記你們的目的是營造一個安全，尊重和協作的社群氛圍。不僅要考慮如何處理有問題的情況，還要考慮們的反應將如何影響你們社群的其他行爲和期望。

當有人報告違規時，處理它是你們的工作，而不是他們的。有時，報告者透露他們的資訊會給他們的職業生涯，聲譽和人生安全帶來很大的風險。迫使報告者面對騷擾者會將他們置於妥協的位置。除非報告者有特別的要求，你們應該直接和有問題的人溝通。

這裏有些方法幫助你們迴應違規行爲：

* **向相關人員發出公開警告**以及解釋他們的行爲產生了怎樣的負面影響，最好在發生問題的地方。在可能的情況下，公開溝通會向社群的其他人傳達你們認真對待行爲守則。要友善，但堅定的溝通。

* **私下接觸相關人員**向他們解釋他們的行爲對其他人產生了怎樣的負面影響。如果相關情況涉及到個人敏感資訊，你們可能會使用私有通信方式。如果你們和一些人私下溝通，對於首先報告這個情況的CC來說是個好主意，因爲他們知道你們採取了行動。在徵求他們的意見之前，請向報告人徵求同意。

有時，一個解決方案不能達到目的。有關的人可能在面對或者不改變他們的行爲時變得氣勢洶洶或敵對。在這種情況下，你會想到考慮採用強制措施。例如：

* **暫停有關人員**在專案中的工作，通過暫時禁止參與專案的任何方面執行

* **永久禁止**有關人員加入專案

對于禁止成員的做法，你們應該非常謹慎，只有在沒有其他解決方案的情況下才能使用。

## 維護者的責任和義務

行爲守則不是可以任意執行的法律。你們是行爲守則的執行者，同時你們的責任是遵守行爲守則確立的規矩。

作爲維護者，你們可以爲社群指定準則，同時你們可以根據行爲守則執行這些準則。這意味着你們需要認真處理違規行爲。報告者對他們的投訴進行了徹底和認真地審查。如果你們確定他們報告的行爲沒有違規，你們需要他們進行溝通並解釋你們爲什麼不進行處理。他們會怎樣做，取決於他們：容忍他們認爲有問題的行爲，或者停止參與社群。

如果報告的行爲沒有_技術上_的違規，這可能表面你們的社群依然存在問題，同時你們應該調查潛在的問題以及採取相應的行動。這可能包括修改你們的行爲守則，以澄清可接受的行爲和/或與行爲被舉報的人交談，並告訴他們，雖然他們沒有違反行爲守則，但是他們在期望和確定的邊緣另其他參與者感到不舒服。

最後，作爲維護者，你們給可接受的行爲建立和執行標準。你們有能力塑造專案社群的價值觀，以及參與者希望你們能 公平公正地執行這些價值觀。

## 鼓勵你們希望看見的行爲 🌎

當你們的社群變得似乎敵對或者不受歡迎時，即使是一個大家能容忍的個人行爲，也會讓你們失去很多貢獻者，你們可能再也遇不到其中的一些人。雖然執行或者採用行爲守則很難，但是營造一個受歡迎的環境將幫助你們社群成長。
