---
lang: tr
title: Projeniz için Kullanıcı Bulma
description: Açık kaynaklı projenizin, mutlu kullanıcıların eline geçerek büyümesini sağlayın.
class: finding
toc:
  spreading-the-word: Duyurmak
  figure-out-your-message: Mesajını ilet
  help-people-find-and-follow-your-project: İnsanların projenizi bulmasına ve takip etmesine yardımcı olun
  go-where-your-projects-audience-is-online: Projenizin izleyicisinin (çevrimiçi) olduğu yere gidin
  go-where-your-projects-audience-is-offline: Projenizin kitlesinin (çevrimdışı) olduğu yere gidin
  build-a-reputation: Bir itibar oluşturun
order: 3
image: "/assets/images/cards/finding.png"
related:
  - beginners
  - building
---

## Duyurmak

Başlar başlamaz açık kaynak projenizi tanıtmanız gerektiğini söyleyen bir kural yok. Açık kaynak kodlu çalışmanın popülerlikle ilgisi olmayan birçok yönü vardır. Başkalarının açık kaynak projenizi bulup kullanmasını ümit etmek yerine, yaptığınız sıkı çalışmayı duyurmanız gerekir!

## Mesajını ilet

Projenizi tanıtmaya yönelik asıl çalışmaya başlamadan önce, ne yaptığını ve neden önemli olduğunu açıklayabilmelisiniz.

Projenizi farklı veya ilginç kılan nedir? Neden yarattınız? Bu soruları kendiniz cevaplamak, projenizin önemini bildirmenize yardımcı olacaktır.

İnsanların kullanıcı olarak dahil olduklarını ve sonunda katkıda bulunduğunu unutmayın, çünkü projeniz onlar için bir problemi çözüyor. Projenizin mesajını ve değerini düşündüğünüzde, _kullanıcıların ve katkıda bulunanların_ ne isteyebileceğini onların gözünden bakmaya çalışarak görmeye çalışın.

Örneğin, @robb, projesi olan [Cartography'nin](https://github.com/robb/Cartography) neden faydalı olduğunu açıkça belirtmek için kod örnekleri kullanır:

![Cartography README](/assets/images/finding-users/cartography.jpg)

Mesajlaşmaya daha derin bir dalış yapmak için Mozilla'nın ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) egzersizini kullanıcı kimliği geliştirmek için kontrol edin.

## İnsanların projenizi bulmasına ve takip etmesine yardımcı olun

<aside markdown="1" class="pquote">
  İdeal olarak, insanları projenizle ilgili olarak tanıtabileceğiniz ve işaret edebileceğiniz tek bir "anasayfa" URL'sine ihtiyacınız var. Süslü bir şablona, hatta etkili bir alan adına sahip olmanıza gerek yoktur, ancak projenizin bir odak noktasına ihtiyacı vardır.
  <p markdown="1" class="pquote-credit">
- Peter Cooper ve Robert Nyman, ["Kodunuzun Mesajı Nasıl Yayılır"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

İnsanların projenizi tek bir alana işaret ederek bulup hatırlamalarına yardımcı olun.

**Çalışmanızı tanıtma işini açık bir şekilde ele alın.** Bir Twitter hesabı, GitHub URL'si veya IRC kanalı, insanları projenize yönlendirmenin kolay bir yoludur. Bu iletişim noktaları aynı zamanda projenizin büyüyen topluluğuna toplanacak bir yer sağlar.

Henüz projeniz için iletişim noktaları kurmak istemiyorsanız, yaptığınız her şeyde kendi Twitter veya GitHub hesabınızı tanıtın. Twitter veya GitHub hesabınızı tanıtmak, insanların sizinle nasıl iletişim kurabileceklerini veya işlerinizi takip etmelerini sağlayacaktır. Bir buluşma veya etkinlikte konuşuyorsanız, iletişim bilgilerinizin biyo veya slaytlarınıza eklendiğinden emin olun.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  Bu ilk günlerde yaptığım bir hata (...) proje için Twitter hesabı oluşturmamaktı. Twitter, insanları bir proje hakkında güncel tutmak ve insanları projeyle sürekli iletişimde bırakmak için harika bir yol.
  <p markdown="1" class="pquote-credit">
- @nathanmarz, ["Apache Storm'un ve Öğrenilen Derslerin Tarihi"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Projeniz için bir web sitesi oluşturmayı düşünün.** Bir web sitesi, projenizi daha net hale getirir ve özellikle açık belgeler ve eğitimlerle desteklendiğinde gezinmeyi kolaylaştırır. Bir web sitesine sahip olmak, projenizin aktif olduğunu ve bu sayede hedef kitlenizin kendisini daha rahat hissetmesini sağlayacaktır. İnsanlara projenizi nasıl kullanacakları hakkında fikir vermek için örnekler verin.

Django'nun yaratıcısı [@adrianholovaty](https://news.ycombinator.com/item?id=7531689) , bir web sitesinin _"ilk günlerde Django için yaptıkları en iyi şey" olduğunu söyledi_.

Projeniz GitHub'da barındırıyorsanız, kolayca web sitesi yapmak için [GitHub Pages](https://pages.github.com/) kullanabilirsiniz. [Yeoman](http://yeoman.io/) , [Vagrant](https://www.vagrantup.com/) ve [Middleman](https://middlemanapp.com/) mükemmel, kapsamlı web sitelerine [birkaç örnektir](https://github.com/showcases/github-pages-examples) .

![Vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

Artık projeniz için bir mesajınız ve insanların projenizi bulmaları için kolay bir yolu olsun, haydi çıkıp izleyicilerinizle konuşun!

## Projenizin izleyicisinin (çevrimiçi) olduğu yere gidin

Çevrimiçi sosyal yardım, mesajınızı hızla paylaşmanın ve yaymanın harika bir yoludur. Çevrimiçi kanalları kullanarak, çok geniş bir kitleye ulaşma potansiyeline sahip olursunuz.

Hedef kitlenize ulaşmak için mevcut çevrimiçi topluluklardan ve platformlardan yararlanın. Açık kaynaklı projeniz bir yazılım projesiyse, kitlenizi [Stack Overflow](https://stackoverflow.com/) , [Reddit](https://www.reddit.com) , [Hacker News](https://news.ycombinator.com/) veya [Quora](https://www.quora.com/)'da bulabilirsiniz. İnsanların işinizden en çok faydalanabileceğini veya heyecanlanacağını düşündüğünüz kanalları bulun.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Her programın, kullanıcıların yalnızca bir kısmının yararlı bulacağı çok özel işlevleri vardır. Mümkün olduğunca çok insana spam yapmayın. Bunun yerine, çabalarınızı projeniz hakkında bilgi sahibi olmaktan yararlanacak topluluklara hedefleyin.
  <p markdown="1" class="pquote-credit">
- @pazdera, ["Açık kaynak projeleri için pazarlama"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Projenizi ilgili kanallarda paylaşmanın yollarını bulabilecek misiniz bir bakın:

* **İlgili açık kaynaklı projeleri ve toplulukları tanıyın.** Bazen projenizi doğrudan tanıtmanız gerekmez. Projeniz Python'u kullanan veri bilimcileri için mükemmelse, Python veri bilimi topluluğunu tanıyın. İnsanlar sizi tanıdıkça, hakkında konuşmak ve çalışmalarınızı paylaşmak için doğal fırsatlar ortaya çıkacaktır.
* **Projenizin çözdüğü sorunu yaşayan insanları bulun.** Projenizin hedef kitlesine giren kişileri ilgili forumlarda arayın. Projenizi bir çözüm olarak önermek için sorularına cevap verin ve uygun olduğunda temkinli bir yol bulun.
* **Geri bildirim isteyin.** Kendinizi ve işinizi ilgili ve ilgi çekici bulabilecek bir kitleye tanıtın. Projenizden kimin faydalanacağını düşündüğünüz konusunda net olun. Cümleyi bitirmeye çalışın: _"Projemin gerçekten Y'yi yapmaya çalışan X'e yardım edeceğini düşünüyorum_ ." Çalışmanızı tanıtmak yerine, başkalarının geri bildirimlerini dinleyin ve bunlara yanıt verin.

Genel olarak konuşursak, karşılığında bir şey istemeden önce başkalarına yardım etmeye odaklanın. Herkes bir projeyi çevrimiçi olarak kolayca tanıtabildiğinden, çok fazla gürültü çıkacaktır. Kalabalıktan sıyrılmak için, insanlara sadece ne istediğinizi değil, kim olduğunuzu anlatmaya çalışın.

İlk duyurularınız hiç kimsesin dikkatini çekmiyorsa veya kimse cevap vermiyorsa, cesaretini kırmayın! Çoğu proje lansmanı aylar veya yıllar alabilen yinelemeli bir süreçtir. İlk kez bir yanıt alamazsanız, farklı bir taktik deneyin veya başkalarının çalışmalarına ilk olarak değer katmanın yollarını arayın. Projenizi tanıtmak ve başlatmak zaman ve özveri gerektirir.

## Projenizin kitlesinin (çevrimdışı) olduğu yere gidin

![Public speaking](/assets/images/finding-users/public_speaking.jpg)

Çevrimdışı etkinlikler, izleyicilere yeni projeler tanıtmanın popüler bir yoludur. Odaklı bir kitleye ulaşmak ve daha derin insan bağlantıları kurmak için, özellikle geliştiricilere ulaşmakla ilgileniyorsanız, harika bir yoldur.

[Topluluk karşısında konuşma konusunda](https://speaking.io/) yeniyseniz, projenizin dili veya ekosistemiyle ilgili yerel bir buluşma bularak başlayın.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  PyCon'a giderken oldukça gergindim. Bir konuşma yapıyordum, sadece birkaç kişiyi tanıyacaktım, bir hafta boyunca gidecektim. (...) Yine de bu kadar endişelenmemeliydim. PyCon olağanüstü bir harikaydı! (...) Herkes inanılmaz derecede cana yakın ve paylaşımcıydı, o kadar ki nadiren ben de konuşmak için fırsat bulabildim!
  <p markdown="1" class="pquote-credit">
- @jhamrick, ["Endişelenmeyi Durdurmayı ve PyCon'u Sevmeyi Nasıl Öğreniyorum"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Daha önce topluluk önünde konuşmadıysanız, gergin hissetmek tamamen normaldir! İzleyicilerinizin sizin için orada olduğunu unutmayın, çünkü işinizi gerçekten duymak istiyorlar.

Konuşmanızı yazarken, izleyicilerinizin ilginç bulacağı ve değer kazanacağı şeylere odaklanın. Dilinizi arkadaşça ve ulaşılabilir tutun. Gülümseyin, nefes alın ve eğlenin.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  Konuşmanızı yazmaya başladığınızda, konunuz ne olursa olsun, konuşmanızı insanlara anlattığınız bir hikaye olarak görmeniz yararlı olabilir.
  <p markdown="1" class="pquote-credit">
- Lena Reinhard, ["Teknik Konferans Konuşması Nasıl Hazırlanır ve Yazılır"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Hazır olduğunuzda, projenizi tanıtmak için bir konferansta konuşmayı düşünün. Konferanslar, bazen dünyanın her yerinden daha fazla insana ulaşmanıza yardımcı olabilir.

Dilinize veya ekosisteminize özgü konferansları arayın. Konuşmanızı göndermeden önce, konuşmanızı katılımcılar için uyarlamak ve konferansta konuşma kabul etme şansınızı artırmak için konferansı araştırın. Konferansın konuşmacılarına bakarak, izleyicilerinizi daha kolay anlayabilirsiniz.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  JSConf insanlarına çok hoş bir şekilde yazdım ve bana JSConf AB'de sunabileceğim bir yer vermeleri için yalvardım. (...) Altı aydır üzerinde çalıştığım bu şeyi sunarken son derece korktum. (...) Bütün konuşma sırasında şunu düşündüm. Aman tanrım, burada ne yapıyorum?
  <p markdown="1" class="pquote-credit">
- @ry, ["Node.js'nin Hikayesi" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Bir itibar oluşturun

Yukarıda belirtilen stratejilere ek olarak, insanları projenizi paylaşmaya ve katkıda bulunmaya davet etmenin en iyi yolu, onların projelerini paylaşma ve katkıda bulunmakdır.

Yeni gelenlere yardım etmek, kaynakları paylaşmak ve başkalarının projelerine anlamlı katkılar yapmak olumlu bir itibara kavuşmanıza yardımcı olacaktır. Açık kaynak topluluğunda aktif bir üye olmak, insanların çalışmanız için bağlam oluşturmasına yardımcı olacak ve projenize dikkat etme ve paylaşma olasılıkları artacaktır. Diğer açık kaynaklı projelerle ilişkilerin geliştirilmesi resmi ortaklıklara yol açabilir.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  Urllib3'ün günümüzdeki en popüler üçüncü parti Python kütüphanesi olmasının tek nedeni isteklerin parçası olmasıdır.
  <p markdown="1" class="pquote-credit">
- @shazow, ["Açık kaynak projeniz nasıl gelişir?"](Https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

İtibarınızı oluşturmak için asla çok erken veya geç değildir. Kendi projenizi daha önce başlatmış olsanız bile, başkalarına yardım etmenin yollarını aramaya devam edin.

Kitle oluşturmak için bir gecede çözüm yoktur. Başkalarının güvenini ve saygısını kazanmak zaman alır ve itibarınızı geliştirmek hiç tamamlanmayan bir iştir.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ariya?s=180" class="pquote-avatar" alt="avatar">
  PhantomJS ilk kez 2011 yılının başında piyasaya sürüldü. (...) Mesajını her zamanki gibi yaydım: Tweetledim, yapabileceğin şeyler hakkında blog yazıları yazdım, buluşmalarda çeşitli tartışmalar sırasında bahsettim. 2014 yılında daha iyi tanındığında, onunla ilgili sunumlar yapmaya başladım.
  <p markdown="1" class="pquote-credit">
- @ariya, ["Geliştirici Hikayeleri"](https://github.com/open-source/stories/ariya) 
  </p>
</aside>

## Devam et!

İnsanların açık kaynaklı projenizi fark etmesi uzun zaman alabilir. Sorun yok! Bugün en popüler projelerden bazılarının yüksek düzeyde faaliyet göstermesi yıllar aldı. Projenizin kendiliğinden popülerlik kazanacağını ummak yerine ilişkiler kurmaya odaklanın. Sabırlı olun ve çalışmanızı takdir edenlerle paylaşmaya devam edin.
