---
lang: pt
title: Como Contribuir para o Open Source
description: Quer contribuir para o open source? Um guia sobre como fazer contribuições, para novatos e veteranos.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Por que contribuir para o open source?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  Trabalhar no \[freenode\] me ajudou a obter várias habilidades que mais tarde usei em meus estudos na universidade e no meu atual trabalho. E penso que trabalhar em projetos open source me ajuda tanto quanto ajuda o projeto!
  <p markdown="1" class="pquote-credit">
— @errietta, ["Why I love contributing to open source software"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

Contribuir para o open source pode ser uma maneira gratificante de aprender, ensinar e construir experiência em praticamente qualquer habilidade que você possa imaginar.

Por que as pessoas contribuem para o open source? Há muitas razões!

### Melhorar as habilidades existentes

Seja codificando, desenhando interface do usuário, desenhando gráfico, escrevendo ou organizando, se você está procurando por prática, há uma tarefa para você em um projeto open source.

### Encontre pessoas que estão interessadas em coisas parecidas

Projetos open source com comunidades calorosas e acolhedoras mantêm as pessoas voltando por anos. Muitas pessoas formam amizades duradouras através da participação em open source, seja em reuniões em conferências ou conversas online sobre burritos.

### Encontre mentores e ensine outras pessoas

Trabalhar com outras pessoas em um projeto compartilhado significa que você terá que explicar como você faz as coisas, além de pedir ajuda a outras pessoas. Os atos de aprendizagem e ensino podem ser uma atividade gratificante para todos os envolvidos.

### Construa artefatos públicos que ajudam você a crescer sua reputação (e uma carreira)

Por definição, todo o seu trabalho open source é público, o que significa que você recebe exemplos gratuitos para levar a qualquer lugar como uma demonstração do que você pode fazer.

### Aprenda habilidades interpessoais

O open source oferece oportunidades para praticar habilidades de liderança e gerenciamento, como resolver conflitos, organizar equipes de pessoas e priorizar o trabalho.

### É empoderador poder fazer mudanças, mesmo pequenas

Você não precisa se tornar um contribuidor vitalício para participar no open source. Você já viu um erro de digitação em um site e desejou que alguém o consertasse? Em um projeto open source, você pode fazer exatamente isso. O open source ajuda as pessoas a sentirem propósito sobre suas vidas e como elas experimentam o mundo, e isso em si é gratificante.

## O que significa contribuir

Se você é um novo contribuidor open source, o processo pode ser intimidador. Como você encontra o projeto certo? E se você não souber codificar? E se algo der errado?

Não se preocupe! Há todo tipo de maneiras de se envolver com um projeto open source, e algumas dicas ajudarão você a aproveitar ao máximo sua experiência.

### Você não precisa contribuir com código

Um equívoco comum sobre contribuir para o open source é que você precisa contribuir com código. Na verdade, muitas vezes são as outras partes de um projeto que são [mais negligenciadas ou esquecidas](https://github.com/blog/2195-the-shape-of-open-source). Você fará um _grande_ favor ao projeto, oferecendo-se para contribuir com esses tipos de contribuições!

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  Fui elogiado pelo meu trabalho no CocoaPods, mas a maioria das pessoas não sabe que eu realmente não faço nenhum trabalho real na própria ferramenta CocoaPods. Meu tempo no projeto é principalmente gasto fazendo coisas como documentação e trabalhando na marca.
  <p markdown="1" class="pquote-credit">
— @orta, ["Moving to OSS by default"](https://realm.io/news/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Mesmo se você gosta de escrever código, outros tipos de contribuições são uma ótima maneira de se envolver com um projeto e conhecer outros membros da comunidade. Construir esses relacionamentos lhe dará oportunidades de trabalhar em outras partes do projeto.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/brettcannon?s=180" class="pquote-avatar" alt="avatar">
  Eu entrei em contato com a equipe de desenvolvimento do Python (também conhecida como python-dev) quando enviei um email para a lista de discussão em 17 de junho de 2002 sobre a aceitação do meu patch. Eu rapidamente peguei o bug do open source e decidi começar a curar os resumos de e-mail para o grupo. Eles me deram uma ótima desculpa para pedir esclarecimentos sobre um tópico, mas, mais criticamente, pude perceber quando alguém apontou algo que precisava ser consertado.
  <p markdown="1" class="pquote-credit">
— @brettcannon, ["Maintainer Stories"](https://github.com/open-source/stories/brettcannon)
  </p>
</aside>

### Você gosta de planejar eventos?

* Organize workshops ou encontros sobre o projeto, [como @fzamperin fez para NodeSchool](https://github.com/nodeschool/organizers/issues/406)
* Organize a conferência do projeto (se eles tiverem uma)
* Ajude os membros da comunidade a encontrar as conferências apropriadas e a submeter propostas de apresentação

### Você gosta de design?

* Reestruture layouts para melhorar a usabilidade do projeto
* Realize pesquisas de usuário para reorganizar e refinar a navegação ou menu do projeto, [como sugere o Drupal](https://www.drupal.org/community-initiatives/drupal-core/usability)
* Coloque junto um guia de estilo para ajudar o projeto a ter um design visual consistente
* Crie arte para camisetas ou um novo logotipo, [como os contribuidores do hapi.js fizeram](https://github.com/hapijs/contrib/issues/68)

### Você gosta de escrever?

* Escreva e melhore a documentação do projeto
* Organize uma pasta de exemplos mostrando como o projeto é usado
* Inicie uma newsletter para o projeto ou selecione resumos da lista de discussão
* Escreva tutoriais para o projeto, [como os crontribuidore do PyPA fizeram](https://github.com/pypa/python-packaging-user-guide/issues/194)
* Escreva uma tradução para a documentação do projeto

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  Sério, \[documentação\] é mega importante. A documentação até agora tem sido ótima e tem sido uma característica destruidora de Babel. Há seções que certamente poderiam ser trabalhadas e até mesmo a adição de um parágrafo aqui ou ali é extremamente apreciada.
  <p markdown="1" class="pquote-credit">
— @kittens, ["Call for contributors"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### Você gosta de organizar?

* Crie links para issues duplicadas, e sugira novos labels para issues, para manter as coisas organizadas
* Revise as issues abertas e sugira o fechamento das antigas, [como @nzakas fez para o ESLint](https://github.com/eslint/eslint/issues/6765)
* Faça perguntas de esclarecimento sobre issues abertas recentemente, para dar continuidade a discussão.

### Você gosta de codificar?

* Encontre um problema em aberto para resolver, [como @dianjin fez para o Leaflet](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* Pergunte se você pode ajudar a codificar uma nova função
* Automatize a configuração do projeto
* Melhore as ferramentas e os testes

### Você gosta de ajudar as pessoas?

* Responda a perguntas sobre o projeto, por exemplo no Stack Overflow ([como este exemplo do Postgres](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) ou Reddit
* Responda as pessoas, em questões que ainda estão abertas
* Ajude a moderar os painéis de discussão ou os canais de comunicação.

### Você gosta de ajudar os outros a codificar?

* Revise o código submetido por outras pessoas
* Escreva tutoriais sobre como um projeto pode ser usado
* Se ofereça para orientar outro contribuidor, [como @ereichert fez com @bronzdoc no Rust](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### Você não precisa apenas trabalhar em projetos de software!

Embora "open source" geralmente se refira a software, você pode colaborar em praticamente qualquer coisa. Existem livros, receitas, listas e aulas que são desenvolvidos como projetos open source.

Por exemplo:

* @sindresorhus faz a curadoria de uma [lista de listas "impressionantes"](https://github.com/sindresorhus/awesome)
* @h5bp mantém uma [lista de possíveis perguntas de entrevistas](https://github.com/h5bp/Front-end-Developer-Interview-Questions) para candidatos a desenvolvedor front-end
* @stuartlynn e @nicole-a-tesla fizeram uma [coleção de curiosidades sobre papagaios-do-mar](https://github.com/stuartlynn/puffin_facts)

Mesmo que vocẽ seja um desenvolvedor de software, trabalhar na documentação de um projeto pode ajudá-lo a começar no open source. Geralmente, é menos intimidador trabalhar em projetos que não envolvam código, e o processo de colaboração aumentará sua confiança e experiência.

## Se orientando para um novo projeto

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  Se você for a uma lista de issues e as coisas parecerem confusas, não é só você. Essas ferramentas exigem muito conhecimento implícito, mas as pessoas podem ajudá-lo a navegar e você pode fazer perguntas.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["How to Contribute to Open Source"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

Para qualquer outra coisa além de um erro de digitação, contribuir para o open source é como caminhar até um grupo de estranhos em uma festa. Se você começar a falar sobre lhamas, enquanto eles estavam mergulhados em uma discussão sobre peixinhos dourados, eles provavelmente olharão para você um pouco estranhamente.

Antes de pular cegamente com suas próprias sugestões, comece aprendendo a ler o ambiente. Isso aumenta as chances de que suas ideias sejam notadas e ouvidas.

### Anatomia de um projeto open source

Toda comunidade open source é diferente.

Passar anos em um projeto open source significa que você conheceu um projeto open source. Mude para um projeto diferente, e você pode achar que o vocabulário, as normas e os estilos de comunicação são completamente diferentes.

Dito isso, muitos projetos open source seguem uma estrutura organizacional similar. Entender os diferentes papéis da comunidade e o processo geral ajudará você a se orientar rapidamente em qualquer novo projeto.

Um típico projeto open source tem os seguintes tipos de pessoas:

* **Autor:** A pessoa ou organização que criou o projeto
* **Proprietário:** Pessoa(s) que tem propriedade administrativa sobre a organização ou repositório (nem sempre é o autor original)
* **Mantenedores:** Colaboradores que são responsáveis por conduzir a visão e gerenciar os aspectos organizacionais do projeto. (Eles também podem ser autores ou proprietários do projeto.)
* **Colaboradores:** Todos que contribuíram com algo para o projeto.
* **Membros da comunidade:** Pessoas que usam o projeto. Eles podem ser ativos em diálogos ou expressar sua opinião sobre a direção do projeto.

Projetos maiores também podem ter subcomitês ou grupos de trabalho focados em tarefas diferentes, como ferramentas, triagem, moderação da comunidade e organização de eventos. Procure no site do projeto uma página "equipe" ou no repositório procure por documentação sobre governança, para encontrar essas informações.

Um projeto também possui documentação. Esses arquivos são geralmente listados no nível superior de um repositório.

* **LICENSE:** Por definição, todo projeto open source deve ter uma [licença open source](https://choosealicense.com). Se o projeto não tiver uma licença, não é open source.
* **README:** O README é o manual de instruções que dá as boas-vindas aos novos membros da comunidade para o projeto. Isso explica por que o projeto é útil e como começar.
* **CONTRIBUTING:** Enquanto os READMEs ajudam as pessoas a _usar_ o projeto, os documentos sobre contribuição ajudam as pessoas a _contribuir_ para o projeto. Ele explica quais tipos de contribuições são necessários e como o processo funciona. Embora nem todo projeto tenha um arquivo CONTRIBUTING, sua presença sinaliza que este é um projeto acolhedor a novas contribuições.
* **CODE_OF_CONDUCT:** O código de conduta estabelece as regras básicas para o comportamento dos participantes e ajuda a facilitar um ambiente amigável e acolhedor. Embora nem todo projeto tenha um arquivo CODE_OF_CONDUCT, sua presença indica que este é um projeto acolhedor a novas contribuições.
* **Outros documentos:** Pode haver documentação adicional, como tutoriais, instruções passo a passo ou políticas de controle, especialmente em projetos maiores.

Por fim, os projetos open source usam as seguintes ferramentas para organizar a discussão. Ao ler os arquivos, você terá uma boa ideia de como a comunidade pensa e trabalha.

* **Issue tracker:** Onde as pessoas discutem issues relacionadas ao projeto.
* **Pull requests:** Onde as pessoas discutem e revisam as alterações que estão em andamento.
* **Fóruns de discussão ou listas de discussão:** Alguns projetos usam esses canais para tópicos de conversação (por exemplo, _"Como faço para ..."_ ou _"O que você acha sobre ..."_ em vez de relatórios de bugs ou solicitações de recursos). Outros usam o issue tracker para todas as conversas.
* **Canais de bate-papo:** Alguns projetos usam canais de bate-papo (como o Slack ou o IRC) para conversas casuais, colaboração e trocas rápidas.

## Encontrando um projeto para contribuir

Agora que você descobriu como os projetos open source funcionam, é hora de encontrar um projeto para contribuir!

Se você nunca contribuiu para o open source antes, siga alguns conselhos do presidente dos EUA John F. Kennedy, que uma vez disse: _"Não pergunte o que seu país pode fazer por você - pergunte o que você pode fazer pelo seu país."_

Contribuir para o open source acontece em todos os níveis nos projetos. Você não precisa pensar sobre o que exatamente será sua primeira contribuição ou como será sua aparência.

Em vez disso, comece pensando nos projetos que você já usa ou deseja usar. Os projetos para os quais você contribuirá ativamente são aqueles para os quais você voltará.

Dentro desses projetos, sempre que você se perceber pensando que algo poderia ser melhor ou diferente, aja de acordo com seu instinto.

O open source não é um clube exclusivo; é feito por pessoas como você. "Open source" é apenas um termo chique para tratar os problemas do mundo como "consertáveis".

Você pode ler um README e encontrar um link quebrado ou um erro de digitação. Ou você é um novo usuário e percebeu que algo está quebrado ou um problema que você acha que deveria estar na documentação. Em vez de ignorá-lo e seguir em frente, ou pedir a alguém para consertá-lo, veja se você pode ajudar. É disso que se trata o open source!

> [28% das contribuições casuais](https://www.igor.pro.br/publica/papers/saner2016.pdf) para o open source são de documentação, como uma correção de erro de digitação, reformatação ou escrita de tradução.

Você também pode usar um dos seguintes recursos para ajudá-lo a descobrir e contribuir para novos projetos:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](http://www.firsttimersonly.com/)
* [Your First PR](https://yourfirstpr.github.io/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](http://up-for-grabs.net/)
* [Contributor-ninja](https://contributor.ninja)

### Um checklist antes de você contribuir

Quando você encontrar um projeto para o qual gostaria de contribuir, faça uma verificação rápida para garantir que o projeto seja adequado para aceitar contribuições. Caso contrário, seu trabalho duro poderá nunca obter uma resposta.

Aqui está um checklist útil para avaliar se um projeto é bom para novos contribuidores.

**Atende a definição de open source**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  Tem licença? Geralmente, este é um arquivo chamado LICENSE na raiz do repositório.
  </label>
</div>

**O projeto aceita cotribuições ativamente**

Veja a atividade de commit no branch master. No GitHub, você pode ver essas informações na página inicial de um repositório.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  Quando foi o último commit?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  Quantos contribuidores o projeto possui?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  Com que frequência as pessoas 'commitam'? (No GitHub, você pode encontrar isso clicando em "Commits" na barra superior.)
  </label>
</div>

Em seguida, examine as issues do projeto.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Quantas issues abertas existem?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Os mantenedores respondem rapidamente às issues quando são abertas?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Existe discussão ativa sobre as issues?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    Há issues recentes?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    As issues estão sendo fechadas? (No GitHub, clique na guia "closed" na página "Issues" para ver as issues fechadas.)
  </label>
</div>

Agora faça o mesmo para os pedidos de pull requests do projeto.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Quantos pull requests abertos existem?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    Os mantenedores respondem rapidamente aos pull requests quando eles são abertos?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Há discussão ativa sobre os pull requests?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Os pull requests são recentes?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    Quão recentemente algum pull request foi aceito e incluido? (No GitHub, clique na guia "closed" na página Pull Requests para ver os PRs fechados.)
  </label>
</div>

**Projeto é acolhedor**

Um projeto que é amigavel e acolhedor indica que eles serão receptivos a novos contribuidores.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    Os mantenedores respondem de maneira útil às questões nas issues?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    As pessoas são amigáveis nas issues, no fórum de discussão e no chat (por exemplo, IRC ou Slack)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    Os pull requests são revisados?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    Os mantenedores agradecem às pessoas pelas contribuições?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Sempre que você vir uma thread longa, verifique as respostas dos principais desenvolvedores no final da thread. Eles estão resumindo construtivamente e tomando providências para levar a discussão a uma decisão de forma educada? Se você vir um monte de guerras acontecendo, isso frequentemente é um sinal de que energia esta sendo gasta em discussões em vez de desenvolvimento.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](http://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## Como submeter uma contribuição

Você encontrou um projeto que gosta e está pronto para fazer uma contribuição. Finalmente! Veja como realizar sua contribuição de forma correta.

### Se comunicando de forma eficaz

Seja você um colaborador ocasional ou esteja tentando entrar em uma comunidade, trabalhar com outras pessoas é uma das habilidades mais importantes que você desenvolverá no open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
    \[Como um contribuidor iniciante,\] eu rapidamente percebi que tinha que fazer perguntas se quisesse fechar a issue. Eu analizei o código. Assim que percebi o que estava acontecendo, pedi mais orientações. E voilà! Consegui resolver a issue depois de obter todos os detalhes relevantes de que precisava.
  <p markdown="1" class="pquote-credit">
— @shubheksha, [A Beginner's Very Bumpy Journey Through The World of Open Source](https://medium.freecodecamp.com/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39#.pcswr2e78)
  </p>
</aside>

Antes de abrir uma issue, pull request ou fazer uma pergunta no bate-papo, ter os pontos a seguir em mente irá ajudar a transmitir sua ideia de maneira eficaz.

**Contextualize** Ajude os outros a entenderem rapidamente. Se você esta patinando em um erro, explique o que esta você esta tentando fazer e como reproduzir este erro. Se você está sugerindo um nova ideia, explique por que você acha que ela seria util para o projeto (não apenas para você).

> 😇 _"Não acontece X quando eu faço Y"_
>
> 😢 _"X esta quebrado! Por favor conserte isto."_

**Faça, antes, sua lição de casa.** Não há problema em não saber as coisas, mas mostre que você tentou. Antes de pedir ajuda, verifique o README de um projeto, a documentação, as issues (abertas ou fechadas), a lista de e-mail e procure na internet por uma resposta. As pessoas vão gostar quando você demonstrar que está tentando aprender.

> 😇 _"Não sei como implementar o X. Verifiquei os documentos de ajuda e não encontrei nada mencionando."_
>
> 😢 _"Como eu faço X?"_

**Mantenha-se conciso e direto.** Assim como enviar um e-mail, todas as contribuições, por mais simples ou útil, exigem a análise de outra pessoa. Muitos projetos têm mais solicitações recebidas do que pessoas disponíveis para ajudar. Seja conciso. Você aumentará a chance de que alguém possa ajudá-lo.

> 😇 _"Eu gostaria de escrever um tutorial da API"_
>
> 😢 _"Eu estava dirigindo pela estrada no outro dia e parei para abastecer, e então eu tive essa ideia incrível para algo que deveríamos fazer, mas antes de explicar isso, deixe-me mostrar-lhe ..."_

**Mantenha toda a comunicação publica** Embora seja tentador, não procure mantenedores de forma privada, a menos que você precise compartilhar informações confidenciais (como um problema de segurança ou violação grave de conduta). Quando você mantém a conversa pública, mais pessoas podem aprender e se beneficiar com a sua troca. As discussões podem ser, em si mesmas, contribuições.

> 😇 _(um comentário) "@-maintainer Olá! Como devemos proceder neste PR?"_
>
> 😢 _(um email) "Ei, desculpe incomodá-lo por e-mail, mas eu queria saber se você teve a chance de rever o meu PR"_

**Não há problema em fazer perguntas (mas seja paciente!).** Todo mundo já foi novo no projeto em algum momento, e até colaboradores experientes precisam se atualizar quando olham para um novo projeto. Da mesma forma, mantenedores de longa data nem sempre estão familiarizados com todas as partes do projeto. Mostre a mesma paciência que você gostaria que eles tivessem com você.

> 😇 _"Obrigado por pegar este erro. Eu segui sua sugestão. Aqui esta a saída."_
>
> 😢 _"Porque você não pode resolver meu problema? Este projeto não é seu?"_

**Respeite a decisão da comunidade.** Suas ideias podem ser diferentes das prioridades ou visão da comunidade. Eles podem oferecer feedback ou decidir não seguir sua ideia. Enquanto você deve discutir e procurar uma solução, os mantenedores têm que viver com sua decisão por mais tempo do que você. Se você não concordar com a decisão deles, você pode sempre trabalhar em sua própria cópia do projeto ou iniciar seu próprio projeto.

> 😇 _"Estou desapontado por não poder apoiar o meu caso de uso, mas como você explicou, isso afeta apenas uma pequena parte dos usuários, eu entendo o porquê. Obrigado por ouvir."_
>
> 😢 _"Porque você não dá suporte ao meu caso de uso? Isto é inaceitavel!"_

**Acima de tudo, mantenha a classe.** O open source é composto por contribuidores de todo o mundo. O contexto se perde em idiomas, culturas, regiões geográficas e fusos horários. Além disso, a comunicação escrita torna mais difícil transmitir um tom ou humor. Assuma boas intenções nessas conversas. É normal se desfazer de uma ideia de forma educada e pedir mais contexto ou esclarecer melhor sua posição. Apenas tente deixar a internet em um lugar melhor do que quando você a encontrou.

### Capturando o contexto

Antes de fazer qualquer coisa, faça uma verificação rápida para garantir que a sua ideia não tenha sido discutida em outro lugar. Explore o README do projeto, os problemas (abertos e fechados), a lista de e-mails e o Stack Overflow. Você não tem que gastar horas passando por tudo, mas uma busca rápida por alguns termos-chave pode lhe dar uma boa visão.

Se você não encontrar sua ideia em outro lugar, você está pronto para fazer uma contribuição. Se o projeto estiver no GitHub, você provavelmente se comunicará abrindo uma issue ou pull request:

* **Issues** são como o inicio de uma conversa ou discussão
* **Pull requests** são para inicio dos trabalhos em uma solução
* **Para communicações leves,** para esclarecimentos ou questões de como fazer, tente perguntar no Stack Overflow, IRC, Slack, ou outro canal de comunicação, se o projeto tiver.

Antes de abrir uma issue ou pull request, verifique os documentos de contribuição do projeto (geralmente um arquivo chamado CONTRIBUTING ou no README), para ver se é necessário incluir algo específico. Por exemplo, eles podem pedir que você siga um modelo ou exigir que você use testes.

Se você quiser fazer uma contribuição substancial, abra uma issue para perguntar antes de trabalhar nela. É útil olhar o projeto por um tempo (no GitHub, [você pode clicar em "Watch"](https://help.github.com/articles/watching-repositories/) para ser notificado de todas as conversas) e conhecer os membros da comunidade, antes de realizar trabalhos que possam não ser aceitos.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  Você aprenderá <em>muito</em> analizando um projeto que você usa ativamente, "vigiando" ele no GitHub e lendo as issues e PR.
<p markdown="1" class="pquote-credit">
— @gaearon [on joining projects](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Abrindo uma issue

Você deve normalmente abrir uma issue nas seguintes situações:

* Reportar um erro que você não pode resolver por conta própria.
* Discutir um tópico de alto nível ou ideia (por exemplo, comunidade, visão ou politicas)
* Propor uma nova função ou outra ideia do projeto.

Dicas para se comunicar sobre problemas:

* **Se você vir uma issue aberta que deseja resolver,** comente na issue para que as pessoas saibam que você está interessado nela. Dessa forma, as pessoas estarão menos propensas a duplicar seu trabalho.
* **Se uma issue foi aberta há algum tempo,** É possível que ela esteja sendo resolvida em algum outro lugar ou já tenha sido resolvida, por isso, comente para pedir confirmação antes de iniciar o trabalho.
* **Se você abriu uma issue, mas descobriu a resposta mais tarde,** comente na issue para que as pessoas saibam, então feche a issue. Mesmo este registro serve como documetação para o projeto.

### Abrindo um pull request

Você deve normalmente abrir um pull request nas seguintes situações:

* Envio de correções triviais (por exemplo, um erro de digitação, um link quebrado ou um erro óbvio)
* Iniciar o trabalho em uma contribuição que já foi discutida, ou que você já tenha discutido em uma issue

Um pull request não precisa representar o trabalho final. Geralmente, é melhor abrir um pull request no início, para que outras pessoas possam acompanhar ou dar feedback sobre seu progresso. Basta marcá-lo com um "WIP" (Work in Progress) na linha de assunto. Você sempre pode adicionar mais commits depois.

Se o projeto estiver no GitHub, veja como enviar um pull request:

* **[Faça um fork do repositorio](https://guides.github.com/activities/forking/)** e clone localmente. Conecte seu repositorio local com o "upstream" adicionado-o como repositorio remoto. Baixe as alterações do "upstream" com frequência para que você fique atualizado, quando enviar seu pull request, os conflitos de mesclagem serão menos prováveis. (Veja instruções mais detalhadas [aqui](https://help.github.com/articles/syncing-a-fork/).)
* **[Crie um branch](https://guides.github.com/introduction/flow/)** para suas edições.
* **Referencie qualquer issue relevante** ou documentação de suporte em seu PR (por exemplo, "Closes #37.")
* **Inclua imagens do antes e depois** se suas mudanças incluirem diferenças no HTML/CSS. Copie e cole as imagens na mensagem do seu pull request.
* **Teste suas mudanças!** Execute suas alterações em relação a quaisquer testes existentes, e crie novos quando necessário. Se os testes existirem sempre verifique se suas alterações não quebram o projeto existente.
* **Contribua para o estilo do projeto** para melhorar suas habilidades. Isso pode significar usar recuos, ponto-e-vírgula ou comentários de maneira diferente do que você faria em seu próprio repositório, mas torna mais fácil para o mantenedor unir codigos, e para outros manter, enteder e melhorar no futuro.

Se este é o seu primeiro pull request, confira [Faça um pull request](http://makeapullrequest.com/), que @kentcdodds criou como um tutorial em vídeo passo a passo. Você também pode praticar a criação de um pull request no repositório [Primeira Contribuição](https://github.com/Roshanjossey/first-contributions), criado por @Roshanjossey.

## O que acontece depois que você envia uma contribuição

Você fez isso! Parabéns por se tornar um contribuidor open source. Esperamos que seja a primeira de muitas.

Depois de enviar uma contribuição, uma das seguintes situações ocorrerá:

### 😭 Você não recebe uma resposta.

Espero que você [tenha checado o projeto em busca de sinais de atividade](#um-checklist-antes-de-você-contribuir) antes de fazer uma contribuição. Mesmo em um projeto ativo, no entanto, é possível que sua contribuição não receba uma resposta.

Se você não obtiver uma resposta após uma semana, é justo responder educadamente no mesmo tópico, pedindo a revisão de alguém. Se você souber o nome da pessoa certa para revisar sua contribuição, você poderá @-menciona-la nesse tópico.

**Não** contate essa pessoa em particular; Lembre-se de que a comunicação pública é vital para projetos open source.

Se você fizer uma chamada educada e ninguém responder, é possível que ninguém responda, nunca. Não é um sentimento agradável, mas não deixe que isso o desanime. Aconteceu com todos! Existem muitas razões possíveis pelas quais você não recebeu uma resposta, incluindo circunstâncias pessoais que podem estar fora de seu controle. Tente encontrar outro projeto ou uma maneira de contribuir. Bem como outros motivos, esta é uma boa razão para não investir muito tempo em fazer uma contribuição antes que outros membros da comunidade estejam engajados e responsivos.

### 🚧 Alguém solicita alterações na sua contribuição.

É comum que você seja solicitado a fazer alterações em sua contribuição, ou mesmo feedback sobre o escopo de sua ideia ou alterações em seu código.

Quando alguém solicitar alterações, seja responsivo. Eles levaram algum tempo para revisar sua contribuição. Abrir um PR e ir embora é má educação. Se você não souber como fazer as alterações, pesquise o problema e peça ajuda se precisar.

Se você não tiver mais tempo para trabalhar no assunto (por exemplo, se a conversa já dura meses, e suas circunstâncias mudaram), informe ao mantenedor para que ele não esteja esperando uma resposta. Alguém pode ficar feliz em assumir o controle.

### 👎 Sua contribuição não é aceita.

Sua contribuição pode ou não ser aceita no final. Espero que você não tenha trabalhado muito nisso até então. Se você não tem certeza do motivo pelo qual não foi aceito, é perfeitamente razoável pedir feedback e esclarecimentos ao mantenedor. Em última análise, no entanto, você precisa respeitar que essa é a decisão deles. Não discuta ou seja hostil. Você é sempre bem vindo para fazer uma cópia e trabalhar em sua própria versão, se você não concordar!

### 🎉 Sua contribuição é aceita.

Viva! Você fez uma contribuição open source com sucesso!

## Você fez isso!

Se você acabou de fazer sua primeira contribuição open source ou está procurando novas maneiras de contribuir, esperamos que você esteja inspirado a agir. Mesmo que sua contribuição não tenha sido aceita, não se esqueça de agradecer quando um mantenedor se esforçar para ajudá-lo. O open source é feito por pessoas como você: uma issue, pull request, comentário ou high-five de cada vez.
